/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MouseInputAdapter;
import org.openide.ErrorManager;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.ExecBridge;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.util.Task;
import org.openide.util.actions.Presenter;

public class Toolbar
extends JToolBar {
    public static final int BASIC_HEIGHT = 34;
    static int HEIGHT_TOLERANCE = 5;
    static int TOP = 2;
    static int LEFT = 3;
    static int BOTTOM = 2;
    static int RIGHT = 3;
    static int RESIDUAL_WIDTH = 16;
    private boolean floatable;
    private DnDListener listener;
    private ToolbarMouseListener mouseListener;
    private String displayName;
    private DataFolder backingFolder;
    private Folder processor;
    static final long serialVersionUID = 5011742660516204764L;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$org$openide$util$actions$Presenter$Toolbar;
    static /* synthetic */ Class class$javax$swing$Action;

    public Toolbar() {
        this("");
    }

    public Toolbar(String string) {
        this(string, string, false);
    }

    public Toolbar(String string, String string2) {
        this(string, string2, false);
    }

    public Toolbar(String string, boolean bl) {
        this(string, string, bl);
    }

    Toolbar(DataFolder dataFolder, boolean bl) {
        this.backingFolder = dataFolder;
        this.initAll(dataFolder.getName(), bl);
    }

    private void doInitialize() {
        if (this.processor == null && this.isVisible()) {
            this.processor = new Folder();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.doInitialize();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.doInitialize();
    }

    public Toolbar(String string, String string2, boolean bl) {
        this.setDisplayName(string2);
        this.initAll(string, bl);
    }

    private void initAll(String string, boolean bl) {
        this.floatable = bl;
        this.mouseListener = null;
        this.setName(string);
        this.setFloatable(false);
        this.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(TOP, LEFT, BOTTOM, RIGHT)));
        this.putClientProperty("JToolBar.isRollover", new Boolean(true));
        this.addGrip();
        this.getAccessibleContext().setAccessibleName(this.displayName == null ? this.getName() : this.displayName);
        this.getAccessibleContext().setAccessibleDescription(this.getName());
    }

    public void removeAll() {
        super.removeAll();
        this.addGrip();
    }

    void addGrip() {
        if (this.floatable) {
            ToolbarBump toolbarBump = new ToolbarBump();
            if (this.mouseListener == null) {
                this.mouseListener = new ToolbarMouseListener();
            }
            toolbarBump.addMouseListener(this.mouseListener);
            toolbarBump.addMouseMotionListener(this.mouseListener);
            this.add(toolbarBump);
            this.addSeparator(new Dimension(4, 1));
        }
    }

    public static int rowCount(int n) {
        return 1 + n / (34 + HEIGHT_TOLERANCE);
    }

    public void setDnDListener(DnDListener dnDListener) {
        this.listener = dnDListener;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return this.backingFolder.getNodeDelegate().getDisplayName();
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    protected void fireDragToolbar(int n, int n2, int n3) {
        if (this.listener != null) {
            this.listener.dragToolbar(new DnDEvent(this, this.getName(), n, n2, n3));
        }
    }

    protected void fireDropToolbar(int n, int n2, int n3) {
        if (this.listener != null) {
            this.listener.dropToolbar(new DnDEvent(this, this.getName(), n, n2, n3));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DnDEvent
    extends EventObject {
        public static final int DND_ONE = 1;
        public static final int DND_END = 2;
        public static final int DND_LINE = 3;
        private String name;
        private int dx;
        private int dy;
        private int type;
        static final long serialVersionUID = 4389530973297716699L;

        public DnDEvent(Toolbar toolbar, String string, int n, int n2, int n3) {
            super(toolbar);
            this.name = string;
            this.dx = n;
            this.dy = n2;
            this.type = n3;
        }

        public String getName() {
            return this.name;
        }

        public int getDX() {
            return this.dx;
        }

        public int getDY() {
            return this.dy;
        }

        public int getType() {
            return this.type;
        }
    }

    public static interface DnDListener
    extends EventListener {
        public void dragToolbar(DnDEvent var1);

        public void dropToolbar(DnDEvent var1);
    }

    private class ToolbarBump
    extends JPanel {
        static final int TOPGAP = 2;
        static final int BOTGAP = 0;
        static final int WIDTH = 6;
        Dimension dim;
        Dimension max;
        static final long serialVersionUID = -8819972936203315277L;

        public ToolbarBump() {
            int n = 6;
            this.dim = new Dimension(n, n);
            this.max = new Dimension(n, Integer.MAX_VALUE);
            this.setToolTipText(Toolbar.this.getDisplayName());
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.height - 0;
            graphics.setColor(this.getBackground());
            int n2 = 0;
            while (n2 + 1 < dimension.width) {
                int n3 = 2;
                while (n3 + 1 < n) {
                    graphics.setColor(this.getBackground().brighter());
                    graphics.drawLine(n2, n3, n2, n3);
                    if (n2 + 5 < dimension.width && n3 + 5 < n) {
                        graphics.drawLine(n2 + 2, n3 + 2, n2 + 2, n3 + 2);
                    }
                    graphics.setColor(this.getBackground().darker().darker());
                    graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
                    if (n2 + 5 < dimension.width && n3 + 5 < n) {
                        graphics.drawLine(n2 + 3, n3 + 3, n2 + 3, n3 + 3);
                    }
                    n3 += 4;
                }
                n2 += 4;
            }
        }

        public Dimension getMinimumSize() {
            return this.dim;
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.max;
        }
    }

    final class Folder
    extends FolderInstance {
        public Folder() {
            super(Toolbar.this.backingFolder);
            this.recreate();
        }

        public String instanceName() {
            return Toolbar.this.getClass().getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return Toolbar.this.getClass();
        }

        protected InstanceCookie acceptDataObject(DataObject dataObject) {
            InstanceCookie instanceCookie = super.acceptDataObject(dataObject);
            if (instanceCookie == null) {
                JButton jButton = ExecBridge.createButton(dataObject);
                return jButton != null ? new InstanceSupport.Instance(jButton) : null;
            }
            return instanceCookie;
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz;
            InstanceCookie.Of of;
            boolean bl = instanceCookie instanceof InstanceCookie.Of ? (of = (InstanceCookie.Of)instanceCookie).instanceOf(class$java$awt$Component == null ? (class$java$awt$Component = Toolbar.class$("java.awt.Component")) : class$java$awt$Component) || of.instanceOf(class$org$openide$util$actions$Presenter$Toolbar == null ? (class$org$openide$util$actions$Presenter$Toolbar = Toolbar.class$("org.openide.util.actions.Presenter$Toolbar")) : class$org$openide$util$actions$Presenter$Toolbar) || of.instanceOf(class$javax$swing$Action == null ? (class$javax$swing$Action = Toolbar.class$("javax.swing.Action")) : class$javax$swing$Action) : (class$java$awt$Component == null ? (class$java$awt$Component = Toolbar.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(clazz = instanceCookie.instanceClass()) || (class$org$openide$util$actions$Presenter$Toolbar == null ? (class$org$openide$util$actions$Presenter$Toolbar = Toolbar.class$("org.openide.util.actions.Presenter$Toolbar")) : class$org$openide$util$actions$Presenter$Toolbar).isAssignableFrom(clazz) || (class$javax$swing$Action == null ? (class$javax$swing$Action = Toolbar.class$("javax.swing.Action")) : class$javax$swing$Action).isAssignableFrom(clazz);
            return bl ? instanceCookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return null;
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            Object object;
            Toolbar.this.removeAll();
            int n = 0;
            while (n < instanceCookieArray.length) {
                try {
                    object = instanceCookieArray[n].instanceCreate();
                    if (object instanceof Presenter.Toolbar) {
                        object = ((Presenter.Toolbar)object).getToolbarPresenter();
                    }
                    if (object instanceof Component) {
                        if (object instanceof JComponent && "Fixed".equals(((JComponent)object).getClientProperty("Toolbar"))) {
                            Toolbar.this.floatable = false;
                            Toolbar.this.removeAll();
                            Toolbar.this.setBorder(null);
                        }
                        Toolbar.this.add((Component)object);
                    } else if (object instanceof Action) {
                        Action action = (Action)object;
                        JButton jButton = new JButton();
                        Actions.connect((AbstractButton)jButton, action);
                        Toolbar.this.add(jButton);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ErrorManager.getDefault().notify(1, classNotFoundException);
                }
                ++n;
            }
            Toolbar.this.invalidate();
            object = Toolbar.this.getParent();
            while (object != null && !(object instanceof Frame)) {
                object = ((Component)object).getParent();
            }
            if (object != null) {
                ((Container)object).validate();
                ((Component)object).repaint();
            }
            return Toolbar.this;
        }

        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable);
        }
    }

    class ToolbarMouseListener
    extends MouseInputAdapter {
        private boolean dragging = false;
        private Point startPoint = null;

        ToolbarMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.startPoint = mouseEvent.getPoint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragging) {
                int n = Toolbar.this.getX() + mouseEvent.getX() - this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : mouseEvent.getX() - this.startPoint.x;
                Toolbar.this.fireDropToolbar(n, mouseEvent.getY() - this.startPoint.y, 1);
                this.dragging = false;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            int n2 = 1;
            if (mouseEvent.isControlDown()) {
                n2 = 3;
            } else if ((n & 8) != 0 || (n & 4) != 0) {
                n2 = 2;
            }
            if (this.startPoint == null) {
                this.startPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            }
            int n3 = Toolbar.this.getX() + mouseEvent.getX() + this.startPoint.x > Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? (Toolbar.this.getX() >= Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH ? 0 : Toolbar.this.getParent().getWidth() - RESIDUAL_WIDTH - Toolbar.this.getX()) : mouseEvent.getX() - this.startPoint.x;
            Toolbar.this.fireDragToolbar(n3, mouseEvent.getY() - this.startPoint.y, n2);
            this.dragging = true;
        }
    }
}

