/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private PipedInputStream pis;
    private PipedOutputStream pos;
    private OutputStreamWriter osw;

    public ReaderInputStream(Reader reader) throws IOException {
        this(reader, "ISO-8859-1");
    }

    public ReaderInputStream(Reader reader, String string) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter((OutputStream)this.pos, string);
    }

    public int read() throws IOException {
        if (this.pis.available() > 0) {
            return this.pis.read();
        }
        int n = this.reader.read();
        if (n == -1) {
            return n;
        }
        this.osw.write(n);
        this.osw.flush();
        return this.pis.read();
    }

    public long skip(long l) throws IOException {
        return this.reader.skip(l);
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this.reader.close();
        this.osw.close();
        this.pis.close();
    }
}

