/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.nbbuild.Issue;
import org.netbeans.nbbuild.IssuezillaXMLHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public final class Issuezilla {
    private URL urlBase;
    private SAXParser saxParser;
    private int maxIOFailures = 15;

    public Issuezilla(URL uRL) {
        this.urlBase = uRL;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException("Cannot initialize parser");
        }
    }

    public Issue getBug(int n) throws SAXException, IOException {
        Issue[] issueArray = this.getBugs(new int[]{n});
        if (issueArray.length != 1) {
            throw new InvalidObjectException("Issue not read");
        }
        return issueArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue[] getBugs(int[] nArray) throws SAXException, IOException {
        int n = 10;
        Issue[] issueArray = new Issue[nArray.length];
        int n2 = 0;
        block9: while (n2 < nArray.length) {
            int n3 = Math.min(nArray.length, n2 + n);
            StringBuffer stringBuffer = new StringBuffer(nArray.length * 8);
            String string = "xml.cgi?id=";
            IOException iOException = null;
            int n4 = n2;
            while (n4 < n3) {
                stringBuffer.append(string);
                stringBuffer.append(nArray[n4]);
                string = ",";
                ++n4;
            }
            stringBuffer.append("&show_attachments=false");
            int n5 = 0;
            while (n5 < this.maxIOFailures) {
                Issue[] issueArray2;
                URL uRL = null;
                try {
                    Object var15_18;
                    uRL = new URL(this.urlBase, stringBuffer.toString());
                    InputStream inputStream = uRL.openStream();
                    try {
                        issueArray2 = this.getBugs(inputStream);
                        var15_18 = null;
                    }
                    catch (Throwable throwable) {
                        var15_18 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    int n6 = 0;
                    while (n6 < issueArray2.length) {
                        issueArray[n2++] = issueArray2[n6++];
                    }
                    continue block9;
                }
                catch (IOException iOException2) {
                    issueArray2 = this;
                    synchronized (issueArray2) {
                        try {
                            System.out.println(new Date().toString() + ": Can't get URL : " + uRL.toString());
                            this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    iOException = iOException2;
                    ++n5;
                }
            }
            throw iOException;
        }
        return issueArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] query(String string) throws SAXException, IOException {
        int n;
        Object object;
        Object object2;
        URL uRL = new URL(this.urlBase, "buglist.cgi?" + string);
        IOException iOException = null;
        BufferedReader bufferedReader = null;
        int n2 = 0;
        while (n2 < this.maxIOFailures) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));
            }
            catch (IOException iOException2) {
                object2 = this;
                synchronized (object2) {
                    try {
                        System.out.println(new Date().toString() + ": Can't get URL : " + uRL.toString());
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                iOException = iOException2;
            }
            ++n2;
        }
        if (bufferedReader == null) {
            if (iOException != null) {
                throw iOException;
            }
            throw new IOException("Can't get connection to " + uRL.toString() + " for " + this.maxIOFailures + "times.");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        object2 = "show_bug.cgi?id=";
        while ((object = bufferedReader.readLine()) != null) {
            int n3 = ((String)object).indexOf((String)object2);
            if (n3 == -1) continue;
            n = ((String)object).indexOf(34, n3 += ((String)object2).length());
            if (n == -1) {
                throw new IOException("No ending \" from index " + n3 + " in " + (String)object);
            }
            String string2 = ((String)object).substring(n3, n);
            arrayList.add(Integer.valueOf(string2));
        }
        object = new int[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n = 0;
        while (n < ((Object)object).length) {
            object[n] = (Integer)iterator.next();
            ++n;
        }
        return object;
    }

    private Issue[] getBugs(InputStream inputStream) throws SAXException, IOException {
        IssuezillaXMLHandler issuezillaXMLHandler = new IssuezillaXMLHandler();
        this.saxParser.parse(inputStream, (HandlerBase)issuezillaXMLHandler);
        return this.getBugsFromHandler(issuezillaXMLHandler);
    }

    private Issue[] getBugsFromHandler(IssuezillaXMLHandler issuezillaXMLHandler) {
        List list = issuezillaXMLHandler.getBugList();
        if (list == null) {
            return null;
        }
        Issue[] issueArray = new Issue[list.size()];
        int n = 0;
        while (n < list.size()) {
            Issue issue = new Issue();
            Map map = (Map)list.get(n);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                issue.setAttribute((String)entry.getKey(), entry.getValue());
            }
            issueArray[n] = issue;
            ++n;
        }
        return issueArray;
    }
}

