/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.io.Serializable;
import org.netbeans.modules.jarpackager.api.ArchiveFilter;
import org.netbeans.modules.jarpackager.api.ArchiveMember;
import org.netbeans.modules.jarpackager.util.JarUtils;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;

public class ContentMember
implements Serializable,
ArchiveMember {
    static final long serialVersionUID = -7995415137147855602L;
    DataObject dataObject;
    ArchiveFilter filter;
    String targetDirectory;
    boolean isRecursive;

    public ContentMember() {
    }

    public ContentMember(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    public ContentMember(DataObject dataObject, ArchiveFilter archiveFilter, String string) {
        this.dataObject = dataObject;
        this.targetDirectory = string;
        this.filter = archiveFilter;
        this.isRecursive = false;
    }

    public ContentMember(DataObject dataObject, ArchiveFilter archiveFilter, String string, boolean bl) {
        this.dataObject = dataObject;
        this.targetDirectory = string;
        this.filter = archiveFilter;
        this.isRecursive = bl;
    }

    public ContentMember resolve() {
        DataObject dataObject = JarUtils.resolve(this.dataObject);
        if (dataObject == this.dataObject) {
            return this;
        }
        return new ContentMember(dataObject, this.filter, this.targetDirectory, this.isRecursive);
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public ArchiveFilter getFilter() {
        return this.filter;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String string) {
        this.targetDirectory = string;
    }

    public void setFilter(ArchiveFilter archiveFilter) {
        this.filter = archiveFilter;
    }

    boolean isRecursive() {
        return this.isRecursive;
    }

    void setRecursive(boolean bl) {
        this.isRecursive = bl;
    }

    String[] saveDataObject() {
        try {
            String[] stringArray = new String[2];
            FileObject fileObject = this.dataObject.getPrimaryFile();
            stringArray[0] = fileObject.getFileSystem().getSystemName();
            stringArray[1] = fileObject.toString();
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String[] stringArray = new String[]{};
            return stringArray;
        }
    }

    void restoreDataObject(String[] stringArray) {
        if (stringArray.length != 2) {
            this.dataObject = null;
        } else {
            try {
                Repository repository = TopManager.getDefault().getRepository();
                FileSystem fileSystem = repository.findFileSystem(stringArray[0]);
                FileObject fileObject = null;
                if (fileSystem != null) {
                    fileObject = fileSystem.findResource(stringArray[1]);
                }
                if (fileObject == null) {
                    fileObject = repository.findResource(stringArray[1]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.dataObject = null;
            }
        }
    }

    public String toString() {
        return this.dataObject == null ? "<NULL>" : this.dataObject.getName();
    }
}

