/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.report;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XDependentTextField;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;
import com.sun.star.util.XNumberFormats;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.wizards.common.TextDocument;
import com.sun.star.wizards.common.Tools;
import com.sun.star.wizards.common.UNODialogs;
import com.sun.star.wizards.report.DBMetaData;
import java.util.Vector;

class ReportDocument
extends TextDocument {
    public XNumberFormats NumberFormats;
    private Object ReportPageStyle;
    private Object FirstPageStyle;
    private int PageWidth;
    private Rectangle PosSize;
    private String ReportFolderName;
    public Vector GroupFormatVector;
    private RecordTable CurRecordTable;
    public DBMetaData CurDBMetaData;
    private long lDateCorrection;
    private String sMsgTableNotExisting;
    private String sMsgCommonReportError;
    private String sMsgEndAutopilot;
    private String ContentTemplatePath;
    private String LayoutTemplatePath;
    private String sMsgInvalidTextField;
    public UNODialogs CurUNODialog;
    public boolean bIsCurLandscape;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$text$XDependentTextField;
    static /* synthetic */ Class class$com$sun$star$container$XIndexAccess;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$text$XTextViewCursorSupplier;
    static /* synthetic */ Class class$com$sun$star$text$XPageCursor;
    static /* synthetic */ Class class$com$sun$star$text$XTextCursor;
    static /* synthetic */ Class class$com$sun$star$text$XTextRange;
    static /* synthetic */ Class class$com$sun$star$text$XTextTable;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertyState;

    public ReportDocument(XMultiServiceFactory xMultiServiceFactory, boolean bl, boolean bl2, String[] stringArray) {
        super(xMultiServiceFactory, bl, bl2);
        Date date = (Date)Tools.getUNOStructValue(this.xNumberFormatsSupplier.getNumberFormatSettings(), "NullDate");
        long l = Tools.convertUnoDatetoInteger(date);
        this.lDateCorrection = Tools.getNullDateCorrection(l);
        this.NumberFormats = this.xNumberFormatsSupplier.getNumberFormats();
        this.GroupFormatVector = new Vector();
        this.CurDBMetaData = new DBMetaData(xMultiServiceFactory, this.CharLocale, this.NumberFormats);
        this.CurDBMetaData.lDateCorrection = this.lDateCorrection;
        this.sMsgTableNotExisting = stringArray[0];
        this.sMsgCommonReportError = stringArray[1];
        this.sMsgEndAutopilot = stringArray[2];
        this.sMsgInvalidTextField = stringArray[3];
        this.sMsgTableNotExisting = this.sMsgTableNotExisting + '\r' + this.sMsgEndAutopilot;
        this.bIsCurLandscape = true;
        this.getReportPageStyles();
    }

    public boolean checkReportLayoutMode(String[] stringArray) {
        try {
            XNameAccess xNameAccess = this.xTextSectionsSupplier.getTextSections();
            Object object = stringArray.length > 0 ? xNameAccess.getByName("GroupField1") : xNameAccess.getByName("RecordSection");
            boolean bl = AnyConverter.toBoolean((Object)Tools.getUNOPropertyValue(object, "IsVisible"));
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return true;
        }
    }

    public void swapContentTemplate(String string) {
        this.xProgressBar.start("", 10);
        this.ContentTemplatePath = string;
        this.loadSectionsfromTemplate(string);
        this.xProgressBar.setValue(40);
        this.loadStyleTemplates(string, "LoadTextStyles");
        this.xProgressBar.setValue(70);
        if (this.CurRecordTable != null) {
            this.CurRecordTable.adjustOptimalTableWidths();
        }
        this.xProgressBar.setValue(100);
        this.selectFirstPage();
        this.CurUNODialog.assignPropertyToDialogControl("cmdGoOn", "Enabled", new Boolean(true));
        this.xProgressBar.end();
    }

    public void swapLayoutTemplate(String string, String string2, UNODialogs uNODialogs) {
        try {
            this.xProgressBar.start("", 10);
            this.LayoutTemplatePath = string;
            boolean bl = AnyConverter.toBoolean((Object)Tools.getUNOPropertyValue(this.ReportPageStyle, "IsLandscape"));
            this.loadStyleTemplates(string, "LoadPageStyles");
            this.xProgressBar.setValue(60);
            this.changePageOrientation(string2, uNODialogs, bl);
            this.xProgressBar.setValue(100);
            this.selectFirstPage();
            this.xProgressBar.end();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void createReportForm(String string) {
        XNameContainer xNameContainer = this.insertFormbyName(string);
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = ReportDocument.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)xNameContainer);
        this.insertHiddenControl(xNameAccess, xNameContainer, "DataSourceName", this.CurDBMetaData.DataSourceName);
        this.insertHiddenControl(xNameAccess, xNameContainer, "Command", this.CurDBMetaData.Command);
        this.insertHiddenControl(xNameAccess, xNameContainer, "CommandType", new String(Integer.toString(this.CurDBMetaData.CommandType)));
        this.insertHiddenControl(xNameAccess, xNameContainer, "GroupFieldNames", Tools.ArraytoString(this.CurDBMetaData.GroupFieldNames));
        this.insertHiddenControl(xNameAccess, xNameContainer, "FieldNames", Tools.ArraytoString(this.CurDBMetaData.FieldNames));
        this.insertHiddenControl(xNameAccess, xNameContainer, "RecordFieldNames", Tools.ArraytoString(this.CurDBMetaData.RecordFieldNames));
    }

    public void updateReportTitle(XTextComponent xTextComponent) {
        String string = xTextComponent.getText();
        Tools.setUNOPropertyValue(this.xDocInfo, "Title", string);
    }

    public void getReportPageStyles() {
        try {
            Object object = this.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            this.ReportPageStyle = Tools.getUNOObjectbyName(object, "Standard");
            this.FirstPageStyle = Tools.getUNOObjectbyName(object, "First Page");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void changePageOrientation(String string, UNODialogs uNODialogs, boolean bl) {
        block5: {
            try {
                this.getReportPageStyles();
                Size size = (Size)Tools.getUNOStructValue(this.ReportPageStyle, "Size");
                this.bIsCurLandscape = AnyConverter.toBoolean((Object)Tools.getUNOPropertyValue(this.ReportPageStyle, "IsLandscape"));
                if (this.bIsCurLandscape != bl) {
                    Size size2 = new Size(size.Height, size.Width);
                    Tools.setUNOPropertyValue(this.ReportPageStyle, "IsLandscape", new Boolean(bl));
                    Tools.setUNOPropertyValue(this.ReportPageStyle, "Size", size2);
                    Tools.setUNOPropertyValue(this.FirstPageStyle, "IsLandscape", new Boolean(bl));
                    Tools.setUNOPropertyValue(this.FirstPageStyle, "Size", size2);
                    int n = AnyConverter.toInt((Object)Tools.getUNOPropertyValue(this.ReportPageStyle, "LeftMargin"));
                    int n2 = AnyConverter.toInt((Object)Tools.getUNOPropertyValue(this.ReportPageStyle, "RightMargin"));
                    this.PageWidth = size2.Width - n - n2;
                    if (this.CurRecordTable != null) {
                        this.CurRecordTable.adjustOptimalTableWidths();
                    }
                }
                if (uNODialogs == null) break block5;
                if (bl) {
                    uNODialogs.assignPropertyToDialogControl("imgOrientation", "ImageURL", string + "/landscape.gif");
                    break block5;
                }
                uNODialogs.assignPropertyToDialogControl("imgOrientation", "ImageURL", string + "/portrait.gif");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    public boolean loadSectionsfromTemplate(String string) {
        try {
            Object object;
            int n = this.CurDBMetaData.GroupFieldNames.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = "GroupField" + Integer.toString(n2 + 1);
                this.renameTextTable(this.xTextTablesSupplier.getTextTables(), "Tbl_" + string2, "MyTextTable");
                object = this.xTextSectionsSupplier.getTextSections().getByName(string2);
                this.linkSectiontoTemplate(object, string, string2);
                this.renameTextTable(this.xTextTablesSupplier.getTextTables(), "MyTextTable", "Tbl_" + string2);
                ++n2;
            }
            if (this.xTextSectionsSupplier.getTextSections().getElementNames().length > this.CurDBMetaData.GroupFieldNames.length) {
                object = this.xTextSectionsSupplier.getTextSections().getByName("RecordSection");
                this.linkSectiontoTemplate(object, string, "RecordSection");
                this.CurRecordTable = new RecordTable(this.xTextTablesSupplier);
                this.insertColumnstoRecordTable();
            } else {
                this.CurRecordTable = null;
            }
            n2 = 0;
            while (n2 < n) {
                DBColumn dBColumn = new DBColumn(this.CurDBMetaData.GroupFieldNames[n2], n2, "Tbl_GroupField" + (n2 + 1), true);
                if (dBColumn == null) {
                    return false;
                }
                this.GroupFormatVector.set(n2, dBColumn);
                this.replaceFieldValueInGroupTable(this.CurDBMetaData.GroupFieldNames[n2], n2);
                ++n2;
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public void setupRecordSection(String string) {
        this.ContentTemplatePath = string;
        if (this.CurDBMetaData.RecordFieldNames.length > 0) {
            this.insertTextSection("RecordSection", string);
            this.CurRecordTable = new RecordTable(this.xTextTablesSupplier);
            this.insertColumnstoRecordTable();
            if (this.CurRecordTable != null) {
                this.CurRecordTable.adjustOptimalTableWidths();
            }
        } else {
            this.CurRecordTable = null;
        }
    }

    public void replaceFieldValueInRecordSection(int n) {
        int n2 = this.CurDBMetaData.GroupFieldNames.length;
        int n3 = this.CurDBMetaData.FieldNames.length;
        int n4 = n2;
        while (n4 < n3) {
            DBColumn dBColumn = (DBColumn)this.GroupFormatVector.elementAt(n4);
            this.insertUserField(dBColumn.xNameCell, this.CurDBMetaData.FieldNames[n4]);
            dBColumn.replaceValueCellofTable(false);
            ++n4;
        }
    }

    public void updateTextSections(XListBox xListBox) throws Exception {
        XNameAccess xNameAccess = this.xTextTablesSupplier.getTextTables();
        int n = xListBox.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            String string = xListBox.getItem((short)n2);
            String string2 = "Tbl_GroupField" + Integer.toString(n2 + 1);
            DBColumn dBColumn = (DBColumn)this.GroupFormatVector.get(n2);
            DBColumn dBColumn2 = new DBColumn(string, n2, string2, true, dBColumn);
            this.GroupFormatVector.setElementAt(dBColumn2, n2);
            this.insertUserField(dBColumn2.xNameCell, string);
            dBColumn2.replaceValueCellofTable(true);
            ++n2;
        }
    }

    public void insertUserField(XCell xCell, String string) {
        String string2 = this.CurDBMetaData.getFieldTitle(string);
        XTextCursor xTextCursor = this.createTextCursor(xCell);
        xTextCursor.gotoStart(false);
        xTextCursor.gotoEnd(true);
        xTextCursor.setString("");
        super.insertUserField(xTextCursor, string, string2);
    }

    public boolean isNameCell(XTextCursor xTextCursor, String string, String string2) {
        try {
            xTextCursor.gotoStart(false);
            XTextRange xTextRange = xTextCursor.getEnd();
            Object object = Tools.getUNOPropertyValue(xTextRange, "TextField");
            if (AnyConverter.isVoid((Object)object)) {
                return false;
            }
            XDependentTextField xDependentTextField = (XDependentTextField)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XDependentTextField == null ? (class$com$sun$star$text$XDependentTextField = ReportDocument.class$("com.sun.star.text.XDependentTextField")) : class$com$sun$star$text$XDependentTextField), (Object)object);
            XPropertySet xPropertySet = xDependentTextField.getTextFieldMaster();
            String string3 = (String)xPropertySet.getPropertyValue("Name");
            boolean bl = string3.equals(string2) || string3.equals(string);
            return bl;
        }
        catch (Exception exception) {
            UNODialogs.showMessageBox(this.xMSF, "ErrorBox", 0x400000, this.sMsgInvalidTextField);
            exception.printStackTrace(System.out);
            return true;
        }
    }

    public void replaceFieldValueInGroupTable(String string, int n) {
        try {
            String string2 = "";
            DBColumn dBColumn = (DBColumn)this.GroupFormatVector.elementAt(n);
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = ReportDocument.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess), (Object)this.xTextTablesSupplier.getTextTables());
            Object object = xIndexAccess.getByIndex(n);
            string2 = "Tbl_GroupField" + (n + 1);
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = ReportDocument.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)object);
            String string3 = xNamed.getName();
            if (string3.compareTo(string2) != 0) {
                xNamed.setName(string2);
            }
            XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = ReportDocument.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)object);
            this.insertUserField(dBColumn.xNameCell, string);
            dBColumn.replaceValueCellofTable(true);
            dBColumn.setCellFont();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void replaceFieldValueInRecordTable() {
        String string = "Tbl_RecordSection";
        String string2 = this.CurRecordTable.xTableName.getName();
        if (string2.compareTo(string) != 0) {
            this.CurRecordTable.xTableName.setName(string);
        }
        int n = this.CurDBMetaData.GroupFieldNames.length;
        int n2 = this.CurDBMetaData.RecordFieldNames.length;
        int n3 = n;
        while (n3 < n2) {
            DBColumn dBColumn = (DBColumn)this.GroupFormatVector.elementAt(n3);
            this.insertUserField(dBColumn.xNameCell, this.CurDBMetaData.RecordFieldNames[n3]);
            dBColumn.replaceValueCellofTable(false);
            ++n3;
        }
    }

    public void insertColumnstoRecordTable() {
        try {
            int n;
            int n2;
            XTableColumns xTableColumns;
            int n3;
            int n4 = this.CurDBMetaData.GroupFieldNames.length;
            String string = this.CurRecordTable.xTableName.getName();
            if (string.compareTo("Tbl_RecordSection") != 0) {
                this.CurRecordTable = new RecordTable(this.xTextTablesSupplier);
            }
            if ((n3 = (xTableColumns = this.CurRecordTable.xTextTable.getColumns()).getCount()) > (n2 = this.CurDBMetaData.RecordFieldNames.length)) {
                n = n3 - n2;
                xTableColumns.removeByIndex(0, n);
            } else if (n3 < n2) {
                n = n2 - n3;
                this.CurRecordTable.xTextTable.getColumns().insertByIndex(n3, n);
            }
            n = 0;
            while (n < n2) {
                DBColumn dBColumn = new DBColumn(this.CurRecordTable, this.CurDBMetaData, n, true);
                this.insertUserField(dBColumn.xNameCell, this.CurDBMetaData.RecordFieldNames[n]);
                dBColumn.replaceValueCellofTable(false);
                if (this.GroupFormatVector.size() <= n + n4) {
                    this.GroupFormatVector.add(dBColumn);
                } else {
                    this.GroupFormatVector.set(n + n4, dBColumn);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    public boolean addGroupNametoDocument(XListBox xListBox, XListBox xListBox2, Vector vector, String string) {
        DBColumn dBColumn = null;
        try {
            int n = vector.size();
            if (n < 4) {
                this.removeGroupNamesofRecordTable(xListBox2.getItemCount());
                String string2 = xListBox.getSelectedItem();
                String string3 = this.CurDBMetaData.getFieldName(string2);
                short s = xListBox.getSelectedItemPos();
                this.CurUNODialog.removeSelectedItems(xListBox);
                vector.addElement(string3);
                this.insertTextSection("GroupField" + ++n, string + "/cnt-default.stw");
                dBColumn = new DBColumn(string3, n - 1, "Tbl_GroupField" + n, true);
                if (dBColumn != null) {
                    this.GroupFormatVector.addElement(dBColumn);
                    this.replaceFieldValueInGroupTable(string3, n - 1);
                    xListBox2.addItem(string2, xListBox2.getItemCount());
                    this.CurUNODialog.selectListBoxItem(xListBox, s);
                    boolean bl = n < 4 && xListBox.getSelectedItems().length > 0;
                    this.CurUNODialog.assignPropertyToDialogControl("cmdGroupOut", "Enabled", new Boolean(bl));
                } else {
                    String string4 = Tools.replaceSubString(this.sMsgTableNotExisting, "Tbl_GroupField" + n, "<TABLENAME>");
                    UNODialogs.showMessageBox(this.xMSF, "ErrorBox", 0x400000, string4);
                }
                this.CurUNODialog.assignPropertyToDialogControl("lblBlindTextNote_1", "Enabled", new Boolean(true));
            }
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
        return dBColumn != null;
    }

    public void removeGroupNamesofRecordTable(int n) {
        int n2 = this.GroupFormatVector.size();
        if (n2 > n) {
            int n3 = n2 - 1;
            while (n3 >= n) {
                this.GroupFormatVector.removeElementAt(n3);
                --n3;
            }
        }
    }

    public void showCommonReportErrorBox(Exception exception) {
        String string = Tools.convertfromURLNotation(this.xMSF, this.ContentTemplatePath);
        String string2 = Tools.replaceSubString(this.sMsgCommonReportError, string, "%PATH");
        UNODialogs.showMessageBox(this.xMSF, "ErrorBox", 0x400000, string2);
        this.CurUNODialog.assignPropertyToDialogControl("cmdGoOn", "Enabled", new Boolean(false));
        exception.printStackTrace(System.out);
    }

    public void removeGroupName(XListBox xListBox, XListBox xListBox2, Vector vector) {
        block4: {
            try {
                short s = xListBox2.getSelectedItemPos();
                if (s <= -1) break block4;
                this.removeGroupNamesofRecordTable(xListBox2.getItemCount());
                String string = xListBox2.getItem(s);
                String string2 = this.CurDBMetaData.getFieldName(string);
                vector.removeElement(string2);
                xListBox.addItem(string, xListBox.getItemCount());
                this.CurUNODialog.assignPropertyToDialogControl("cmdGroupOut", "Enabled", new Boolean(xListBox.getSelectedItems().length > 0));
                this.CurUNODialog.assignPropertyToDialogControl("cmdGroupIn", "Enabled", new Boolean(!vector.isEmpty()));
                this.removeLastTextSection();
                this.removeLastTextTable();
                xListBox2.removeItems(s, (short)1);
                if (s != xListBox2.getItemCount()) {
                    this.updateTextSections(xListBox2);
                }
                short s2 = xListBox2.getItemCount();
                this.GroupFormatVector.remove(s2);
                if (s2 > 0) {
                    this.CurUNODialog.selectListBoxItem(xListBox2, s);
                    break block4;
                }
                this.CurUNODialog.assignPropertyToDialogControl("lblBlindTextNote_1", "Enabled", new Boolean(false));
            }
            catch (Exception exception) {
                this.showCommonReportErrorBox(exception);
            }
        }
    }

    public void getallDBColumns() {
        try {
            int n = this.CurDBMetaData.GroupFieldNames.length;
            int n2 = this.CurDBMetaData.FieldNames.length;
            int n3 = 0;
            while (n3 < n2) {
                DBColumn dBColumn = n3 < n ? new DBColumn(this.CurDBMetaData.GroupFieldNames[n3], n3, "Tbl_GroupField" + (n3 + 1), false) : new DBColumn(this.CurRecordTable, this.CurDBMetaData, n3 - n, false);
                if (dBColumn != null) {
                    this.GroupFormatVector.addElement(dBColumn);
                } else {
                    String string = Tools.replaceSubString(this.sMsgTableNotExisting, "Tbl_GroupField" + n, "<TABLENAME>");
                    UNODialogs.showMessageBox(this.xMSF, "ErrorBox", 0x400000, string);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            this.showCommonReportErrorBox(exception);
        }
    }

    public void selectFirstPage() {
        try {
            this.xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ReportDocument.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)this.xComponent);
            this.xViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextViewCursorSupplier == null ? (class$com$sun$star$text$XTextViewCursorSupplier = ReportDocument.class$("com.sun.star.text.XTextViewCursorSupplier")) : class$com$sun$star$text$XTextViewCursorSupplier), (Object)this.xTextDocument.getCurrentController());
            XPageCursor xPageCursor = (XPageCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XPageCursor == null ? (class$com$sun$star$text$XPageCursor = ReportDocument.class$("com.sun.star.text.XPageCursor")) : class$com$sun$star$text$XPageCursor), (Object)this.xViewCursorSupplier.getViewCursor());
            XTextCursor xTextCursor = (XTextCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextCursor == null ? (class$com$sun$star$text$XTextCursor = ReportDocument.class$("com.sun.star.text.XTextCursor")) : class$com$sun$star$text$XTextCursor), (Object)xPageCursor);
            xPageCursor.jumpToFirstPage();
            xPageCursor.jumpToStartOfPage();
            Tools.setUNOPropertyValue(xPageCursor, "PageDescName", "First Page");
            Object object = this.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = ReportDocument.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)object);
            Object object2 = xNameAccess.getByName("First Page");
            Object object3 = this.xTextTablesSupplier.getTextTables().hasByName("Tbl_GroupField1") ? this.xTextTablesSupplier.getTextTables().getByName("Tbl_GroupField1") : this.xTextTablesSupplier.getTextTables().getByName("Tbl_RecordSection");
            Tools.setUNOPropertyValue(object3, "PageDescName", "First Page");
            XTextRange xTextRange = (XTextRange)Tools.getUNOPropertyValue(object2, "HeaderText", class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = ReportDocument.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange);
            if (!AnyConverter.isVoid((Object)xTextRange)) {
                xTextCursor.gotoRange(xTextRange, false);
                xTextCursor.collapseToStart();
            } else {
                System.out.println("No Headertext available");
            }
            this.unlockallControllers();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DBColumn {
        public XCell xValCell;
        public XTextRange xValTextCell;
        public XTextCursor xValCellCursor;
        public XNumberFormats xValCellNumberFormats;
        public XCell xNameCell;
        public XTextRange xNameTextCell;
        public boolean bAlignLeft;
        public Object DefaultValue;
        public String CharFontName;
        public int FormatKey;
        public PropertyState PropertyState;
        public int ValColumn = 1;
        public int ValRow = 0;
        public DBMetaData.FieldColumn CurDBField;

        public DBColumn(RecordTable recordTable, DBMetaData dBMetaData, int n, boolean bl) throws Exception {
            if (recordTable == null) {
                recordTable = new RecordTable(ReportDocument.this.xTextTablesSupplier);
            }
            String string = dBMetaData.RecordFieldNames[n];
            this.CurDBField = dBMetaData.getFieldColumn(string);
            this.xNameCell = recordTable.xCellRange.getCellByPosition(n, 0);
            String string2 = (String)Tools.getUNOPropertyValue(this.xNameCell, "CellName");
            this.xNameTextCell = (XTextRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = ReportDocument.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange), (Object)this.xNameCell);
            this.xValCell = recordTable.xCellRange.getCellByPosition(n, 1);
            this.xValTextCell = (XTextRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = ReportDocument.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange), (Object)this.xValCell);
            this.xValCellCursor = ReportDocument.this.createTextCursor(this.xValCell);
            if (bl) {
                this.getNumberFormat();
                this.setCellFont();
            }
        }

        public DBColumn(String string, int n, String string2, boolean bl, DBColumn dBColumn) throws Exception {
            String string3 = "G" + String.valueOf(n + 1) + "xxx";
            XNameAccess xNameAccess = ReportDocument.this.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string2)) {
                this.CurDBField = ReportDocument.this.CurDBMetaData.getFieldColumn(string);
                Object object = xNameAccess.getByName(string2);
                XTextTable xTextTable = (XTextTable)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextTable == null ? (class$com$sun$star$text$XTextTable = ReportDocument.class$("com.sun.star.text.XTextTable")) : class$com$sun$star$text$XTextTable), (Object)object);
                XTableColumns xTableColumns = xTextTable.getColumns();
                this.xNameCell = dBColumn.xNameCell;
                this.xNameTextCell = dBColumn.xNameTextCell;
                this.xValCell = dBColumn.xValCell;
                this.xValTextCell = dBColumn.xValTextCell;
                this.xValCellCursor = ReportDocument.this.createTextCursor(this.xValCell);
                this.ValColumn = dBColumn.ValColumn;
                this.ValRow = dBColumn.ValRow;
                if (bl) {
                    this.formatValueCell(xTableColumns);
                }
            }
        }

        public DBColumn(String string, int n, String string2, boolean bl) throws Exception {
            String string3 = "G" + String.valueOf(n + 1) + "xxx";
            XNameAccess xNameAccess = ReportDocument.this.xTextTablesSupplier.getTextTables();
            if (xNameAccess.hasByName(string2)) {
                Object object = xNameAccess.getByName(string2);
                XTextTable xTextTable = (XTextTable)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextTable == null ? (class$com$sun$star$text$XTextTable = ReportDocument.class$("com.sun.star.text.XTextTable")) : class$com$sun$star$text$XTextTable), (Object)object);
                XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = ReportDocument.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)object);
                XTableColumns xTableColumns = xTextTable.getColumns();
                XTableRows xTableRows = xTextTable.getRows();
                int n2 = 0;
                while (n2 < xTableColumns.getCount()) {
                    int n3 = 0;
                    while (n3 < xTableRows.getCount()) {
                        XCell xCell = xCellRange.getCellByPosition(n2, n3);
                        XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRange == null ? ReportDocument.class$("com.sun.star.text.XTextRange") : class$com$sun$star$text$XTextRange), (Object)xCell);
                        String string4 = xTextRange.getString();
                        String string5 = string2.substring(4);
                        XTextCursor xTextCursor = ReportDocument.this.createTextCursor(xCell);
                        if (ReportDocument.this.isNameCell(xTextCursor, string, string5)) {
                            this.xNameCell = xCell;
                            this.xNameTextCell = xTextRange;
                        } else if (string4.equals(string3)) {
                            this.xValCell = xCell;
                            this.xValTextCell = xTextRange;
                            this.xValCellCursor = xTextCursor;
                            this.ValColumn = n2;
                            this.ValRow = n3;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                if (bl) {
                    this.CurDBField = ReportDocument.this.CurDBMetaData.getFieldColumn(string);
                    this.formatValueCell(xTableColumns);
                }
            }
        }

        public void getNumberFormat() {
            try {
                XPropertySet xPropertySet = ReportDocument.this.NumberFormats.getByKey(this.CurDBField.DBFormatKey);
                String string = AnyConverter.toString((Object)Tools.getUNOPropertyValue(xPropertySet, "FormatString"));
                Locale locale = (Locale)Tools.getUNOPropertyValue(xPropertySet, "Locale");
                int n = ReportDocument.this.NumberFormats.queryKey(string, locale, true);
                if (n == -1) {
                    n = ReportDocument.this.NumberFormats.addNew(string, locale);
                }
                Tools.setUNOPropertyValue(this.xValCell, "NumberFormat", new Integer(n));
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }

        public void formatValueCell(XTableColumns xTableColumns) {
            this.getNumberFormat();
            if (this.CurDBField.bIsNumberFormat && this.ValColumn == xTableColumns.getCount() - 1) {
                this.bAlignLeft = true;
                this.setCellFont();
            }
        }

        public void modifyCellContent(XCellRange xCellRange, Object object) {
            try {
                this.xValCell = xCellRange.getCellByPosition(this.ValColumn, this.ValRow);
                this.xValTextCell = (XTextRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = ReportDocument.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange), (Object)this.xValCell);
                this.modifyCellContent(object);
                if (this.bAlignLeft) {
                    this.xValCellCursor = ReportDocument.this.createTextCursor(this.xValCell);
                    Tools.setUNOPropertyValue(this.xValCellCursor, "ParaAdjust", new Integer(0));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }

        public void modifyCellContent(Object object) {
            block15: {
                double d = 0.0;
                try {
                    if (this.xValCell == null) break block15;
                    if (AnyConverter.isString((Object)object)) {
                        String string = AnyConverter.toString((Object)object);
                        this.xValTextCell.setString(string);
                        break block15;
                    }
                    boolean bl = AnyConverter.isVoid((Object)object);
                    if (AnyConverter.isBoolean((Object)object)) {
                        d = AnyConverter.toInt((Object)object);
                    }
                    if (AnyConverter.isByte((Object)object)) {
                        d = AnyConverter.toByte((Object)object);
                    } else if (AnyConverter.isDouble((Object)object)) {
                        d = AnyConverter.toDouble((Object)object);
                    } else if (AnyConverter.isFloat((Object)object)) {
                        d = AnyConverter.toFloat((Object)object);
                    } else if (AnyConverter.isInt((Object)object)) {
                        d = AnyConverter.toInt((Object)object);
                    } else if (AnyConverter.isLong((Object)object)) {
                        d = AnyConverter.toLong((Object)object);
                    } else if (AnyConverter.isShort((Object)object)) {
                        d = AnyConverter.toShort((Object)object);
                    }
                    this.xValCell.setValue(d);
                }
                catch (Exception exception) {
                    System.err.println((Object)exception);
                }
            }
        }

        public void replaceValueCellofTable(boolean bl) {
            block7: {
                try {
                    Object object = !bl && !this.CurDBField.bIsNumberFormat ? ReportDocument.this.CurDBMetaData.adjustBlindTextlength(this.CurDBField, ReportDocument.this.bIsCurLandscape) : this.CurDBField.DefaultValue;
                    this.modifyCellContent(object);
                    this.xValCellCursor.gotoStart(false);
                    this.xValCellCursor.gotoEnd(true);
                    if (this.bAlignLeft) {
                        Tools.setUNOPropertyValue(this.xValCellCursor, "ParaAdjust", new Integer(0));
                    }
                    if (this.CurDBField.FieldType == -7) {
                        this.CharFontName = "StarSymbol";
                        Tools.setUNOPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
                        if (bl) break block7;
                        Tools.setUNOPropertyValue(this.xValCellCursor, "ParaAdjust", new Integer(3));
                        break block7;
                    }
                    if (this.PropertyState == com.sun.star.beans.PropertyState.DEFAULT_VALUE) {
                        XPropertyState xPropertyState = (XPropertyState)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertyState == null ? (class$com$sun$star$beans$XPropertyState = ReportDocument.class$("com.sun.star.beans.XPropertyState")) : class$com$sun$star$beans$XPropertyState), (Object)this.xValCellCursor);
                        xPropertyState.setPropertyToDefault("CharFontName");
                    } else if (this.PropertyState == com.sun.star.beans.PropertyState.DIRECT_VALUE) {
                        Tools.setUNOPropertyValue(this.xValCellCursor, "CharFontName", this.CharFontName);
                    }
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    unknownPropertyException.printStackTrace(System.out);
                }
            }
        }

        public void setCellFont() {
            block3: {
                try {
                    int n = this.CurDBField.FieldType;
                    if (n == -7) {
                        this.CharFontName = "StarSymbol";
                        this.PropertyState = com.sun.star.beans.PropertyState.DIRECT_VALUE;
                        break block3;
                    }
                    XPropertyState xPropertyState = (XPropertyState)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertyState == null ? (class$com$sun$star$beans$XPropertyState = ReportDocument.class$("com.sun.star.beans.XPropertyState")) : class$com$sun$star$beans$XPropertyState), (Object)this.xValCellCursor);
                    this.PropertyState = xPropertyState.getPropertyState("CharFontName");
                    this.CharFontName = AnyConverter.toString((Object)Tools.getUNOPropertyValue(this.xValCellCursor, "CharFontName"));
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
            }
        }
    }

    class RecordTable {
        String CurFieldName;
        String LabelDescription;
        short ColumnIndex;
        long LabelWidth;
        long Valuewidth;
        long MinWidth;
        long MaxWidth;
        long DiffWidth;
        long CalcreducedWidth;
        long CalcincreasedWidth;
        boolean bIsunlimitedText;
        short bDecreaseWithPriority;
        double CharFactor;
        long ColumnMargin;
        public XNamed xTableName;
        public XCellRange xCellRange;
        public XTextTable xTextTable;

        public RecordTable(XTextTablesSupplier xTextTablesSupplier) {
            try {
                String[] stringArray = xTextTablesSupplier.getTextTables().getElementNames();
                XNameAccess xNameAccess = xTextTablesSupplier.getTextTables();
                if (!xNameAccess.hasByName("Tbl_RecordSection")) {
                    XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = ReportDocument.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess), (Object)xNameAccess);
                    this.xTextTable = (XTextTable)xIndexAccess.getByIndex(xIndexAccess.getCount() - 1);
                    this.xTableName = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = ReportDocument.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)this.xTextTable);
                    this.xTableName.setName("Tbl_RecordSection");
                } else {
                    Object object = xNameAccess.getByName("Tbl_RecordSection");
                    this.xTextTable = (XTextTable)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextTable == null ? (class$com$sun$star$text$XTextTable = ReportDocument.class$("com.sun.star.text.XTextTable")) : class$com$sun$star$text$XTextTable), (Object)object);
                    this.xTableName = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = ReportDocument.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)this.xTextTable);
                }
                this.xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = ReportDocument.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)this.xTextTable);
            }
            catch (NoSuchElementException noSuchElementException) {
                noSuchElementException.printStackTrace(System.out);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace(System.out);
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace(System.out);
            }
        }

        public void adjustOptimalTableWidths() {
            try {
                int n = this.xTextTable.getColumns().getCount();
                XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = ReportDocument.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)this.xTextTable);
                XCellRange xCellRange2 = xCellRange.getCellRangeByPosition(0, 0, n - 1, 1);
                short s = AnyConverter.toShort((Object)Tools.getUNOPropertyValue(this.xTextTable, "HoriOrient"));
                XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = ReportDocument.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)ReportDocument.this.xTextDocument.getCurrentController());
                xSelectionSupplier.select((Object)xCellRange2);
                Tools.dispatchURL(ReportDocument.this.xMSF, ".uno:DistributeColumns", ReportDocument.this.xFrame);
                Tools.dispatchURL(ReportDocument.this.xMSF, ".uno:SetOptimalColumnWidth", ReportDocument.this.xFrame);
                Tools.setUNOPropertyValue(this.xTextTable, "HoriOrient", new Short(s));
                XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextViewCursorSupplier == null ? (class$com$sun$star$text$XTextViewCursorSupplier = ReportDocument.class$("com.sun.star.text.XTextViewCursorSupplier")) : class$com$sun$star$text$XTextViewCursorSupplier), (Object)ReportDocument.this.xTextDocument.getCurrentController());
                XTextViewCursor xTextViewCursor = xTextViewCursorSupplier.getViewCursor();
                xTextViewCursor.collapseToStart();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }
}

