/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sun.star.help.Definitions;
import com.sun.star.help.DefinitionsSorted;
import com.sun.star.help.HelpDatabases;
import com.sun.star.help.HelpIndexer;
import com.sun.star.help.HelpPackager;
import com.sun.star.help.HelpURLStreamHandlerFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class HelpTransformer {
    Definitions definitions = new Definitions();
    private Stack _stack = new Stack();
    int _pos;
    String _expr;
    static final int STRINGTOKEN = 0;
    static final int KOMMATOKEN = 1;
    static final int LBRACKETTOKEN = 2;
    static final int COLONTOKEN = 3;
    static final int SEMTOKEN = 4;
    static final int RBRACKETTOKEN = 5;
    static final int ENDTOKEN = 6;
    int _tokentype;
    String _token;

    private static URL verurle(String string) {
        try {
            return new URL(string.charAt(0) == '/' ? "file://" + string : "file:///" + string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException.getMessage());
            return null;
        }
    }

    public HelpTransformer(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            this._stack.push(file);
        }
    }

    void transform(String string, HelpIndexer.ParseStuff parseStuff, HelpPackager helpPackager) {
        boolean bl = true;
        while (bl && !this._stack.empty()) {
            Object object;
            File file = (File)this._stack.pop();
            if (file.isDirectory()) {
                object = file.listFiles();
                int n = 0;
                while (n < ((File[])object).length) {
                    this._stack.push(object[n]);
                    ++n;
                }
                continue;
            }
            object = file.getAbsolutePath().replace('\\', '/');
            String string2 = HelpTransformer.verurle((String)object).toExternalForm();
            String string3 = ((String)object).substring(1 + string.length()).toLowerCase();
            helpPackager.addEntry(string3, parseStuff.parse(string2));
            System.out.println("added entry: " + string3);
        }
        helpPackager.close();
    }

    public void css(HelpIndexer.ParseStuff parseStuff) {
        Object object;
        String string = new String("e:/help/export/home/abi/help/pool.css");
        FileWriter fileWriter = null;
        try {
            new File(string).createNewFile();
            fileWriter = new FileWriter(string, true);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        boolean bl = true;
        boolean bl2 = false;
        while (bl && !this._stack.empty()) {
            File file = (File)this._stack.pop();
            if (file.isDirectory()) {
                object = file.listFiles();
                int n = 0;
                while (n < ((File[])object).length) {
                    this._stack.push(object[n]);
                    ++n;
                }
                continue;
            }
            object = file.getAbsolutePath().replace('\\', '/');
            String string2 = HelpTransformer.verurle((String)object).toExternalForm();
            try {
                byte[] byArray = parseStuff.parse(string2);
                String string3 = new String(byArray, "UTF8");
                this.divide(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(unsupportedEncodingException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            System.out.println("css determined: " + string2);
        }
        try {
            object = new DefinitionsSorted(this.definitions);
            object.print(fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    void divide(String string) {
        this._pos = 0;
        this._expr = string;
        this.nextToken();
        while (this._tokentype != 6) {
            LinkedList linkedList = new LinkedList();
            this.addNameTag(linkedList);
            if (this._tokentype != 2) {
                System.err.println("weia");
                System.exit(1);
            }
            Hashtable hashtable = new Hashtable();
            this.nextToken();
            this.addValueKey(hashtable);
            if (this._tokentype != 5) {
                System.err.println("weia");
                System.exit(1);
            }
            this.nextToken();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.definitions.addStyle(string2, hashtable);
            }
        }
    }

    void addValueKey(Hashtable hashtable) {
        while (this._tokentype == 0) {
            String string = this._token;
            this.nextToken();
            if (this._tokentype != 3) {
                System.err.println("no colon");
                System.exit(1);
            }
            this.nextToken();
            if (this._tokentype != 0) {
                System.err.println("_tokentype = " + this._tokentype);
                System.err.println("no value");
                System.exit(1);
            }
            String string2 = this._token;
            hashtable.put(string, string2);
            this.nextToken();
            if (this._tokentype != 4) {
                System.err.println("_tokentype = " + this._tokentype);
                System.err.println("no value");
                System.exit(1);
            }
            this.nextToken();
        }
    }

    void addNameTag(LinkedList linkedList) {
        this.addName(linkedList);
        while (this._tokentype == 1) {
            this.nextToken();
            this.addName(linkedList);
        }
    }

    void addName(LinkedList linkedList) {
        if (this._tokentype == 0) {
            linkedList.addLast(this._token);
            this.nextToken();
        } else {
            System.err.println(this._tokentype);
            System.err.println("aua weia");
            System.exit(1);
        }
    }

    void nextToken() {
        char c;
        while (this._pos < this._expr.length() && Character.isWhitespace(this._expr.charAt(this._pos))) {
            ++this._pos;
        }
        if (this._pos == this._expr.length()) {
            this._tokentype = 6;
            return;
        }
        if ((c = this._expr.charAt(this._pos++)) == ',') {
            this._tokentype = 1;
        } else if (c == '{') {
            this._tokentype = 2;
        } else if (c == ':') {
            this._tokentype = 3;
        } else if (c == ';') {
            this._tokentype = 4;
        } else if (c == '}') {
            this._tokentype = 5;
        } else {
            char[] cArray = new char[]{c};
            this._token = new String(cArray);
            while (this._pos < this._expr.length() && (c = this._expr.charAt(this._pos)) != ',' && c != '{' && c != ':' && c != ';' && c != '}') {
                this._token = this._token + c;
                ++this._pos;
            }
            this._tokentype = 0;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("HelpTransformer <XMLDir> <XSLFile> [HelpRoot]");
            System.exit(1);
        }
        String string = stringArray[0];
        System.out.println("------------------------");
        System.out.println("Starting Transformation:");
        System.out.println("------------------------");
        System.out.println("XMLDir=   " + stringArray[0]);
        System.out.println("XSLFile=  " + stringArray[1]);
        try {
            String string2 = HelpDatabases.getURLMode();
            HelpURLStreamHandlerFactory helpURLStreamHandlerFactory = new HelpURLStreamHandlerFactory(string2);
            URL.setURLStreamHandlerFactory(helpURLStreamHandlerFactory);
            String string3 = stringArray.length > 2 ? stringArray[2] : stringArray[0];
            HelpIndexer.ParseStuff parseStuff = new HelpIndexer.ParseStuff(HelpTransformer.verurle(stringArray[1]));
            HelpPackager helpPackager = new HelpPackager(stringArray[0] + ".jar");
            HelpTransformer helpTransformer = new HelpTransformer(stringArray[0]);
            helpTransformer.transform(string3, parseStuff, helpPackager);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

