/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.bind.serial.SerialInput;
import com.sleepycat.bdb.bind.serial.SerialOutput;
import com.sleepycat.bdb.util.FastInputStream;
import com.sleepycat.bdb.util.FastOutputStream;
import com.sleepycat.bdb.util.IOExceptionWrapper;
import java.io.IOException;

public class SerialFormat
implements DataFormat {
    private ClassCatalog classCatalog;
    private Class baseClass;

    public SerialFormat(ClassCatalog classCatalog, Class baseClass) {
        this.classCatalog = classCatalog;
        this.baseClass = baseClass;
    }

    public final Class getBaseClass() {
        return this.baseClass;
    }

    public final Object dataToObject(DataBuffer data) throws IOException {
        Object object = data.getDataFormation();
        if (object != null) {
            return object;
        }
        int length = data.getDataLength();
        byte[] hdr = SerialOutput.getStreamHeader();
        byte[] bufWithHeader = new byte[length + hdr.length];
        System.arraycopy(hdr, 0, bufWithHeader, 0, hdr.length);
        System.arraycopy(data.getDataBytes(), data.getDataOffset(), bufWithHeader, hdr.length, length);
        SerialInput jin = new SerialInput(new FastInputStream(bufWithHeader, 0, bufWithHeader.length), this.classCatalog);
        try {
            object = jin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOExceptionWrapper(e);
        }
        data.setDataFormation(object);
        return object;
    }

    public final void objectToData(Object object, DataBuffer data) throws IOException {
        if (this.baseClass != null && !this.baseClass.isInstance(object)) {
            throw new IllegalArgumentException("Data object class (" + object.getClass() + ") not an instance of format's base class (" + this.baseClass + ')');
        }
        FastOutputStream fo = new FastOutputStream();
        SerialOutput jos = new SerialOutput(fo, this.classCatalog);
        jos.writeObject(object);
        byte[] hdr = SerialOutput.getStreamHeader();
        data.setData(fo.getBufferBytes(), hdr.length, fo.getBufferLength() - hdr.length);
        data.setDataFormation(object);
    }
}

