/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.connection.XConnection;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.sandbox.Disposable;
import com.sun.star.lib.uno.bridges.java_remote.ProxyFactory;
import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionInputStream_Adapter;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionOutputStream_Adapter;
import com.sun.star.lib.uno.environments.java.java_environment;
import com.sun.star.lib.uno.environments.remote.IMessage;
import com.sun.star.lib.uno.environments.remote.IProtocol;
import com.sun.star.lib.uno.environments.remote.IReceiver;
import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.environments.remote.ThreadPoolFactory;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.util.IInvokable;
import com.sun.star.lib.util.IInvokeHook;
import com.sun.star.lib.util.IStableListener;
import com.sun.star.lib.util.IStableObject;
import com.sun.star.lib.util.WeakTable;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class java_remote_bridge
implements IBridge,
IReceiver,
RequestHandler,
XBridge,
Disposable,
XComponent,
IStableObject {
    private static final boolean DEBUG = false;
    public static IInvokeHook __MessageDispatcher_run_hook;
    protected XConnection _xConnection;
    protected InputStream _inputStream;
    protected DataOutputStream _outputStream;
    protected XInstanceProvider _xInstanceProvider;
    protected String _name = "remote";
    protected IProtocol _iProtocol;
    protected IEnvironment _java_environment;
    protected MessageDispatcher _messageDispatcher;
    protected int _life_count = 0;
    protected Hashtable _refHolders;
    protected Vector _listeners;
    protected Vector _stableListeners;
    protected boolean _negotiate;
    protected boolean _forceSynchronous;
    protected IThreadPool _iThreadPool;
    private int state = 0;
    private static final int STATE_ALIVE = 0;
    private static final int STATE_DISPOSING = 1;
    private static final int STATE_DISPOSED = 2;
    private final ProxyFactory proxyFactory;
    static /* synthetic */ Class class$com$sun$star$uno$IBridge;
    static /* synthetic */ Class class$com$sun$star$uno$XInterface;

    int getLifeCount() {
        return this._life_count;
    }

    IProtocol getProtocol() {
        return this._iProtocol;
    }

    private boolean hasRefHolder(String string, Type type) {
        return this._refHolders.containsKey(string + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addRefHolder(Object object, Type type, String string) {
        this.acquire();
        Hashtable hashtable = this._refHolders;
        synchronized (hashtable) {
            RefHolder refHolder = (RefHolder)this._refHolders.get(string + type);
            if (refHolder == null) {
                refHolder = new RefHolder();
                refHolder._type = type;
                refHolder._oid = string;
                refHolder._hardRef = object;
                this._refHolders.put(string + type, refHolder);
            }
            ++refHolder._mapCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remRefHolder(Type type, String string) {
        Hashtable hashtable = this._refHolders;
        synchronized (hashtable) {
            RefHolder refHolder = (RefHolder)this._refHolders.get(string + type);
            if (refHolder != null) {
                --refHolder._mapCount;
                if (refHolder._mapCount <= 0) {
                    this._refHolders.remove(string + type);
                }
                this.release();
            } else {
                System.err.println(this.getClass().getName() + ".remRefHolder - warning - unknown oid:" + string + " " + type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void freeHolders() {
        Hashtable hashtable = this._refHolders;
        synchronized (hashtable) {
            Enumeration enumeration = this._refHolders.elements();
            while (enumeration.hasMoreElements()) {
                RefHolder refHolder = (RefHolder)enumeration.nextElement();
                while (refHolder._mapCount > 0) {
                    --refHolder._mapCount;
                    this._java_environment.revokeInterface(refHolder._oid, refHolder._type);
                    this.release();
                }
            }
        }
    }

    private String parseAttributes(String string) {
        string = string.trim().toLowerCase();
        String string2 = null;
        int n = string.indexOf(44);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1).trim();
        } else {
            string2 = string;
            string = "";
        }
        string2 = string2.trim();
        boolean bl = false;
        while (string.length() > 0) {
            n = string.indexOf(44);
            String string3 = null;
            if (n >= 0) {
                string3 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            } else {
                string3 = string.trim();
                string = "";
            }
            String string4 = null;
            String string5 = null;
            n = string3.indexOf(61);
            if (n >= 0) {
                string4 = string3.substring(0, n).trim();
                string5 = string3.substring(n + 1).trim();
            } else {
                string4 = string3;
            }
            if (string4.equals("negotiate")) {
                this._negotiate = string5 != null ? Integer.parseInt(string5) == 1 : true;
                bl = true;
                continue;
            }
            if (string4.equals("forcesynchronous")) {
                this._forceSynchronous = string5 != null ? Integer.parseInt(string5) == 1 : true;
                if (!this._forceSynchronous || bl) continue;
                this._negotiate = true;
                continue;
            }
            System.err.println(this.getClass().getName() + ".<init> - unknown attribute:" + string4);
        }
        if (this._negotiate) {
            throw new com.sun.star.uno.RuntimeException("java_remote_bridge: negotiation not available yet, use negotiate=0 to disable");
        }
        return string2;
    }

    public java_remote_bridge(IEnvironment iEnvironment, IEnvironment iEnvironment2, Object[] objectArray) throws Exception {
        String string = this.parseAttributes((String)objectArray[0]);
        this._java_environment = iEnvironment;
        Class<?> clazz = Class.forName("com.sun.star.lib.uno.protocols." + string + "." + string);
        Constructor<?> constructor = clazz.getConstructor(class$com$sun$star$uno$IBridge == null ? (class$com$sun$star$uno$IBridge = java_remote_bridge.class$("com.sun.star.uno.IBridge")) : class$com$sun$star$uno$IBridge);
        this._iProtocol = (IProtocol)constructor.newInstance(this);
        this._xConnection = (XConnection)objectArray[1];
        this._xInstanceProvider = (XInstanceProvider)objectArray[2];
        this._inputStream = new XConnectionInputStream_Adapter(this._xConnection);
        this._outputStream = new DataOutputStream(new XConnectionOutputStream_Adapter(this._xConnection));
        if (objectArray.length > 3) {
            this._name = (String)objectArray[3];
        }
        if (this._java_environment == null || this._xConnection == null || this._iProtocol == null || this._inputStream == null || this._outputStream == null) {
            throw new IllegalArgumentException(this.getClass().getName());
        }
        this._refHolders = new Hashtable();
        this._listeners = new Vector();
        this._stableListeners = new Vector();
        this.proxyFactory = new ProxyFactory(this, this);
        this._messageDispatcher = new MessageDispatcher();
        this._messageDispatcher.start();
        this._iThreadPool = ThreadPoolFactory.createThreadPool();
    }

    private void notifyListeners() {
        EventObject eventObject = new EventObject((Object)this);
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            XEventListener xEventListener = (XEventListener)enumeration.nextElement();
            try {
                xEventListener.disposing(eventObject);
            }
            catch (com.sun.star.uno.RuntimeException runtimeException) {}
        }
    }

    private void notifyStableListeners() {
        EventObject eventObject = new EventObject((Object)this);
        Enumeration enumeration = this._stableListeners.elements();
        while (enumeration.hasMoreElements()) {
            IStableListener iStableListener = (IStableListener)enumeration.nextElement();
            iStableListener.deStable();
        }
    }

    public java_remote_bridge(Object[] objectArray) throws Exception {
        this(UnoRuntime.getEnvironment("java", null), UnoRuntime.getEnvironment("remote", null), objectArray);
    }

    public Object mapInterfaceTo(Object object, Type type) {
        this.checkDisposed();
        String[] stringArray = new String[1];
        if (object instanceof String) {
            stringArray[0] = (String)object;
        } else if (!this.proxyFactory.isProxy(object = this._java_environment.registerInterface(object, stringArray, type), type)) {
            this.addRefHolder(object, type, stringArray[0]);
        }
        return stringArray[0];
    }

    public Object mapInterfaceFrom(Object object, Type type) {
        this.checkDisposed();
        this.acquire();
        String string = (String)object;
        Object object2 = this._java_environment.getRegisteredInterface(string, type);
        if (object2 == null) {
            object2 = this._java_environment.registerInterface(this.proxyFactory.create(string, type), new String[]{string}, type);
        } else if (!this.hasRefHolder(string, type)) {
            try {
                this.sendRequest(string, type, "release", null, new Boolean[]{new Boolean(this._forceSynchronous)}, new Boolean[]{new Boolean(this._forceSynchronous)});
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".mapInterfaceFrom - unexpected: " + throwable);
            }
        }
        return object2;
    }

    public IEnvironment getSourceEnvironment() {
        return this._java_environment;
    }

    public IEnvironment getTargetEnvironment() {
        return null;
    }

    public synchronized void acquire() {
        ++this._life_count;
    }

    public synchronized void release() {
        --this._life_count;
        if (this._life_count <= 0) {
            this.dispose(new com.sun.star.uno.RuntimeException("end of life"));
        }
    }

    public void dispose() {
        this.dispose(new com.sun.star.uno.RuntimeException("user dispose"));
    }

    private synchronized void dispose(Throwable throwable) {
        if (this.state == 0) {
            this.state = 1;
            this.notifyListeners();
            this.notifyStableListeners();
            try {
                this._messageDispatcher._quit = true;
                this._xConnection.close();
                if (Thread.currentThread() != this._messageDispatcher && this._messageDispatcher.isAlive()) {
                    if (System.getProperty("os.name", "notlinux").toLowerCase().equals("linux") && System.getProperty("java.version", "not1.3").startsWith("1.3.0") && (System.getProperty("java.vendor", "notsun").toLowerCase().indexOf("sun") != -1 || System.getProperty("java.vendor", "notblackdown").toLowerCase().indexOf("blackdown") != -1)) {
                        this._messageDispatcher.suspend();
                        this._messageDispatcher.resume();
                    }
                    this._messageDispatcher.join(1000L);
                    if (this._messageDispatcher.isAlive()) {
                        this._messageDispatcher.interrupt();
                        this._messageDispatcher.join();
                    }
                }
                this._iThreadPool.dispose(throwable);
                this.freeHolders();
                Object object = WeakTable.__getObject(this._java_environment);
                if (object instanceof java_environment) {
                    ((java_environment)object).revokeAllProxies();
                }
                if (this._life_count != 0) {
                    // empty if block
                }
                this._xConnection = null;
                this._java_environment = null;
                this._messageDispatcher = null;
                this.state = 2;
            }
            catch (InterruptedException interruptedException) {
                System.err.println(this.getClass().getName() + ".dispose - InterruptedException:" + interruptedException);
            }
            catch (com.sun.star.io.IOException iOException) {
                System.err.println(this.getClass().getName() + ".dispose - IOException:" + (Object)((Object)iOException));
            }
        }
    }

    public Object getInstance(String string) {
        Object object = null;
        Type type = null;
        try {
            type = new Type(class$com$sun$star$uno$XInterface == null ? (class$com$sun$star$uno$XInterface = java_remote_bridge.class$("com.sun.star.uno.XInterface")) : class$com$sun$star$uno$XInterface);
        }
        catch (Exception exception) {
            throw new com.sun.star.uno.RuntimeException(exception.getMessage());
        }
        try {
            object = this.sendRequest(string, type, "queryInterface", new Object[]{type}, null, null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".getInstance - unexpected:" + throwable);
        }
        return object;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._iProtocol.getName() + "," + this._xConnection.getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReply(boolean bl, ThreadId threadId, Object object) {
        this.checkDisposed();
        try {
            DataOutputStream dataOutputStream = this._outputStream;
            synchronized (dataOutputStream) {
                this._iProtocol.writeReply(bl, threadId, object);
                this._iProtocol.flush(this._outputStream);
                this._outputStream.flush();
            }
        }
        catch (Exception exception) {
            this.dispose(exception);
            throw new DisposedException(this.getClass().getName() + ".sendReply - unexpected: " + exception);
        }
        catch (Error error) {
            this.dispose(error);
            throw error;
        }
    }

    public Object sendRequest(String string, Type type, String string2, Object[] objectArray) throws Throwable {
        Boolean[] booleanArray;
        Boolean[] booleanArray2;
        if (this._forceSynchronous) {
            Boolean[] booleanArray3 = new Boolean[1];
            booleanArray2 = booleanArray3;
            booleanArray3[0] = Boolean.TRUE;
        } else {
            booleanArray2 = null;
        }
        if (this._forceSynchronous) {
            Boolean[] booleanArray4 = new Boolean[1];
            booleanArray = booleanArray4;
            booleanArray4[0] = Boolean.TRUE;
        } else {
            booleanArray = null;
        }
        return this.sendRequest(string, type, string2, objectArray, booleanArray2, booleanArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sendRequest(Object object, Type type, String string, Object[] objectArray, Boolean[] booleanArray, Boolean[] booleanArray2) throws Throwable {
        DataOutputStream dataOutputStream;
        Object object2 = null;
        if (booleanArray == null) {
            booleanArray = new Boolean[1];
        }
        if (booleanArray2 == null) {
            booleanArray2 = new Boolean[1];
        }
        this.checkDisposed();
        if (string.equals("acquire")) {
            this.acquire();
        }
        boolean bl = false;
        ThreadId threadId = ThreadPoolFactory.getThreadId();
        Object object3 = null;
        try {
            dataOutputStream = this._outputStream;
            synchronized (dataOutputStream) {
                this._iProtocol.writeRequest((String)object, TypeDescription.getTypeDescription((Type)type), string, threadId, objectArray, booleanArray, booleanArray2);
                boolean bl2 = bl = booleanArray[0] != false && Thread.currentThread() != this._messageDispatcher;
                if (bl) {
                    object3 = this._iThreadPool.attach(threadId);
                }
                try {
                    this._iProtocol.flush(this._outputStream);
                    this._outputStream.flush();
                }
                catch (IOException iOException) {
                    DisposedException disposedException = new DisposedException(iOException.getMessage());
                    this.dispose((Throwable)disposedException);
                    throw disposedException;
                }
            }
            if (bl) {
                object2 = this._iThreadPool.enter(object3, threadId);
            }
            Object var16_15 = null;
            if (bl) {
                this._iThreadPool.detach(object3, threadId);
            }
            if (string.equals("release")) {
                this.release();
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (bl) {
                this._iThreadPool.detach(object3, threadId);
            }
            if (string.equals("release")) {
                this.release();
            }
            throw throwable;
        }
        if (string.equals("queryInterface") && object2 instanceof Any) {
            dataOutputStream = (Any)object2;
            object2 = dataOutputStream.getType().getTypeClass() == TypeClass.INTERFACE ? dataOutputStream.getObject() : null;
        }
        return object2;
    }

    public void addEventListener(XEventListener xEventListener) {
        this._listeners.addElement(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this._listeners.removeElement(xEventListener);
    }

    public void addStableListener(IStableListener iStableListener) {
        this._stableListeners.addElement(iStableListener);
    }

    public void removeStableListener(IStableListener iStableListener) {
        this._stableListeners.removeElement(iStableListener);
    }

    private void checkDisposed() {
        if (this.state == 2) {
            throw new DisposedException("java_remote_bridge " + this + " is disposed");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RefHolder {
        Type _type;
        String _oid;
        int _mapCount;
        Object _hardRef;

        private RefHolder() {
        }
    }

    public class MessageDispatcher
    extends Thread
    implements IInvokable {
        boolean _quit = false;
        private ThreadId _threadId;

        MessageDispatcher() {
            super("MessageDispatcher");
        }

        public void run() {
            this._threadId = ThreadPoolFactory.getThreadId();
            if (__MessageDispatcher_run_hook != null) {
                try {
                    __MessageDispatcher_run_hook.invoke(this, null);
                }
                catch (Exception exception) {
                    System.err.println(this.getClass().getName() + " - unexpected: method >invoke< threw an exception - " + exception);
                    exception.printStackTrace();
                }
            } else {
                this.invoke(null);
            }
        }

        public Object invoke(Object[] objectArray) {
            DisposedException disposedException = null;
            try {
                do {
                    String[] stringArray;
                    Object object;
                    IMessage iMessage;
                    if ((iMessage = java_remote_bridge.this._iProtocol.readMessage(java_remote_bridge.this._inputStream)).getThreadId().equals(this._threadId)) continue;
                    String string = iMessage.getOperation();
                    String string2 = iMessage.getOid();
                    if (string != null && string.equals("release")) {
                        object = new Type(iMessage.getInterface());
                        java_remote_bridge.this._java_environment.revokeInterface(string2, (Type)object);
                        java_remote_bridge.this.remRefHolder((Type)object, string2);
                        if (iMessage.mustReply()) {
                            java_remote_bridge.this.sendReply(false, iMessage.getThreadId(), null);
                        }
                    } else if (string != null && string.equals("acquire")) {
                        object = new Type(iMessage.getInterface());
                        stringArray = new String[]{string2};
                        java_remote_bridge.this._java_environment.registerInterface(null, stringArray, (Type)object);
                        java_remote_bridge.this.addRefHolder(null, (Type)object, string2);
                    } else {
                        object = null;
                        if (string != null) {
                            stringArray = new Type(iMessage.getInterface());
                            object = java_remote_bridge.this._java_environment.getRegisteredInterface(string2, (Type)stringArray);
                            com.sun.star.uno.RuntimeException runtimeException = null;
                            if (object == null) {
                                if (java_remote_bridge.this._xInstanceProvider == null) {
                                    runtimeException = new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".dispatch - no instance provider set and unknown object:" + string2);
                                } else {
                                    try {
                                        object = java_remote_bridge.this._xInstanceProvider.getInstance(string2);
                                        if (object == null && !string.equals("queryInterface")) {
                                            runtimeException = new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".dispatch: instance provider returned null and operation >" + string + "< not supported on null");
                                        }
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        runtimeException = new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".dispatch - wrapped exception:" + (Object)((Object)noSuchElementException));
                                    }
                                    catch (com.sun.star.uno.RuntimeException runtimeException2) {
                                        runtimeException = runtimeException2;
                                    }
                                }
                            }
                            if (runtimeException != null) {
                                java_remote_bridge.this.sendReply(true, iMessage.getThreadId(), (Object)runtimeException);
                                iMessage = null;
                            }
                        }
                        if (iMessage != null) {
                            stringArray = new Job(object, java_remote_bridge.this, iMessage);
                            java_remote_bridge.this._iThreadPool.putJob((Job)stringArray);
                            stringArray = null;
                        }
                    }
                    iMessage = null;
                } while (!this._quit);
            }
            catch (EOFException eOFException) {
                if (!this._quit) {
                    // empty if block
                }
                disposedException = new DisposedException(eOFException.getMessage());
            }
            catch (Exception exception) {
                disposedException = new DisposedException(exception.getMessage());
            }
            if (!this._quit) {
                java_remote_bridge.this.dispose((Throwable)disposedException);
            }
            return null;
        }
    }
}

