/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.EndianConverter;

public class Pane
implements BIFFRecord {
    private byte[] x = new byte[2];
    private byte[] y = new byte[2];
    private byte[] rwTop = new byte[2];
    private byte[] colLeft = new byte[2];
    private byte pnnAcct;

    public Pane() {
        this.pnnAcct = (byte)2;
    }

    public Pane(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public short getBiffType() {
        return 65;
    }

    public Point getFreezePoint() {
        return new Point(EndianConverter.readShort((byte[])this.x), EndianConverter.readShort((byte[])this.y));
    }

    public int getLeft() {
        return EndianConverter.readShort((byte[])this.colLeft);
    }

    public int getPaneNumber() {
        return this.pnnAcct;
    }

    public Point getSplitPoint() {
        int n = EndianConverter.readShort((byte[])this.x) / 11;
        int n2 = EndianConverter.readShort((byte[])this.y) / 15;
        return new Point(n, n2);
    }

    public int getTop() {
        return EndianConverter.readShort((byte[])this.rwTop);
    }

    public int read(InputStream inputStream) throws IOException {
        int n = inputStream.read(this.x);
        n += inputStream.read(this.y);
        n += inputStream.read(this.rwTop);
        n += inputStream.read(this.colLeft);
        this.pnnAcct = (byte)inputStream.read();
        Debug.log((int)4, (String)("\tx : " + EndianConverter.readShort((byte[])this.x) + " y : " + EndianConverter.readShort((byte[])this.y) + " rwTop : " + EndianConverter.readShort((byte[])this.rwTop) + " colLeft : " + EndianConverter.readShort((byte[])this.colLeft) + " pnnAcct : " + this.pnnAcct));
        return ++n;
    }

    public void setLeft(int n) {
        this.colLeft = EndianConverter.writeShort((short)((short)n));
    }

    public void setPaneNumber(int n) {
        this.pnnAcct = (byte)n;
    }

    public void setSplitPoint(Point point, Point point2) {
        if (point.getX() == 1.0 || point.getY() == 1.0) {
            int n = (int)point2.getY();
            short s = (short)(n * 15);
            this.y = EndianConverter.writeShort((short)s);
            int n2 = (int)point2.getX();
            short s2 = (short)(n2 * 11);
            this.x = EndianConverter.writeShort((short)s2);
        } else {
            this.y = EndianConverter.writeShort((short)((short)point2.getY()));
            this.x = EndianConverter.writeShort((short)((short)point2.getX()));
        }
    }

    public void setTop(int n) {
        this.rwTop = EndianConverter.writeShort((short)((short)n));
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBiffType());
        outputStream.write(this.x);
        outputStream.write(this.y);
        outputStream.write(this.rwTop);
        outputStream.write(this.colLeft);
        outputStream.write(this.pnnAcct);
        Debug.log((int)4, (String)"Writing Pane record");
    }
}

