/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.Identifier;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public final class FieldElement
extends MemberElement {
    private static final ElementFormat FIELD_FORMAT = new ElementFormat("{m,,\" \"}{t} {n}");
    static final long serialVersionUID = 2195820119328567201L;
    static /* synthetic */ Class class$org$openide$src$FieldElement;
    static /* synthetic */ Class class$org$openide$src$ElementFormat;

    public FieldElement() {
        this(new Memory(), null);
    }

    public FieldElement(Impl impl, ClassElement classElement) {
        super(impl, classElement);
    }

    public Object clone() {
        return new FieldElement(new Memory(this), null);
    }

    final Impl getFieldImpl() {
        return (Impl)this.impl;
    }

    public Type getType() {
        return this.getFieldImpl().getType();
    }

    public void setType(Type type) throws SourceException {
        if (type == null) {
            this.throwSourceException(NbBundle.getMessage(class$org$openide$src$FieldElement == null ? (class$org$openide$src$FieldElement = FieldElement.class$("org.openide.src.FieldElement")) : class$org$openide$src$FieldElement, "ERR_NullType"));
        } else if (type.equals(Type.VOID)) {
            this.throwSourceException(NbBundle.getMessage(class$org$openide$src$FieldElement == null ? (class$org$openide$src$FieldElement = FieldElement.class$("org.openide.src.FieldElement")) : class$org$openide$src$FieldElement, "ERR_FieldTypeVoid"));
        }
        this.getFieldImpl().setType(type);
    }

    public String getInitValue() {
        return this.getFieldImpl().getInitValue();
    }

    public void setInitValue(String string) throws SourceException {
        this.getFieldImpl().setInitValue(string);
    }

    public int getModifiersMask() {
        if (this.isDeclaredInInterface()) {
            return 25;
        }
        return 223;
    }

    public final void setName(Identifier identifier) throws SourceException {
        FieldElement fieldElement;
        ClassElement classElement = this.getDeclaringClass();
        if (classElement != null && (fieldElement = classElement.getField(identifier)) != null && fieldElement != this) {
            String string = NbBundle.getMessage(class$org$openide$src$ElementFormat == null ? (class$org$openide$src$ElementFormat = FieldElement.class$("org.openide.src.ElementFormat")) : class$org$openide$src$ElementFormat, "FMT_EXC_RenameField", classElement.getName().getName(), identifier);
            this.throwSourceException(string);
        }
        super.setName(identifier);
    }

    public JavaDoc.Field getJavaDoc() {
        return this.getFieldImpl().getJavaDoc();
    }

    public void print(ElementPrinter elementPrinter) throws ElementPrinterInterruptException {
        elementPrinter.markField(this, 0);
        JavaDoc.Field field = this.getJavaDoc();
        if (field != null && !field.isEmpty()) {
            elementPrinter.markField(this, 2);
            Element.printJavaDoc(field, elementPrinter);
            elementPrinter.markField(this, 3);
            elementPrinter.println("");
        }
        elementPrinter.markField(this, 4);
        elementPrinter.print(FIELD_FORMAT.format(this));
        elementPrinter.markField(this, 5);
        String string = this.getInitValue();
        if (string.length() > 0) {
            elementPrinter.print(" = ");
            elementPrinter.markField(this, 6);
            elementPrinter.print(string);
            elementPrinter.markField(this, 7);
        }
        elementPrinter.print(";");
        elementPrinter.markField(this, 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Memory
    extends MemberElement.Memory
    implements Impl {
        private Type type;
        private String initValue;
        private JavaDoc.Field javaDoc;
        static final long serialVersionUID = 1407258001185361107L;

        Memory() {
            this.type = Type.VOID;
            this.initValue = "";
            this.javaDoc = JavaDocSupport.createFieldJavaDoc(null);
        }

        Memory(FieldElement fieldElement) {
            super(fieldElement);
            this.type = fieldElement.getType();
            this.initValue = fieldElement.getInitValue();
            this.javaDoc = fieldElement.getJavaDoc().isEmpty() ? JavaDocSupport.createFieldJavaDoc(null) : JavaDocSupport.createFieldJavaDoc(fieldElement.getJavaDoc().getRawText());
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            Type type2 = this.type;
            this.type = type;
            this.firePropertyChange("type", type2, type);
        }

        public String getInitValue() {
            return this.initValue;
        }

        public void setInitValue(String string) {
            String string2 = this.initValue;
            this.initValue = string;
            this.firePropertyChange("initValue", string2, string);
        }

        public JavaDoc.Field getJavaDoc() {
            return this.javaDoc;
        }

        public Object readResolve() {
            return new FieldElement(this, null);
        }
    }

    public static interface Impl
    extends MemberElement.Impl {
        public static final long serialVersionUID = -1612065404733395830L;

        public Type getType();

        public void setType(Type var1) throws SourceException;

        public String getInitValue();

        public void setInitValue(String var1) throws SourceException;

        public JavaDoc.Field getJavaDoc();
    }
}

