/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.aportisdoc;

import java.io.IOException;
import java.util.Enumeration;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentDeserializer;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PalmDocument;
import org.openoffice.xmerge.converter.palm.Record;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocConstants;
import org.openoffice.xmerge.converter.xml.sxw.aportisdoc.DocDecoder;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DocumentDeserializerImpl
implements OfficeConstants,
DocConstants,
DocumentDeserializer {
    private ConvertData cd = null;

    public DocumentDeserializerImpl(ConvertData cd) {
        this.cd = cd;
    }

    public Document deserialize() throws IOException, ConvertException {
        int numberOfPDBs = this.cd.getNumDocuments();
        SxwDocument doc = null;
        boolean i = false;
        Enumeration e = this.cd.getDocumentEnumeration();
        while (e.hasMoreElements()) {
            PalmDocument palmDoc = (PalmDocument)e.nextElement();
            PalmDB pdb = palmDoc.getPdb();
            this.log("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.log("<AportisDoc>");
            Record[] recs = pdb.getRecords();
            String docName = palmDoc.getName();
            DocDecoder decoder = new DocDecoder();
            String text = decoder.parseRecords(recs);
            doc = this.buildDocument(docName, text);
            this.log("</AportisDoc>");
        }
        return doc;
    }

    private SxwDocument buildDocument(String docName, String str) throws IOException {
        SxwDocument sxwDoc = new SxwDocument(docName);
        sxwDoc.initContentDOM();
        org.w3c.dom.Document doc = sxwDoc.getContentDOM();
        NodeList list = doc.getElementsByTagName("office:body");
        Node bodyNode = list.item(0);
        char[] text = str.toCharArray();
        int startIndex = -1;
        Element paraNode = doc.createElement("text:p");
        this.log("<PARA>");
        int i = 0;
        while (i < text.length) {
            switch (text[i]) {
                case '\t': {
                    if (startIndex >= 0) {
                        this.addTextNode(doc, paraNode, text, startIndex, i - 1);
                        startIndex = -1;
                    }
                    Element tabNode = doc.createElement("text:tab-stop");
                    paraNode.appendChild(tabNode);
                    this.log("<TAB/>");
                    break;
                }
                case '\n': {
                    if (startIndex >= 0) {
                        this.addTextNode(doc, paraNode, text, startIndex, i - 1);
                        startIndex = -1;
                    }
                    bodyNode.appendChild(paraNode);
                    paraNode = doc.createElement("text:p");
                    this.log("</PARA>");
                    this.log("<PARA>");
                    break;
                }
                case ' ': {
                    int count = 0;
                    while (text[i + 1 + count] == ' ') {
                        ++count;
                    }
                    if (count > 0) {
                        if (startIndex >= 0) {
                            this.addTextNode(doc, paraNode, text, startIndex, i);
                            startIndex = -1;
                        }
                        Element spaceNode = doc.createElement("text:s");
                        spaceNode.setAttribute("text:c", Integer.toString(count));
                        paraNode.appendChild(spaceNode);
                        i += count;
                        this.log("<SPACE count=\"" + count + "\" />");
                        break;
                    }
                    if (startIndex >= 0) break;
                    startIndex = i;
                    this.log("<TEXT>");
                    break;
                }
                default: {
                    if (startIndex >= 0) break;
                    startIndex = i;
                    this.log("<TEXT>");
                }
            }
            ++i;
        }
        int lastIndex = text.length - 1;
        if (startIndex >= 0) {
            this.addTextNode(doc, paraNode, text, startIndex, lastIndex);
        }
        if (text[lastIndex] != '\n') {
            bodyNode.appendChild(paraNode);
        }
        this.log("</PARA>");
        return sxwDoc;
    }

    private void addTextNode(org.w3c.dom.Document doc, Node para, char[] text, int startPos, int endPos) {
        String str = new String(text, startPos, endPos - startPos + 1);
        Text textNode = doc.createTextNode(str);
        para.appendChild(textNode);
        this.log(str);
        this.log("</TEXT>");
    }

    private void log(String str) {
        Debug.log((int)4, (String)str);
    }
}

