/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.indexer;

import com.jclark.xsl.dom.Transform;
import com.jclark.xsl.dom.XSLTransformEngine;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.XMLProcessorImpl;
import com.jclark.xsl.tr.LoadContext;
import com.jclark.xsl.tr.Result;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xmlsearch.tree.ResultAdapter;
import com.sun.xmlsearch.tree.TreeBuilder;
import com.sun.xmlsearch.util.Compressor;
import com.sun.xmlsearch.util.ConceptLocation;
import com.sun.xmlsearch.util.IntegerArray;
import com.sun.xmlsearch.util.LineInput;
import com.sun.xmlsearch.util.PrefixTranslator;
import com.sun.xmlsearch.util.Token;
import com.sun.xmlsearch.util.Tokenizer;
import com.sun.xmlsearch.xml.XmlIndex;
import com.sun.xmlsearch.xml.indexer.ElementIndexer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;

public final class XmlIndexBuilder {
    private final String Http = "http://localhost:8084/";
    private static int InitSize = 4096;
    private int _size = InitSize;
    private int _free = 0;
    private ConceptLocation[] _locations = new ConceptLocation[this._size];
    private XmlIndex _index;
    private int _currentDocID = 0;
    private Hashtable _indexers = new Hashtable();
    private Hashtable _stoplist = new Hashtable();
    private Hashtable _linkCodes = new Hashtable();
    private Vector _linknames = new Vector();
    private static int CurrenMaxLinkCode = 0;
    private int _availContextNumber;
    private int _lastWordNumber;
    private int _firstWord;
    private boolean _anyLocationsStored = false;
    private Hashtable _nodes = new Hashtable(4096);
    private IntegerArray _initialWords = new IntegerArray(512);
    private IntegerArray _links = new IntegerArray(512);
    private IntegerArray _dests = new IntegerArray(512);
    private IntegerArray _seqNumbers = new IntegerArray(512);
    private ElementIndexer _defaultIndexer;
    private PrefixTranslator _prefixTransl;
    private String _transformLocation = null;
    private boolean _useLocalTransformFile = false;
    private TreeBuilder _treeBuilder;
    private MyXslEngine _transformEngine;
    private Transform _indexingTransform;
    private Transform _defaultTransform;
    private IndexAdapter _indexAdapter;

    public XmlIndexBuilder(String string) throws Exception {
        this._index = new XmlIndex(string, true);
    }

    public boolean init(String string) throws Exception {
        if (this._index.init()) {
            File file = new File(System.getProperty("XMLSEARCH"), "etc");
            this.readStoplist(new File(file, "StopList"));
            this.reset();
            String[] stringArray = this._index.getLinkNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.getLinkCode(stringArray[i]);
                }
            }
            this.initXmlProcessor(string);
            return true;
        }
        return false;
    }

    public void indexDocument(URL uRL, String string) throws Exception {
        InputSource inputSource = new InputSource(uRL.openStream());
        inputSource.setSystemId(uRL.toString());
        ValidatingParser validatingParser = new ValidatingParser();
        validatingParser.setFastStandalone(true);
        XMLProcessorImpl xMLProcessorImpl = new XMLProcessorImpl((Parser)validatingParser);
        Node node = xMLProcessorImpl.load(inputSource, 0, this._transformEngine.getSourceLoadContext(), this._transformEngine.getNameTable());
        this.recordNodes(node.getChildren().next());
        this.openDocument(uRL.toString());
        this._indexAdapter.init();
        this._indexingTransform.transform(node, (Result)this._indexAdapter);
        this._indexAdapter.finish();
        this.closeDocument(string);
        this._nodes.clear();
    }

    private void recordNodes(Node node) {
        switch (node.getType()) {
            case 0: {
                Node node2;
                this._nodes.put(node.getGeneratedId(), node);
                SafeNodeIterator safeNodeIterator = node.getAttributes();
                while ((node2 = safeNodeIterator.next()) != null) {
                    this._nodes.put(node2.getGeneratedId(), node2);
                }
                safeNodeIterator = node.getChildren();
                while ((node2 = safeNodeIterator.next()) != null) {
                    this.recordNodes(node2);
                }
                break;
            }
            case 1: {
                this._nodes.put(node.getGeneratedId(), node);
            }
        }
    }

    private final void initXmlProcessor(String string) throws Exception {
        this._transformEngine = new MyXslEngine();
        NameTable nameTable = this._transformEngine.getNameTable();
        this._treeBuilder = new TreeBuilder(nameTable);
        this._defaultTransform = this.getTransform("default");
        this._indexingTransform = this.getTransform(string);
        this._indexAdapter = new IndexAdapter(nameTable);
    }

    private Node parseTargetDocument(URL uRL) throws Exception {
        return this._treeBuilder.getRoot(uRL);
    }

    private Transform getTransform(String string) throws Exception {
        System.out.println("creating indexing transform: " + string);
        URL uRL = null;
        uRL = this._useLocalTransformFile ? new URL("file:" + this._transformLocation + "/" + string + ".xsl") : new URL("http://localhost:8084/" + string + ".xsl");
        System.out.println(uRL.toString());
        InputStream inputStream = uRL.openStream();
        XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputStream)inputStream, (boolean)false);
        return this._transformEngine.createTransform((org.w3c.dom.Node)xmlDocument);
    }

    public void setTransformLocation(String string) {
        this._transformLocation = null;
        this._useLocalTransformFile = false;
        File file = new File(string);
        if (file.exists()) {
            this._transformLocation = string;
            this._useLocalTransformFile = true;
        }
    }

    public void setPrefixTranslator(PrefixTranslator prefixTranslator) {
        this._prefixTransl = prefixTranslator;
    }

    public void updateIndex(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) throws Exception {
        String string;
        this._index.pruneIndex(hashtable, hashtable2);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.println("= " + string);
            this.indexDocument(new URL(string), "xml");
        }
        enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            System.out.println("+ " + string);
            this.indexDocument(new URL(string), "xml");
        }
    }

    public void clearIndex() throws IOException {
        this._index.clear();
    }

    private int intern(String string) throws Exception {
        return this._index.intern(string);
    }

    public void openDocument(String string) throws Exception {
        if (this._currentDocID != 0) {
            throw new Exception("document already open");
        }
        this._currentDocID = this.intern(this._prefixTransl != null ? this._prefixTransl.translatePrefix(string) : string);
        this.reset();
    }

    public void closeDocument(String string) throws Exception {
        if (this._currentDocID == 0) {
            throw new Exception("no document open");
        }
        if (this._free > 0) {
            IntegerArray integerArray = new IntegerArray();
            Compressor compressor = new Compressor();
            Compressor compressor2 = new Compressor();
            Compressor compressor3 = new Compressor();
            Compressor compressor4 = new Compressor();
            integerArray.add(compressor.compressAscending(this._initialWords));
            integerArray.add(compressor2.minimize(this._dests, 2));
            integerArray.add(compressor3.minimize(this._links, 2));
            integerArray.add(compressor4.minimize(this._seqNumbers, 2));
            Compressor compressor5 = new Compressor();
            int n = compressor5.minimize(integerArray, 4);
            compressor5.concatenate(compressor);
            compressor5.concatenate(compressor2);
            compressor5.concatenate(compressor3);
            compressor5.concatenate(compressor4);
            this._index.compress(this._currentDocID, this.intern(string), this._locations, this._free, null, 0, n, compressor5);
        } else {
            System.out.println("no indexable content");
        }
        this._free = 0;
        this._currentDocID = 0;
    }

    private void readStoplist(File file) {
        try {
            String string;
            LineInput lineInput = new LineInput(new FileInputStream(file));
            while ((string = lineInput.readLine()) != null) {
                this._stoplist.put(string.trim(), this);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void close() throws Exception {
        Object[] objectArray = this._linknames.toArray(new String[this._linknames.size()]);
        this._index.saveLinkNames(objectArray);
        this._index.close();
        System.out.println("done");
    }

    private void reset() {
        this._availContextNumber = 0;
        this._lastWordNumber = 0;
        this._free = 0;
        this._anyLocationsStored = false;
        this._initialWords.clear();
        this._dests.clear();
        this._links.clear();
        this._seqNumbers.clear();
    }

    private void storeToken(String string) throws Exception {
        int n = this._lastWordNumber++;
        if (this._stoplist.get(string) == null) {
            this.storeLocation(string, n);
        }
    }

    private void storeLocation(String string, int n) throws Exception {
        if (this._free == this._size) {
            ConceptLocation[] conceptLocationArray = new ConceptLocation[this._size *= 2];
            System.arraycopy(this._locations, 0, conceptLocationArray, 0, this._free);
            this._locations = conceptLocationArray;
        }
        this._locations[this._free++] = new ConceptLocation(this.intern(string), n, n);
        this._anyLocationsStored = true;
    }

    private int getLinkCode(String string) {
        Integer n = (Integer)this._linkCodes.get(string);
        if (n != null) {
            return n;
        }
        this._linknames.addElement(string);
        int n2 = CurrenMaxLinkCode++;
        this._linkCodes.put(string, new Integer(n2));
        return n2;
    }

    private void storeEdge(int n, int n2, int n3) {
        this._links.add(n);
        this._seqNumbers.add(n2);
        this._dests.add(n3);
    }

    static /* synthetic */ ConceptLocation[] access$1202(XmlIndexBuilder xmlIndexBuilder, ConceptLocation[] conceptLocationArray) {
        xmlIndexBuilder._locations = conceptLocationArray;
        return conceptLocationArray;
    }

    private final class IndexAdapter
    extends ResultAdapter {
        private static final String IndexNS = "http://sun.com/2000/XMLSearch";
        private static final String DefTok = "com.sun.xmlsearch.util.SimpleTokenizer";
        private static final int StackSize = 64;
        private final Name _indexText_Name;
        private final Name _indexElement_Name;
        private final Name _indexAttribute_Name;
        private final Name _nodeID_Name;
        private final Name _tokenizer_Name;
        private final Name _attributeName_Name;
        private Vector _textNodes = new Vector(512);
        private Hashtable _tokenizers = new Hashtable();
        private Tokenizer _defaultTokenizer;
        private Hashtable _numberedNodes = new Hashtable(4096);
        private boolean[] _indexOnOffStack = new boolean[64];
        private int _sp;
        private Tokenizer[] _tokenizerStack = new Tokenizer[64];
        private int _tsp;
        private String[] _attributeStack = new String[64];
        private int _attrSP;
        private Node _currentNode;

        public IndexAdapter(NameTable nameTable) {
            this._indexText_Name = nameTable.createName("index:text", IndexNS);
            this._indexElement_Name = nameTable.createName("index:element", IndexNS);
            this._indexAttribute_Name = nameTable.createName("index:attribute", IndexNS);
            this._nodeID_Name = nameTable.createName("index:nodeID", IndexNS);
            this._tokenizer_Name = nameTable.createName("index:tokenizer", IndexNS);
            this._attributeName_Name = nameTable.createName("index:attributeName", IndexNS);
            this._defaultTokenizer = this.getTokenizer(DefTok);
        }

        public void init() throws XSLException {
            XmlIndexBuilder.this._availContextNumber = 0;
            XmlIndexBuilder.this._lastWordNumber = 0;
            XmlIndexBuilder.this._anyLocationsStored = false;
            XmlIndexBuilder.this._initialWords.clear();
            this._sp = -1;
            this._tsp = -1;
            this._attrSP = -1;
            XmlIndexBuilder.this._free = 0;
        }

        public void finish() throws XSLException {
            int n;
            Object object;
            Node node;
            SafeNodeIterator safeNodeIterator;
            Node node2;
            int n2;
            this._numberedNodes.clear();
            XmlIndexBuilder.this._dests.clear();
            XmlIndexBuilder.this._seqNumbers.clear();
            XmlIndexBuilder.this._links.clear();
            int n3 = this._textNodes.size();
            XmlIndexBuilder.this._availContextNumber = n3;
            Vector<Node> vector = new Vector<Node>(n3 * 2);
            for (n2 = 0; n2 < n3; ++n2) {
                Node node3 = (Node)this._textNodes.elementAt(n2);
                node2 = node3.getParent();
                safeNodeIterator = node2.getChildren();
                int n4 = 1;
                while ((node = safeNodeIterator.next()) != node3) {
                    if (node.getType() != 1) continue;
                    ++n4;
                }
                XmlIndexBuilder.this._seqNumbers.add(n4);
                object = this._numberedNodes.get(node2);
                if (object == null) {
                    n = XmlIndexBuilder.this._availContextNumber++;
                    this._numberedNodes.put(node2, new Integer(n));
                    XmlIndexBuilder.this._dests.add(n);
                    vector.addElement(node2);
                    continue;
                }
                XmlIndexBuilder.this._dests.add((Integer)object);
            }
            this._textNodes.setSize(0);
            n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                node2 = (Node)vector.elementAt(i);
                safeNodeIterator = node2.getName();
                node = node2.getParent();
                XmlIndexBuilder.this._links.add(XmlIndexBuilder.this.getLinkCode(safeNodeIterator.toString()));
                if (node.getType() == 0) {
                    SafeNodeIterator safeNodeIterator2 = node.getChildren();
                    n = 1;
                    while ((object = safeNodeIterator2.next()) != node2) {
                        if (object.getName() != safeNodeIterator) continue;
                        ++n;
                    }
                    XmlIndexBuilder.this._seqNumbers.add(n);
                    Object v = this._numberedNodes.get(node);
                    if (v == null) {
                        int n5 = XmlIndexBuilder.this._availContextNumber++;
                        this._numberedNodes.put(node, new Integer(n5));
                        XmlIndexBuilder.this._dests.add(n5);
                        vector.addElement(node);
                        continue;
                    }
                    XmlIndexBuilder.this._dests.add((Integer)v);
                    continue;
                }
                XmlIndexBuilder.this._dests.add(0);
                XmlIndexBuilder.this._seqNumbers.add(1);
                n2 = i + n3;
            }
            XmlIndexBuilder.this._dests.set(n2, XmlIndexBuilder.this._availContextNumber);
        }

        public void characters(String string) throws XSLException {
            if (this._sp >= 0 && this._indexOnOffStack[this._sp]) {
                try {
                    this.indexText(string, this._tsp != -1 ? this._tokenizerStack[this._tsp] : this._defaultTokenizer);
                }
                catch (Exception exception) {
                    throw new XSLException(exception);
                }
            }
        }

        public void startElement(Name name, NamespacePrefixMap namespacePrefixMap) throws XSLException {
            if (name == this._indexElement_Name) {
                this._indexOnOffStack[++this._sp] = true;
                if (this._tsp != -1) {
                    --this._tsp;
                }
            } else if (name != this._indexText_Name && name == this._indexAttribute_Name) {
                ++this._attrSP;
            }
        }

        public void attribute(Name name, String string) throws XSLException {
            if (name == this._nodeID_Name) {
                this._currentNode = (Node)XmlIndexBuilder.this._nodes.get(string);
            } else if (name == this._tokenizer_Name) {
                this._tokenizerStack[++this._tsp] = this.getTokenizer(string);
            } else if (name == this._attributeName_Name) {
                try {
                    NamespacePrefixMap namespacePrefixMap = this._currentNode.getNamespacePrefixMap();
                    Name name2 = namespacePrefixMap.expandAttributeName(string, this._currentNode);
                    String string2 = this._currentNode.getAttributeValue(name2);
                    this._attributeStack[this._attrSP] = this._currentNode.getName().toString() + '<' + string + '<' + string2;
                    this.storeLocation("+<" + this._attributeStack[this._attrSP]);
                }
                catch (Exception exception) {
                    throw new XSLException(exception);
                }
            }
        }

        public void endElement(Name name) throws XSLException {
            if (name == this._indexElement_Name) {
                --this._sp;
            } else if (name != this._indexText_Name && name == this._indexAttribute_Name) {
                try {
                    this.storeLocation("-<" + this._attributeStack[this._attrSP--]);
                }
                catch (Exception exception) {
                    throw new XSLException(exception);
                }
            }
        }

        private void storeLocation(String string, int n) throws Exception {
            if (XmlIndexBuilder.this._free == XmlIndexBuilder.this._size) {
                ConceptLocation[] conceptLocationArray = new ConceptLocation[XmlIndexBuilder.this._size *= 2];
                System.arraycopy(XmlIndexBuilder.this._locations, 0, conceptLocationArray, 0, XmlIndexBuilder.this._free);
                XmlIndexBuilder.access$1202(XmlIndexBuilder.this, conceptLocationArray);
            }
            ((XmlIndexBuilder)XmlIndexBuilder.this)._locations[((XmlIndexBuilder)XmlIndexBuilder.this)._free++] = new ConceptLocation(XmlIndexBuilder.this.intern(string), n, n);
        }

        private void storeLocation(String string) throws Exception {
            System.out.println(string);
            this.storeLocation(string, XmlIndexBuilder.this._lastWordNumber++);
        }

        private void indexText(String string, Tokenizer tokenizer) throws Exception {
            Token token;
            tokenizer.setText(string);
            XmlIndexBuilder.this._firstWord = XmlIndexBuilder.this._lastWordNumber;
            XmlIndexBuilder.this._anyLocationsStored = false;
            while ((token = tokenizer.nextToken()) != null) {
                String string2 = token.toLowerCaseString();
                if (XmlIndexBuilder.this._stoplist.get(string2) == null) {
                    this.storeLocation(string2);
                    XmlIndexBuilder.this._anyLocationsStored = true;
                    continue;
                }
                XmlIndexBuilder.this._lastWordNumber++;
            }
            if (XmlIndexBuilder.this._anyLocationsStored && XmlIndexBuilder.this._firstWord > -1) {
                XmlIndexBuilder.this._initialWords.add(XmlIndexBuilder.this._firstWord);
                this._textNodes.addElement(this._currentNode);
            }
            XmlIndexBuilder.this._firstWord = -1;
        }

        private Tokenizer getTokenizer(String string) {
            Object object = this._tokenizers.get(string);
            if (object != null) {
                return (Tokenizer)object;
            }
            try {
                object = Class.forName(string).newInstance();
                this._tokenizers.put(string, object);
                return (Tokenizer)object;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return this._defaultTokenizer;
            }
        }
    }

    final class MyXslEngine
    extends XSLTransformEngine {
        MyXslEngine() {
        }

        public Node load(URL uRL, int n, LoadContext loadContext, NameTable nameTable) throws XSLException {
            System.out.println("loading for indexing " + uRL.toString());
            try {
                System.out.println("parsing");
                Node node = XmlIndexBuilder.this.parseTargetDocument(uRL);
                System.out.println("parsed");
                return node;
            }
            catch (Exception exception) {
                throw new XSLException(exception);
            }
        }
    }
}

