/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.util.PrefixTranslator;
import com.sun.xmlsearch.xml.qe.QueryHitData;
import com.sun.xmlsearch.xml.qe.QueryHitIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class QueryResults
implements Externalizable {
    private QueryHitData[] _queryHits;
    private String _docType;
    private String[] _prefixTranslations;
    private int _size;

    public QueryResults() {
    }

    public QueryResults(String[] stringArray, String string, QueryHitData[] queryHitDataArray) {
        this._prefixTranslations = stringArray;
        this._docType = string;
        this._queryHits = queryHitDataArray;
    }

    public boolean isNonEmpty() {
        return this._queryHits != null && this._queryHits.length > 0 && this._queryHits[0] != null;
    }

    public QueryHitIterator makeQueryHitIterator() {
        return new QueryHitIteratorImpl();
    }

    public void translate() {
        PrefixTranslator prefixTranslator = PrefixTranslator.makePrefixTranslator(this._prefixTranslations);
        this._size = 0;
        if (this._queryHits != null) {
            while (this._size < this._queryHits.length && this._queryHits[this._size] != null) {
                this._queryHits[this._size++].setDocumentType(this._docType);
            }
        }
        if (prefixTranslator != null) {
            for (int i = 0; i < this._size; ++i) {
                this._queryHits[i].translate(prefixTranslator);
            }
        }
    }

    public int getNextNonZero(int n) {
        if (this._queryHits != null) {
            int n2;
            for (n2 = n + 1; n2 < this._queryHits.length && this._queryHits[n2] == null; ++n2) {
            }
            if (n2 == this._queryHits.length) {
                return -1;
            }
            return n2;
        }
        return -1;
    }

    public int getNonZeroCount() {
        int n = 0;
        if (this._queryHits != null) {
            for (int i = 0; i < this._queryHits.length; ++i) {
                if (this._queryHits[i] == null) continue;
                ++n;
            }
        }
        return n;
    }

    public int size() {
        return this._size;
    }

    public QueryHitData getHit(int n) {
        return this._queryHits[n];
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        int n = objectInput.readInt();
        if (n > 0) {
            this._queryHits = new QueryHitData[n];
            for (int i = 0; i < n; ++i) {
                this._queryHits[i] = new QueryHitData();
                this._queryHits[i].readExternal(objectInput);
            }
            this._prefixTranslations = (String[])objectInput.readObject();
            this._docType = (String)objectInput.readObject();
        } else {
            this._prefixTranslations = null;
            this._queryHits = null;
            this._docType = null;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        if (this._queryHits != null && (n = this._queryHits.length) > 0) {
            int n2 = 0;
            while (this._queryHits[n2] != null && ++n2 < n) {
            }
            if (n2 > 0) {
                objectOutput.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    this._queryHits[i].writeExternal(objectOutput);
                }
                objectOutput.writeObject(this._prefixTranslations);
                objectOutput.writeObject(this._docType);
                return;
            }
        }
        objectOutput.writeInt(0);
    }

    private final class QueryHitIteratorImpl
    implements QueryHitIterator {
        private int _index = 0;
        private double _penalty;

        public QueryHitIteratorImpl() {
            this._penalty = QueryResults.this._queryHits[0].getPenalty();
        }

        public QueryHitData getHit() {
            return QueryResults.this._queryHits[this._index];
        }

        public boolean next() {
            if (++this._index < QueryResults.this._queryHits.length && QueryResults.this._queryHits[this._index] != null) {
                this._penalty = QueryResults.this._queryHits[this._index].getPenalty();
                return true;
            }
            this._penalty = Double.MAX_VALUE;
            return false;
        }

        public double getPenalty() {
            return this._penalty;
        }

        public boolean betterThan(QueryHitIterator queryHitIterator) {
            return this._penalty < queryHitIterator.getPenalty();
        }
    }
}

