/*************************************************************************
 *
 *  $RCSfile: sbprop.hxx,v $
 *
 *  $Revision: 1.1.1.1.134.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/10/12 10:57:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SB_SBPROPERTY_HXX
#define _SB_SBPROPERTY_HXX

#ifndef __SBX_SBXPROPERTY_HXX //autogen
#include <svtools/sbxprop.hxx>
#endif
#include <basic/sbdef.hxx>

class SbModule;

class SbProperty : public SbxProperty
{
	friend class SbiFactory;
	friend class SbModule;
	friend class SbProcedureProperty;
	SbModule* pMod;
	BOOL	 bInvalid;
	SbProperty( const String&, SbxDataType, SbModule* );
	virtual ~SbProperty();
public:
	SBX_DECL_PERSIST_NODATA(SBXCR_SBX,SBXID_BASICPROP,1);
	TYPEINFO();
	SbModule* GetModule() { return pMod; }
};

#ifndef __SB_SBPROPERTYREF_HXX
#define __SB_SBPROPERTYREF_HXX
SV_DECL_IMPL_REF(SbProperty)
#endif

class SbProcedureProperty : public SbxProperty
{
	bool mbSet;		// Flag for set command

	virtual ~SbProcedureProperty();

public:
	SbProcedureProperty::SbProcedureProperty( const String& r, SbxDataType t )
			: SbxProperty( r, t ) // , pMod( p )
			, mbSet( false )
	{}
	TYPEINFO();

	bool isSet( void )
		{ return mbSet; }
	void setSet( bool bSet )
		{ mbSet = bSet; }
};

#ifndef __SB_SBPROCEDUREPROPERTYREF_HXX
#define __SB_SBPROCEDUREPROPERTYREF_HXX
SV_DECL_IMPL_REF(SbProcedureProperty)
#endif

#endif
