/*************************************************************************
 *
 *  $RCSfile: decltor.hxx,v $
 *
 *  $Revision: 1.62.94.2 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:52:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __DECLTOR_HXX
#define __DECLTOR_HXX

#include <limits.h>

#ifndef _GEN_HXX //autogen
#include <tools/gen.hxx>
#endif

#ifndef _RTTI_HXX //autogen
#include <tools/rtti.hxx>
#endif

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

#ifndef _DATE_HXX //autogen
#include <tools/date.hxx>
#endif

#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif

#ifndef _PVER_HXX //autogen
#include <svtools/pver.hxx>
#endif

#include <setup2/ident.hxx>
#include <setup2/simode.hxx>
#include <setup2/compiler.hxx>

// ------------------------------------------------------------------

extern const char NSEP[];

#define LANG_DEFAULT		USHRT_MAX

#define MULTI_LANG_MEMBER(type, name)		\
	type	m_##name;						\
	BOOL	m_Is##name

#define INIT_MULTI_LANG_MEMBER(name)		\
	m_Is##name = FALSE

#define SET_MULTI_LANG_MEMBER(name, value)	\
	m_##name = value;						\
	m_Is##name = TRUE

#define WRITE_MULTI_LANG_MEMBER( property, member ) \
	if( m_Is##member ) 						\
		aStream.WriteProperty( property, m_##member, m_nLanguage )

#define JOIN_MULTI_LANG_MEMBER( name )		\
	if( !m_Is##name )						\
		m_##name = pParent->m_##name

///////////////////////////////////////////////////////////////////////////////
//
//		SiDeclarator
//

class SiDatabase;
class SiDeclarator;

DECLARE_LIST(SiLangRefs,SiDeclarator*)

class SiDeclarator
{
	SiCompilerRef		m_xCompiler;
	ByteString       	m_ID;
	BOOL         		m_bSystemObject;

	void				Missing(char const* aFieldname);
	void				Obsolete(char const* aFieldname);

protected:
    int                 m_nRefCount;
	USHORT 				m_nLanguage;
	SiLangRefs			m_aLangRefs;
	SiDeclarator*		m_pLangParent;

	BOOL				SetBool(BOOL&,ByteString const&);
	BOOL				SetDate(Date&,ByteString const&);
	BOOL				SetTime(Time&,ByteString const&);

	void				Error(ByteString const&);
	void				Warning(ByteString const&);
	void				OsWarning(char const* aFieldname);

	BOOL				CheckField(ByteString const&, char const* aFieldname);
	BOOL				CheckField(SiDeclarator const*, char const* aFieldname);
	BOOL				CheckField(UniString const&, char const* aFieldname);

	BOOL				CheckFieldEmpty(ByteString const&, char const* aFieldname);
	BOOL				CheckFieldEmpty(SiDeclarator const*, char const* aFieldname);

	// zum Pruefen von plattfoemabhaengigen Feldern
	BOOL				IsWin() const;
	BOOL				IsOs2() const;
	BOOL				IsMac() const;
	BOOL				IsUnix() const;

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, sal_uInt32 nValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);
	virtual BOOL		Check();

	virtual BOOL		WriteTo(SiDatabase&) const = 0;
	virtual ByteString		GetNaturalID() const = 0;

	virtual	void 		JoinWithParent() = 0;
	void				SetLanguage(USHORT nNew)		{ m_nLanguage = nNew; }
	USHORT				GetLanguage() const 			{ return m_nLanguage; }
	SiDeclarator*		GetInternalLangRef(USHORT nLanguage);
	BOOL				IsLangRef() const				{ return m_nLanguage != USHRT_MAX; }

public:
		SiDeclarator(SiIdentifier const& ID, SiCompiler*, BOOL bSystemObject = FALSE);
		virtual ~SiDeclarator();
		TYPEINFO();

	virtual BOOL  		IsDocLang()const  			{ return FALSE; }
	BOOL 				HasLangRef() const 			{ return m_aLangRefs.Count()? TRUE : FALSE; }
	virtual SiDeclarator* GetLangRef(USHORT nLanguage);

	ByteString				GetID() const;
	void				SetID(ByteString const& rID)	{ m_ID = rID;  }

	SiCompiler*			GetCompiler()		const	{ return m_xCompiler; }
	BOOL				IsSystemObject()	const	{ return m_bSystemObject; }

    int                 GetRefCount()       const   { return m_nRefCount; }
    void                AddRefCount(int n = 1)      { m_nRefCount += n; }
    void				ResetRefCount()				{ m_nRefCount = 0; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiDataCarrier
//

typedef ULONG Flags;

const Flags DCFLAG_DISKETTE = 1;
const Flags DCFLAG_CD       = 2;
const Flags DCFLAG_HARDDISK = 3;

class SiDataCarrier : public SiDeclarator
{
	MULTI_LANG_MEMBER( ByteString,				aName );
	MULTI_LANG_MEMBER( int,		  			nDiskNo );
	MULTI_LANG_MEMBER( ByteString,	 	  		aArchive );
	MULTI_LANG_MEMBER( Flags,	 	  		Flags );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);
	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiDataCarrier(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	ByteString const& GetName()    const { return m_aName;	 }
	int			  GetDiskNo()  const { return m_nDiskNo; }
	ByteString const& GetArchive() const { return m_aArchive; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiDirectory
//

class SiDirectory;
DECLARE_LIST(SiDirectoryList,SiDirectory*)
typedef SiDirectoryList SiDirList;

class SiDirectory : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiDirectory*,		pParent );
	MULTI_LANG_MEMBER( ByteString,		  	Name );
	MULTI_LANG_MEMBER( BOOL,	 	  		bWorkstation );
	MULTI_LANG_MEMBER( BOOL,	 	  		bCreate );
	MULTI_LANG_MEMBER( BOOL,		 		bDontDelete );
	MULTI_LANG_MEMBER( BOOL,		 		bDeleteAll );

	MULTI_LANG_MEMBER( BOOL,				bSystem );
	MULTI_LANG_MEMBER( int,					nRefCount );
	MULTI_LANG_MEMBER( SiDirectoryList,		SubDirs );
	MULTI_LANG_MEMBER( int,					nUnixRights );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);
	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiDirectory(SiIdentifier const& ID, SiCompiler*,
					BOOL bSystemObj = FALSE, BOOL bSystemDir = FALSE,
					BOOL bDeleteAll = FALSE );
		TYPEINFO();

	virtual SiDeclarator* GetLangRef(USHORT nLanguage);

	ByteString 				GetSingleName() const		{ return m_Name; }
	ByteString				GetName() const;
	ByteString 				GetWebName() const;

	BOOL				IsSystem() const;
	BOOL				IsDontDelete() const;
	BOOL 				IsThisSystem() const 		{ return m_bSystem; }
	SiDirectory*		GetParent() const			{ return m_pParent; }
	SiDirList const&	GetSubDirList() const		{ return m_SubDirs; }
	BOOL				IsDeleteAll() const			{ return m_bDeleteAll; }
	BOOL				DoCreate() const			{ return m_bCreate; }
	void				SetCreate(BOOL bNew)		{ m_bCreate = bNew; }
	int					GetUnixRights() const		{ return m_nUnixRights; }

	BOOL 				InstallFileInThisDirOnWorkstation() const;
	BOOL				InstallOnWorkstation() const;

	void Add(SiDirectory *pDir)						{ m_SubDirs.Insert(pDir,LIST_APPEND);}
	int  GetRefCount() const						{ return m_nRefCount; }
	void AddRefCount(int n = 1)						{ m_nRefCount += n; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiFile
//

struct SiFileFlags
{
	BOOL bPacked			: 1;
	BOOL bArchive			: 1;
	BOOL bFont				: 1;
	BOOL bFontWarnIfExists	: 1;
	BOOL bCheckVersion		: 1;
	BOOL bCheckTimestamp	: 1;
	BOOL bDeleteOnly		: 1;
	BOOL bDontDelete		: 1;
	BOOL bDontInstall		: 1;
	BOOL bDontOverwrite 	: 1;
	BOOL bOverwriteOnly 	: 1;
	BOOL bOverwrite		 	: 1;
	BOOL bWorkstation		: 1;
	BOOL bWorkstationOnly	: 1;
	BOOL bUnixSoftLink		: 1;
	BOOL bSetup		    	: 1;
	BOOL bSetupZip			: 1;
	BOOL bDontRecover 		: 1;
	BOOL bBind		 		: 1;
	BOOL bIsHelp			: 1;
	BOOL bIsCompHelp		: 1;
	BOOL bIsAgentLoader 	: 1;
	BOOL bIsProcessGuard	: 1;
	BOOL bDoMigration		: 1;
	BOOL bSubstitute		: 1;
	BOOL bUnoComponent		: 1;
	BOOL bIsDocLang			: 1;
	BOOL bWebOnly			: 1;
	BOOL bNoWeb				: 1;
	BOOL bNoTimeStamp		: 1;
	BOOL bNoUpdate			: 1;
	BOOL bNoWarnIfNotExists : 1;
	BOOL bActiveX			: 1;
    BOOL bPatchSOName       : 1;
    BOOL bForceRepair       : 1;
	// #99548#
	BOOL mbScpzipReplace    : 1;
	BOOL mbNoPathPage       : 1;
	BOOL mbHidePageReadyGo  : 1;
	SiFileFlags();
};

class SiStarRegistry;
class SiOs2Creator;
class SiFile;
class SiShortcut;

struct SiSubfile {
	ByteString 	aFilename;
	ULONG 		nSize;
};

DECLARE_LIST(SiFileList,SiFile*)
DECLARE_LIST(SiSubfileList,SiSubfile*)
DECLARE_LIST(SiStarRegistryList,SiStarRegistry*)
DECLARE_LIST(SiShortcutList,SiShortcut*)

class SiFile : public SiDeclarator
{
	MULTI_LANG_MEMBER( ByteString,			Name );
	MULTI_LANG_MEMBER( ByteString, 	   		PackedName );
	MULTI_LANG_MEMBER( ByteString, 	   		ScpExtSearchName );
	MULTI_LANG_MEMBER( ByteString, 			FontName );

	MULTI_LANG_MEMBER( Date, 				Date );
	MULTI_LANG_MEMBER( Time,  				Time );
	MULTI_LANG_MEMBER( SiFileFlags,			Flags );

	MULTI_LANG_MEMBER( long, 				lSize );
	MULTI_LANG_MEMBER( long, 				nDownloadSize );
	MULTI_LANG_MEMBER( long,  				nArchiveSize );
	MULTI_LANG_MEMBER( long,				nArchiveFiles );
	MULTI_LANG_MEMBER( sal_uInt32,			nCRC );

	MULTI_LANG_MEMBER( SiDirectory*,		pDirectory );
	MULTI_LANG_MEMBER( SiDirectory*,		pNetDirectory );
	MULTI_LANG_MEMBER( SiDataCarrier*,		pDataCarrier );

	MULTI_LANG_MEMBER( ByteString,			aOverwriteMsg );

	MULTI_LANG_MEMBER( int,		   			nParts );
	MULTI_LANG_MEMBER( int,					nPart );
	MULTI_LANG_MEMBER( SiFile*,				pPartOf );

	MULTI_LANG_MEMBER( SiShortcutList, 		ShortcutList );
	MULTI_LANG_MEMBER( SiStarRegistryList,	RegistryList );
	MULTI_LANG_MEMBER( SiSubfileList,		SubfileList );
	MULTI_LANG_MEMBER( SiFileList,			PartList );
	MULTI_LANG_MEMBER( SiOs2Creator*,		pOs2Creator );
	MULTI_LANG_MEMBER( SiFile*, 	   	  	pOs2EAFile );
	MULTI_LANG_MEMBER( int,					nUnixRights );
	MULTI_LANG_MEMBER( int,					nScpUnixRights );

	MULTI_LANG_MEMBER( ByteString,			MacCreator );

    BOOL                FileInSubfile( ByteString const& aFilename, ULONG nSize,
                                       long nStart, long nEnd, ULONG& nPos );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, sal_uInt32 nValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiFile(SiIdentifier const& ID, SiCompiler*);
		virtual ~SiFile();
		TYPEINFO();

	ByteString        const&  GetName()        const { return m_Name;         }
	ByteString        const&  GetPackedName()  const;
	BOOL 					  IsPackedName()   const		{ return m_IsPackedName; }

	ByteString        const&  GetFontName()    const { return m_FontName;     }

	ByteString        const&  GetScpExtSearchName() const { return m_ScpExtSearchName; }
	void					  SetScpExtSearchName( const ByteString& r ) { m_IsScpExtSearchName = TRUE; m_ScpExtSearchName = r; }

	SiDirectory   const*  GetDirectory()   const { return m_pDirectory;       }
	SiDirectory   const*  GetNetDirectory() const;
	SiDirectory   const*  GetBlankNetDirectory() const { return m_pNetDirectory; }

	SiDataCarrier const*  GetDataCarrier() const { return m_pDataCarrier;     }
	long                  GetSize()        const { return m_lSize;            }
	long                  GetDownloadSize() const { return m_nDownloadSize;   }
	long                  GetArchiveSize() const { return m_nArchiveSize;     }
	long                  GetArchiveFiles()const { return m_nArchiveFiles;    }
	ULONG				  GetCRC()		   const { return m_nCRC;    		  }
	void				  SetCRC(ULONG nNew) 	 { m_nCRC = nNew;   		  }
	int                   GetPart()        const { return m_nPart;            }
	SiFile			   *  GetPartOf()      const { return m_pPartOf;          }
	Date          const&  GetDate()        const { return m_Date;             }
	Time          const&  GetTime()        const { return m_Time;             }
	SiFileList	  const&  GetPartList()	   const { return m_PartList;		  }
	SiSubfileList const&  GetSubfileList() const { return m_SubfileList;	  }
	SiFileFlags			  GetFlags()	   const { return m_Flags;			  }

	BOOL IsMigration()		const 		{ return m_Flags.bDoMigration; }
	BOOL IsPacked()			const 		{ return m_Flags.bPacked || m_Flags.bArchive; }
	BOOL IsArchive()		const 		{ return m_Flags.bArchive; }
	BOOL IsFont()			const 		{ return m_Flags.bFont; }
	BOOL IsFontWarnIfExists() const		{ return m_Flags.bFontWarnIfExists; }
	BOOL CheckTimestamp()	const 		{ return m_Flags.bCheckTimestamp; }
	BOOL CheckVersion()		const 		{ return m_Flags.bCheckVersion; }
	BOOL DeleteOnly()		const 		{ return m_Flags.bDeleteOnly; }
	BOOL DontDelete()		const 		{ return m_Flags.bDontDelete; }
	BOOL DontInstall()		const 		{ return m_Flags.bDontInstall; }
	BOOL DontOverwrite()	const 		{ return m_Flags.bDontOverwrite; }
	BOOL OverwriteOnly()	const 		{ return m_Flags.bOverwriteOnly; }
	BOOL Overwrite()    	const 		{ return m_Flags.bOverwrite; }
	BOOL IsSetup()			const 		{ return m_Flags.bSetup; }
	BOOL IsSetupZip()		const 		{ return m_Flags.bSetupZip; }
	BOOL IsDontRecover()	const 		{ return m_Flags.bDontRecover; }
	BOOL IsBind()			const 		{ return m_Flags.bBind; }
	BOOL IsHelpFile()		const 		{ return m_Flags.bIsHelp; }
	BOOL IsCompHelpFile()	const 		{ return m_Flags.bIsCompHelp; }
	BOOL IsAgentLoader()	const		{ return m_Flags.bIsAgentLoader; }
	BOOL IsProcessGuard()	const 		{ return m_Flags.bIsProcessGuard; }
	BOOL IsWorkstationOnly() const		{ return m_Flags.bWorkstationOnly; }
	BOOL IsUnoComponent()	const		{ return m_Flags.bUnoComponent; }
	BOOL IsDocLang()		const		{ return m_Flags.bIsDocLang; }
	BOOL IsWebOnly()		const		{ return m_Flags.bWebOnly; }
	BOOL IsNoWeb() 			const		{ return m_Flags.bNoWeb; }
	BOOL IsNoTimeStamp()	const		{ return m_Flags.bNoTimeStamp; }
	BOOL IsNoUpdate()		const		{ return m_Flags.bNoUpdate; }
	BOOL IsNoWarning()		const		{ return m_Flags.bNoWarnIfNotExists; }
	BOOL IsActiveX()		const		{ return m_Flags.bActiveX; }
	BOOL IsPatchSOName()	const		{ return m_Flags.bPatchSOName; }
	BOOL IsForceRepair()	const		{ return m_Flags.bForceRepair; }
	// #99548#
	BOOL IsScpzipReplace() const { return m_Flags.mbScpzipReplace; }
	BOOL IsPathPage() const {return m_Flags.mbNoPathPage ? FALSE : TRUE;}
	BOOL IsPageReadyGo() const {return m_Flags.mbHidePageReadyGo ? FALSE : TRUE;}

	BOOL InstallOnWorkstation() const;
	BOOL IsSystem() const;

	const SiStarRegistryList*	GetRegistryList() const			{ return &m_RegistryList; 		}
	void 						AddShortcut(SiShortcut* pNew, BOOL bAppend = FALSE)
																{ m_ShortcutList.Insert(pNew, bAppend? LIST_APPEND : 0L); }
	const SiShortcutList*	   	GetShortcutList() const 		{ return &m_ShortcutList; }

	// OS/2 Felder
	SiOs2Creator const* GetOs2Creator() const			{ return m_pOs2Creator; 		}
	SiFile       const* GetOs2EAFile() const			{ return m_pOs2EAFile;  		}

	// Unix Felder
	int				 GetUnixRights() const				{ return m_nUnixRights;			}
	int				 GetScpUnixRights() const  			{ return m_nScpUnixRights;		}
	BOOL			 IsSoftLinkPrefered() const			{ return m_Flags.bUnixSoftLink;	}

	// Mac Felder
	ByteString  const&  GetMacCreator() const			{ return m_MacCreator;			}

	void AddSubfile(ByteString const&,ULONG);
	void RemoveSubfile(ByteString *pName);
	void RemoveAllSubfiles();

	void AddPart(SiFile*);
	void AddToSize(long lSize)							{ m_lSize += lSize;				}
	void SetUnpacked()									{ m_Flags.bPacked = FALSE;		}
	void SetDontRecover(BOOL bNew)						{ m_Flags.bDontRecover = bNew;	}
	void SetBind(BOOL bNew)								{ m_Flags.bBind = bNew;			}
	void SetFontFlag(BOOL bNew)							{ m_Flags.bFont = bNew;			}
};

inline ByteString const& SiFile::GetPackedName() const
{
	return m_PackedName.Len()? m_PackedName : m_Name;
}

inline SiDirectory const* SiFile::GetNetDirectory() const
{
	return m_pNetDirectory != NULL ? m_pNetDirectory : m_pDirectory;
}

inline BOOL SiFile::InstallOnWorkstation() const
{
	return m_Flags.bWorkstation
		|| (m_pDirectory && m_pDirectory->InstallFileInThisDirOnWorkstation());
}

inline BOOL SiFile::IsSystem() const
{
	return IsFont()
		|| (m_pDirectory && m_pDirectory->IsSystem());
}

///////////////////////////////////////////////////////////////////////////////
//
//		SiFolder
//

class SiFolder : public SiDeclarator
{
	MULTI_LANG_MEMBER( UniString,			aName );

	MULTI_LANG_MEMBER( ByteString,			anOs2ID );
	MULTI_LANG_MEMBER( SiFile*,				pOs2OpenIcon );
	MULTI_LANG_MEMBER( SiFile*,				pOs2CloseIcon );

	MULTI_LANG_MEMBER(	int,				nItemCount );
	MULTI_LANG_MEMBER(	BOOL,				bPredefined );

public:
	virtual BOOL		SetProperty( ByteString const& aProperty, ByteString const& aValue );
	virtual BOOL		SetProperty( ByteString const& aProperty, long lValue );
	virtual BOOL		SetProperty( ByteString const& aProperty, SiDeclarator* aValue );

	virtual BOOL 		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

	BOOL SetUniProperty( ByteString const& _sProperty, UniString const& _suValue );
public:
		SiFolder( SiIdentifier const& ID, SiCompiler*, BOOL bSystemObject = FALSE );
		TYPEINFO();

	void				SetPredefined()			{ m_bPredefined = TRUE; }
	BOOL 				IsPredefined() const 	{ return m_bPredefined; }
	// ByteString const&	GetName() const 		{ return m_aName; }
	UniString const&	GetName() const 		{ return m_aName; }

	ByteString const&	GetOs2ID() const		{ return m_anOs2ID;       }
	SiFile const*		GetOs2OpenIcon()  const { return m_pOs2OpenIcon;  }
	SiFile const*		GetOs2CloseIcon() const { return m_pOs2CloseIcon; }

	int  				GetItemCount() const  	{ return m_nItemCount; }
	void 				AddItemCount(int n=1);
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiFolderItem
//

class SiOs2Class;
class SiOs2Creator;
class SiModule;

class SiFolderItem : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );
	MULTI_LANG_MEMBER( ByteString,			aName );
	MULTI_LANG_MEMBER( SiFolder*, 			pFolder );
	MULTI_LANG_MEMBER( SiFile*,   			pFile );
	MULTI_LANG_MEMBER( SiFile*,             pIconFile );
	MULTI_LANG_MEMBER( ByteString,			aParameter );
	MULTI_LANG_MEMBER( sal_Int32,			nIconIndex );
	MULTI_LANG_MEMBER( BOOL,				bNoWeb );
	MULTI_LANG_MEMBER( BOOL,				bWebOnly );

	MULTI_LANG_MEMBER( ByteString,			anOs2ID );
	MULTI_LANG_MEMBER( SiOs2Class*, 		pOs2Class );
	MULTI_LANG_MEMBER( SiOs2Creator*,		pOs2Creator );
	MULTI_LANG_MEMBER( ByteString,		  	anOs2Filters );
	MULTI_LANG_MEMBER( SiFolderItem*, 		pOs2Reference );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long nValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiFolderItem(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	ByteString   const& GetName()   const { return m_aName;   }
	SiFolder	  * GetFolder() const { return m_pFolder; }
	SiFile   const* GetFile()   const { return m_pFile;   }
	ByteString   const& GetParameter() const { return m_aParameter;   }

	SiFile*             GetIconFile() const		{ return m_pIconFile; }
    sal_Int32           GetIconIndex() const    { return m_nIconIndex; }

	BOOL 			IsNoWeb() const { return m_bNoWeb; }
	BOOL 			IsWebOnly() const { return m_bWebOnly; }

	// OS/2 Felder
	ByteString       const& GetOs2ID()        const { return m_anOs2ID;      }
	SiOs2Class   const* GetOs2Class()     const { return m_pOs2Class;    }
	SiOs2Creator const* GetOs2Creator()   const { return m_pOs2Creator;  }
	ByteString       const& GetOs2Filters()   const { return m_anOs2Filters; }
	SiFolderItem const* GetOs2Reference() const { return m_pOs2Reference; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiProfile
//

class SiProfile : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );
	MULTI_LANG_MEMBER( ByteString,				Name );
	MULTI_LANG_MEMBER( SiDirectory*,	 	pDirectory );
	MULTI_LANG_MEMBER( BOOL,	 			bNetwork );
	MULTI_LANG_MEMBER( BOOL,				bDontDelete );
	MULTI_LANG_MEMBER( BOOL,				bIsServerINI );
	MULTI_LANG_MEMBER( int,			  		nUnixRights );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiProfile(SiIdentifier const& ID, SiCompiler*);
		virtual ~SiProfile();
		TYPEINFO();

	ByteString      const&	GetName() const				{ return m_Name; }
	SiDirectory		 *	GetDirectory() const		{ return m_pDirectory; }
	SiModule	const*  GetModule() const			{ return m_pModule; }
	BOOL				InstallOnNetwork() const	{ return m_bNetwork; }

	void				SetDontDelete(BOOL bNew)	{ m_bDontDelete = bNew; }
	BOOL				DontDelete() const			{ return m_bDontDelete; }
	BOOL 				IsServerINI() const 		{ return m_bIsServerINI; }

	int				 	GetUnixRights() const		{ return m_nUnixRights; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiProfileItem
//

class SiModule;

class SiProfileItem : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );
	MULTI_LANG_MEMBER( SiProfile*,			pProfile );
	MULTI_LANG_MEMBER( ByteString,		  		Section );
	MULTI_LANG_MEMBER( ByteString,		  		Key );
	MULTI_LANG_MEMBER( ByteString,		  		Value );
	MULTI_LANG_MEMBER( ByteString,		  		WorkstationValue );
	MULTI_LANG_MEMBER( ByteString,	StandaloneValue );
	MULTI_LANG_MEMBER( BOOL,		  		bDontDelete );
	MULTI_LANG_MEMBER( BOOL,		  		bDontOverwrite );
	MULTI_LANG_MEMBER( BOOL,		  		bIsDocLang );

	MULTI_LANG_MEMBER( int,		  			nOrder );
	MULTI_LANG_MEMBER( BOOL,		  		bInstallInfo );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiProfileItem(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	SiProfile const* GetProfile() const				{ return m_pProfile; }
	ByteString    const& GetSection() const				{ return m_Section;  }
	ByteString    const& GetKey() const					{ return m_Key;      }
	ByteString    const& GetValue() const				{ return m_Value;    }
	ByteString    const& GetWorkstationValue() const	{ return m_WorkstationValue; }
	ByteString  const& GetStandaloneValue() const	{ return m_StandaloneValue; }

	BOOL 			IsDocLang() const			  	{ return m_bIsDocLang; }
	BOOL			IsInstallInfo() const			{ return m_bInstallInfo; }
	void			SetInstallInfo(BOOL bNew)		{ m_bInstallInfo = bNew; }

	int				GetOrder()   const 				{ return m_nOrder;  }
	BOOL			DontDelete() const				{ return m_bDontDelete;  }

	BOOL			DontOverwrite() const			{ return m_bDontOverwrite; }
	void			SetDontOverwrite(BOOL b)		{ m_bDontOverwrite = b; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiStarRegistry
//

class SiStarRegistry : public SiDeclarator
{
	MULTI_LANG_MEMBER( ByteString,			aName );
	MULTI_LANG_MEMBER( SiDirectory*,		pDirectory );

protected:
	friend class SiStarRegistryItem;

	virtual BOOL		SetProperty(const ByteString& aProperty, const ByteString& aValue);
	virtual BOOL		SetProperty(const ByteString& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

public:
		SiStarRegistry(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	const ByteString&  	GetName() const				{ return m_aName; }
	SiDirectory*		GetDir() const 				{ return m_pDirectory; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiStarRegistryItem
//

class SiStarRegistryItem : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );
	MULTI_LANG_MEMBER( SiStarRegistry*,		pRegistry );

	MULTI_LANG_MEMBER( ByteString,	 		aKey );

	MULTI_LANG_MEMBER( long,	   			nNumValue );
	MULTI_LANG_MEMBER( ByteString,	   		aStrValue );
	MULTI_LANG_MEMBER( ByteString,	   		aSeqValue );

	MULTI_LANG_MEMBER( BOOL,				bHasNumValue );
	MULTI_LANG_MEMBER( BOOL,				bHasStrValue );
	MULTI_LANG_MEMBER( BOOL,				bHasSeqValue );

	MULTI_LANG_MEMBER( BOOL,	   			bNetwork );

public:
	virtual BOOL		SetProperty(const ByteString& aProperty, long aValue);
	virtual BOOL		SetProperty(const ByteString& aProperty, const ByteString& aValue);
	virtual BOOL		SetProperty(const ByteString& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

public:
		SiStarRegistryItem(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	SiModule* 			GetModule() const			{ return m_pModule; }
	SiStarRegistry*		GetRegistry() const			{ return m_pRegistry; }

	const ByteString&	GetKey() const				{ return m_aKey; }

	BOOL				HasNumValue() const			{ return m_bHasNumValue; }
	long				GetNumValue() const			{ return m_nNumValue; }

	BOOL				HasStrValue() const			{ return m_bHasStrValue; }
	const ByteString&   GetStrValue() const			{ return m_aStrValue; }

	BOOL				HasSeqValue() const			{ return m_bHasSeqValue; }
	const ByteString&   GetSeqValue() const			{ return m_aSeqValue; }

	BOOL 				InstallOnNetwork() const	{ return m_bNetwork; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiConfigurationItem
//

class SiConfigurationItem : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );

	MULTI_LANG_MEMBER( ByteString,	 		aPath );
	MULTI_LANG_MEMBER( ByteString,	 		aUserName );
	MULTI_LANG_MEMBER( ByteString,	 		aKey );
	MULTI_LANG_MEMBER( ByteString,	 		aValue );
	MULTI_LANG_MEMBER( ByteString,		  	aWorkstationValue );

	MULTI_LANG_MEMBER( BOOL,			  	bWorkstation );
	MULTI_LANG_MEMBER( BOOL,			  	bNetwork );
	MULTI_LANG_MEMBER( BOOL,			  	bCreate );

public:
	enum CfgType { BOOLEAN, STRING, NUMERIC, STRINGLIST, BINARY };

	virtual BOOL		SetProperty(const ByteString& aProperty, const ByteString& aValue);
	virtual BOOL		SetProperty(const ByteString& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

public:
		SiConfigurationItem( SiIdentifier const& ID, SiCompiler* );
		TYPEINFO();

	SiModule* 			GetModule() const			{ return m_pModule; }

	BOOL				IsCreate() const	   		{ return m_bCreate; }
    BOOL 				IsWorkstation() const       { return m_bWorkstation; }
	BOOL 				IsNetwork() const;

	const ByteString&   GetUserName() const			{ return m_aUserName; }
	const ByteString&   GetPath() const				{ return m_aPath; }
	const ByteString&   GetKey() const				{ return m_aKey; }
	const ByteString&   GetValue() const	  		{ return m_aValue; }
	const ByteString&   GetWorkstationValue() const { return m_aValue; }
	CfgType				GetValueType() const	  	{ return m_eCfgType; }

private:
	MULTI_LANG_MEMBER( CfgType,				eCfgType );
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiRegistryItem
//

class SiModule;

class SiRegistryItem : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );
	MULTI_LANG_MEMBER( SiRegistryItem*,		pParent );

	MULTI_LANG_MEMBER( ByteString,			Key );
	MULTI_LANG_MEMBER( ByteString,			Subkey );
	MULTI_LANG_MEMBER( ByteString,			Name );
	MULTI_LANG_MEMBER( ByteString,			Value );
	MULTI_LANG_MEMBER( BOOL,				bHexValue );
	MULTI_LANG_MEMBER( BOOL,				bDontDelete );
	MULTI_LANG_MEMBER( BOOL,				bDeleteAll );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiRegistryItem( SiIdentifier const& ID, SiCompiler*, BOOL bSysObj = FALSE );
		TYPEINFO();

	void SetKey(ByteString const& aKey) { m_Key = aKey; }

	SiRegistryItem
			const* GetParent()  const { return m_pParent; }
	ByteString  const& GetKey()     const;
	ByteString		   GetSubkey()  const;
	ByteString  const& GetName()    const { return m_Name;		  }
	ByteString  const& GetValue()   const { return m_Value;		  }
	BOOL		   IsHexValue() const { return m_bHexValue;	  }
	BOOL		   DontDelete()	const { return m_bDontDelete; }
	BOOL		   DeleteAll()	const { return m_bDeleteAll;  }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiRegistryArea
//

class SiModule;

class SiRegistryArea : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );
	MULTI_LANG_MEMBER( ByteString,				SubKey );
	MULTI_LANG_MEMBER( ByteString,				FromKey );
	MULTI_LANG_MEMBER( ByteString,				ToKey );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
	SiRegistryArea(SiIdentifier const& ID, SiCompiler*);
	TYPEINFO();

	ByteString const& GetSubKey()  const { return m_SubKey; }
	ByteString const& GetFromKey() const { return m_FromKey; }
	ByteString const& GetToKey()   const { return m_ToKey; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiProcedure
//

class SiProcedure : public SiDeclarator
{
	struct SiProcStyles
	{
		BOOL bStandalone  : 1;
		BOOL bNetwork	  : 1;
		BOOL bWorkstation : 1;
		BOOL bInstall	  : 1;
		BOOL bUninstall	  : 1;
		BOOL bRepairable  : 1;
	};

	MULTI_LANG_MEMBER( ByteString,				aProcName );
	MULTI_LANG_MEMBER( ByteString,				aCode );

	MULTI_LANG_MEMBER( BOOL,				bIsPreSelectProc );
	MULTI_LANG_MEMBER( BOOL,				bIsLanguageSelectProc );
	MULTI_LANG_MEMBER( BOOL,				bExecuteBefore );
	MULTI_LANG_MEMBER( SiProcStyles, 		Styles );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiProcedure(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	ByteString const& GetProcName() const { return m_aProcName; }
	ByteString const& GetCode()		const { return m_aCode; }

	BOOL IsPreSelectProc() 	const {	return m_bIsPreSelectProc; }
	BOOL IsLanguageSelectProc() const { return m_bIsLanguageSelectProc; }

	BOOL ExecuteBefore()	const { return m_bExecuteBefore; }

	BOOL RunAtStandalone()  const { return m_Styles.bStandalone; }
	BOOL RunAtNetwork()		const { return m_Styles.bNetwork; }
	BOOL RunAtWorkstation() const { return m_Styles.bWorkstation; }

	BOOL RunAtInstall()		const { return m_Styles.bInstall; }
	BOOL RunAtUninstall()	const { return m_Styles.bUninstall; }

	BOOL IsRepairable()		const { return m_Styles.bRepairable; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiCustom
//

class SiCustom;
DECLARE_LIST(SiCustomList, SiCustom*)

class SiCustom : public SiDeclarator
{
	MULTI_LANG_MEMBER( ByteString,  		DllName );
	MULTI_LANG_MEMBER( ByteString,  		aCode );

	MULTI_LANG_MEMBER( BOOL,				bStandalone );
	MULTI_LANG_MEMBER( BOOL,				bNetwork );
	MULTI_LANG_MEMBER( BOOL,				bWorkstation );
  	MULTI_LANG_MEMBER( BOOL,				bMigration );
  	MULTI_LANG_MEMBER( BOOL,				bResponsefileWizard );

	MULTI_LANG_MEMBER( BOOL,				bExecInstBefore );
	MULTI_LANG_MEMBER( BOOL,				bExecInstAfter );
	MULTI_LANG_MEMBER( BOOL,				bExecDeInstBefore );
	MULTI_LANG_MEMBER( BOOL,				bExecDeInstAfter );
	MULTI_LANG_MEMBER( BOOL,				bExecModifyBefore );
	MULTI_LANG_MEMBER( BOOL,				bExecModifyAfter );
	MULTI_LANG_MEMBER( BOOL,				bExecRepair );
	MULTI_LANG_MEMBER( BOOL,				bKeepAlive );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiCustom(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	ByteString const&	GetDllName()  const			{ return m_DllName; }
	ByteString const&	GetCode() const				{ return m_aCode; }

	BOOL			IsMigration() const		   		{ return m_bMigration; }
	BOOL			IsResponsefileWizard() const	{ return m_bResponsefileWizard; }

	BOOL			RunAtStandalone() const			{ return m_bStandalone; }
	BOOL			RunAtNetwork() const			{ return m_bNetwork; }
	BOOL			RunAtWorkstation() const		{ return m_bWorkstation; }

	BOOL			ExecInstBefore() const			{ return m_bExecInstBefore; }
	BOOL			ExecInstAfter() const			{ return m_bExecInstAfter; }
	BOOL			ExecDeInstBefore() const		{ return m_bExecDeInstBefore; }
	BOOL			ExecDeInstAfter() const			{ return m_bExecDeInstAfter; }
	BOOL			ExecModifyBefore() const        { return m_bExecModifyBefore; }
	BOOL			ExecModifyAfter() const         { return m_bExecModifyAfter; }
	BOOL			ExecRepair() const              { return m_bExecRepair; }
	BOOL			KeepAlive() const               { return m_bKeepAlive; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiSlide
//

class SiSlide : public SiDeclarator
{
	MULTI_LANG_MEMBER( USHORT,				nOrder );
	MULTI_LANG_MEMBER( ByteString,			aText );
	MULTI_LANG_MEMBER( Size,				aTextSize );
	MULTI_LANG_MEMBER( USHORT,				nFontSize );
	MULTI_LANG_MEMBER( ByteString,			aBmpFileName );
	MULTI_LANG_MEMBER( Point,				aBmpPos );
	MULTI_LANG_MEMBER( ByteString,			aWaveFileName );
	MULTI_LANG_MEMBER( ByteString,			aFadeType );
	MULTI_LANG_MEMBER( ByteString,			aFadeSpeed );

public:
	virtual BOOL 		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL 		SetProperty(ByteString const& aProperty, long aValue);

	virtual BOOL 		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL 		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiSlide(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	int				GetOrder()			const	{ return m_nOrder; }

	ByteString	const&	GetText()			const	{ return m_aText; }
	Size	const&	GetTextSize()		const	{ return m_aTextSize; }
	USHORT			GetFontSize()		const 	{ return m_nFontSize; }

	ByteString	const&	GetBmpFileName()	const	{ return m_aBmpFileName; }
	Point	const&	GetBmpPos()			const	{ return m_aBmpPos;  }

	ByteString	const&	GetWaveFileName()	const	{ return m_aWaveFileName; }

	ByteString	const&	GetFadeType()		const	{ return m_aFadeType; }
	ByteString	const&	GetFadeSpeed()		const	{ return m_aFadeSpeed; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiHelpText
//

class SiHelpText : public SiDeclarator
{
	MULTI_LANG_MEMBER( ByteString,			aText );
	MULTI_LANG_MEMBER( USHORT,				nPageId );

public:
	virtual BOOL 		SetProperty(ByteString const& aProperty, ByteString const& aValue);

	virtual BOOL 		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL 		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiHelpText(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	USHORT				GetPageId() const		{ return m_nPageId; }
	const ByteString&		GetHelpText() const		{ return m_aText; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiHelpText
//

class SiScpAction : public SiDeclarator
{
	MULTI_LANG_MEMBER( ByteString,			aCpySource );
	MULTI_LANG_MEMBER( ByteString,			aCpyDestination );
	MULTI_LANG_MEMBER( ByteString,			aFlatLoaderZip );
	MULTI_LANG_MEMBER( BOOL,		 		bScpzipReplace );

public:
	virtual BOOL 		SetProperty(ByteString const& aProperty, ByteString const& aValue);

	virtual BOOL 		Check() { return TRUE; }

	virtual	void 		JoinWithParent();
	virtual BOOL 		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

public:
		SiScpAction(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	const ByteString& 	GetCpySource() const			{ return m_aCpySource; }
	const ByteString& 	GetCpyDestination() const		{ return m_aCpyDestination; }
	const ByteString& 	GetFlatLoaderZip() const		{ return m_aFlatLoaderZip; }
    BOOL                IsScpzipReplace() const         { return m_bScpzipReplace; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiModule
//

class SiModule;
class SiModuleIds;
class SiOs2Class;
class SiOs2Template;
class SiEnvironment;
class SiDoneList;

DECLARE_LIST(SiModuleList,				SiModule*)
DECLARE_LIST(SiModuleIdsList,           SiModuleIds*)
DECLARE_LIST(SiFolderItemList,			SiFolderItem*)
DECLARE_LIST(SiProfileList,				SiProfile*)
DECLARE_LIST(SiProfileItemList, 		SiProfileItem*)
DECLARE_LIST(SiStarRegistryItemList,	SiStarRegistryItem*)
DECLARE_LIST(SiProcedureList,	 		SiProcedure*)
DECLARE_LIST(SiRegistryItemList, 		SiRegistryItem*)
DECLARE_LIST(SiRegistryAreaList, 		SiRegistryArea*)
DECLARE_LIST(SiOs2ClassList,	 		SiOs2Class*)
DECLARE_LIST(SiOs2TemplateList,  		SiOs2Template*)
DECLARE_LIST(SiConfigurationItemList,	SiConfigurationItem*)
DECLARE_HASHTABLE(SiDoneModList, ByteString, UINT32);

class SiModule : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*, 			pParent );
	MULTI_LANG_MEMBER( ByteString,			Name );
	MULTI_LANG_MEMBER( ByteString,			Description );
	MULTI_LANG_MEMBER( ByteString,			OnSelect );
	MULTI_LANG_MEMBER( ByteString,			OnDeselect );
	MULTI_LANG_MEMBER( USHORT,				nMaxSelect );
	MULTI_LANG_MEMBER( BOOL,				bMinimal );
	MULTI_LANG_MEMBER( BOOL,				bDefault );
	MULTI_LANG_MEMBER( BOOL,				bHiddenRoot );
	MULTI_LANG_MEMBER( BOOL,				bHiddenRootRecursive );
	MULTI_LANG_MEMBER( SiFileList,			Files );
	MULTI_LANG_MEMBER( SiDirList,			Dirs );
	MULTI_LANG_MEMBER( SiProcedureList,		Procedures );
	MULTI_LANG_MEMBER( SiCustomList,		Customs );

	MULTI_LANG_MEMBER( SiModuleList,		Modules );
	MULTI_LANG_MEMBER( SiProfileList,		Profiles );
	MULTI_LANG_MEMBER( SiProfileItemList,	ProfileItems );
	MULTI_LANG_MEMBER( SiStarRegistryItemList, StarRegistryItems );
	MULTI_LANG_MEMBER( SiRegistryItemList,	RegistryItems );
	MULTI_LANG_MEMBER( SiRegistryAreaList,	RegistryAreas );
	MULTI_LANG_MEMBER( SiFolderItemList,	FolderItems );
	MULTI_LANG_MEMBER( SiOs2ClassList,		Os2Classes );
	MULTI_LANG_MEMBER( SiOs2TemplateList,	Os2Templates );
	MULTI_LANG_MEMBER( SiConfigurationItemList,	ConfigurationItems );

	MULTI_LANG_MEMBER( ULONG,				nEditions );
	MULTI_LANG_MEMBER( BOOL,				bInstalled );
	MULTI_LANG_MEMBER( BOOL,				bSelected );
	MULTI_LANG_MEMBER( BOOL,				bDontSelectByUser );
	MULTI_LANG_MEMBER( BOOL,				bHasChangeUninstall );
	MULTI_LANG_MEMBER( BOOL,				bHasChangeInstall );

	MULTI_LANG_MEMBER( ExecType,			eExecType );
	MULTI_LANG_MEMBER( ByteString,			eExecCommand );
	MULTI_LANG_MEMBER( ExecType,			eFollowExecType );
	MULTI_LANG_MEMBER( ByteString,			eFollowExecCommand );

	SiDoneModList* 		m_pDoneFileList;
	SiDoneModList* 		m_pDoneDirList;

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

public:
	                    SiModule(SiIdentifier const& ID, SiCompiler*);
	                    virtual ~SiModule();
	                    TYPEINFO();

	void 				SetParent(SiModule *pParent) { m_pParent = pParent; }
	SiModule          * GetParent()           const { return  m_pParent;       }
	SiModuleList const* GetModuleList()       const { return &m_Modules;       }
	SiModuleList*		GetModuleList()   		  { return &m_Modules;       }

	ByteString   const& GetName()             const { return  m_Name;          }
	ByteString   const& GetDescription()      const { return  m_Description;   }
	ByteString   const& GetOnSelect()         const { return  m_OnSelect;      }
	ByteString   const& GetOnDeselect()       const { return  m_OnDeselect;    }
	USHORT		 const& GetMaxSelect()        const { return  m_nMaxSelect;    }

	SiFileList		   const& GetFileList()         const { return  m_Files;         }
	SiDirList		   const& GetDirList()          const { return  m_Dirs;          }
	SiFolderItemList   const& GetFolderItemList()   const { return  m_FolderItems;   }
	SiProfileList	   const& GetProfileList()		const { return  m_Profiles; }
	SiProfileItemList  const& GetProfileItemList()  const { return  m_ProfileItems;  }
	SiStarRegistryItemList const& GetStarRegistryItemList() const { return  m_StarRegistryItems;  }
	SiCustomList	   const& GetCustomList()		const { return  m_Customs;	}
	SiProcedureList    const& GetProcedureList()	const { return  m_Procedures;    }
	SiRegistryItemList const& GetRegistryItemList() const { return  m_RegistryItems; }
	SiRegistryAreaList const& GetRegistryAreaList() const { return  m_RegistryAreas; }
	SiOs2ClassList     const& GetOs2ClassList()     const { return  m_Os2Classes;    }
	SiOs2TemplateList  const& GetOs2TemplateList()  const { return  m_Os2Templates;  }
	SiConfigurationItemList  const& GetConfigurationItemList()  const { return  m_ConfigurationItems;  }

	ExecType				GetExecType() const { return m_eExecType; }
	const ByteString&		GetExecCommand() const { return m_eExecCommand; }
	ExecType				GetFollowExecType() const { return m_eFollowExecType; }
	const ByteString&		GetFollowExecCommand() const { return m_eFollowExecCommand; }

	void Add(SiFile* pFile);
	void Add(SiDirectory* pDir);
	void Add(SiModule* pModule);
	void Add(SiFolderItem* pItem)				{ m_FolderItems.Insert(pItem,LIST_APPEND);
												  m_IsFolderItems = TRUE; }
	void Add(SiProfile* pItem)					{ m_Profiles.Insert(pItem,LIST_APPEND);
												  m_IsProfiles = TRUE; }
	void Add(SiProfileItem* pItem)				{ m_ProfileItems.Insert(pItem,LIST_APPEND);
												  m_IsProfileItems = TRUE; }
	void Add(SiStarRegistryItem* pItem)			{ m_StarRegistryItems.Insert(pItem,LIST_APPEND);
												  m_IsStarRegistryItems = TRUE; }
	void Add(SiProcedure* pItem)				{ m_Procedures.Insert(pItem,LIST_APPEND);
												  m_IsProcedures = TRUE; pItem->AddRefCount(1); }
	void Add(SiCustom* pItem)					{ m_Customs.Insert(pItem,LIST_APPEND);
												  m_IsCustoms = TRUE; }
	void Add(SiRegistryItem* pItem)				{ m_RegistryItems.Insert(pItem,LIST_APPEND);
												  m_IsRegistryItems = TRUE; pItem->AddRefCount(1); }
	void Add(SiRegistryArea* pItem)				{ m_RegistryAreas.Insert(pItem,LIST_APPEND);
												  m_IsRegistryAreas = TRUE; }
	void Add(SiOs2Class* pItem)			   		{ m_Os2Classes.Insert(pItem,LIST_APPEND);
												  m_IsOs2Classes = TRUE; }
	void Add(SiOs2Template* pItem)				{ m_Os2Templates.Insert(pItem,LIST_APPEND);
												  m_IsOs2Templates = TRUE; }
	void Add(SiConfigurationItem* pItem)	   	{ m_ConfigurationItems.Insert(pItem,LIST_APPEND);
												  m_IsConfigurationItems = TRUE; }

	void Remove(SiFile *pFile);
	void Remove(SiModule *pItem)				{ m_Modules.Remove(pItem);				}
	void Remove(SiFolderItem *pItem)			{ m_FolderItems.Remove(pItem);			}
	void Remove(SiProfile *pItem)				{ m_Profiles.Remove(pItem);				}
	void Remove(SiProfileItem *pItem)			{ m_ProfileItems.Remove(pItem);			}
	void Remove(SiStarRegistryItem *pItem)		{ m_StarRegistryItems.Remove(pItem);	}
	void Remove(SiProcedure *pItem)				{ m_Procedures.Remove(pItem);       pItem->AddRefCount(-1); }
	void Remove(SiCustom *pItem)				{ m_Customs.Remove(pItem);				}
	void Remove(SiRegistryItem *pItem)			{ m_RegistryItems.Remove(pItem);    pItem->AddRefCount(-1); }
	void Remove(SiRegistryArea *pItem)			{ m_RegistryAreas.Remove(pItem);		}
	void Remove(SiOs2Class *pItem)	  			{ m_Os2Classes.Remove(pItem);			}
	void Remove(SiOs2Template *pItem)			{ m_Os2Templates.Remove(pItem);			}
	void Remove(SiConfigurationItem *pItem)		{ m_ConfigurationItems.Remove(pItem);	}

	enum Selection {
			THIS_UNSEL,  THIS_UNSEL_IGNORE_INST,
            THIS_SEL,    THIS_SEL_IGNORE_INST,
			ALL_UNSEL,   ALL_SEL,
			ALL_DEFAULT, ALL_MINIMAL, ALL_INSTALLED };

	BOOL 	HasLangRef() const;
	BOOL 	HasObjects() const;
	BOOL 	HasUISubModules() const;
	BOOL	DontSelectByUser() const	{ return m_bDontSelectByUser; }

	void 	Select(Selection);

	BOOL 	IsSelected() const			{ return m_bSelected; }
	void 	SetSelected(BOOL bNew)		{ m_bSelected = bNew; }

	void 	SetInstalled(BOOL b=TRUE)	{ m_IsbInstalled = m_bInstalled = b; }
	BOOL 	IsInstalled() const			{ return m_bInstalled; }

	void	SetChangeUninstall() 		{ m_bHasChangeUninstall = TRUE; }
	BOOL	HasChangeUninstall() const	{ return m_bHasChangeUninstall; }
	void	SetChangeInstall() 	  		{ m_bHasChangeInstall = TRUE; }
	BOOL	HasChangeInstall() const	{ return m_bHasChangeInstall; }

	void 	SetMinimal(BOOL bNew)		{ m_bMinimal = bNew; }
	void 	SetDefault(BOOL bNew)		{ m_bDefault = bNew; }
	BOOL 	IsMinimal() const			{ return m_bMinimal;   }
	BOOL 	IsDefault() const			{ return m_bDefault;   }

	BOOL	IsHidden() const 			{ return m_bHiddenRoot; }
	void	SetHidden(BOOL bNew=TRUE)	{ m_bHiddenRoot = bNew; m_IsbHiddenRoot = bNew; }

	void	SetHiddenRecursive(BOOL bNew=TRUE)
										{ m_bHiddenRootRecursive = bNew; m_IsbHiddenRootRecursive = bNew; }
	BOOL	IsHiddenRecursiveFlag() const { return m_bHiddenRootRecursive; }
	BOOL	IsHiddenRecursive();

	enum MType { ALL, MINIMAL, DEFAULT, INSTALL, UNINSTALL, TEMP, ONLYTHIS, INSTALL_SYSTEM };

	// returns the real size with 10mb additional
	ULONG CalculateSize(SiEnvironment &rEnv, MType, ULONG lClusterSize,
				BOOL bSystem = FALSE, BOOL bWorkstation = FALSE,
				BOOL bIsFATFileSystem = FALSE) const;

private:
	ULONG _CalculateSize( SiFile* pFile, ULONG lThisSize, MType eType,
		  		ULONG lClusterSize, BOOL bSystem, BOOL bWorkstation,
		  		BOOL bIsFATFileSystem ) const;

	// returns the real size
	ULONG CalculateSize_impl(SiEnvironment &rEnv, MType, ULONG lClusterSize,
				BOOL bSystem = FALSE, BOOL bWorkstation = FALSE,
				BOOL bIsFATFileSystem = FALSE) const;
};

inline void SiModule::Remove(SiFile *pFile)
{
	m_Files.Remove(pFile);
	pFile->AddRefCount(-1);
}

// -------------------------------------------------------------
// SiModuleIds
// -------------------------------------------------------------

class SiModuleIds : public SiDeclarator
{
    MULTI_LANG_MEMBER( ByteString,          Name );
    MULTI_LANG_MEMBER( SiModuleList,        Modules );
    MULTI_LANG_MEMBER( BOOL,				bRecursive );

public:
    virtual BOOL            SetProperty(ByteString const& aProperty, ByteString const& aValue);
    virtual BOOL            SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

    virtual BOOL            Check();

    virtual	void            JoinWithParent();
    virtual BOOL            WriteTo(SiDatabase&) const;
    virtual ByteString      GetNaturalID() const;

public:
                            SiModuleIds( SiIdentifier const& ID, SiCompiler* );
    virtual                ~SiModuleIds();
                            TYPEINFO();

	ByteString const&       GetName() const             { return m_Name;       }
    SiModuleList const&     GetModuleList() const       { return m_Modules;    }
    BOOL                    IsRecursive() const         { return m_bRecursive; }

private:
    void                    Add( SiModule* pModule );
};

// -------------------------------------------------------------
// SiModuleSet
// -------------------------------------------------------------

class SiModulesSet : public SiDeclarator
{
    MULTI_LANG_MEMBER( ByteString,          Name );
    MULTI_LANG_MEMBER( ByteString,          Description );
    MULTI_LANG_MEMBER( SiModuleIdsList,     ModulesList );

public:
    virtual BOOL            SetProperty(ByteString const& aProperty, ByteString const& aValue);
    virtual BOOL            SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

    virtual BOOL            Check();

    virtual	void            JoinWithParent();
    virtual BOOL            WriteTo(SiDatabase&) const;
    virtual ByteString      GetNaturalID() const;

public:
                            SiModulesSet( SiIdentifier const& ID, SiCompiler* );
    virtual                ~SiModulesSet();
                            TYPEINFO();

	ByteString const&       GetName()           const { return m_Name;          }
	ByteString const&       GetDescription()    const { return m_Description;   }
    SiModuleIdsList const&  GetModuleIdsList()  const { return m_ModulesList;   }

private:
    void                    Add( SiModuleIds* pModuleIds );
};

///////////////////////////////////////////////////////////////////////////////

// SiModuleSet Hilfsklasse

DECLARE_LIST(ModList,SiModule*)

class SiModuleSet
{
	ModList		aModLst;
	ByteString	aName;
public:
		SiModuleSet(const ByteString& rN)				{ aName = rN; }
		~SiModuleSet() 								{}

	const ByteString&	Name() const 					{ return aName; }
	void				SetName(const ByteString& rNew)	{ aName = rNew; }

	void 				Add( SiModule* p) 				{ aModLst.Insert(p, LIST_APPEND); }
	void 				Remove(SiModule* p)				{ aModLst.Remove(p); }
	SiModule*			Seek(SiModule* p)				{ return aModLst.Seek(p); }

	ModList&			GetModList() 	 				{ return aModLst; }

	void				Select();
    void                Select( SiModule::Selection eSelection );
	void				DeSelect();
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiInstallation
//

class SiEnvironment;

class SiInstallation : public SiDeclarator
{
	// Felder der Inst-DB
	SiInstallMode	m_eInstallMode;
	ByteString		m_aSourcePath;
	ByteString		m_aDefaultDestPath;
	ByteString		m_aDestPath;

	ByteString 		m_aInternalProductVersion;
	ByteString 		m_aProductVersion;
	ByteString 		m_aProductName;
	ByteString 		m_aVendorVersion;
	ByteString 		m_aVendorName;
	ByteString 		m_aSuiteName;

	int				m_nScriptVersion;
	USHORT			m_nPatchLevel;
	BOOL 			m_bPatched;

	ByteString		m_aCompanyName;

	ByteString		m_aUpdateName;
	ULONG			m_nUpdateSize;
	ByteString		m_aTransmitter;
	BOOL			m_bOUpdateDone;
	ByteString 		m_aUiProcName;
	ByteString 		m_aTemplateFilename;

	// Updates/Upgrades
	ByteString		m_anUpdateFor;
	ByteString		m_anUpgradeFor;
	BOOL			m_bKeepOldVersion		: 1;	// Option fuer Update
	BOOL			m_bOldVersionRequired	: 1;	// Option fuer Update
	BOOL			m_bRegistrationRequired	: 1;
	BOOL			m_bForceOverwrite; 				// Option fuer Update

	ByteString		m_aDeleteKey;

	// Patch
	ByteString      m_aProductExtension;
	ByteString      m_aProductPatch;
	ByteString      m_aPatchLevel;

	// Spezielle Versionen
	ByteString		m_aSpecialVersion;
	ByteString		m_aProductBMP;
	ByteString 		m_aLogoBMP;
	ByteString 		m_aVendorBMP;

	// FollowApp
	ByteString 		m_aFollowApp;

	// Languages
	ByteString 		m_aDefLanguage;
	ByteString 		m_aLanguages;
	ByteString		m_aInstLanguages;

	BOOL			m_bRequiresShare	: 1;
	BOOL			m_bModifyPath		: 1;
	BOOL			m_bHideStandard		: 1;
	BOOL			m_bOnlyCustom		: 1;
	BOOL			m_bReboot			: 1;
	BOOL 			m_bNeedCfgServer	: 1;
	BOOL 			m_bInstallForAll	: 1;
	bool            m_bPathPage         : 1;
	bool            m_bHidePageReadyGo  : 1;

	BOOL			m_bInstallFromNet;
// overrideables
public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long aValue);
    virtual BOOL        SetProperty( ByteString const& aProperty, sal_uInt32 nValue );
    virtual BOOL        SetProperty( ByteString const& aProperty, SiDeclarator* aValue );

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

public:
	SiInstallation(SiIdentifier const& ID, SiCompiler*);
	TYPEINFO();

	ByteString const& GetSourcePath() const						{ return m_aSourcePath;		}

	ByteString const& GetDefaultDestPath() const				{ return m_aDefaultDestPath; }
	void		  SetDefaultDestPath(const ByteString& rNew)	{ m_aDefaultDestPath = rNew; }

	ByteString const& GetDestPath() const						{ return m_aDestPath; }
	void		  SetDestPath(const ByteString& rNew)			{ m_aDestPath = rNew; }

	ByteString const& GetInternalProductVersion() const			{ return m_aInternalProductVersion; }
	ByteString const& GetProductVersion() const					{ return m_aProductVersion; }
	ByteString const& GetProductName() const					{ return m_aProductName; }
	ByteString const& GetSuiteName() const		   				{ return m_aSuiteName; }
    ByteString const& GetVendorVersion() const                  { return m_aVendorVersion; }
    ByteString const& GetVendorName() const                     { return m_aVendorName; }

	SiInstallMode GetInstallMode() const						{ return m_eInstallMode;	}
	BOOL		  InstallFromNet() const						{ return m_bInstallFromNet;	}
	int			  GetScriptVersion() const						{ return m_nScriptVersion;	}

	void		  SetPatchLevel( USHORT n )						{ m_nPatchLevel = n;		}
	USHORT		  GetPatchLevel() const			   				{ return m_nPatchLevel;		}
	BOOL 		  IsPatched() const			   		  			{ return m_bPatched;		}
	void 		  SetPatched( BOOL bPatched = TRUE )  			{ m_bPatched = bPatched;	}

	ByteString const& GetUpdateFor() const						{ return m_anUpdateFor;   	}
	void 		  SetUpdateFor(const ByteString& rNew) 			{ m_anUpdateFor = rNew;		}
	ByteString const& GetUpgradeFor() const						{ return m_anUpgradeFor;	}
	ByteString const& GetCompanyName() const					{ return m_aCompanyName; 	}
	ByteString const& GetUiProcName() const 					{ return m_aUiProcName;		}
	ByteString const& GetTemplateFilename() const 				{ return m_aTemplateFilename; }

	ByteString const& GetUpdateName() const						{ return m_aUpdateName; 	}
	ULONG		  GetUpdateSize() const							{ return m_nUpdateSize;		}
	ByteString const& GetTransmitter() const					{ return m_aTransmitter;	}
	BOOL 		  HasOUpdate() const							{ return m_bOUpdateDone;	}
	void		  SetOUpdate()									{ m_bOUpdateDone = TRUE;	}

	BOOL 		  IsHideStandard() const						{ return m_bHideStandard; }
	BOOL          ForceOverwrite() const						{ return m_bForceOverwrite;}
	BOOL		  KeepOldVersion() const						{ return m_bKeepOldVersion;}
	BOOL		  IsOldVersionRequired() const					{ return m_bOldVersionRequired; }
	BOOL		  IsRegistrationRequired() const				{ return m_bRegistrationRequired; }

	BOOL		  RequiresShare() const 						{ return m_bRequiresShare;	}
	BOOL		  DoModifyPath() const 							{ return m_bModifyPath;		}
	ByteString	  GetDeleteKey() const 							{ return m_aDeleteKey;		}

	ByteString		  GetSpecialVersion() const 				{ return m_aSpecialVersion; }
	ByteString		  GetProductBMP() const						{ return m_aProductBMP; }
	ByteString		  GetVendorBMP() const						{ return m_aVendorBMP; }
	ByteString		  GetLogoBMP() const						{ return m_aLogoBMP; }

	const ByteString& GetFollowApp() const 						{ return m_aFollowApp; }

	const ByteString& GetDefLanguage() const 					{ return m_aDefLanguage; }
	const ByteString& GetLanguages() const	 					{ return m_aLanguages; }
	void 			SetLanguages(const ByteString& rNew)		{ m_aLanguages = rNew; }
	const ByteString&	GetInstalledLanguages() const 			{ return m_aInstLanguages; }
    void			    SetInstalledLanguages( const ByteString& rNew ) { m_aInstLanguages = rNew; }
	void			SetInstalledLanguages(SiEnvironment* pEnv);
	void			ClearInstalledLanguages()					{ m_aInstLanguages = ""; }
	BOOL 			IsLanguageInstalled(USHORT nLang, BOOL& rProg, BOOL& rDoc);

	void     			SetSourcePath(ByteString const& aPath)		{ m_aSourcePath = aPath; }
	void     			SetInstallMode(SiInstallMode m)				{ m_eInstallMode = m; }
	void     			SetInstallFromNet(BOOL b=TRUE)	   			{ m_bInstallFromNet = b; }

	BOOL    			IsOnlyCustom() const						{ return m_bOnlyCustom; }

    BOOL                InstallForAllUser() const                   { return m_bInstallForAll; }
	void 			    SetInstallForAllUser(BOOL b=TRUE)           { m_bInstallForAll = b; }

	void 				SetPathPage(bool b = true) 					{m_bPathPage = b;}
	bool 				IsPathPage() const         					{return m_bPathPage;}
	bool                IsPageReadyGo() const {return m_bHidePageReadyGo ? FALSE : TRUE;}

	// #102476#
	// ByteString const& GetProductExtension() const {return m_aProductExtension;}
	// void SetProductExtension(const ByteString& _rNew) {m_aProductExtension = _rNew;}
	// ByteString const& GetProductPatch() const {return m_aProductPatch;}
	// void SetProductPatch(const ByteString& _rNew) {m_aProductPatch = _rNew;}
};

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// 						System-Deklatratoren
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////
//
//		SiOs2Class
//

class SiOs2Class : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiModule*,			pModule );
	MULTI_LANG_MEMBER( ByteString,		  		aName );
	MULTI_LANG_MEMBER( SiFile*,		   		pDLL );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
	SiOs2Class(SiIdentifier const& ID, SiCompiler*, BOOL bSystemObject = FALSE);
	TYPEINFO();

	SiModule    * GetModule() const { return m_pModule; }
	ByteString const& GetName()   const { return m_aName;   }
	SiFile const* GetDLL()    const { return m_pDLL;    }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiOs2Creator
//

class SiOs2Creator : public SiDeclarator
{
	MULTI_LANG_MEMBER( ByteString,				aName );
	MULTI_LANG_MEMBER( ByteString,				anIcon );
	MULTI_LANG_MEMBER( SiDirectory*,		pIconDir );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiOs2Creator(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	ByteString      const& GetName()    const { return m_aName;    }
	ByteString      const& GetIcon()    const { return m_anIcon;   }
	SiDirectory const* GetIconDir() const { return m_pIconDir; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiOs2Template
//

class SiOs2Template : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiOs2Class*,		   	pOs2Class );
	MULTI_LANG_MEMBER( ByteString,			anID );
	MULTI_LANG_MEMBER( SiFile*,				pIcon );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString		GetNaturalID() const;

public:
		SiOs2Template(SiIdentifier const& ID, SiCompiler*);
		TYPEINFO();

	ByteString const& GetID()    const { return m_anID;		 }
	SiFile const*	  GetIcon()  const { return m_pIcon;	 }
	SiOs2Class const* GetClass() const { return m_pOs2Class; }
};

///////////////////////////////////////////////////////////////////////////////
//
//		SiUnixHardLink
//

class SiShortcut : public SiDeclarator
{
	MULTI_LANG_MEMBER( SiFile*,		   		pFile );
	MULTI_LANG_MEMBER( SiFile*,             pIconFile );
	MULTI_LANG_MEMBER( SiShortcut*,	   		pShortcut );
	MULTI_LANG_MEMBER( SiDirectory*,		pDir );
	MULTI_LANG_MEMBER( SiDirectory*,		pWorkDir );
	MULTI_LANG_MEMBER( ByteString,			aName );
	MULTI_LANG_MEMBER( ByteString,			aParameter );
	MULTI_LANG_MEMBER( ByteString,			aDescription );
	MULTI_LANG_MEMBER( sal_Int32,			nIconIndex );
	MULTI_LANG_MEMBER( BOOL,		   		bRelative );
	MULTI_LANG_MEMBER( BOOL,		   		bNetwork );
	MULTI_LANG_MEMBER( BOOL,		   		bStandalone );
	MULTI_LANG_MEMBER( BOOL,		   		bWorkstation );

public:
	virtual BOOL		SetProperty(ByteString const& aProperty, ByteString const& aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, SiDeclarator* aValue);
	virtual BOOL		SetProperty(ByteString const& aProperty, long nValue);

	virtual BOOL		Check();

	virtual	void 		JoinWithParent();
	virtual BOOL		WriteTo(SiDatabase&) const;
	virtual ByteString	GetNaturalID() const;

public:
	SiShortcut(SiIdentifier const& ID, SiCompiler*);
	TYPEINFO();

	ByteString const& GetName() const		{ return m_aName;   }

	SiFile      * GetFile() const			{ return m_pFile;   }
	SiFile      * GetIconFile() const		{ return m_pIconFile; }
	SiShortcut  * GetShortcut() const		{ return m_pShortcut; }

	SiDirectory * GetDirectory() const		{ return m_pDir; }
	SiDirectory * GetWorkDir() const		{ return m_pWorkDir; }

    sal_Int32     GetIconIndex() const      { return m_nIconIndex; }
    const ByteString& GetParameter() const  { return m_aParameter; }
    const ByteString& GetDescription() const{ return m_aDescription; }

	BOOL 		  IsRelative() const        { return m_bRelative; }
	BOOL 		  RunAtNetwork() const      { return m_bNetwork; }
	BOOL 		  RunAtStandalone() const   { return m_bStandalone; }
	BOOL 		  RunAtWorkstation() const  { return m_bWorkstation; }
};

#endif // __DECLTOR_HXX

