/*************************************************************************
 *
 *  $RCSfile: svstor.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:28:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVSTOR_HXX
#define _SVSTOR_HXX

#ifndef _IFACE_HXX
#include <so3/iface.hxx>
#endif
#ifndef _SOT_STORAGE_HXX
#include <sot/storage.hxx>
#endif

#include <so3/so2defs.hxx>

class SvStorage;
class StorageStream;
class SvStorageStream : virtual public SvObject, public SotStorageStream
{
friend class SvStorage;
friend class ImpStream;
	void *   pObjI;      // Zeiger auf das Speichermedium
	void  *  pRelease;   // OLE-Spec, wenn Erzeuger zerstoert
	virtual ULONG       GetData( void* pData, ULONG nSize );
	virtual ULONG       PutData( const void* pData, ULONG nSize );
	virtual ULONG       SeekPos( ULONG nPos );
	virtual void        FlushData();
protected:
						~SvStorageStream();
public:
	static void			Ole2SvStreamMode( ULONG nOleMode,
										StreamMode *, StorageMode * );
	static ULONG        Sv2OleStreamMode( StreamMode, StorageMode );
						SvStorageStream( const String &,
									 StreamMode = STREAM_STD_READWRITE,
									 StorageMode = 0 );
                        SvStorageStream( BaseStorageStream *pStm );
						SvStorageStream();
						SO2_DECL_STANDARD_CLASS_DLL(SvStorageStream,SOAPP)

	virtual USHORT		IsA() const;
	virtual void 		SyncSvStream();

	virtual void        SetSize( ULONG nNewSize );
	virtual BOOL        Commit();
	virtual BOOL        Revert();
};
#ifndef SO2_DECL_SVSTORAGESTREAM_DEFINED
#define SO2_DECL_SVSTORAGESTREAM_DEFINED
SO2_DECL_REF(SvStorageStream)
#endif
SO2_IMPL_REF(SvStorageStream)

//============================================================================
//============================================================================
//============================================================================
class  ImpPersistFile;
class  SvStorageInfoList;
class  Storage;
class SvStorage : virtual public SvObject, public SotStorage
{
friend class SvStorageStream;
friend class ImpPersistFile;
	void	 *  pRelease;  // OLE-Spec, wenn Erzeuger zerstoert
	void *		pObjI;     // Zeiger auf das Speichermedium
protected:
						~SvStorage();
public:
						SvStorage( const String &,
								   StreamMode = STREAM_STD_READWRITE,
								   StorageMode = 0 );
                        SvStorage( BOOL bUCBStorage, const String &,
                                   StreamMode = STREAM_STD_READWRITE,
                                   StorageMode = 0 );
                        SvStorage( BaseStorage * );
						SvStorage( SvStream & rStm );
                        SvStorage( BOOL bUCBStorage, SvStream & rStm );
						SvStorage( SvStream * pStm, BOOL bDelete );
						SvStorage();
						SO2_DECL_STANDARD_CLASS_DLL(SvStorage,SOAPP)

	static BOOL         IsStorageFile( const String & rFileName );
	const String &      GetName() const;

						// eigener Datenbereich
	void                SetClass( const SvGlobalName & rClass,
								  ULONG bOriginalClipFormat,
								  const String & rUserTypeName );
	void                SetConvertClass( const SvGlobalName & rConvertClass,
										 ULONG bOriginalClipFormat,
										 const String & rUserTypeName );
	SvGlobalName        GetClassName();// Typ der Daten im Storage
	ULONG               GetFormat();
	String              GetUserName();
	BOOL                ShouldConvert();

						// Liste aller Elemente
	void                FillInfoList( SvStorageInfoList * ) const;
	BOOL                CopyTo( SotStorage * pDestStg );
	BOOL                Commit();
	BOOL                Revert();

						/* Element Methoden     */
						// Stream mit Verbindung zu Storage erzeugen,
						// in etwa eine Parent-Child Beziehung
	SotStorageStream *  OpenSotStream( const String & rEleName,
									StreamMode = STREAM_STD_READWRITE,
									StorageMode = 0 );
	SotStorage *        OpenSotStorage( const String & rEleName,
									StreamMode = STREAM_STD_READWRITE,
									StorageMode = STORAGE_TRANSACTED );
	SvStorageStream *   OpenStream( const String & rEleName,
									StreamMode a = STREAM_STD_READWRITE,
									StorageMode b = 0 )
						{ return (SvStorageStream*)OpenSotStream( rEleName, a, b ); }
	SvStorage *         OpenStorage( const String & rEleName,
									StreamMode a = STREAM_STD_READWRITE,
									StorageMode b = STORAGE_TRANSACTED )
						{ return (SvStorage*)OpenSotStorage( rEleName, a, b ); }
    SvStorage *        OpenUCBStorage( const String & rEleName,
                                    StreamMode = STREAM_STD_READWRITE,
                                    StorageMode = STORAGE_TRANSACTED );
    SvStorage *        OpenOLEStorage( const String & rEleName,
                                    StreamMode = STREAM_STD_READWRITE,
                                    StorageMode = STORAGE_TRANSACTED );
						// Abfrage auf Storage oder Stream
	BOOL                IsStream( const String & rEleName ) const;
	BOOL                IsStorage( const String & rEleName ) const;
	BOOL                IsContained( const String & rEleName ) const;
						// Element loeschen
	BOOL                Remove( const String & rEleName );
						// Elementnamen aendern
	BOOL                Rename( const String & rEleName,
								const String & rNewName );
	BOOL                CopyTo( const String & rEleName, SotStorage * pDest,
								const String & rNewName );
	BOOL                MoveTo( const String & rEleName, SotStorage * pDest,
								const String & rNewName );
};

#ifndef SO2_DECL_SVSTORAGE_DEFINED
#define SO2_DECL_SVSTORAGE_DEFINED
SO2_DECL_REF(SvStorage)
#endif
SO2_IMPL_REF(SvStorage)

#endif // _SVSTOR_HXX
