/*************************************************************************
 *
 *  $RCSfile: brooker.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:36:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVTOOLS_BROOKER_HXX_
#define _SVTOOLS_BROOKER_HXX_

#include <tools/bcst.hxx>
#include <svtools/communi.hxx>

class FilterMessagePack
{
	BroadcastMessage &maMsg;
	BroadcastFilterFlag mnFilterFlags;
public:
	FilterMessagePack( BroadcastMessage &aMsg, BroadcastFilterFlag nFilterFlags )
		: maMsg( aMsg )
		, mnFilterFlags( nFilterFlags )
	{}

	BroadcastMessage& GetMsg() { return maMsg; }
	BroadcastFilterFlag GetFlags() { return mnFilterFlags; }
};

class TypedCommunicationLinkList;
SV_DECL_PTRARR_SORT( ClientLists, TypedCommunicationLinkList*, 1, 10 )

class InformationBrooker
{
	LinkList aMessageArrivedLnkList;
	LinkList aExtraCommandLnkList;
	LinkList aFilterMessageLnkList;
	CommunicationManager *mpManager;

	ClientLists *mpClientLists;

	DECL_LINK( ManagerOpen, CommunicationLink* );
	DECL_LINK( ManagerClose, CommunicationLink* );
	DECL_LINK( ManagerData, CommunicationLink* );

	void ImplDisconnectAll();
	void ImplRemoveLink( TypedCommunicationLinkList *pLinkList, CommunicationLink* pCL );
	void ImplHandleListeningLink( BroadcastCommand aCmd, BroadcastCategory nType, CommunicationLink* pCL );

	virtual void OpenConnection( CommunicationLink* pCL ){;}
	virtual void CloseConnection( CommunicationLink* pCL ){;}
	virtual void ReceiveData( CommunicationLink* pCL ){;}	/// Data is lost at this Point!!

public:
	InformationBrooker();
	virtual ~InformationBrooker();

	void Broadcast( ByteString aMsg, BroadcastCategory nCategory, ClientID aCI = BCST_CLIENT_BROOKER, BroadcastFilterFlag nFlags = BCST_FILTER_NOFILTER );

	USHORT GetCommunicationLinkCount() { return mpManager->GetCommunicationLinkCount(); }
	CommunicationLinkRef GetCommunicationLink( USHORT nNr ) { return mpManager->GetCommunicationLink( nNr ); }

	virtual BOOL ExtraCommand( SvStream *pData );
	/// Der Link wird mit einem *SvStream aufgerufen.
	/// die Links werden der Reihe nach solange gerufen, bis TRUE zurckgegeben wird.
	void AddExtraCommandHdl( Link aLink ) { aExtraCommandLnkList.Insert( new Link( aLink ), LIST_APPEND ); }
	void RemoveExtraCommandHdl( Link aLink );

	virtual void MessageArrived( const BroadcastMessage &aMsg );
	/// Der Link wird mit einem Pointer auf eine BroadcastMessage aufgerufen
	void AddMessageArrivedHdl( Link aLink ) { aMessageArrivedLnkList.Insert( new Link( aLink ), LIST_APPEND ); }
	void RemoveMessageArrivedHdl( Link aLink );

	virtual BOOL FilterMessage( BroadcastMessage &aMsg, BroadcastFilterFlag &nFilterFlags );
	/// Der Link wird mit einem Pointer auf ein FilterMessagePack aufgerufen.
	/// Soll die Message weiter behandelt werden, so mu TRUE zurckgegeben werden,
	/// anderenfalls wird die Message nach den Filtern weggeworfen.
	void AddFilterMessageHdl( Link aLink ) { aFilterMessageLnkList.Insert( new Link( aLink ), LIST_APPEND ); }
	void RemoveFilterMessageHdl( Link aLink );

};

#endif

