/*************************************************************************
 *
 *  $RCSfile: hdft.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: os $ $Date: 2002/08/26 11:29:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_HDFT_HXX
#define _SVX_HDFT_HXX

// include ---------------------------------------------------------------

#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

#ifndef _GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _SVX_PAGECTRL_HXX //autogen
#include <svx/pagectrl.hxx>
#endif

// class  SvxHFPage ------------------------------------------------------

class SvxHFPage: public SfxTabPage
{
public:

	virtual BOOL 	FillItemSet( SfxItemSet& rOutSet );
	virtual void	Reset( const SfxItemSet& rSet );

	virtual 		~SvxHFPage();

	void			DisableDeleteQueryBox() { bDisableQueryBox = TRUE; }
	void			EnableBackgroundSelector( BOOL bNew ) { bEnableBackgroundSelector = bNew; }
    void            EnableDynamicSpacing();

protected:
	virtual void	ActivatePage( const SfxItemSet& rSet );
	virtual int		DeactivatePage( SfxItemSet* pSet = 0 );

	SvxHFPage( Window* pParent, USHORT nResId, const SfxItemSet& rSet,
			   USHORT nSetId );

	CheckBox        aTurnOnBox;
	CheckBox        aCntSharedBox;
	FixedText       aLMLbl;
	MetricField     aLMEdit;
	FixedText       aRMLbl;
	MetricField     aRMEdit;
	FixedText		aDistFT;
	MetricField     aDistEdit;
    CheckBox        aDynSpacingCB;
	FixedText		aHeightFT;
	MetricField     aHeightEdit;
	CheckBox     	aHeightDynBtn;
	FixedLine       aFrm;
	SvxPageWindow	aBspWin;
	PushButton		aBackgroundBtn;

	USHORT			nId;
	SfxItemSet*		pBBSet;
	BOOL			bDisableQueryBox;
	BOOL			bEnableBackgroundSelector;
	FASTBOOL		bInReset;

	void 			InitHandler();
	DECL_LINK( TurnOnHdl, CheckBox*);
	DECL_LINK( DistModify, MetricField*);
	DECL_LINK( HeightModify, MetricField*);
	DECL_LINK( BorderModify, MetricField*);
	DECL_LINK( BackgroundHdl, Button*);

	void			UpdateExample();
	DECL_LINK( RangeHdl, Edit*);

private:
#ifdef _SVX_HDFT_CXX
	void			ResetBackground_Impl( const SfxItemSet& rSet );
#endif
};

// class SvxHeaderPage ---------------------------------------------------

class SvxHeaderPage : public SvxHFPage
{
public:
	static SfxTabPage* 	Create(	Window* pParent, const SfxItemSet& rSet );
	static USHORT*		GetRanges();

private:
	SvxHeaderPage( Window* pParent, const SfxItemSet& rSet );
};

// class SvxFooterPage ---------------------------------------------------

class SvxFooterPage : public SvxHFPage
{
public:
	static SfxTabPage* 	Create(	Window* pParent, const SfxItemSet& rSet );
	static USHORT*		GetRanges();

private:
	SvxFooterPage( 	Window* pParent, const SfxItemSet& rSet );
};

#endif

