/*************************************************************************
 *
 *  $RCSfile: i_map.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_MAP_HXX
#define UDM_MAP_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/data.hxx>
	// COMPONENTS
	// PARAMETERS
#include <udm/object.hxx>

namespace udm
{

class Map : public Data
{
  protected:
    class iterator_impl
    {
      public:
        virtual         ~iterator_impl() {}
        void            advance();
        Object          ref() const;
        DYN iterator_impl &
                        create_copy() const;
      private:
        virtual void    do_Advance() = 0;
        virtual Object  inq_Ref() const= 0;
        virtual DYN iterator_impl &
                        inq_CreateCopy() const = 0;
    };

  public:
    class iterator
    {
      public:
                        iterator(
                            DYN iterator_impl & let_drImpl );
                        iterator(
                            const iterator &    i_rIter );

        iterator &      operator=(
                            const iterator &    i_rIter );
        Object          operator*() const;
        iterator &      operator++();

      private:
        Dyn<iterator_impl>
                        pi;
    };

    enum E_KeyType
    {
        key_String,
        key_UInteger
    };

    // LIFECYCLE
    virtual             ~Map() {}

    // OPERATORS
    Object              operator[](
                            const ::csv::String & i_key ) const;
    Object              operator[](
                            uintt               i_key ) const;

    Object              operator[](
                            const ::csv::String & i_key );
    Object              operator[](
                            uintt               i_key );

    // OPERATIONS
    void                erase();
    void                add(
                            const ::csv::String & i_key,
                            DYN Data &          let_drData );
    void                add(
                            uintt               i_key,
                            DYN Data &          let_drData );
    void                remove(
                            const ::csv::String & i_key );
    void                remove(
                            uintt               i_key );

    // INQUIRY
    uintt               size() const;

    iterator            begin() const;
    iterator            end() const;

    E_KeyType           key_type() const;

  private:
    // Interface Data:
    virtual accessor_type
                        inq_Type() const;
    // Locals
    virtual void        do_erase() = 0;
    virtual void        do_add(
                            DYN Data &          let_drData ) = 0;
    virtual uintt       inq_Size() const = 0;
    virtual E_KeyType   inq_KeyType() const = 0;
};



}   // namespace udm


#endif


