/*************************************************************************
 *
 *  $RCSfile: system.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: pl $ $Date: 2002/07/04 11:19:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SYSTEM_HXX
#define _SV_SYSTEM_HXX

class Window;

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_FONT_HXX
#include <vcl/font.hxx>
#endif

// ----------------
// - StandardFont -
// ----------------

enum _StandardFont { _STDFONT_SWISS, _STDFONT_ROMAN, _STDFONT_FIXED, _STDFONT_SYMBOL };

// ----------------
// - System-Types -
// ----------------

#define SYSTEM_GETSYSTEMINFO_STACK          ((ULONG)0x00000001)
#define SYSTEM_GETSYSTEMINFO_MODULES        ((ULONG)0x00000002)
#define SYSTEM_GETSYSTEMINFO_SYSTEMVERSION  ((ULONG)0x00000004)
#define SYSTEM_GETSYSTEMINFO_CPUTYPE        ((ULONG)0x00000008)
#define SYSTEM_GETSYSTEMINFO_MEMORYINFO     ((ULONG)0x00000010)
#define SYSTEM_GETSYSTEMINFO_LOCALVOLUMES   ((ULONG)0x00000020)
#define SYSTEM_GETSYSTEMINFO_SYSTEMDIRS     ((ULONG)0x00000040)
#define SYSTEM_GETSYSTEMINFO_MOUSEINFO      ((ULONG)0x00000080)
#define SYSTEM_GETSYSTEMINFO_GRAPHICSSYSTEM ((ULONG)0x00000100)
#define SYSTEM_GETSYSTEMINFO_ALL            ((ULONG)0xFFFFFFFF)

// ----------
// - System -
// ----------

class System
{
public:
    static  Font            _GetStandardFont( _StandardFont eStdFont );

    static  LineEnd         GetLineEnd()
                                    { return ::GetSystemLineEnd(); }

    static XubString        GetSummarySystemInfos( ULONG nFlags = SYSTEM_GETSYSTEMINFO_ALL );

    struct DisplayInfo
    {
        int nWidth, nHeight, nDepth;
    };
    // fills the submitted DisplayInfo
    // return value of false tells an error has
    // occurred, in this case the submitted DisplayInfo
    // will not be changed
    static bool			GetDisplayInfo( DisplayInfo& rInfo );
};

#endif // _SV_SYSTEM_HXX
