/*************************************************************************
 *
 *  $RCSfile: stdobj1.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:12:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SBSTDOBJ1_HXX
#define _SBSTDOBJ1_HXX

#ifndef _SBX_SBXOBJECT_HXX //autogen
#include <svtools/sbxobj.hxx>
#endif
#ifndef _GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef __SBX_SBX_FACTORY_HXX //autogen
#include <svtools/sbxfac.hxx>
#endif
class StarBASIC;
class SbStdFactory;

//--------------------
// class SbStdFactory
//--------------------
class SbStdFactory : public SbxFactory
{
public:
	SbStdFactory();

	virtual SbxObject*  CreateObject( const String& rClassName );
};

//--------------------
// class SbStdPicture
//--------------------
class SbStdPicture : public SbxObject
{
protected:
	Graphic		aGraphic;

   ~SbStdPicture();
	virtual void SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							 const SfxHint& rHint, const TypeId& rHintType );

	void 	PropType( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	PropWidth( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	PropHeight( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );

public:
	TYPEINFO();

	SbStdPicture();
	virtual SbxVariable* Find( const String&, SbxClassType );

	Graphic GetGraphic() const { return aGraphic; }
	void	SetGraphic( const Graphic& rGrf ) { aGraphic = rGrf; }
};

//-----------------
// class SbStdFont
//-----------------
class SbStdFont : public SbxObject
{
protected:
	BOOL	bBold;
	BOOL	bItalic;
	BOOL	bStrikeThrough;
	BOOL	bUnderline;
	USHORT	nSize;
	String	aName;

   ~SbStdFont();
	virtual void SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							 const SfxHint& rHint, const TypeId& rHintType );

	void 	PropBold( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	PropItalic( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	PropStrikeThrough( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	PropUnderline( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	PropSize( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	PropName( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );

public:
	TYPEINFO();

	SbStdFont();
	virtual SbxVariable* Find( const String&, SbxClassType );

	void	SetBold( BOOL bB ) { bBold = bB; }
	BOOL	IsBold() const { return bBold; }
	void	SetItalic( BOOL bI ) { bItalic = bI; }
	BOOL	IsItalic() const { return bItalic; }
	void	SetStrikeThrough( BOOL bS ) { bStrikeThrough = bS; }
	BOOL	IsStrikeThrough() const { return bStrikeThrough; }
	void	SetUnderline( BOOL bU ) { bUnderline = bU; }
	BOOL	IsUnderline() const { return bUnderline; }
	void	SetSize( USHORT nS ) { nSize = nS; }
	USHORT	GetSize() const { return nSize; }
	void	SetFontName( const String& rName ) { aName = rName; }
	String	GetFontName() const { return aName; }
};

//----------------------
// class SbStdClipboard
//----------------------
class SbStdClipboard : public SbxObject
{
protected:

   ~SbStdClipboard();
	virtual void SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							 const SfxHint& rHint, const TypeId& rHintType );

	void 	MethClear( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	MethGetData( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	MethGetFormat( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	MethGetText( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	MethSetData( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );
	void	MethSetText( SbxVariable* pVar, SbxArray* pPar, BOOL bWrite );

public:
	TYPEINFO();

	SbStdClipboard();
	virtual SbxVariable* Find( const String&, SbxClassType );
};

#endif
