/*************************************************************************
 *
 *  $RCSfile: fattr.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:02:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _FATTR_HXX
#define _FATTR_HXX

#include <tools/fsys.hxx>
#include <string.h>

#if defined (WNT) || defined (OS2)
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#endif

#define FA_NORMAL	0x00000000L
#ifndef UNX
#define	FA_RDONLY	00444
#else
#define	FA_RDONLY	S_IREAD /*| S_IFREG */
#endif
#define FA_HIDDEN	0x00000002L
#define	FA_SYSTEM	0x00000004L
#ifndef UNX
#define	FA_WRITE	S_IREAD | S_IWRITE /* | S_IFREG */
#else
#define	FA_WRITE	00777
#endif
#define	FA_SUBDIR	0x00000010L
#define	FA_ARCH		0x00000020L

#if defined(WNT)
#define chmod	_chmod
#endif

struct FileAttribute_Impl;

class FileAttribute : public FileStat
{
	DirEntry			theEntry;
	char				*pFileName;
	FileAttribute_Impl	*pImpl;

protected:
	FileAttribute_Impl* GetAttributes();
	void				SetAttributes( FileAttribute_Impl * );
public:
						FileAttribute();
						FileAttribute( const DirEntry& rDirEntry );
						FileAttribute( const FileAttribute &rFattr );
						~FileAttribute();

	void				SetName( const DirEntry &rEntry );
	void				SetName( const String &rName );
	DirEntry			GetDirEntry();

	BOOL				Attrib( ULONG nAttr );
	BOOL				Touch();
	BOOL				Delete();
	BOOL				Touch( String aRefFile );
	BOOL				Touch( Date &rModDate, Time &rModTime );
	BOOL				Touch( Date &rModDate, Time &rModTime, Date &rAccDate, Time &rAccTime );
	ULONG				GetFlags();

	void				LowerName();
	void				LowerName(char*);
	static void			Error();
};

struct FileCloner_Impl;

/*
 * Die Klasse FileCloner fertigt nicht nur eine Kopie einer Datei an
 * sondern erhaelt darueber hinaus auch die Attribute
 *
 */

class FileCloner
{
	DirEntry			aSource;
	DirEntry			aTarget;
	ULONG				nBytesTotal;
	ULONG				nBytesCopied;
	Link				aProgressLink;
	USHORT				nBlockSize;
	ULONG				nProgress;
	BOOL				bUpdateCopy;// copy if newer !
	BOOL				bDiffCopy; 	// copy if different !
	BOOL				bCopied;	// really copied !
	FileCloner_Impl*	pImp;

private:
	FSysError			DoCopy_Impl( const DirEntry &rSource,
								const DirEntry &rTarget, BOOL bTop );
	BOOL				DoCompare_Impl( const DirEntry &rSource,
								const DirEntry &rTarget );

protected:
	virtual BOOL		Progress();
	virtual ErrCode		Error( ErrCode eErr,
							   const DirEntry *pSource, const DirEntry *pTarget );
	void				Begin();
	void				End();
public:
						FileCloner();
						FileCloner( const DirEntry &rSource,
						            const DirEntry &rTarget );
						FileCloner( const FileCloner &rCloner );

	FileCloner&			operator = ( const FileCloner &rCloner );

	void				SetBlockSize( USHORT nBytes ) { nBlockSize = nBytes; }
	USHORT				GetBlockSize() const { return nBlockSize; }

	ULONG				GetBytesTotal() const { return nBytesTotal; }
	ULONG				GetBytesCopied() const { return nBytesCopied; }

	void				SetSource( const DirEntry &rSource ) { aSource = rSource; }
	void				SetTarget( const DirEntry &rTarget ) { aTarget = rTarget; }
	const DirEntry&		GetSource() const { return aSource; }
	const DirEntry&		GetTarget() const { return aTarget; }

	void				SetUpdateCopy( BOOL bUpdate = TRUE ){bUpdateCopy =
																bUpdate; }
	void				SetDiffCopy( BOOL bDiff = TRUE ){bDiffCopy =
																bDiff; }
	FSysError			Execute( FSysAction nActions = FSYS_ACTION_STANDARD );

	BOOL				Compare();

	const DirEntry*		GetErrorSource() const;
	const DirEntry*		GetErrorTarget() const;
	ErrCode				GetError() const;
	BOOL				Copied(){ return bCopied;}

	void				SetProgressHdl( const Link& rLink ) { aProgressLink = rLink; }
	const Link&			GetProgressHdl() const { return aProgressLink; }
	void				SetErrorHdl( const Link& rLink );
	const Link&			GetErrorHdl() const;~FileCloner();
};

#endif
