#ifndef _LINUX_ATOMIC_H_
#define _LINUX_ATOMIC_H_


typedef struct { volatile int aVal; } atomic_t;

#define INIT_ATOMIC_VALUE(c) { (c) }

#define atomic_dec_and_test(p) (atomic_dec((p)) == 0)

#define atomic_read(p) ((p)->aVal)


#if defined ( X86 ) || defined(__x86__)

static __inline__ int atomic_inc (atomic_t * pCount)
{
	int  nCount;

	__asm__ __volatile__ (
		"movl $1, %0\n\t"
		"lock\n\t" 
		"xadd %0, %2\n\t"
		"incl %0"
	:	"=&r" (nCount), "=m" (pCount->aVal)
	:	"m" (pCount->aVal)
	:	"memory");

    return nCount;
}

static __inline__ int atomic_dec(atomic_t * pCount)
{
	int nCount;

	__asm__ __volatile__ (
		"movl $-1, %0\n\t"
		"lock\n\t"
		"xadd %0, %2\n\t"
		"decl %0"
	:	"=&r" (nCount), "=m" (pCount->aVal)
	:	"m" (pCount->aVal)
	:	"memory");

    return nCount;
}

#elif defined ( POWERPC ) || defined(__powerpc__) || defined (ppc)

static __inline__ int atomic_inc(atomic_t * pCount)
{
	int nCount;

	__asm__ __volatile__ (
		"1: lwarx   %0,0,%2\n\t"
		"   addic   %0,%0,1\n\t"
		"   stwcx.  %0,0,%2\n\t"
		"   bne-    1b\n\t"
                "   sync"
		: "=&r" (nCount), "=m" (pCount->aVal)
		: "r" (pCount), "m" (pCount->aVal)
		: "cc");

	return nCount;
}


static __inline__ int atomic_dec(atomic_t * pCount)
{
	int  nCount;

	__asm__ __volatile__ (
		"1: lwarx   %0,0,%2\n\t"
		"   subic   %0,%0,1\n\t"
		"   stwcx.  %0,0,%2\n\t"
		"   bne-    1b\n\t"
		"   sync"
		: "=&r" (nCount), "=m" (pCount->aVal)
		: "r" (pCount), "m" (pCount->aVal)
		: "cc");

	return nCount;
}


#elif defined(__s390__)

#define __CS_LOOP(old_val, new_val, ptr, op_val, op_string)		\
       __asm__ __volatile__("   l     %0,0(%2)\n"			\
                            "0: lr    %1,%0\n"			\
                            op_string "  %1,%3\n"			\
                            "   cs    %0,%1,0(%2)\n"			\
                            "   jl    0b"				\
                            : "=&d" (old_val), "=&d" (new_val)		\
		     : "a" (ptr), "d" (op_val) : "cc" );

static __inline__ int atomic_inc(volatile atomic_t *v)
{
int old_val, new_val;
__CS_LOOP(old_val, new_val, v, 1, "ar");
       return new_val;
}


static __inline__ int atomic_dec(volatile atomic_t *v)
{
int old_val, new_val;
__CS_LOOP(old_val, new_val, v, 1, "sr");
       return new_val;
}

#else

#error - need to define your processors atomic inc and dec here

#endif

#endif
