/*************************************************************************
 *
 *  $RCSfile: b2dmpnt.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:30:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _B2D_MPNT_HXX
#define _B2D_MPNT_HXX

#ifndef _B2D_MBASE_HXX
#include <goodies/b2dmbase.hxx>
#endif

//************************************************************
//   Defines
//************************************************************

// Enum for MarkerKind
enum B2dIAOMarkerKind
{
	B2D_IAO_MARKER_POINT,
	B2D_IAO_MARKER_PLUS,
	B2D_IAO_MARKER_CROSS,

	B2D_IAO_MARKER_RECT_3X3,
	B2D_IAO_MARKER_RECT_5X5,
	B2D_IAO_MARKER_RECT_7X7,
	B2D_IAO_MARKER_RECT_9X9,

	B2D_IAO_MARKER_CIRCLE_3X3,
	B2D_IAO_MARKER_CIRCLE_5X5,
	B2D_IAO_MARKER_CIRCLE_7X7,
	B2D_IAO_MARKER_CIRCLE_9X9,

	B2D_IAO_MARKER_ELLIPSE_5X3,
	B2D_IAO_MARKER_ELLIPSE_7X5,
	B2D_IAO_MARKER_ELLIPSE_9X7,

	B2D_IAO_MARKER_ELLIPSE_3X5,
	B2D_IAO_MARKER_ELLIPSE_5X7,
	B2D_IAO_MARKER_ELLIPSE_7X9,

	B2D_IAO_MARKER_CROSSHAIR_3X3,
	B2D_IAO_MARKER_CROSSHAIR_5X5,
	B2D_IAO_MARKER_CROSSHAIR_7X7,
	B2D_IAO_MARKER_CROSSHAIR_9X9
};

//************************************************************
//   InterActionObjectMarker
//************************************************************

class B2dIAOMarker : public B2dIAObject
{
	// 2nd color of IAO (for Borders)
	Color						a2ndColor;

	// Kind of Marker
	B2dIAOMarkerKind			eMarkerKind;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

	// local help functions for creation
	void CreateGeometryFromMarkerData(BYTE* pData);
	void CreateBaseRectFromMarkerData(BYTE* pData);
	BOOL DoHitTestWithMarkerData(BYTE* pData, const Point& rPixelPos, UINT16 nTol);

public:
    TYPEINFO();
	B2dIAOMarker(B2dIAOManager* pMan, Point aPos, B2dIAOMarkerKind eKind = B2D_IAO_MARKER_POINT);
	virtual ~B2dIAOMarker();

	// Access to 2ndColor
	const Color& Get2ndColor() const { return a2ndColor; }
	void Set2ndColor(Color aNew);

	// Access to Kind
	B2dIAOMarkerKind GetKind() const { return eMarkerKind; }
	void SetMarkerKind(B2dIAOMarkerKind eNew);

	// Hittest
	virtual BOOL IsHit(const Point& rPixelPos, UINT16 nTol = 0);
};

#endif          // _B2D_MPNT_HXX
