/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /usr/home/sean/mozdev/mozilla-1.0/mozilla/netwerk/base/public/nsISocketTransport.idl
 */

#ifndef __gen_nsISocketTransport_h__
#define __gen_nsISocketTransport_h__


#ifndef __gen_nsITransport_h__
#include "nsITransport.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsISocketTransport */
#define NS_ISOCKETTRANSPORT_IID_STR "785ca0f0-c39e-11d3-9ed6-0010a4053fd0"

#define NS_ISOCKETTRANSPORT_IID \
  {0x785ca0f0, 0xc39e, 0x11d3, \
    { 0x9e, 0xd6, 0x00, 0x10, 0xa4, 0x05, 0x3f, 0xd0 }}

class NS_NO_VTABLE nsISocketTransport : public nsITransport {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISOCKETTRANSPORT_IID)

  /**
     * Destination host and port. These are used for reporting status messages
     * Since the end server may change at any time (eg persistent connections
     * through proxies), a client can update this to get correct results.
     * There is no other effect of setting these attributes, and if a proxy
     * server is not being used, NS_ERROR_FAILURE is returned.
     */
  /* attribute string host; */
  NS_IMETHOD GetHost(char * *aHost) = 0;
  NS_IMETHOD SetHost(const char * aHost) = 0;

  /* attribute long port; */
  NS_IMETHOD GetPort(PRInt32 *aPort) = 0;
  NS_IMETHOD SetPort(PRInt32 aPort) = 0;

  /**
     *
     */
  /* attribute boolean reuseConnection; */
  NS_IMETHOD GetReuseConnection(PRBool *aReuseConnection) = 0;
  NS_IMETHOD SetReuseConnection(PRBool aReuseConnection) = 0;

  /**
     * socket read/write timeout in seconds; 0 = no timeout
     */
  /* attribute unsigned long socketTimeout; */
  NS_IMETHOD GetSocketTimeout(PRUint32 *aSocketTimeout) = 0;
  NS_IMETHOD SetSocketTimeout(PRUint32 aSocketTimeout) = 0;

  /**
     * socket   connect  timeout in seconds; 0 = no timeout
     */
  /* attribute unsigned long socketConnectTimeout; */
  NS_IMETHOD GetSocketConnectTimeout(PRUint32 *aSocketConnectTimeout) = 0;
  NS_IMETHOD SetSocketConnectTimeout(PRUint32 aSocketConnectTimeout) = 0;

  /**
     * Is used to tell the channel to stop reading data after a certain point;
     * needed by HTTP/1.1
     */
  /* attribute long bytesExpected; */
  NS_IMETHOD GetBytesExpected(PRInt32 *aBytesExpected) = 0;
  NS_IMETHOD SetBytesExpected(PRInt32 aBytesExpected) = 0;

  /* attribute unsigned long reuseCount; */
  NS_IMETHOD GetReuseCount(PRUint32 *aReuseCount) = 0;
  NS_IMETHOD SetReuseCount(PRUint32 aReuseCount) = 0;

  /**
     * Checks if the socket is still alive
     *
     * @param seconds   amount of time after which the socket is always deemed to be
     *                  dead (no further checking is done in this case); seconds = 0
     *                  will cause it not to do the timeout checking at all
     */
  /* boolean isAlive (in unsigned long seconds); */
  NS_IMETHOD IsAlive(PRUint32 seconds, PRBool *_retval) = 0;

  /**
     * maximum amount of time in seconds the transport is allowed to stay alive
     * while connected (0 - default; no maximum idle timeout)
     */
  /* attribute unsigned long idleTimeout; */
  NS_IMETHOD GetIdleTimeout(PRUint32 *aIdleTimeout) = 0;
  NS_IMETHOD SetIdleTimeout(PRUint32 aIdleTimeout) = 0;

  /**
	 * the string representation of the underlying ip address. Caller 
	 * is responsible for de-allocating the returned string.
	 */
  /* [noscript] string GetIPStr (in unsigned long aStrLen); */
  NS_IMETHOD GetIPStr(PRUint32 aStrLen, char **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISOCKETTRANSPORT \
  NS_IMETHOD GetHost(char * *aHost); \
  NS_IMETHOD SetHost(const char * aHost); \
  NS_IMETHOD GetPort(PRInt32 *aPort); \
  NS_IMETHOD SetPort(PRInt32 aPort); \
  NS_IMETHOD GetReuseConnection(PRBool *aReuseConnection); \
  NS_IMETHOD SetReuseConnection(PRBool aReuseConnection); \
  NS_IMETHOD GetSocketTimeout(PRUint32 *aSocketTimeout); \
  NS_IMETHOD SetSocketTimeout(PRUint32 aSocketTimeout); \
  NS_IMETHOD GetSocketConnectTimeout(PRUint32 *aSocketConnectTimeout); \
  NS_IMETHOD SetSocketConnectTimeout(PRUint32 aSocketConnectTimeout); \
  NS_IMETHOD GetBytesExpected(PRInt32 *aBytesExpected); \
  NS_IMETHOD SetBytesExpected(PRInt32 aBytesExpected); \
  NS_IMETHOD GetReuseCount(PRUint32 *aReuseCount); \
  NS_IMETHOD SetReuseCount(PRUint32 aReuseCount); \
  NS_IMETHOD IsAlive(PRUint32 seconds, PRBool *_retval); \
  NS_IMETHOD GetIdleTimeout(PRUint32 *aIdleTimeout); \
  NS_IMETHOD SetIdleTimeout(PRUint32 aIdleTimeout); \
  NS_IMETHOD GetIPStr(PRUint32 aStrLen, char **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISOCKETTRANSPORT(_to) \
  NS_IMETHOD GetHost(char * *aHost) { return _to GetHost(aHost); } \
  NS_IMETHOD SetHost(const char * aHost) { return _to SetHost(aHost); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return _to GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return _to SetPort(aPort); } \
  NS_IMETHOD GetReuseConnection(PRBool *aReuseConnection) { return _to GetReuseConnection(aReuseConnection); } \
  NS_IMETHOD SetReuseConnection(PRBool aReuseConnection) { return _to SetReuseConnection(aReuseConnection); } \
  NS_IMETHOD GetSocketTimeout(PRUint32 *aSocketTimeout) { return _to GetSocketTimeout(aSocketTimeout); } \
  NS_IMETHOD SetSocketTimeout(PRUint32 aSocketTimeout) { return _to SetSocketTimeout(aSocketTimeout); } \
  NS_IMETHOD GetSocketConnectTimeout(PRUint32 *aSocketConnectTimeout) { return _to GetSocketConnectTimeout(aSocketConnectTimeout); } \
  NS_IMETHOD SetSocketConnectTimeout(PRUint32 aSocketConnectTimeout) { return _to SetSocketConnectTimeout(aSocketConnectTimeout); } \
  NS_IMETHOD GetBytesExpected(PRInt32 *aBytesExpected) { return _to GetBytesExpected(aBytesExpected); } \
  NS_IMETHOD SetBytesExpected(PRInt32 aBytesExpected) { return _to SetBytesExpected(aBytesExpected); } \
  NS_IMETHOD GetReuseCount(PRUint32 *aReuseCount) { return _to GetReuseCount(aReuseCount); } \
  NS_IMETHOD SetReuseCount(PRUint32 aReuseCount) { return _to SetReuseCount(aReuseCount); } \
  NS_IMETHOD IsAlive(PRUint32 seconds, PRBool *_retval) { return _to IsAlive(seconds, _retval); } \
  NS_IMETHOD GetIdleTimeout(PRUint32 *aIdleTimeout) { return _to GetIdleTimeout(aIdleTimeout); } \
  NS_IMETHOD SetIdleTimeout(PRUint32 aIdleTimeout) { return _to SetIdleTimeout(aIdleTimeout); } \
  NS_IMETHOD GetIPStr(PRUint32 aStrLen, char **_retval) { return _to GetIPStr(aStrLen, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISOCKETTRANSPORT(_to) \
  NS_IMETHOD GetHost(char * *aHost) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetHost(aHost); } \
  NS_IMETHOD SetHost(const char * aHost) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHost(aHost); } \
  NS_IMETHOD GetPort(PRInt32 *aPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPort(aPort); } \
  NS_IMETHOD SetPort(PRInt32 aPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPort(aPort); } \
  NS_IMETHOD GetReuseConnection(PRBool *aReuseConnection) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReuseConnection(aReuseConnection); } \
  NS_IMETHOD SetReuseConnection(PRBool aReuseConnection) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReuseConnection(aReuseConnection); } \
  NS_IMETHOD GetSocketTimeout(PRUint32 *aSocketTimeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSocketTimeout(aSocketTimeout); } \
  NS_IMETHOD SetSocketTimeout(PRUint32 aSocketTimeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSocketTimeout(aSocketTimeout); } \
  NS_IMETHOD GetSocketConnectTimeout(PRUint32 *aSocketConnectTimeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSocketConnectTimeout(aSocketConnectTimeout); } \
  NS_IMETHOD SetSocketConnectTimeout(PRUint32 aSocketConnectTimeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSocketConnectTimeout(aSocketConnectTimeout); } \
  NS_IMETHOD GetBytesExpected(PRInt32 *aBytesExpected) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBytesExpected(aBytesExpected); } \
  NS_IMETHOD SetBytesExpected(PRInt32 aBytesExpected) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetBytesExpected(aBytesExpected); } \
  NS_IMETHOD GetReuseCount(PRUint32 *aReuseCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReuseCount(aReuseCount); } \
  NS_IMETHOD SetReuseCount(PRUint32 aReuseCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReuseCount(aReuseCount); } \
  NS_IMETHOD IsAlive(PRUint32 seconds, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsAlive(seconds, _retval); } \
  NS_IMETHOD GetIdleTimeout(PRUint32 *aIdleTimeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIdleTimeout(aIdleTimeout); } \
  NS_IMETHOD SetIdleTimeout(PRUint32 aIdleTimeout) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetIdleTimeout(aIdleTimeout); } \
  NS_IMETHOD GetIPStr(PRUint32 aStrLen, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetIPStr(aStrLen, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSocketTransport : public nsISocketTransport
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISOCKETTRANSPORT

  nsSocketTransport();
  virtual ~nsSocketTransport();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSocketTransport, nsISocketTransport)

nsSocketTransport::nsSocketTransport()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsSocketTransport::~nsSocketTransport()
{
  /* destructor code */
}

/* attribute string host; */
NS_IMETHODIMP nsSocketTransport::GetHost(char * *aHost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetHost(const char * aHost)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long port; */
NS_IMETHODIMP nsSocketTransport::GetPort(PRInt32 *aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetPort(PRInt32 aPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean reuseConnection; */
NS_IMETHODIMP nsSocketTransport::GetReuseConnection(PRBool *aReuseConnection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetReuseConnection(PRBool aReuseConnection)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long socketTimeout; */
NS_IMETHODIMP nsSocketTransport::GetSocketTimeout(PRUint32 *aSocketTimeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetSocketTimeout(PRUint32 aSocketTimeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long socketConnectTimeout; */
NS_IMETHODIMP nsSocketTransport::GetSocketConnectTimeout(PRUint32 *aSocketConnectTimeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetSocketConnectTimeout(PRUint32 aSocketConnectTimeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute long bytesExpected; */
NS_IMETHODIMP nsSocketTransport::GetBytesExpected(PRInt32 *aBytesExpected)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetBytesExpected(PRInt32 aBytesExpected)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long reuseCount; */
NS_IMETHODIMP nsSocketTransport::GetReuseCount(PRUint32 *aReuseCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetReuseCount(PRUint32 aReuseCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isAlive (in unsigned long seconds); */
NS_IMETHODIMP nsSocketTransport::IsAlive(PRUint32 seconds, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long idleTimeout; */
NS_IMETHODIMP nsSocketTransport::GetIdleTimeout(PRUint32 *aIdleTimeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsSocketTransport::SetIdleTimeout(PRUint32 aIdleTimeout)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* [noscript] string GetIPStr (in unsigned long aStrLen); */
NS_IMETHODIMP nsSocketTransport::GetIPStr(PRUint32 aStrLen, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsISocketTransport_h__ */
