/*************************************************************************
 *
 *  $RCSfile: maindlg.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _MAINDLG_HXX
#define _MAINDLG_HXX

#include <setup2/agentdlg.hxx>

class SiEnvironment;
class SiCompiledScript;

enum ModelType {
	MODEL_NOTSET 					= 0,
	MODEL_FIRST_INST				= 1,
	MODEL_END_FIRST_INST			= 2,
	MODEL_END_FIRST_INST_BOOT		= 3,
	MODEL_END_INST_BOOT				= 4,
	MODEL_END_INST					= 5,
	MODEL_REINSTALL					= 6,
	MODEL_WRONG_SETUP				= 7,
	MODEL_UPDATE_OLD_VERSION		= 8,
	MODEL_FIRST_INST_APPSERVER		= 9,
	MODEL_USERONLY_APPSERVER		= 10,
	MODEL_REINST_APPSERVER			= 11,
 	MODEL_CRCCHECK					= 12,
	MODEL_USERDATAONLY				= 13,
	MODEL_OFFICEREPAIR				= 14,
	MODEL_SCRIPT_NOT_FOUND			= 15,
	MODEL_RESPONSE_WIZARD			= 16,
	MODEL_PATCH						= 17
};

class SetupAgentDialog : public SvAgentDlg
{
	BOOL 				bAskOnExit;
	BOOL				bModalFlag;
	BOOL				bModalSucc;
	ULONG 				nSuccEventID;
	ULONG 				nFailEventID;

	ModelType 			eModelType;

	USHORT 				nLanguage;
	SiEnvironment* 		pEnv;
	SiCompiledScript*	pCScript;
	SiCompiledScript*	pOldCScript;

	ByteString			aTempReadmePath;

	DECL_LINK(InitPage,SvAgentPage*);
public:
                        SetupAgentDialog( Window* pParent, ResMgr* pMgr,
                                          SetupApp* pSetup, BOOL bWizard = FALSE);
                       ~SetupAgentDialog();

	virtual BOOL		Close();
	virtual void		AddAllPages();

	void 				SetAskOnExit( BOOL bNew ) { bAskOnExit = bNew; }
	BOOL 				AskExit();

	BOOL				EndAgentDlg(BOOL bSucc);
	BOOL				DoModal();

	void 				SetModelType( ModelType eNew )	{ eModelType = eNew; }
	ModelType 			GetModelType() const 			{ return eModelType; }

	void				SuccEvent(ULONG nNew) { nSuccEventID = nNew; }
	void				FailEvent(ULONG nNew) { nFailEventID = nNew; }

	void				SetLanguage(USHORT nNew ) { nLanguage = nNew; }
	USHORT		 		GetLanguage() const { return nLanguage; }
	void				SetEnv(SiEnvironment* pNew ) { pEnv = pNew; }
	SiEnvironment* 		GetEnv() const { return pEnv; }
	void				SetCScript(SiCompiledScript* pNew ) { pCScript = pNew; }
	SiCompiledScript*	GetCScript() const { return pCScript; }
	void				SetOldCScript( SiCompiledScript* pNew ) { pOldCScript = pNew; }
	SiCompiledScript*	GetOldCScript() const { return pOldCScript; }

	void				CreateModel_FirstInstallation();
	void				CreateModel_EndFirstInstallation(BOOL bReboot = FALSE);
	void				CreateModel_EndInstallation(BOOL bReboot = FALSE);
	void 				CreateModel_ReInstallation();
	void				CreateModel_WrongSetup();
	void 				CreateModel_ScriptNotFound();
	void				CreateModel_UpdateOldVersion();
	void				CreateModel_PatchSetup();

	void				CreateModel_ResponseWizard();

	void				CreateModel_AppServerInstallation();
	void 				CreateModel_AppServerReInstallation();

	void				CreateModel_CRCCheck();

	void				CreateModel_UserDataOnly();
	void				CreateModel_OfficeRepair();
};

#define GETDLG() ((SetupAgentDialog*)GetAgentDlg())

#endif //_MAINDLG_HXX
