/*************************************************************************
 *
 *  $RCSfile: msdffimp.hxx,v $
 *
 *  $Revision: 1.9.206.1 $
 *
 *  last change: $Author: vg $ $Date: 2004/01/19 16:33:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _MSDFFIMP_HXX
#define _MSDFFIMP_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>		// UINTXX
#endif

#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif

#ifndef _SV_COLOR_HXX //autogen
#include <vcl/color.hxx>
#endif

#ifndef _SV_GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _TOOLS_TABLE_HXX
#include <tools/table.hxx>
#endif
#ifndef _MSDFFDEF_HXX
#include <svx/msdffdef.hxx>
#endif
#ifndef _MS_FILTERTRACER_HXX
#include <svx/msfiltertracer.hxx>
#endif
#ifndef _SV_GRAPH_HXX
#include <vcl/graph.hxx>
#endif
#include <string.h>

#ifndef SVX_LIGHT
#ifndef _IPOBJ_HXX //autogen
#include <so3/ipobj.hxx>
#endif
#endif

#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

class Graphic;
class SvStream;
class SdrObject;
class SdrOle2Obj;
class SvStorageRef;
class Polygon;
class PolyPolygon;
class XPolygon;
class XPolyPolygon;

class FmFormModel;
class SdrModel;
class DffRecordHeader;

class SwFlyFrmFmt;

struct SvxMSDffBLIPInfo;
struct SvxMSDffShapeInfo;
struct SvxMSDffShapeOrder;

#define COL_DEFAULT RGB_COLORDATA( 0xFA, 0xFB, 0xFC )

typedef SvxMSDffBLIPInfo*  SvxMSDffBLIPInfo_Ptr;

typedef SvxMSDffShapeInfo* SvxMSDffShapeInfo_Ptr;

typedef SvxMSDffShapeOrder* SvxMSDffShapeOrder_Ptr;

// nach der Reihenfolge des Auftretens sortiert werden:
//
SV_DECL_PTRARR_DEL(SvxMSDffBLIPInfos,	SvxMSDffBLIPInfo_Ptr,	16,16);

SV_DECL_PTRARR_DEL(SvxMSDffShapeOrders,	SvxMSDffShapeOrder_Ptr,	16,16);

// explizit sortiert werden:
//
SV_DECL_PTRARR_SORT_DEL(SvxMSDffShapeInfos,	SvxMSDffShapeInfo_Ptr,	16,16);

SV_DECL_PTRARR_SORT(SvxMSDffShapeTxBxSort,	SvxMSDffShapeOrder_Ptr,	16,16);

#define SVXMSDFF_SETTINGS_CROP_BITMAPS		1
#define SVXMSDFF_SETTINGS_IMPORT_PPT		2
#define SVXMSDFF_SETTINGS_IMPORT_EXCEL		4

//---------------------------------------------------------------------------
//  Dreh- und Angelpunkt: der Shape-Typ
//---------------------------------------------------------------------------
typedef enum
   {
   mso_sptMin = 0,
   mso_sptNotPrimitive = mso_sptMin,
   mso_sptRectangle = 1,
   mso_sptRoundRectangle = 2,
   mso_sptEllipse = 3,
   mso_sptDiamond = 4,
   mso_sptIsocelesTriangle = 5,
   mso_sptRightTriangle = 6,
   mso_sptParallelogram = 7,
   mso_sptTrapezoid = 8,
   mso_sptHexagon = 9,
   mso_sptOctagon = 10,
   mso_sptPlus = 11,
   mso_sptStar = 12,
   mso_sptArrow = 13,
   mso_sptThickArrow = 14,
   mso_sptHomePlate = 15,
   mso_sptCube = 16,
   mso_sptBalloon = 17,
   mso_sptSeal = 18,
   mso_sptArc = 19,
   mso_sptLine = 20,
   mso_sptPlaque = 21,
   mso_sptCan = 22,
   mso_sptDonut = 23,
   mso_sptTextSimple = 24,
   mso_sptTextOctagon = 25,
   mso_sptTextHexagon = 26,
   mso_sptTextCurve = 27,
   mso_sptTextWave = 28,
   mso_sptTextRing = 29,
   mso_sptTextOnCurve = 30,
   mso_sptTextOnRing = 31,
   mso_sptStraightConnector1 = 32,
   mso_sptBentConnector2 = 33,
   mso_sptBentConnector3 = 34,
   mso_sptBentConnector4 = 35,
   mso_sptBentConnector5 = 36,
   mso_sptCurvedConnector2 = 37,
   mso_sptCurvedConnector3 = 38,
   mso_sptCurvedConnector4 = 39,
   mso_sptCurvedConnector5 = 40,
   mso_sptCallout1 = 41,
   mso_sptCallout2 = 42,
   mso_sptCallout3 = 43,
   mso_sptAccentCallout1 = 44,
   mso_sptAccentCallout2 = 45,
   mso_sptAccentCallout3 = 46,
   mso_sptBorderCallout1 = 47,
   mso_sptBorderCallout2 = 48,
   mso_sptBorderCallout3 = 49,
   mso_sptAccentBorderCallout1 = 50,
   mso_sptAccentBorderCallout2 = 51,
   mso_sptAccentBorderCallout3 = 52,
   mso_sptRibbon = 53,
   mso_sptRibbon2 = 54,
   mso_sptChevron = 55,
   mso_sptPentagon = 56,
   mso_sptNoSmoking = 57,
   mso_sptSeal8 = 58,
   mso_sptSeal16 = 59,
   mso_sptSeal32 = 60,
   mso_sptWedgeRectCallout = 61,
   mso_sptWedgeRRectCallout = 62,
   mso_sptWedgeEllipseCallout = 63,
   mso_sptWave = 64,
   mso_sptFoldedCorner = 65,
   mso_sptLeftArrow = 66,
   mso_sptDownArrow = 67,
   mso_sptUpArrow = 68,
   mso_sptLeftRightArrow = 69,
   mso_sptUpDownArrow = 70,
   mso_sptIrregularSeal1 = 71,
   mso_sptIrregularSeal2 = 72,
   mso_sptLightningBolt = 73,
   mso_sptHeart = 74,
   mso_sptPictureFrame = 75,
   mso_sptQuadArrow = 76,
   mso_sptLeftArrowCallout = 77,
   mso_sptRightArrowCallout = 78,
   mso_sptUpArrowCallout = 79,
   mso_sptDownArrowCallout = 80,
   mso_sptLeftRightArrowCallout = 81,
   mso_sptUpDownArrowCallout = 82,
   mso_sptQuadArrowCallout = 83,
   mso_sptBevel = 84,
   mso_sptLeftBracket = 85,
   mso_sptRightBracket = 86,
   mso_sptLeftBrace = 87,
   mso_sptRightBrace = 88,
   mso_sptLeftUpArrow = 89,
   mso_sptBentUpArrow = 90,
   mso_sptBentArrow = 91,
   mso_sptSeal24 = 92,
   mso_sptStripedRightArrow = 93,
   mso_sptNotchedRightArrow = 94,
   mso_sptBlockArc = 95,
   mso_sptSmileyFace = 96,
   mso_sptVerticalScroll = 97,
   mso_sptHorizontalScroll = 98,
   mso_sptCircularArrow = 99,
   mso_sptNotchedCircularArrow = 100,
   mso_sptUturnArrow = 101,
   mso_sptCurvedRightArrow = 102,
   mso_sptCurvedLeftArrow = 103,
   mso_sptCurvedUpArrow = 104,
   mso_sptCurvedDownArrow = 105,
   mso_sptCloudCallout = 106,
   mso_sptEllipseRibbon = 107,
   mso_sptEllipseRibbon2 = 108,
   mso_sptFlowChartProcess = 109,
   mso_sptFlowChartDecision = 110,
   mso_sptFlowChartInputOutput = 111,
   mso_sptFlowChartPredefinedProcess = 112,
   mso_sptFlowChartInternalStorage = 113,
   mso_sptFlowChartDocument = 114,
   mso_sptFlowChartMultidocument = 115,
   mso_sptFlowChartTerminator = 116,
   mso_sptFlowChartPreparation = 117,
   mso_sptFlowChartManualInput = 118,
   mso_sptFlowChartManualOperation = 119,
   mso_sptFlowChartConnector = 120,
   mso_sptFlowChartPunchedCard = 121,
   mso_sptFlowChartPunchedTape = 122,
   mso_sptFlowChartSummingJunction = 123,
   mso_sptFlowChartOr = 124,
   mso_sptFlowChartCollate = 125,
   mso_sptFlowChartSort = 126,
   mso_sptFlowChartExtract = 127,
   mso_sptFlowChartMerge = 128,
   mso_sptFlowChartOfflineStorage = 129,
   mso_sptFlowChartOnlineStorage = 130,
   mso_sptFlowChartMagneticTape = 131,
   mso_sptFlowChartMagneticDisk = 132,
   mso_sptFlowChartMagneticDrum = 133,
   mso_sptFlowChartDisplay = 134,
   mso_sptFlowChartDelay = 135,
   mso_sptTextPlainText = 136,
   mso_sptTextStop = 137,
   mso_sptTextTriangle = 138,
   mso_sptTextTriangleInverted = 139,
   mso_sptTextChevron = 140,
   mso_sptTextChevronInverted = 141,
   mso_sptTextRingInside = 142,
   mso_sptTextRingOutside = 143,
   mso_sptTextArchUpCurve = 144,
   mso_sptTextArchDownCurve = 145,
   mso_sptTextCircleCurve = 146,
   mso_sptTextButtonCurve = 147,
   mso_sptTextArchUpPour = 148,
   mso_sptTextArchDownPour = 149,
   mso_sptTextCirclePour = 150,
   mso_sptTextButtonPour = 151,
   mso_sptTextCurveUp = 152,
   mso_sptTextCurveDown = 153,
   mso_sptTextCascadeUp = 154,
   mso_sptTextCascadeDown = 155,
   mso_sptTextWave1 = 156,
   mso_sptTextWave2 = 157,
   mso_sptTextWave3 = 158,
   mso_sptTextWave4 = 159,
   mso_sptTextInflate = 160,
   mso_sptTextDeflate = 161,
   mso_sptTextInflateBottom = 162,
   mso_sptTextDeflateBottom = 163,
   mso_sptTextInflateTop = 164,
   mso_sptTextDeflateTop = 165,
   mso_sptTextDeflateInflate = 166,
   mso_sptTextDeflateInflateDeflate = 167,
   mso_sptTextFadeRight = 168,
   mso_sptTextFadeLeft = 169,
   mso_sptTextFadeUp = 170,
   mso_sptTextFadeDown = 171,
   mso_sptTextSlantUp = 172,
   mso_sptTextSlantDown = 173,
   mso_sptTextCanUp = 174,
   mso_sptTextCanDown = 175,
   mso_sptFlowChartAlternateProcess = 176,
   mso_sptFlowChartOffpageConnector = 177,
   mso_sptCallout90 = 178,
   mso_sptAccentCallout90 = 179,
   mso_sptBorderCallout90 = 180,
   mso_sptAccentBorderCallout90 = 181,
   mso_sptLeftRightUpArrow = 182,
   mso_sptSun = 183,
   mso_sptMoon = 184,
   mso_sptBracketPair = 185,
   mso_sptBracePair = 186,
   mso_sptSeal4 = 187,
   mso_sptDoubleWave = 188,
   mso_sptActionButtonBlank = 189,
   mso_sptActionButtonHome = 190,
   mso_sptActionButtonHelp = 191,
   mso_sptActionButtonInformation = 192,
   mso_sptActionButtonForwardNext = 193,
   mso_sptActionButtonBackPrevious = 194,
   mso_sptActionButtonEnd = 195,
   mso_sptActionButtonBeginning = 196,
   mso_sptActionButtonReturn = 197,
   mso_sptActionButtonDocument = 198,
   mso_sptActionButtonSound = 199,
   mso_sptActionButtonMovie = 200,
   mso_sptHostControl = 201,
   mso_sptTextBox = 202,
   mso_sptMax = 0x0FFF,
   mso_sptNil = mso_sptMax
 } MSO_SPT;

#define SP_FGROUP		0x001	// This shape is a group shape
#define SP_FCHILD		0x002	// Not a top-level shape
#define SP_FPATRIARCH	0x004	// This is the topmost group shape.
								// Exactly one of these per drawing.
#define SP_FDELETED		0x008	// The shape has been deleted
#define SP_FOLESHAPE	0x010	// The shape is an OLE object
#define SP_FHAVEMASTER	0x020	// Shape has a hspMaster property
#define SP_FFLIPH		0x040	// Shape is flipped horizontally
#define SP_FFLIPV		0x080	// Shape is flipped vertically
#define SP_FCONNECTOR	0x100	// Connector type of shape
#define SP_FHAVEANCHOR	0x200	// Shape has an anchor of some kind
#define SP_FBACKGROUND	0x400	// Background shape
#define SP_FHAVESPT		0x800	// Shape has a shape type property

// for the CreateSdrOLEFromStorage we need the information, how we handle
// convert able OLE-Objects - this ist stored in
#define OLE_MATHTYPE_2_STARMATH				0x0001
#define OLE_WINWORD_2_STARWRITER			0x0002
#define OLE_EXCEL_2_STARCALC				0x0004
#define OLE_POWERPOINT_2_STARIMPRESS		0x0008

struct SvxMSDffConnectorRule
{
	sal_uInt32	nRuleId;
	sal_uInt32  nShapeA;		// SPID of shape A

	sal_uInt32  nShapeB;		// SPID of shape B
	sal_uInt32  nShapeC;		// SPID of connector shape
	sal_uInt32  ncptiA;			// Connection site Index of shape A
	sal_uInt32  ncptiB;			// Connection site Index of shape B
    sal_uInt32  nSpFlagsA;      // SpFlags of shape A ( the original mirror flags must be known when solving the Solver Container )
    sal_uInt32  nSpFlagsB;      // SpFlags of shape A 

	SdrObject* pAObj;		// pPtr of object ( corresponding to shape A ) 
	SdrObject* pBObj;		//	 "
	SdrObject* pCObj;		//	 "  of connector object    

			SvxMSDffConnectorRule() : pAObj( NULL ), pBObj( NULL ), pCObj( NULL ), nSpFlagsA( 0 ), nSpFlagsB( 0 ){};

    friend SvStream& operator>>( SvStream& rIn, SvxMSDffConnectorRule& rAtom );
};
struct SvxMSDffSolverContainer
{
	List	aCList;

			SvxMSDffSolverContainer();
			~SvxMSDffSolverContainer();

	friend SvStream& operator>>( SvStream& rIn, SvxMSDffSolverContainer& rAtom );
};

struct FIDCL
{
	UINT32	dgid;		// DG owning the SPIDs in this cluster
	UINT32	cspidCur;	// number of SPIDs used so far
};

//---------------------------------------------------------------------------
//  von SvxMSDffManager fuer jedes in der Gruppe enthaltene Shape geliefert
//---------------------------------------------------------------------------
struct MSDffTxId
{
	USHORT nTxBxS;
	USHORT nSequence;
	MSDffTxId(USHORT nTxBxS_, USHORT nSequence_ )
			: nTxBxS(			  nTxBxS_		),
			  nSequence(		  nSequence_	){}
	MSDffTxId(const MSDffTxId& rCopy)
			: nTxBxS(			  rCopy.nTxBxS    ),
			  nSequence(		  rCopy.nSequence ){}
};

struct SvxMSDffImportRec
{
	SdrObject*	pObj;
	char*		pClientAnchorBuffer;
	UINT32		nClientAnchorLen;
	char*		pClientDataBuffer;
	UINT32		nClientDataLen;
	UINT32		nXAlign;
	UINT32		nXRelTo;
	UINT32		nYAlign;
	UINT32		nYRelTo;
	long		nTextRotationAngle;
	long		nDxTextLeft;	// Abstand der Textbox vom umgebenden Shape
	long		nDyTextTop;
	long		nDxTextRight;
	long		nDyTextBottom;
	long		nDxWrapDistLeft;
	long		nDyWrapDistTop;
	long		nDxWrapDistRight;
	long		nDyWrapDistBottom;
	long		nCropFromTop;
	long		nCropFromBottom;
	long		nCropFromLeft;
	long		nCropFromRight;
	MSDffTxId	aTextId;		// Kennungen fuer Textboxen
	ULONG		nNextShapeId;	// fuer verlinkte Textboxen
	ULONG		nShapeId;
	MSO_SPT		eShapeType;
	MSO_LineStyle eLineStyle;	// Umrandungs-Arten
	BOOL		bDrawHell		:1;
//	BOOL		bInGroup		:1;
	BOOL		bReplaceByFly	:1;
	BOOL		bLastBoxInChain	:1;
	BOOL		bHasUDefProp	:1;

	SvxMSDffImportRec()
		 :pObj( 0 ),
		  pClientAnchorBuffer( 0 ),
		  nClientAnchorLen(  0 ),
		  pClientDataBuffer( 0 ),
		  nClientDataLen(    0 ),
		  nXAlign( 0 ),	// position n cm from left
		  nXRelTo( 2 ), //   relative to column
		  nYAlign( 0 ), // position n cm below
		  nYRelTo( 2 ), //   relative to paragraph
		  nTextRotationAngle( 0 ),
		  nDxTextLeft( 144 ),
		  nDyTextTop( 72 ),
		  nDxTextRight(	144 ),
		  nDyTextBottom( 72 ),
		  nDxWrapDistLeft( 0 ),
		  nDyWrapDistTop( 0 ),
		  nDxWrapDistRight( 0 ),
		  nDyWrapDistBottom(0 ),
		  nCropFromTop( 0 ),
		  nCropFromBottom( 0 ),
		  nCropFromLeft( 0 ),
		  nCropFromRight( 0 ),
		  aTextId( 0, 0 ),
		  nNextShapeId(	0 ),
		  nShapeId( 0 ),
		  eShapeType( mso_sptNil )
	{
		  eLineStyle      = mso_lineSimple; // GPF-Bug #66227#
		  bDrawHell       = FALSE;
//		  bInGroup		  = FALSE;
		  bReplaceByFly   = FALSE;
		  bLastBoxInChain = TRUE;
		  bHasUDefProp    = FALSE; // was the DFF_msofbtUDefProp record set?
	}

	SvxMSDffImportRec(const SvxMSDffImportRec& rCopy)
		 :pObj(	rCopy.pObj ),
		  nXAlign( rCopy.nXAlign ),
		  nXRelTo( rCopy.nXRelTo ),
		  nYAlign( rCopy.nYAlign ),
		  nYRelTo( rCopy.nYRelTo ),
		  nTextRotationAngle( rCopy.nTextRotationAngle ),
		  nDxTextLeft( rCopy.nDxTextLeft	),
		  nDyTextTop( rCopy.nDyTextTop ),
		  nDxTextRight( rCopy.nDxTextRight ),
		  nDyTextBottom( rCopy.nDyTextBottom ),
		  nDxWrapDistLeft( rCopy.nDxWrapDistLeft ),
		  nDyWrapDistTop( rCopy.nDyWrapDistTop ),
		  nDxWrapDistRight( rCopy.nDxWrapDistRight ),
		  nDyWrapDistBottom(rCopy.nDyWrapDistBottom ),
		  nCropFromTop( rCopy.nCropFromTop ),
		  nCropFromBottom( rCopy.nCropFromBottom ),
		  nCropFromLeft( rCopy.nCropFromLeft ),
		  nCropFromRight( rCopy.nCropFromRight ),
		  aTextId( rCopy.aTextId ),
		  nNextShapeId( rCopy.nNextShapeId ),
		  nShapeId( rCopy.nShapeId ),
          eShapeType( rCopy.eShapeType )
		{
			eLineStyle       = rCopy.eLineStyle; // GPF-Bug #66227#
			bDrawHell        = rCopy.bDrawHell;
//			bInGroup		 = rCopy.bInGroup;
			bReplaceByFly    = rCopy.bReplaceByFly;
			bLastBoxInChain  = rCopy.bLastBoxInChain;
			bHasUDefProp     = rCopy.bHasUDefProp;
			nClientAnchorLen = rCopy.nClientAnchorLen;
			if( rCopy.nClientAnchorLen )
			{
				pClientAnchorBuffer = new char[ nClientAnchorLen ];
				memcpy( pClientAnchorBuffer,
						rCopy.pClientAnchorBuffer,
						nClientAnchorLen );
			}
			else
				pClientAnchorBuffer = 0;

			nClientDataLen = rCopy.nClientDataLen;
			if( rCopy.nClientDataLen )
			{
				pClientDataBuffer = new char[ nClientDataLen ];
				memcpy( pClientDataBuffer,
						rCopy.pClientDataBuffer,
						nClientDataLen );
			}
			else
				pClientDataBuffer = 0;
		}
	~SvxMSDffImportRec()
	{
		if( pClientAnchorBuffer )
			delete[] pClientAnchorBuffer;
		if( pClientDataBuffer )
			delete[] pClientDataBuffer;
	}
	BOOL operator==( const SvxMSDffImportRec& rEntry ) const
	{   return nShapeId == rEntry.nShapeId; }
	BOOL operator<( const SvxMSDffImportRec& rEntry ) const
	{   return nShapeId < rEntry.nShapeId;  }
};
typedef SvxMSDffImportRec* MSDffImportRec_Ptr;

// Liste aller SvxMSDffImportRec fuer eine Gruppe
SV_DECL_PTRARR_SORT_DEL(MSDffImportRecords, MSDffImportRec_Ptr, 16,16);

//---------------------------------------------------------------------------
//   Import-/Export-Parameterblock fuer 1 x ImportObjAtCurrentStreamPos()
//---------------------------------------------------------------------------
struct SvxMSDffImportData
{
	MSDffImportRecords	aRecords;	// Shape-Pointer, -Ids und private Daten
	Rectangle			aParentRect;// Rectangle der umgebenden Gruppe
									// bzw. von aussen reingegebenes Rect
	Rectangle 			aNewRect;	// mit diesem Shape definiertes Rectangle

	SvxMSDffImportData()
		{}
	SvxMSDffImportData(const Rectangle& rParentRect)
		:aParentRect( rParentRect )
		{}
	void SetNewRect(INT32 l, INT32 o,
					INT32 r, INT32 u ){	aNewRect = Rectangle(l,o, r,u); }
	BOOL HasParRect() const { return aParentRect.IsEmpty(); }
	BOOL HasNewRect() const { return aNewRect.IsEmpty()   ; }
	BOOL HasRecords() const { return 0 != aRecords.Count(); }
	USHORT				GetRecCount() const { return aRecords.Count();	}
	SvxMSDffImportRec*	GetRecord(USHORT iRecord) const
							{  return aRecords.GetObject( iRecord ); }
};

struct DffObjData
{
	Rectangle	aChildAnchor;

	DffRecordHeader&	rSpHd;
	Rectangle&			rBoundRect;

	UINT32		nShapeId;
	UINT32		nSpFlags;
	UINT32		nOldFilePos;
	MSO_SPT		eShapeType;

	BOOL bShapeType		: 1;
	BOOL bClientAnchor	: 1;
	BOOL bClientData	: 1;
	BOOL bChildAnchor	: 1;
	BOOL bOpt			: 1;
	BOOL bIsAutoText	: 1;

	/*
	BOOL bCalledByGroup : 1;
	*/
	int nCalledByGroup;

	DffObjData( DffRecordHeader& rObjHd,
				Rectangle&		rBdRect,
				/*
				BOOL			bClByGroup,
				*/
				int 			nClByGroup,
				UINT32			nOldFP ) :
		rSpHd( rObjHd ),
		rBoundRect(	rBdRect ),
		nOldFilePos( nOldFP ),
		bIsAutoText( FALSE ),
		nCalledByGroup(	nClByGroup ){}
};

#define DFF_RECORD_MANAGER_BUF_SIZE			64

struct DffRecordList
{
		UINT32				nCount;
		UINT32				nCurrent;
		DffRecordList*		pPrev;
		DffRecordList*		pNext;

		DffRecordHeader		mHd[ DFF_RECORD_MANAGER_BUF_SIZE ];

							DffRecordList( DffRecordList* pList );
							~DffRecordList();
};

enum DffSeekToContentMode
{
	SEEK_FROM_BEGINNING,
	SEEK_FROM_CURRENT,
	SEEK_FROM_CURRENT_AND_RESTART
};

class DffRecordManager : public DffRecordList
{
	public :

		DffRecordList*		pCList;

		void				Clear();
		void				Consume( SvStream& rIn, BOOL bAppend = FALSE, UINT32 nStOfs = 0 );

		BOOL				SeekToContent( SvStream& rIn, UINT16 nRecType, DffSeekToContentMode eMode = SEEK_FROM_BEGINNING );
		DffRecordHeader*	GetRecordHeader( UINT16 nRecType,  DffSeekToContentMode eMode = SEEK_FROM_BEGINNING );

							DffRecordManager();
							DffRecordManager( SvStream& rIn );
							~DffRecordManager();

		DffRecordHeader*	Current();
		DffRecordHeader*	First();
		DffRecordHeader*	Next();
		DffRecordHeader*	Prev();
		DffRecordHeader*	Last();
};

/*
	SvxMSDffManager - abstrakte Basis-Klasse fuer Escher-Import
	===============
	Zweck:	Zugriff auf Objekte im Drawing File Format
	Stand:	Zugriff nur auf BLIPs (wird spaeter erweitert)

	Beachte: in der zwecks PowerPoint-, ODER Word- ODER Excel-Import
	======== abgeleiteten Klasse
			 MUSS jeweils die Methode ProcessUserDefinedRecord()
			 implementiert werden!
*/
class SvxMSDffManager : public DffPropertyReader
{
	FmFormModel*			pFormModel;
	SvxMSDffBLIPInfos*		pBLIPInfos;
	SvxMSDffShapeInfos*		pShapeInfos;
	SvxMSDffShapeOrders*	pShapeOrders;
	ULONG					nDefaultFontHeight;
	long					nOffsDgg;
	USHORT					nBLIPCount;
	USHORT					nShapeCount;
	sal_uInt32				nGroupShapeFlags;

	void CheckTxBxStoryChain();
	void GetFidclData( long nOffsDgg );

protected :

	UINT32					mnCurMaxShapeId;	// we need this information to
	UINT32					mnDrawingsSaved;	// access the right drawing
	UINT32					mnIdClusters;		// while only knowing the shapeid
	FIDCL*					mpFidcls;
	Table					maDgOffsetTable;	// array of fileoffsets

	friend class DffPropertyReader;

	SvStream&		rStCtrl;
	SvStream*		pStData;
	SvStream*		pStData2;
	SdrModel*		pSdrModel;

	long			nMapMul;
	long			nMapDiv;
	long			nMapXOfs;
	long			nMapYOfs;
	long			nEmuMul;
	long			nEmuDiv;
	long			nPntMul;
	long			nPntDiv;
	FASTBOOL		bNeedMap;
	UINT32			nSvxMSDffSettings;
	UINT32			nSvxMSDffOLEConvFlags;

	void GetCtrlData( long nOffsDgg );
	void GetDrawingGroupContainerData(	SvStream& rSt, ULONG nLenDgg            );
	void GetDrawingContainerData(		SvStream& rSt, ULONG nLenDg             );
	BOOL GetShapeGroupContainerData(	SvStream& rSt, ULONG nLenShapeGroupCont,
										BOOL bPatriarch );
	BOOL GetShapeContainerData(			SvStream& rSt, ULONG nLenShapeCont,
										ULONG nPosGroup = ULONG_MAX);

	FASTBOOL ReadGraphic( SvStream& rSt, ULONG nIndex, Graphic& rGraphic ) const;
	SdrObject* ImportWordArt( SvStream&, SfxItemSet&, Rectangle& rBoundRect ) const;
	SdrObject* ImportGraphic( SvStream&, SfxItemSet&, Rectangle& rBoundRect, const DffObjData& ) const;
//	SdrObject* ImportVertices( SvStream&, Rectangle& rBoundRect, DffObjData& rObjData, Rectangle* pTextRect = NULL ) const;
	virtual SdrObject* ImportOLE( long nOLEId, const Graphic& rGraf, const Rectangle& rBoundRect ) const;
	SdrObject* GetAutoForm( MSO_SPT eTyp ) const;
	void MSDFFReadZString( SvStream& rIn, String& rStr, ULONG nMaxLen, FASTBOOL bUniCode = FALSE ) const;
	static const GDIMetaFile* lcl_GetMetaFileFromGrf_Impl( const Graphic& rGrf, GDIMetaFile& rMtf );
#ifndef SVX_LIGHT
	static const SvInPlaceObjectRef CheckForConvertToSOObj( UINT32 nConvertFlags, SvStorage& rSrcStg, SvStorage& rDestStorage, const Graphic& rGrf );
#endif

/*
		folgende Methoden sind zum Excel-Import zu ueberschreiben:
*/
	virtual BOOL ProcessClientAnchor(SvStream& rStData, ULONG nDatLen, char*& rpBuff, UINT32& rBuffLen ) const;
	virtual void ProcessClientAnchor2( SvStream& rStData, DffRecordHeader& rHd, void* pData, DffObjData& );
	virtual BOOL ProcessClientData(  SvStream& rStData, ULONG nDatLen, char*& rpBuff, UINT32& rBuffLen ) const;
	virtual SdrObject* ProcessObj( SvStream& rSt, DffObjData& rData, void* pData, Rectangle& rTextRect, SdrObject* pObj = NULL);
	virtual ULONG Calc_nBLIPPos( ULONG nOrgVal, ULONG nStreamPos ) const;
	virtual FASTBOOL GetColorFromPalette(USHORT nNum, Color& rColor) const;

	// -----------------------------------------------------------------------

	/*
		folgende Methoden sind zum PowerPoint-Import zu ueberschreiben:
	*/
	FASTBOOL ReadDffString(SvStream& rSt, String& rTxt) const;
	FASTBOOL ReadObjText(SvStream& rSt, SdrObject* pObj) const;
	// -----------------------------------------------------------------------

	/*
		folgende Methode ist von allen zu ueberschreiben, die OLE-Objecte
		importieren moechten:
	*/
	virtual BOOL GetOLEStorageName( long nOLEId, String& rStorageName,
									SvStorageRef& rSrcStorage,
									SvStorageRef& rDestStorage ) const;

	/*
		folgende Methode ist von allen zu ueberschreiben, die verhindern
		moechten, dass (abgerundete) Rechtecke mit umgebrochenem Text
		immer in SdrRectObj( OBJ_TEXT ) umgewandelt werden:
		TRUE bedeutet umwandeln.
	*/
	virtual BOOL ShapeHasText(ULONG nShapeId, ULONG nFilePos) const;

public:

	void*				pSvxMSDffDummy1;
	void*				pSvxMSDffDummy2;
	void*				pSvxMSDffDummy3;
	List*				pEscherBlipCache;

	DffRecordManager	maShapeRecords;
	ColorData			mnDefaultColor;

	MSFilterTracer*		mpTracer;
	sal_Bool			mbTracing;

	Color				MSO_CLR_ToColor( sal_uInt32 nColorCode,
											sal_uInt16 nContextProperty = DFF_Prop_lineColor ) const;

	virtual BOOL SeekToShape( SvStream& rSt, void* pClientData, UINT32 nId ) const;
	FASTBOOL SeekToRec( SvStream& rSt, USHORT nRecId, ULONG nMaxFilePos, DffRecordHeader* pRecHd = NULL, ULONG nSkipCount = 0 ) const;
	FASTBOOL SeekToRec2( USHORT nRecId1, USHORT nRecId2, ULONG nMaxFilePos, DffRecordHeader* pRecHd = NULL, ULONG nSkipCount = 0 ) const;

	// -----------------------------------------------------------------------

	static BOOL ReadCommonRecordHeader( DffRecordHeader& rRec, SvStream& rIn );
	static BOOL ReadCommonRecordHeader( SvStream& rSt,
										BYTE&     rVer,
										USHORT&   rInst,
										USHORT&   rFbt,
										ULONG&    rLength );
/*
	Konstruktor
	===========
	Input:	rStCtrl	  - Verwaltungsstream mit Containern,
						FBSE Objekten und Shapes
						( muss immer uebergeben werden;
						  Stream muss bereits offen sein )

			nOffsDgg  -	Offset im rStCtrl: Beginn des Drawing Group Containers

			pStData	  - Datenstream, in dem die BLIPs gespeichert sind
						( falls Null, wird angenommen, dass die
						  BLIPs ebenfalls im rStCtrl gespeichert sind;
						  dieser Stream muss ebenfalls bereits offen sein )
			pSdrModel_  kann beim Ctor-Aufruf leer bleiben, muss dann aber
						spaeter ueber SetModel() gesetzt werden!

	setzt nBLIPCount
*/
	SvxMSDffManager( SvStream& rStCtrl,
					 long      nOffsDgg,
					 SvStream* pStData,
					 SdrModel* pSdrModel_			=  0,
					 long      nApplicationScale	=  0,
					 ColorData mnDefaultColor_		=  COL_DEFAULT,
					 ULONG     nDefaultFontHeight_	= 24,
					 SvStream* pStData2_			=  0,
					 MSFilterTracer* pTracer		= NULL );

	// in PPT werden die Parameter DGGContainerOffset und PicStream
	// mit Hilfe einer Init Routine Uebergeben.
	SvxMSDffManager( SvStream& rStCtrl, MSFilterTracer* pTracer );
	void InitSvxMSDffManager( long nOffsDgg_, SvStream* pStData_, sal_uInt32 nSvxMSDffOLEConvFlags );
	void SetDgContainer( SvStream& rSt );

	virtual ~SvxMSDffManager();

	UINT32	GetSvxMSDffSettings() const { return nSvxMSDffSettings; };
	void	SetSvxMSDffSettings( UINT32 nSettings ) { nSvxMSDffSettings = nSettings; };

	void SetModel(SdrModel* pModel, long nApplicationScale);
	SdrModel*  GetModel() const { return pSdrModel; }
	void Scale(long& rVal) const;
	void Scale(Point& rPos) const;
	void Scale(Size& rSiz) const;
	void Scale(Rectangle& rRect) const;
	void Scale(Polygon& rPoly) const;
	void Scale(PolyPolygon& rPoly) const;
	void Scale(XPolygon& rPoly) const;
	void Scale(XPolyPolygon& rPoly) const;
	void ScaleEmu(long& rVal) const;
	UINT32 ScalePt( UINT32 nPt ) const;
	INT32 ScalePoint( INT32 nVal ) const;

/*
	GetBLIP()			- Anforderung eines bestimmten BLIP
	=========
	Input:	nIdx		- Nummer des angeforderten BLIP
						  ( muss immer uebergeben werden )

	Output:	rData		- bereits fertig konvertierte Daten
						  ( direkt als Grafik in unsere Dokumente einzusetzen )

	Rueckgabewert: TRUE, im Erfolgsfalls, FALSE bei Fehler
*/
	BOOL GetBLIP(ULONG nIdx, Graphic& rData) const;

/*
	GetBLIPDirect()		-Einlesen eines BLIP aus schon positioniertem Stream
	===============
	Input:	rBLIPStream	-bereits korrekt positionierter Stream
						  ( muss immer uebergeben werden )

	Output:	rData		-bereits fertig konvertierte Daten
						  ( direkt als Grafik in unsere Dokumente einzusetzen )

	Rueckgabewert: TRUE, im Erfolgsfalls, FALSE bei Fehler
*/
	BOOL GetBLIPDirect(SvStream& rBLIPStream, Graphic& rData) const;

	BOOL GetShape(ULONG nId,
				  SdrObject*& rpData, SvxMSDffImportData& rData);

/*
	GetBLIPCount()	- Abfrage der verwalteten BLIP Anzahl
	==============
	Input:	./.
	Output:	./.
	Rueckgabewert: nBLIPCount	- Anzahl der im pStData (bzw. rStCtrl) enthaltenen BLIPs
								  ( sprich: Anzahl der FBSEs im Drawing Group Container )

						Werte:	0	- Struktur Ok, jedoch keine BLIPs vorhanden
								1..	- Anzahl der BLIPs
						USHRT_MAX	- Fehler: kein korrektes Drawing File Format
*/
	USHORT GetBLIPCount() const{ return nBLIPCount; }

/*
	ZCodecDecompressed()  - Dekomprimierung eines komp. WMF oder Enhanced WMF
	====================
	Input:	rIn		-bereits korrekt positionierter Stream,
					 der das komprimierte Bild enthaelt
			rOut	-bereits korrekt positionierter Ausgabe-Stream,

		bLookForEnd -Flag, ob das komp. Bild bis zum Stream-Ende reicht.
					 Falls TRUE, wird jeweils geprueft, ob das gelesene	noch
														zum Bild gehoert.
					 Falls FALSE, wird bis zum Stream-Ende gelesen.

	Output:	rIn     -Der Stream steht hinter dem Ende des komp. Bildes.
					 (es kann aber noch eine Ende-Kennung und CRC-Sum folgen)
			rOut	-Der Stream enthaelt das dekomprimierte Bild.
					 Der Stream wird auf den Anfang des Bildes positioniert.
					 (also dorthin, wo der Stream vor der Verarbeitung stand)

	Rueckgabewert:	TRUE, im Erfolgsfall
					FALSE bei Fehler oder Null Bytes geschrieben
*/
	static BOOL ZCodecDecompressed(	SvStream& rIn,
									SvStream& rOut,
									BOOL bLookForEnd );

	SdrObject* ImportObj(SvStream& rSt, void* pData,
		const Rectangle* pBoundRect, int nCalledByGroup = 0);

	inline const SvxMSDffShapeInfos* GetShapeInfos( void ) const
		{
			return pShapeInfos;
		}

	inline const SvxMSDffShapeOrders* GetShapeOrders( void ) const
		{
			return pShapeOrders;
		}

	void StoreShapeOrder(ULONG			nId,
						 ULONG			nTxBx,
						 SdrObject*		pObject,
						 SwFlyFrmFmt*	pFly = 0,
						 short			nHdFtSection = 0) const;

	void ExchangeInShapeOrder(SdrObject* pOldObject,
							  ULONG nTxBx,
							  SwFlyFrmFmt* pFly,
							  SdrObject*   pObject) const;

	void RemoveFromShapeOrder( SdrObject* pObject ) const;

	UINT32	GetConvertFlags() const { return nSvxMSDffOLEConvFlags; }

	static SdrOle2Obj* CreateSdrOLEFromStorage( const String& rStorageName,
												SvStorageRef& rSrcStorage,
												SvStorageRef& rDestStorage,
												const Graphic& rGraf,
												const Rectangle& rBoundRect,
												SvStream* pDataStrrm,
												UINT32 nConvertFlags = 0 );

	/* the method SolveSolver will create connections between shapes, it should be called after a page is imported.
	The SvxMSDffSolverContainer is containing necessary data data that is collected during the import of each shape
	*/
    void SolveSolver( const SvxMSDffSolverContainer& rSolver );

	static sal_Bool SetPropValue(
		const ::com::sun::star::uno::Any& rAny,
			const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
				const String& rPropertyName,
					sal_Bool bTestPropertyAvailability = sal_False );

};

struct SvxMSDffBLIPInfo
{
	USHORT nBLIPType;	// Art des BLIP: z.B. 6 fuer PNG
	ULONG  nFilePos;	// Offset des BLIP im Daten-Stream
	ULONG  nBLIPSize;	// Anzahl Bytes, die der BLIP im Stream einnimmt
	SvxMSDffBLIPInfo(USHORT nBType, ULONG nFPos, ULONG nBSize):
		nBLIPType( nBType ), nFilePos( nFPos ), nBLIPSize( nBSize ){}
};

struct SvxMSDffShapeInfo
{
	ULONG nShapeId;	 // Shape Id, verwendet im PLCF SPA und im mso_fbtSp (FSP)
	ULONG nFilePos;	 // Offset des Shape im Kontroll-Stream fuer eventuelle
					 // erneute Zugriffe auf dieses Shape
	ULONG nTxBxComp;

	BOOL bReplaceByFly  :1; // Shape darf im Writer durch Rahmen ersetzt werden.
	BOOL bSortByShapeId :1;
	BOOL bLastBoxInChain:1;

	SvxMSDffShapeInfo(ULONG nFPos, ULONG nId=0, ULONG nBIdx=0,
					  USHORT nSeqId=0, USHORT nBoxId=0):
		nShapeId( nId ),
		nFilePos( nFPos ),
		nTxBxComp( (nSeqId << 16) + nBoxId )
		{
			bReplaceByFly	= FALSE;
			bSortByShapeId	= FALSE;
			bLastBoxInChain	= TRUE;
		}
	SvxMSDffShapeInfo(SvxMSDffShapeInfo& rInfo):
		nShapeId( rInfo.nShapeId ),
		nFilePos( rInfo.nFilePos ),
		nTxBxComp( rInfo.nTxBxComp )
		{
			bReplaceByFly	= rInfo.bReplaceByFly;
			bSortByShapeId	= rInfo.bSortByShapeId;
			bLastBoxInChain	= rInfo.bLastBoxInChain;
		}
	BOOL operator==( const SvxMSDffShapeInfo& rEntry ) const
	{
		return bSortByShapeId ? (nShapeId  == rEntry.nShapeId)
							  : (nTxBxComp == rEntry.nTxBxComp && this == &rEntry);
	}
	BOOL operator<( const SvxMSDffShapeInfo& rEntry ) const
	{
		return bSortByShapeId ? (nShapeId  < rEntry.nShapeId)
							  : (nTxBxComp < rEntry.nTxBxComp);
	}
};

struct SvxMSDffShapeOrder
{
	ULONG nShapeId;		// Shape Id, verwendet im PLCF SPA und im mso_fbtSp (FSP)

	ULONG nTxBxComp;	// Ketten- und Boxnummer in der Text-Box-Story (bzw. Null)

	SwFlyFrmFmt* pFly;	// Frame-Format eines statt des Sdr-Text-Objektes im
						// Writer eingefuegten Rahmens: zur Verkettung benoetigt!

	short nHdFtSection; // used by Writer to find out if linked frames are in the
						// same header or footer of the same section

	SdrObject*	pObj;	// Zeiger auf das Draw-Objekt (bzw. Null, falls nicht verwendet)

	// Vorgehensweise:  im Ctor des SvxMSDffManager werden im der Shape-Order-Array
	//					nur die Shape-Ids vermerkt,
	//					Text-Box-Nummer und der Objekt-Pointer werden nur dann
	//					gespeichert, wenn das Shape tatsaechlich importiert wird!
	SvxMSDffShapeOrder( ULONG nId ):
		nShapeId( nId ), nTxBxComp( 0 ), pFly( 0 ), nHdFtSection( 0 ), pObj( 0 ){}

	BOOL operator==( const SvxMSDffShapeOrder& rEntry ) const
	{
		return (nTxBxComp == rEntry.nTxBxComp);
	}
	BOOL operator<( const SvxMSDffShapeOrder& rEntry ) const
	{
		return (nTxBxComp < rEntry.nTxBxComp);
	}
};

#endif

