/*************************************************************************
 *
 *  $RCSfile: scripttypeitem.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 09:56:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_SCRIPTTYPEITEM_HXX
#define _SVX_SCRIPTTYPEITEM_HXX

// include ---------------------------------------------------------------

#ifndef _SFXINTITEM_HXX
#include <svtools/intitem.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif

// class SvxScriptTypeItem ----------------------------------------------

/* [Description]

		This item describe  the scriptype of the selected text and is only
	used for the user interface.
*/

USHORT GetI18NScriptTypeOfLanguage( USHORT nLang );
USHORT GetItemScriptType( short nI18NType );
short  GetI18NScriptType( USHORT nItemType );

class SvxScriptTypeItem : public SfxUInt16Item
{
public:
	TYPEINFO();

	SvxScriptTypeItem( sal_uInt16 nType = SCRIPTTYPE_LATIN );
	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;

};

class SvxScriptSetItem : public SfxSetItem
{
public:
	TYPEINFO();

	SvxScriptSetItem( USHORT nSlotId, SfxItemPool& rPool );

	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0 ) const;
	virtual SfxPoolItem* Create( SvStream &, USHORT nVersion ) const;

	static const SfxPoolItem* GetItemOfScriptSet( const SfxItemSet& rSet,
													USHORT nWhich );
	inline const SfxPoolItem* GetItemOfScriptSet( USHORT nWhich ) const
	{ return SvxScriptSetItem::GetItemOfScriptSet( GetItemSet(), nWhich ); }

	const SfxPoolItem* GetItemOfScript( USHORT nScript ) const;

	void PutItemForScriptType( USHORT nScriptType, const SfxPoolItem& rItem );

	void GetWhichIds( USHORT& rLatin, USHORT& rAsian, USHORT& rComplex) const;

	static void GetSlotIds( USHORT nSlotId, USHORT& rLatin, USHORT& rAsian,
											USHORT& rComplex );
	inline void GetSlotIds( USHORT& rLatin, USHORT& rAsian,
								USHORT& rComplex ) const
	{ GetSlotIds( Which(), rLatin, rAsian, rComplex ); }
};

#endif

