/*************************************************************************
 *
 *  $RCSfile: date.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DATE_HXX
#define _DATE_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

class ResId;

// --------------
// - Date-Types -
// --------------

enum WeekCountStart { WEEKCOUNT_FIRSTDAY,
					  WEEKCOUNT_FIRST4DAYWEEK,
					  WEEKCOUNT_FIRSTFULLWEEK };

enum DayOfWeek { MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY,
				 SATURDAY, SUNDAY };

// --------
// - Date -
// --------

class Date
{
private:
	ULONG			nDate;

public:
					Date();
					Date( const ResId & rResId );
					Date( ULONG _nDate ) { Date::nDate = _nDate; }
					Date( const Date& rDate )
						{ nDate = rDate.nDate; }
					Date( USHORT nDay, USHORT nMonth, USHORT nYear )
						{ nDate = ((ULONG)(nDay%100)) +
								  (((ULONG)(nMonth%100))*100) +
								  (((ULONG)nYear%10000)*10000); }

	void			SetDate( ULONG nNewDate ) { nDate = nNewDate; }
	ULONG			GetDate() const { return nDate; }

	void			SetDay( USHORT nNewDay );
	void			SetMonth( USHORT nNewMonth );
	void			SetYear( USHORT nNewYear );
	USHORT			GetDay() const { return (USHORT)(nDate % 100); }
	USHORT			GetMonth() const { return (USHORT)((nDate / 100) % 100); }
	USHORT			GetYear() const { return (USHORT)(nDate / 10000); }

	DayOfWeek		GetDayOfWeek() const;
	USHORT			GetDayOfYear() const;
	USHORT			GetWeekOfYear( DayOfWeek eStartDay = MONDAY,
								   WeekCountStart eWeekStart = WEEKCOUNT_FIRST4DAYWEEK ) const;

	USHORT			GetDaysInMonth() const;
	USHORT			GetDaysInYear() const { return (IsLeapYear()) ? 366 : 365; }
	BOOL			IsLeapYear() const;
	BOOL			IsValid() const;

	BOOL			IsBetween( const Date& rFrom, const Date& rTo ) const
						{ return ((nDate >= rFrom.nDate) &&
								 (nDate <= rTo.nDate)); }

	BOOL			operator ==( const Date& rDate ) const
						{ return (nDate == rDate.nDate); }
	BOOL			operator !=( const Date& rDate ) const
						{ return (nDate != rDate.nDate); }
	BOOL			operator  >( const Date& rDate ) const
						{ return (nDate > rDate.nDate); }
	BOOL			operator  <( const Date& rDate ) const
						{ return (nDate < rDate.nDate); }
	BOOL			operator >=( const Date& rDate ) const
						{ return (nDate >= rDate.nDate); }
	BOOL			operator <=( const Date& rDate ) const
						{ return (nDate <= rDate.nDate); }

	Date&			operator =( const Date& rDate )
						{ nDate = rDate.nDate; return *this; }
	Date&			operator +=( long nDays );
	Date&			operator -=( long nDays );
	Date&			operator ++();
	Date&			operator --();
#ifndef MPW33
	Date			operator ++( int );
	Date			operator --( int );
#endif

	friend Date 	operator +( const Date& rDate, long nDays );
	friend Date 	operator -( const Date& rDate, long nDays );
	friend long 	operator -( const Date& rDate1, const Date& rDate2 );

#ifdef SMART_UNO_GENERATION
	UINT16			getDay() const { return GetDay(); }
	UINT16			getMonth() const { return GetMonth(); }
	UINT16			getYear() const { return GetYear(); }

	void			setDay( UINT16 nDay ) { SetDay( nDay ); }
	void			setMonth( UINT16 nMonth ) { SetMonth( nMonth ); }
	void			setYear( UINT16 nYear ) { SetYear( nYear ); }

	void			setDate( UINT32 nDate ) { SetDate( nDate ); }
	UINT32			getDate() const { return GetDate(); }
#endif
};

#endif // _DATE_HXX
