/*************************************************************************
 *
 *  $RCSfile: datetime.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: er $ $Date: 2002/04/15 10:57:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DATETIME_HXX
#define _DATETIME_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TIME_HXX
#include <tools/time.hxx>
#endif

// ------------
// - DateTime -
// ------------

class DateTime : public Date, public Time
{
public:
                    DateTime() : Date(), Time() {}
                    DateTime( const DateTime& rDateTime ) :
                        Date( rDateTime ), Time( rDateTime ) {}
                    DateTime( const Date& rDate ) : Date( rDate ), Time(0) {}
                    DateTime( const Time& rTime ) : Date(0), Time( rTime ) {}
                    DateTime( const Date& rDate, const Time& rTime ) :
                        Date( rDate ), Time( rTime ) {}

    BOOL            IsBetween( const DateTime& rFrom,
                               const DateTime& rTo ) const;

    BOOL            IsEqualIgnore100Sec( const DateTime& rDateTime ) const
                        {
                            if ( Date::operator!=( rDateTime ) )
                                return FALSE;
                            return Time::IsEqualIgnore100Sec( rDateTime );
                        }

    BOOL            operator ==( const DateTime& rDateTime ) const
                        { return (Date::operator==( rDateTime ) &&
                                  Time::operator==( rDateTime )); }
    BOOL            operator !=( const DateTime& rDateTime ) const
                        { return (Date::operator!=( rDateTime ) ||
                                  Time::operator!=( rDateTime )); }
    BOOL            operator  >( const DateTime& rDateTime ) const;
    BOOL            operator  <( const DateTime& rDateTime ) const;
    BOOL            operator >=( const DateTime& rDateTime ) const;
    BOOL            operator <=( const DateTime& rDateTime ) const;

    ULONG           GetSecFromDateTime( const Date& rDate ) const;
    void            MakeDateTimeFromSec( const Date& rDate, ULONG nSec );

    void            ConvertToUTC()       { *this -= Time::GetUTCOffset(); }
    void            ConvertToLocalTime() { *this += Time::GetUTCOffset(); }

    DateTime&       operator +=( long nDays )
                        { Date::operator+=( nDays ); return *this; }
    DateTime&       operator -=( long nDays )
                        { Date::operator-=( nDays ); return *this; }
	DateTime&		operator +=( double fTimeInDays );
	DateTime&		operator -=( double fTimeInDays )
						{ return operator+=( -fTimeInDays ); }
    DateTime&       operator +=( const Time& rTime );
    DateTime&       operator -=( const Time& rTime );

    friend DateTime operator +( const DateTime& rDateTime, long nDays );
    friend DateTime operator -( const DateTime& rDateTime, long nDays );
    friend DateTime operator +( const DateTime& rDateTime, double fTimeInDays );
    friend DateTime operator -( const DateTime& rDateTime, double fTimeInDays )
						{ return operator+( rDateTime, -fTimeInDays ); }
    friend DateTime operator +( const DateTime& rDateTime, const Time& rTime );
    friend DateTime operator -( const DateTime& rDateTime, const Time& rTime );
	friend double	operator -( const DateTime& rDateTime1, const DateTime& rDateTime2 );
	friend long		operator -( const DateTime& rDateTime, const Date& rDate )
						{ return (const Date&) rDateTime - rDate; }

    DateTime&       operator =( const DateTime& rDateTime );
};

inline DateTime& DateTime::operator =( const DateTime& rDateTime )
{
    Date::operator=( rDateTime );
    Time::operator=( rDateTime );
    return *this;
}

#endif // _DATETIME_HXX
