/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: actiontriggerhelper.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:15:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef __FRAMEWORK_HELPER_ACTIONTRIGGERHELPER_HXX_
#define __FRAMEWORK_HELPER_ACTIONTRIGGERHELPER_HXX_

#ifndef _COM_SUN_STAR_CONTAINER_XINDEXCONTAINER_HPP_
#include <com/sun/star/container/XIndexContainer.hpp>
#endif

// #110897#
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif

namespace framework
{
	class ActionTriggerHelper
	{
		public:
			// Fills the submitted menu with the structure contained in the second
			// parameter rActionTriggerContainer
			// @param pNewMenu = must be a valid and empty menu
			// @param rActionTriggerContainer = must be an instance of service "com.sun.star.ui.ActionTriggerContaienr"
			static void
				CreateMenuFromActionTriggerContainer( 
					Menu* pNewMenu,
					const com::sun::star::uno::Reference< com::sun::star::container::XIndexContainer >& rActionTriggerContainer );

			// Creates a "com::sun::star::ui::ActionTriggerContainer" with the structure of the menu
			// provided as a parameter. The implementation class stores the menu pointer
			// to optimize the time of creation of a menu from a actiontrigger structure.
			// IMPORTANT: The caller must ensure that the menu pointer is valid through the
			//			  life time of the XIndexContainer object!!!
			//
			// @param pNewMenu = Must be a valid menu. Please be aware that this implementation is based on
			//					 the above mentioned restriction!!!

			// #110897#
			static com::sun::star::uno::Reference< com::sun::star::container::XIndexContainer > CreateActionTriggerContainerFromMenu(
				const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xServiceFactory,
				const Menu* pMenu );

			// Fills the submitted rActionTriggerContainer with the structure of the menu
			// provided as the second parameter
			// @param rActionTriggerContainer = must be an instance of service "com.sun.star.ui.ActionTriggerContainer"
			// @param pNewMenu = must be a valid menu
			static void
				FillActionTriggerContainerFromMenu( 
					com::sun::star::uno::Reference< com::sun::star::container::XIndexContainer >& rActionTriggerContainer,
					const Menu* pMenu );

	};
}

#endif // __FRAMEWORK_HELPER_ACTIONTRIGGERHELPER_HXX_
