/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: b2dmpnt.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:11:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _B2D_MPNT_HXX
#define _B2D_MPNT_HXX

#ifndef _B2D_MBASE_HXX
#include <goodies/b2dmbase.hxx>
#endif

//************************************************************
//   Defines
//************************************************************

// Enum for MarkerKind
enum B2dIAOMarkerKind
{
	B2D_IAO_MARKER_POINT,
	B2D_IAO_MARKER_PLUS,
	B2D_IAO_MARKER_CROSS,

	B2D_IAO_MARKER_RECT_3X3,
	B2D_IAO_MARKER_RECT_5X5,
	B2D_IAO_MARKER_RECT_7X7,
	B2D_IAO_MARKER_RECT_9X9,

	B2D_IAO_MARKER_CIRCLE_3X3,
	B2D_IAO_MARKER_CIRCLE_5X5,
	B2D_IAO_MARKER_CIRCLE_7X7,
	B2D_IAO_MARKER_CIRCLE_9X9,

	B2D_IAO_MARKER_ELLIPSE_5X3,
	B2D_IAO_MARKER_ELLIPSE_7X5,
	B2D_IAO_MARKER_ELLIPSE_9X7,

	B2D_IAO_MARKER_ELLIPSE_3X5,
	B2D_IAO_MARKER_ELLIPSE_5X7,
	B2D_IAO_MARKER_ELLIPSE_7X9,

	B2D_IAO_MARKER_CROSSHAIR_3X3,
	B2D_IAO_MARKER_CROSSHAIR_5X5,
	B2D_IAO_MARKER_CROSSHAIR_7X7,
	B2D_IAO_MARKER_CROSSHAIR_9X9
};

//************************************************************
//   InterActionObjectMarker
//************************************************************

class B2dIAOMarker : public B2dIAObject
{
	// 2nd color of IAO (for Borders)
	Color						a2ndColor;

	// Kind of Marker
	B2dIAOMarkerKind			eMarkerKind;

	// Create the Geometry - this is the pixel creator
	virtual void CreateGeometry();

	// Create the BaseRect
	virtual void CreateBaseRect();

	// local help functions for creation
	void CreateGeometryFromMarkerData(BYTE* pData);
	void CreateBaseRectFromMarkerData(BYTE* pData);
	BOOL DoHitTestWithMarkerData(BYTE* pData, const Point& rPixelPos, UINT16 nTol);

public:
    TYPEINFO();
	B2dIAOMarker(B2dIAOManager* pMan, Point aPos, B2dIAOMarkerKind eKind = B2D_IAO_MARKER_POINT);
	virtual ~B2dIAOMarker();

	// Access to 2ndColor
	const Color& Get2ndColor() const { return a2ndColor; }
	void Set2ndColor(Color aNew);

	// Access to Kind
	B2dIAOMarkerKind GetKind() const { return eMarkerKind; }
	void SetMarkerKind(B2dIAOMarkerKind eNew);

	// Hittest
	virtual BOOL IsHit(const Point& rPixelPos, UINT16 nTol = 0);
};

#endif          // _B2D_MPNT_HXX
