/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: AccessibleBrowseBoxHeaderCell.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:59:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOXHEADERCELL_HXX
#define _SVTOOLS_ACCESSIBLEBROWSEBOXHEADERCELL_HXX

#ifndef _SVTOOLS_ACCESSIBLEBROWSEBOXBASE_HXX
#include <svtools/AccessibleBrowseBoxBase.hxx>
#endif

namespace svt
{
	class AccessibleBrowseBoxHeaderCell : public BrowseBoxAccessibleElement
	{
		sal_Int32	m_nColumnRowId;
	public:
		AccessibleBrowseBoxHeaderCell(sal_Int32 _nColumnRowId,
										  const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& rxParent,
										  IAccessibleTableProvider&                  _rBrowseBox,
										  const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >& _xFocusWindow,
										  AccessibleBrowseBoxObjType  _eObjType);
		/** @return  The count of visible children. */
		virtual sal_Int32 SAL_CALL getAccessibleChildCount() throw ( ::com::sun::star::uno::RuntimeException );

		/** @return  The XAccessible interface of the specified child. */
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL
			getAccessibleChild( sal_Int32 nChildIndex ) throw ( ::com::sun::star::lang::IndexOutOfBoundsException,::com::sun::star::uno::RuntimeException );

		/** @return  The index of this object among the parent's children. */
		virtual sal_Int32 SAL_CALL getAccessibleIndexInParent() throw ( ::com::sun::star::uno::RuntimeException );

		/** Grabs the focus to the BrowseBox. */
		virtual void SAL_CALL grabFocus() throw ( ::com::sun::star::uno::RuntimeException );

		inline sal_Bool isRowBarCell() const
		{
			return getType() == BBTYPE_ROWHEADERCELL;
		}

		/** @return
				The name of this class.
		*/
		virtual ::rtl::OUString SAL_CALL getImplementationName() throw ( ::com::sun::star::uno::RuntimeException );

		/** Creates a new AccessibleStateSetHelper and fills it with states of the
			current object.
			@return
				A filled AccessibleStateSetHelper.
		*/
		::utl::AccessibleStateSetHelper* implCreateStateSetHelper();

	protected:
		virtual Rectangle implGetBoundingBox();

		virtual Rectangle implGetBoundingBoxOnScreen();
	};
}

#endif // _SVTOOLS_ACCESSIBLEBROWSEBOXHEADERCELL_HXX

