/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: isolang.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:45:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _ISOLANG_HXX
#define _ISOLANG_HXX

#ifndef _LANG_HXX
#include <tools/lang.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef INCLUDED_TOOLSDLLAPI_H
#include "tools/toolsdllapi.h"
#endif

// -----------------------------
// - ConvertLanguageToIsoNames -
// -----------------------------

TOOLS_DLLPUBLIC void ConvertLanguageToIsoNames( LanguageType eLang, UniString& rLangStr, UniString& rCountry );
TOOLS_DLLPUBLIC void ConvertLanguageToIsoNames( LanguageType eLang, ByteString& rLangStr, ByteString& rCountry );
TOOLS_DLLPUBLIC UniString ConvertLanguageToIsoString( LanguageType eLang, sal_Unicode cSep = '-' );
TOOLS_DLLPUBLIC ByteString ConvertLanguageToIsoByteString( LanguageType eLang, sal_Char cSep = '-' );

// -----------------------------
// - ConvertIsoNamesToLanguage -
// -----------------------------

TOOLS_DLLPUBLIC LanguageType ConvertIsoNamesToLanguage( const UniString& rLang, const UniString& rCountry );
TOOLS_DLLPUBLIC LanguageType ConvertIsoNamesToLanguage( const ByteString& rLang, const ByteString& rCountry );
TOOLS_DLLPUBLIC LanguageType ConvertIsoStringToLanguage( const UniString& rString, sal_Unicode cSep = '-' );
TOOLS_DLLPUBLIC LanguageType ConvertIsoByteStringToLanguage( const ByteString& rString, sal_Char cSep = '-' );
TOOLS_DLLPUBLIC LanguageType ConvertUnxByteStringToLanguage( const ByteString& rString );

// ---------------------------------------------------------------------------

/// @internal - Access to fields of an element of the simple conversion table.
struct IsoLangEntry
{
    LanguageType  meLang;
    sal_Char      maLangStr[4];
    sal_Char      maCountry[3];
};

/** @internal - Return a pointer to the IsoLangEntry of the underlying table,
    matching the offset passed by nIndex. Only meaningful for the resource
    compiler to build a list of known languages.

    @returns address of IsoLangEntry, or NULL pointer if nIndex exceeds the
    table elements' count.
 */
TOOLS_DLLPUBLIC const IsoLangEntry* GetIsoLangEntry( size_t nIndex );

#endif //_ISOLANG_HXX
