/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends NativeFunction
implements Function {
    static final int PREFERENCE_EQUAL = 0;
    static final int PREFERENCE_FIRST_ARG = 1;
    static final int PREFERENCE_SECOND_ARG = 2;
    static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    Method[] methods;
    private static final Method method_setAccessible = NativeJavaMethod.getMethod(class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = NativeJavaMethod.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method, "setAccessible", new Class[]{Boolean.TYPE});
    static /* synthetic */ Class class$java$lang$reflect$Method;

    public NativeJavaMethod() {
        this.functionName = null;
    }

    public NativeJavaMethod(Method[] methodArray) {
        this.methods = methodArray;
        this.functionName = methodArray[0].getName();
    }

    public NativeJavaMethod(Method method, String string) {
        this.methods = new Method[1];
        this.methods[0] = method;
        this.functionName = string;
    }

    public void add(Method method) {
        if (this.functionName == null) {
            this.functionName = method.getName();
        } else if (!this.functionName.equals(method.getName())) {
            throw new RuntimeException("internal method name mismatch");
        }
        int n = this.methods == null ? 0 : this.methods.length;
        Method[] methodArray = new Method[n + 1];
        for (int i = 0; i < n; ++i) {
            methodArray[i] = this.methods[i];
        }
        methodArray[n] = method;
        this.methods = methodArray;
    }

    static String scriptSignature(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (clazz == ScriptRuntime.UndefinedClass) {
            return "undefined";
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return "boolean";
        }
        if (clazz == ScriptRuntime.StringClass) {
            return "string";
        }
        if (ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
            return "number";
        }
        if (object instanceof Wrapper) {
            return ((Wrapper)object).unwrap().getClass().getName();
        }
        if (object instanceof Scriptable) {
            if (object instanceof Function) {
                return "function";
            }
            return "object";
        }
        return NativeJavaMethod.javaSignature(clazz);
    }

    static String scriptSignature(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(NativeJavaMethod.scriptSignature(objectArray[i]));
        }
        return stringBuffer.toString();
    }

    static String javaSignature(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        if (clazz.isArray()) {
            return NativeJavaMethod.javaSignature(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    static String javaSignature(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(NativeJavaMethod.javaSignature(classArray[i]));
        }
        return stringBuffer.toString();
    }

    static String signature(Member member) {
        if (member instanceof Method) {
            Class[] classArray = ((Method)member).getParameterTypes();
            return member.getName() + "(" + NativeJavaMethod.javaSignature(classArray) + ")";
        }
        Class[] classArray = ((Constructor)member).getParameterTypes();
        return "(" + NativeJavaMethod.javaSignature(classArray) + ")";
    }

    public String decompile(Context context, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() {");
        }
        stringBuffer.append("/*\n");
        this.toString(stringBuffer);
        stringBuffer.append(bl ? "*/\n" : "*/}\n");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer) {
        for (int i = 0; i < this.methods.length; ++i) {
            stringBuffer.append(NativeJavaMethod.javaSignature(this.methods[i].getReturnType()));
            stringBuffer.append(' ');
            stringBuffer.append(NativeJavaMethod.signature(this.methods[i]));
            stringBuffer.append('\n');
        }
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        Object object2;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        Method method = (Method)NativeJavaMethod.findFunction(this.methods, objectArray);
        if (method == null) {
            Class<?> clazz = this.methods[0].getDeclaringClass();
            String string = clazz.getName() + "." + this.functionName + "(" + NativeJavaMethod.scriptSignature(objectArray) + ")";
            throw Context.reportRuntimeError1("msg.java.no_such_method", string);
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = NativeJavaObject.coerceType(classArray[i], objectArray[i], true);
        }
        if (Modifier.isStatic(method.getModifiers())) {
            object2 = null;
        } else {
            object = scriptable2;
            while (!(object instanceof Wrapper)) {
                if ((object = object.getPrototype()) != null) continue;
                throw Context.reportRuntimeError1("msg.nonjava.method", this.functionName);
            }
            object2 = ((Wrapper)object).unwrap();
        }
        try {
            try {
                object = method.invoke(object2, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = NativeJavaMethod.retryIllegalAccessInvoke(method, object2, objectArray, illegalAccessException);
            }
            Class<?> clazz = method.getReturnType();
            Object object3 = context.getWrapFactory().wrap(context, scriptable, object, clazz);
            if (object3 == Undefined.instance) {
                return object3;
            }
            if (object3 == null && clazz == Void.TYPE) {
                return Undefined.instance;
            }
            return object3;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Context.reportRuntimeError("While attempting to call \"" + method.getName() + "\" in class \"" + method.getDeclaringClass().getName() + "\" receieved " + illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.wrapException(context, scriptable, invocationTargetException);
        }
    }

    static Object retryIllegalAccessInvoke(Method method, Object object, Object[] objectArray, IllegalAccessException illegalAccessException) throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray2;
        if (Modifier.isPublic(method.getModifiers())) {
            objectArray2 = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getDeclaringClass();
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i = 0; i < classArray2.length; ++i) {
                clazz = classArray2[i];
                try {
                    Method method2 = clazz.getMethod((String)objectArray2, classArray);
                    return method2.invoke(object, objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException2) {
                    // empty catch block
                }
            }
        }
        if (method_setAccessible != null) {
            objectArray2 = new Object[]{Boolean.TRUE};
            try {
                method_setAccessible.invoke((Object)method, objectArray2);
            }
            catch (IllegalAccessException illegalAccessException3) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return method.invoke(object, objectArray);
        }
        throw illegalAccessException;
    }

    static Member findFunction(Member[] memberArray, Object[] objectArray) {
        int n;
        Class[] classArray;
        Member member;
        int n2;
        Class[] classArray2;
        if (memberArray.length == 0) {
            return null;
        }
        boolean bl = memberArray[0] instanceof Method;
        for (int i = 0; i < objectArray.length; ++i) {
            classArray2 = objectArray[i];
            if (!(classArray2 instanceof Wrapper) || (classArray2 = ((Wrapper)classArray2).unwrap()) instanceof Number) continue;
            objectArray[i] = classArray2;
        }
        Member member2 = null;
        classArray2 = null;
        ObjArray objArray = null;
        for (n2 = 0; n2 < memberArray.length; ++n2) {
            member = memberArray[n2];
            Class[] classArray3 = classArray = bl ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            if (classArray2 == null) {
                for (n = 0; n < classArray.length && NativeJavaObject.canConvert(objectArray[n], classArray[n]); ++n) {
                }
                if (n != classArray.length) continue;
                member2 = member;
                classArray2 = classArray;
                continue;
            }
            n = NativeJavaMethod.preferSignature(objectArray, classArray, classArray2);
            if (n == 3) {
                if (objArray == null) {
                    objArray = new ObjArray();
                }
                objArray.add(member);
                continue;
            }
            if (n == 1) {
                member2 = member;
                classArray2 = classArray;
                continue;
            }
            if (n != 0 || !Modifier.isStatic(member2.getModifiers()) || !member2.getDeclaringClass().isAssignableFrom(member.getDeclaringClass())) continue;
            member2 = member;
            classArray2 = classArray;
        }
        if (objArray == null) {
            return member2;
        }
        for (n2 = objArray.size() - 1; n2 >= 0; --n2) {
            member = (Member)objArray.get(n2);
            classArray = bl ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
            n = NativeJavaMethod.preferSignature(objectArray, classArray, classArray2);
            if (n == 1) {
                member2 = member;
                classArray2 = classArray;
                objArray.remove(n2);
                continue;
            }
            if (n != 2) continue;
            objArray.remove(n2);
        }
        if (objArray.size() > 0) {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = member2 instanceof Constructor;
            objArray.add(member2);
            for (int i = 0; i < objArray.size(); ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                Member member3 = (Member)objArray.get(i);
                if (!bl2) {
                    Class<?> clazz = ((Method)member3).getReturnType();
                    stringBuffer.append(clazz);
                    stringBuffer.append(' ');
                }
                stringBuffer.append(NativeJavaMethod.signature(member3));
            }
            if (bl2) {
                Object[] objectArray2 = new Object[]{member2.getName(), NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString()};
                string = Context.getMessage("msg.constructor.ambiguous", objectArray2);
            } else {
                Object[] objectArray3 = new Object[]{member2.getDeclaringClass().getName(), member2.getName(), NativeJavaMethod.scriptSignature(objectArray), stringBuffer.toString()};
                string = Context.getMessage("msg.method.ambiguous", objectArray3);
            }
            throw Context.reportRuntimeError(string);
        }
        return member2;
    }

    public static int preferSignature(Object[] objectArray, Class[] classArray, Class[] classArray2) {
        Class clazz;
        Class clazz2;
        int n = 0;
        for (int i = 0; i < objectArray.length && ((clazz2 = classArray[i]) == (clazz = classArray2[i]) || (n |= NativeJavaMethod.preferConversion(objectArray[i], clazz2, clazz)) != 3); ++i) {
        }
        return n;
    }

    public static int preferConversion(Object object, Class clazz, Class clazz2) {
        int n = NativeJavaObject.getConversionWeight(object, clazz);
        int n2 = NativeJavaObject.getConversionWeight(object, clazz2);
        if (n == 0 && n2 == 0) {
            if (clazz.isAssignableFrom(clazz2)) {
                return 2;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return 1;
            }
        } else {
            if (n < n2) {
                return 1;
            }
            if (n > n2) {
                return 2;
            }
        }
        return 3;
    }

    Method[] getMethods() {
        return this.methods;
    }

    private static Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static void printDebug(String string, Member member, Object[] objectArray) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

