/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected ObjArray loops;
    protected ObjArray loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream tokenStream, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, Node node2, TokenStream tokenStream, Scriptable scriptable) {
        Node node3;
        this.loops = new ObjArray();
        this.loopEnds = new ObjArray();
        boolean bl = this.inFunction = node.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(node, this.getVariableTable(node));
        }
        this.irFactory = this.createIRFactory(tokenStream, scriptable);
        boolean bl2 = false;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        while ((node3 = preorderNodeIterator.nextNode()) != null) {
            int n = node3.getType();
            block0 : switch (n) {
                case 110: {
                    if (node3 == node) {
                        VariableTable variableTable = this.getVariableTable(node);
                        this.addVariables(node, variableTable);
                        Node node4 = node3.getLastChild();
                        Node node5 = node4.getLastChild();
                        if (node5 != null && node5.getType() == 5) break;
                        node4.addChildToBack(new Node(5));
                        break;
                    }
                    FunctionNode functionNode = (FunctionNode)node3.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                        functionNode.setCheckThis(true);
                    }
                    this.addParameters(functionNode);
                    NodeTransformer nodeTransformer = this.newInstance();
                    functionNode = (FunctionNode)nodeTransformer.transform(functionNode, node, tokenStream, scriptable);
                    node3.putProp(5, functionNode);
                    ObjArray objArray = (ObjArray)node.getProp(5);
                    if (objArray == null) {
                        objArray = new ObjArray();
                        node.putProp(5, objArray);
                    }
                    objArray.add(functionNode);
                    break;
                }
                case 136: {
                    Object object4;
                    Object object2;
                    Object object3;
                    Node node6 = node3.getFirstChild();
                    node3.removeChild(node6);
                    String string = node6.getString();
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        object3 = (Node)this.loops.get(i);
                        if (((Node)object3).getType() != 136 || !string.equals(object2 = (String)((Node)object3).getProp(20))) continue;
                        object4 = Context.getMessage1("msg.dup.label", string);
                        this.reportMessage(Context.getContext(), (String)object4, node3, node, true, scriptable);
                        break block0;
                    }
                    node3.putProp(20, string);
                    Node node7 = new Node(137);
                    object3 = preorderNodeIterator.getCurrentParent();
                    for (object2 = node3.getNext(); object2 != null && (((Node)object2).getType() == 136 || ((Node)object2).getType() == 137); object2 = ((Node)object2).getNext()) {
                    }
                    if (object2 == null) break;
                    ((Node)object3).addChildAfter(node7, (Node)object2);
                    node3.putProp(2, node7);
                    if (((Node)object2).getType() == 138) {
                        node3.putProp(3, ((Node)object2).getProp(3));
                    }
                    this.loops.push(node3);
                    this.loopEnds.push(node7);
                    break;
                }
                case 115: {
                    Object object2;
                    Node node8 = new Node(137);
                    Node node9 = preorderNodeIterator.getCurrentParent();
                    node9.addChildAfter(node8, node3);
                    Object object = node3;
                    Object object3 = node3.getFirstChild().next;
                    while (object3 != null) {
                        object2 = ((Node)object3).next;
                        node3.removeChild((Node)object3);
                        node9.addChildAfter((Node)object3, (Node)object);
                        object = object3;
                        object3 = object2;
                    }
                    node3.putProp(2, node8);
                    this.loops.push(node3);
                    this.loopEnds.push(node8);
                    node3.putProp(13, new ObjArray());
                    break;
                }
                case 116: 
                case 117: {
                    Node node10 = (Node)this.loops.peek();
                    if (n == 116) {
                        ObjArray objArray = (ObjArray)node10.getProp(13);
                        objArray.add(node3);
                        break;
                    }
                    node10.putProp(14, node3);
                    break;
                }
                case 144: {
                    int n2 = node.getIntProp(22, 0);
                    node.putIntProp(22, n2 + 1);
                    break;
                }
                case 138: {
                    this.loops.push(node3);
                    this.loopEnds.push(node3.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    this.loops.push(node3);
                    Node node11 = node3.getNext();
                    if (node11.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(node11);
                    break;
                }
                case 75: {
                    Node node12 = (Node)node3.getProp(21);
                    if (node12 != null) {
                        bl2 = true;
                        this.loops.push(node3);
                        this.loopEnds.push(node12);
                    }
                    int n3 = node.getIntProp(22, 0);
                    node.putIntProp(22, n3 + 1);
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.isEmpty() || this.loopEnds.peek() != node3) break;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    Object object2;
                    Object object3;
                    if (!bl2) break;
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        Node node13 = (Node)this.loops.get(i);
                        int n4 = node13.getType();
                        if (n4 == 75) {
                            object3 = new Node(143);
                            object2 = node13.getProp(21);
                            ((Node)object3).putProp(1, object2);
                            preorderNodeIterator.addBeforeCurrent((Node)object3);
                            continue;
                        }
                        if (n4 != 124) continue;
                        object3 = new Node(4);
                        preorderNodeIterator.addBeforeCurrent((Node)object3);
                    }
                    break;
                }
                case 121: 
                case 122: {
                    Object[] objectArray;
                    Object object;
                    Object object4;
                    Object object2;
                    Object object3;
                    Object object5 = null;
                    boolean bl3 = node3.hasChildren();
                    String string = null;
                    if (bl3) {
                        object3 = node3.getFirstChild();
                        string = ((Node)object3).getString();
                        node3.removeChild((Node)object3);
                    }
                    for (int i = this.loops.size() - 1; i >= 0; --i) {
                        object2 = (Node)this.loops.get(i);
                        int n5 = ((Node)object2).getType();
                        if (n5 == 124) {
                            object = new Node(4);
                            preorderNodeIterator.addBeforeCurrent((Node)object);
                            continue;
                        }
                        if (n5 == 75) {
                            object = new Node(143);
                            objectArray = ((Node)object2).getProp(21);
                            ((Node)object).putProp(1, objectArray);
                            preorderNodeIterator.addBeforeCurrent((Node)object);
                            continue;
                        }
                        if (!bl3 && (n5 == 138 || n5 == 115 && n == 121)) {
                            object5 = object2;
                            break;
                        }
                        if (!bl3 || n5 != 136 || !string.equals((String)((Node)object2).getProp(20))) continue;
                        object5 = object2;
                        break;
                    }
                    int n6 = n == 121 ? 2 : 3;
                    Object object6 = object4 = object5 == null ? null : (Node)((Node)object5).getProp(n6);
                    if (object5 == null || object4 == null) {
                        if (!bl3) {
                            object = n == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (object5 != null) {
                            object = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            objectArray = new Object[]{string};
                            object = Context.getMessage("msg.undef.label", objectArray);
                        }
                        this.reportMessage(Context.getContext(), (String)object, node3, node, true, scriptable);
                        node3.setType(128);
                        break;
                    }
                    node3.setType(6);
                    node3.putProp(1, object4);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node3, node);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node3, node);
                    break;
                }
                case 108: {
                    Node node14 = node3.getLastChild();
                    node14.setType(46);
                    break;
                }
                case 140: {
                    node3.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    ObjArray objArray = (ObjArray)node.getProp(12);
                    if (objArray == null) {
                        objArray = new ObjArray();
                        node.putProp(12, objArray);
                    }
                    objArray.add(node3);
                    Node node15 = new Node(56);
                    preorderNodeIterator.replaceCurrent(node15);
                    node15.putProp(12, node3);
                    break;
                }
                case 123: {
                    Object object4;
                    Object object2;
                    Object object3;
                    Node node16 = new Node(133);
                    for (Node node17 = node3.getFirstChild(); node17 != null; node17 = node17.getNext()) {
                        Node node18 = node17;
                        if (!node18.hasChildren()) continue;
                        object3 = node18.getFirstChild();
                        node18.removeChild((Node)object3);
                        object2 = (Node)this.irFactory.createAssignment(128, node18, (Node)object3, null, false);
                        object4 = new Node(57, (Node)object2, node3.getLineno());
                        node16.addChildToBack((Node)object4);
                    }
                    preorderNodeIterator.replaceCurrent(node16);
                    break;
                }
                case 10: 
                case 31: {
                    Node node19;
                    Object object3;
                    if (!this.inFunction || this.inWithStatement() || (node19 = node3.getFirstChild()) == null || node19.getType() != 61) break;
                    String string = node19.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if (!((VariableTable)(object3 = this.getVariableTable(node))).hasVariable(string)) break;
                    if (n == 10) {
                        node3.setType(73);
                        node19.setType(46);
                        break;
                    }
                    Object object2 = new Node(109, 51);
                    preorderNodeIterator.replaceCurrent((Node)object2);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Node node20 = node3.getFirstChild().getNext();
                    String string = node20 == null ? "" : node20.getString();
                    Context context = Context.getCurrentContext();
                    if ((context == null || !context.isActivationNeeded(string)) && (!string.equals("length") || Context.getContext().getLanguageVersion() != 120)) break;
                    ((FunctionNode)node).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable variableTable;
                    if (!this.inFunction || this.inWithStatement()) break;
                    String string = node3.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if (!(variableTable = this.getVariableTable(node)).hasVariable(string)) break;
                    node3.setType(72);
                }
            }
        }
        return node;
    }

    protected void addVariables(Node node, VariableTable variableTable) {
        Object object;
        Object object2;
        Node node2;
        boolean bl = node.getType() == 110;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        ObjToIntMap objToIntMap = null;
        while ((node2 = preorderNodeIterator.nextNode()) != null) {
            int n = node2.getType();
            if (bl && n == 110 && node2 != node && ((FunctionNode)node2.getProp(5)).getFunctionType() == 3) {
                object2 = node2.getString();
                if (object2 == null) continue;
                variableTable.removeLocal((String)object2);
                if (objToIntMap == null) {
                    objToIntMap = new ObjToIntMap();
                }
                objToIntMap.put(object2, 0);
            }
            if (n != 123) continue;
            for (object2 = node2.getFirstChild(); object2 != null; object2 = ((Node)object2).getNext()) {
                object = ((Node)object2).getString();
                if (objToIntMap != null && objToIntMap.has(object)) continue;
                variableTable.addLocal((String)object, this.createVariableObject((String)object, false));
            }
        }
        if (bl) {
            FunctionNode functionNode = (FunctionNode)node;
            object2 = functionNode.getFunctionName();
            if (functionNode.getFunctionType() == 2 && object2 != null && ((String)object2).length() > 0 && variableTable.hasVariable((String)object2)) {
                variableTable.addLocal((String)object2, this.createVariableObject((String)object2, false));
                object = node.getLastChild();
                Node node3 = new Node(57, new Node(73, Node.newString((String)object2), new Node(109, 87)));
                ((Node)object).addChildrenToFront(node3);
            }
        }
    }

    protected void addParameters(FunctionNode functionNode) {
        VariableTable variableTable = functionNode.getVariableTable();
        Node node = functionNode.getFirstChild();
        if (node.getType() == 94 && variableTable.getParameterCount() == 0) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                String string = node2.getString();
                variableTable.addParameter(string, this.createVariableObject(string, true));
            }
        }
    }

    protected Object createVariableObject(String string, boolean bl) {
        return string;
    }

    protected void visitNew(Node node, Node node2) {
    }

    protected void visitCall(Node node, Node node2) {
        Node node3;
        Object object;
        Object object2;
        Node node4 = node.getFirstChild();
        int n = 0;
        Node node5 = node4.getNext();
        while (node5 != null) {
            node5 = node5.getNext();
            ++n;
        }
        boolean bl = false;
        if (node4.getType() == 44) {
            object2 = this.getVariableTable(node2);
            object = node4.getString();
            if (this.inFunction && ((VariableTable)object2).hasVariable((String)object) && !this.inWithStatement()) {
                node4.setType(72);
            } else {
                node.removeChild(node4);
                node4.setType(71);
                node3 = node4.cloneNode();
                node3.setType(46);
                Node node6 = new Node(39, node4, node3);
                node.addChildToFront(node6);
                node4 = node6;
                boolean bl2 = bl = this.inWithStatement() || !this.inFunction;
            }
        }
        if (node4.getType() != 39 && node4.getType() != 41) {
            node.removeChild(node4);
            object2 = this.irFactory.createNewTemp(node4);
            object = this.irFactory.createUseTemp((Node)object2);
            ((Node)object).putProp(6, object2);
            node3 = new Node(141, (Node)object);
            node.addChildToFront(node3);
            node.addChildToFront((Node)object2);
            return;
        }
        object2 = node4.getFirstChild();
        node4.removeChild((Node)object2);
        object = this.irFactory.createNewTemp((Node)object2);
        node4.addChildToFront((Node)object);
        node3 = this.irFactory.createUseTemp((Node)object);
        node3.putProp(6, object);
        if (bl) {
            node3 = new Node(68, node3);
        }
        node.addChildAfter(node3, node4);
    }

    protected boolean inWithStatement() {
        for (int i = this.loops.size() - 1; i >= 0; --i) {
            Node node = (Node)this.loops.get(i);
            if (node.getType() != 124) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecialCallName(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        boolean bl = false;
        if (node3.getType() == 44) {
            String string = node3.getString();
            bl = string.equals("eval") || string.equals("With");
        } else if (node3.getType() == 39) {
            String string = node3.getLastChild().getString();
            bl = string.equals("exec");
        }
        if (bl) {
            if (this.inFunction) {
                ((FunctionNode)node).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node node) {
        if (this.inFunction) {
            return ((FunctionNode)node).getVariableTable();
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        if (variableTable == null) {
            variableTable = this.createVariableTable();
            node.putProp(10, variableTable);
        }
        return variableTable;
    }

    protected void reportMessage(Context context, String string, Node node, Node node2, boolean bl, Scriptable scriptable) {
        Object object;
        int n = node.getLineno();
        Object object2 = object = node2 == null ? null : node2.getProp(16);
        if (bl) {
            if (scriptable != null) {
                throw NativeGlobal.constructError(context, "SyntaxError", string, scriptable, (String)object, n, 0, null);
            }
            Context.reportError(string, (String)object, n, null, 0);
        } else {
            Context.reportWarning(string, (String)object, n, null, 0);
        }
    }
}

