/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.classfile.JavaVariable;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.TypeEvent;

final class OptLocalVariable
implements JavaVariable {
    private String itsName;
    private boolean itsIsParameter;
    private int itsIndex = -1;
    private short itsJRegister = (short)-1;
    private boolean itsLiveAcrossCall;
    private boolean itsIsNumber;
    private TypeEvent itsTypeUnion;
    private int initPC;

    public OptLocalVariable(String string, boolean bl) {
        this.itsName = string;
        this.itsIsParameter = bl;
        int n = bl ? 3 : 0;
        this.itsTypeUnion = new TypeEvent(n);
    }

    public String toString() {
        return "LocalVariable : '" + this.getName() + "', index = " + this.getIndex() + ", LiveAcrossCall = " + this.itsLiveAcrossCall + ", isNumber = " + this.itsIsNumber + ", isParameter = " + this.isParameter() + ", JRegister = " + this.itsJRegister;
    }

    public String getName() {
        return this.itsName;
    }

    public String getTypeDescriptor() {
        return this.isNumber() ? "D" : "Ljava/lang/Object;";
    }

    public short getJRegister() {
        return this.itsJRegister;
    }

    void assignJRegister(short s) {
        this.itsJRegister = s;
    }

    public int getStartPC() {
        return this.initPC;
    }

    int getIndex() {
        return this.itsIndex;
    }

    void setIndex(int n) {
        this.itsIndex = n;
    }

    void setStartPC(int n) {
        this.initPC = n;
    }

    void setIsNumber() {
        this.itsIsNumber = true;
    }

    boolean isNumber() {
        return this.itsIsNumber;
    }

    boolean isParameter() {
        return this.itsIsParameter;
    }

    void markLiveAcrossCall() {
        this.itsLiveAcrossCall = true;
    }

    void clearLiveAcrossCall() {
        this.itsLiveAcrossCall = false;
    }

    boolean isLiveAcrossCall() {
        return this.itsLiveAcrossCall;
    }

    boolean assignType(int n) {
        return this.itsTypeUnion.add(n);
    }

    int getTypeUnion() {
        return this.itsTypeUnion.getEvent();
    }

    static OptLocalVariable get(VariableTable variableTable, int n) {
        return (OptLocalVariable)variableTable.getVariable(n);
    }

    static OptLocalVariable get(VariableTable variableTable, String string) {
        return (OptLocalVariable)variableTable.getVariable(string);
    }

    static void establishIndices(VariableTable variableTable) {
        int n = variableTable.size();
        for (int i = 0; i != n; ++i) {
            OptLocalVariable.get((VariableTable)variableTable, (int)i).itsIndex = i;
        }
    }

    static OptLocalVariable[] toArray(VariableTable variableTable) {
        Object[] objectArray = null;
        if (variableTable != null) {
            objectArray = new OptLocalVariable[variableTable.size()];
            variableTable.getAllVariables(objectArray);
        }
        return objectArray;
    }
}

