/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import javax.swing.text.BadLocationException;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.Main;

class SetFilePosition
implements Runnable {
    Main db;
    FileWindow w;
    int line;
    boolean activate;

    SetFilePosition(Main main, FileWindow fileWindow, int n) {
        this.db = main;
        this.w = fileWindow;
        this.line = n;
        this.activate = true;
    }

    SetFilePosition(Main main, FileWindow fileWindow, int n, boolean bl) {
        this.db = main;
        this.w = fileWindow;
        this.line = n;
        this.activate = bl;
    }

    public void run() {
        FileTextArea fileTextArea = this.w.textArea;
        try {
            if (this.line == -1) {
                this.w.setPosition(-1);
                if (this.db.currentWindow == this.w) {
                    this.db.currentWindow = null;
                }
            } else {
                int n = fileTextArea.getLineStartOffset(this.line - 1);
                if (this.db.currentWindow != null && this.db.currentWindow != this.w) {
                    this.db.currentWindow.setPosition(-1);
                }
                this.w.setPosition(n);
                this.db.currentWindow = this.w;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.activate) {
            if (this.w.isIcon()) {
                this.db.desk.getDesktopManager().deiconifyFrame(this.w);
            }
            this.db.desk.getDesktopManager().activateFrame(this.w);
            try {
                this.w.show();
                this.w.toFront();
                this.w.setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

