/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class BackBuffer {
    private BufferedImage backBuffer;
    private Graphics2D backBufferGraphics;
    private Graphics2D referenceDevice;

    public BackBuffer(Graphics2D graphics2D, int n, int n2) {
        this.referenceDevice = graphics2D;
        this.setSize(n, n2);
    }

    public Graphics2D getGraphics() {
        return this.backBufferGraphics;
    }

    public void setSize(int n, int n2) {
        if (this.backBuffer != null && n == this.backBuffer.getWidth() && n2 == this.backBuffer.getHeight()) {
            return;
        }
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
        }
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = this.referenceDevice.getDeviceConfiguration().createCompatibleImage(n, n2);
        this.backBufferGraphics = this.backBuffer.createGraphics();
        CanvasUtils.initGraphics(this.backBufferGraphics);
        this.backBufferGraphics.setColor(Color.white);
        this.backBufferGraphics.fillRect(0, 0, n, n2);
    }

    public void redraw(Graphics2D graphics2D) {
        if (graphics2D != null && this.backBuffer != null) {
            CanvasUtils.printLog("BackBuffer.redraw(): using buffer of size (" + this.backBuffer.getWidth() + "," + this.backBuffer.getHeight() + ")");
            graphics2D.drawImage((Image)this.backBuffer, 0, 0, null);
        }
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public void dispose() {
        this.backBufferGraphics.dispose();
        this.backBuffer.flush();
    }
}

