/*
 * Decompiled with CFR 0.152.
 */
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.rendering.ViewState;
import com.sun.star.rendering.XAnimation;
import com.sun.star.rendering.XCanvas;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class SpriteRep {
    private BufferedImage buffer;
    private CanvasBitmap canvasBitmap;
    private double alpha;
    private Point2D.Double outputPosition;
    private boolean bufferOwned;

    public SpriteRep() {
        CanvasUtils.printLog("SpriteRep constructor called!");
        this.alpha = 0.0;
        this.outputPosition = new Point2D.Double(0.0, 0.0);
        this.bufferOwned = true;
    }

    public SpriteRep(SpriteRep spriteRep) {
        CanvasUtils.printLog("SpriteRep clone constructor called!");
        this.alpha = 0.0;
        this.outputPosition = new Point2D.Double(0.0, 0.0);
        this.cloneBuffer(spriteRep);
        this.bufferOwned = false;
    }

    public synchronized void renderAnimation(XAnimation xAnimation, ViewState viewState, double d) {
        if (this.canvasBitmap != null) {
            Graphics2D graphics2D = this.canvasBitmap.getGraphics();
            graphics2D.setColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
            graphics2D.setComposite(AlphaComposite.getInstance(1));
            graphics2D.setTransform(new AffineTransform());
            graphics2D.setClip(new Rectangle(0, 0, this.buffer.getWidth(), this.buffer.getHeight()));
            graphics2D.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            try {
                xAnimation.render((XCanvas)this.canvasBitmap, viewState, d);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CanvasUtils.printLog("Cannot create EmbeddedFrame within VCL window hierarchy!");
            }
        }
    }

    public synchronized void setSpriteAlpha(double d) {
        CanvasUtils.printLog("SpriteRep.setSpriteAlpha called with alpha=" + this.alpha);
        this.alpha = d;
    }

    public synchronized void moveSprite(Point2D.Double double_) {
        this.outputPosition = double_;
        CanvasUtils.printLog("SpriteRep.moveSprite: moving to (" + this.outputPosition.x + ", " + this.outputPosition.y + ")");
    }

    public synchronized void redraw(Graphics2D graphics2D) {
        if (this.buffer != null) {
            CanvasUtils.printLog("SpriteRep.redraw: compositing with alpha=" + this.alpha);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.alpha));
            graphics2D.drawImage((Image)this.buffer, (int)(this.outputPosition.getX() + 0.5), (int)(this.outputPosition.getY() + 0.5), null);
            CanvasUtils.printLog("SpriteRep.redraw called, output rect is (" + this.outputPosition.getX() + ", " + this.outputPosition.getY() + ", " + this.buffer.getWidth() + ", " + this.buffer.getHeight() + ")");
        }
    }

    public synchronized void setupBuffer(Graphics2D graphics2D, int n, int n2) {
        if (this.canvasBitmap != null) {
            this.canvasBitmap.dispose();
        }
        if (this.buffer != null) {
            this.buffer.flush();
        }
        this.buffer = graphics2D.getDeviceConfiguration().createCompatibleImage(Math.max(1, n), Math.max(1, n2), 3);
        this.canvasBitmap = new CanvasBitmap(this.buffer);
        CanvasUtils.initGraphics(this.canvasBitmap.getGraphics());
        CanvasUtils.printLog("SpriteRep.setupBuffer called, with dimensions (" + n + ", " + n2 + ")");
    }

    public synchronized void cloneBuffer(SpriteRep spriteRep) {
        this.buffer = spriteRep.buffer;
    }

    public synchronized XCanvas getContentCanvas() {
        CanvasUtils.printLog("SpriteRep.getContentCanvas() called");
        Graphics2D graphics2D = this.canvasBitmap.getGraphics();
        graphics2D.setTransform(new AffineTransform());
        graphics2D.setComposite(AlphaComposite.getInstance(1));
        graphics2D.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        return this.canvasBitmap;
    }

    public void dispose() {
        if (this.canvasBitmap != null) {
            this.canvasBitmap.dispose();
        }
        if (this.buffer != null && this.bufferOwned) {
            this.buffer.flush();
        }
        this.canvasBitmap = null;
        this.buffer = null;
    }
}

