/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.StatusHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class INIOutputter {
    FileWriter m_aOut;
    String m_sFilename;
    String m_sNamePrefix;
    String ls;

    public static INIOutputter create(String string, String string2, String string3, String string4) {
        FileHelper.makeDirectories("", string);
        INIOutputter iNIOutputter = new INIOutputter();
        String string5 = System.getProperty("file.separator");
        String string6 = string + string5 + string2;
        try {
            File file = new File(string6);
            iNIOutputter.m_aOut = new FileWriter(file.toString());
            iNIOutputter.ls = System.getProperty("line.separator");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            GlobalLogWriter.get().println("ERROR: Can't create INI Outputter");
            return null;
        }
        iNIOutputter.m_sFilename = string6;
        iNIOutputter.m_sNamePrefix = string3;
        return iNIOutputter;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public void createHeader() {
        try {
            this.m_aOut.write("; This file is automatically created by a convwatch run" + this.ls);
            this.m_aOut.write("; " + this.ls);
            this.m_aOut.write("; If you see this file in a browser you may have forgotten to set the follows in the property file" + this.ls);
            this.m_aOut.write("; DOC_COMPARATOR_HTML_OUTPUT_PREFIX=http://lla-1.germany/gfxcmp/cw.php?inifile=" + this.ls);
            this.m_aOut.write("; Please check the documentation if you got confused." + this.ls);
            this.m_aOut.write("; " + this.ls);
            this.m_aOut.write("; " + this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeSection(String string) {
        try {
            this.m_aOut.write("[" + string + "]" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeValue(String string, String string2) {
        try {
            this.m_aOut.write(string + "=" + string2 + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startSection(int n) {
        this.writeSection("page" + String.valueOf(n));
    }

    public void close() {
        try {
            this.m_aOut.flush();
            this.m_aOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkLine(StatusHelper statusHelper, boolean bl) {
        try {
            this.m_aOut.write("oldgfx=" + statusHelper.m_sOldGfx + this.ls);
            this.m_aOut.write("newgfx=" + statusHelper.m_sNewGfx + this.ls);
            this.m_aOut.write("diffgfx=" + statusHelper.m_sDiffGfx + this.ls);
            String string = String.valueOf(statusHelper.nPercent) + "%";
            if (statusHelper.nPercent > 0 && statusHelper.nPercent < 5) {
                string = string + " (less 5% is ok)";
            }
            this.m_aOut.write("percent=" + string + this.ls);
            if (statusHelper.m_sDiff_BM_Gfx == null) {
                this.m_aOut.write("BM=false" + this.ls);
            } else {
                this.m_aOut.write("BM=true" + this.ls);
                this.m_aOut.write("old_BM_gfx=" + statusHelper.m_sOld_BM_Gfx + this.ls);
                this.m_aOut.write("new_BM_gfx=" + statusHelper.m_sNew_BM_Gfx + this.ls);
                this.m_aOut.write("diff_BM_gfx=" + statusHelper.m_sDiff_BM_Gfx + this.ls);
                String string2 = String.valueOf(statusHelper.nPercent2) + "%";
                if (statusHelper.nPercent2 > 0 && statusHelper.nPercent2 < 5) {
                    string2 = string2 + " (less 5% is ok)";
                }
                this.m_aOut.write("percent2=" + string2 + this.ls);
            }
            this.writeResult(bl);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void writeResult(boolean bl) throws IOException {
        if (bl) {
            this.m_aOut.write("result=YES" + this.ls);
        } else {
            this.m_aOut.write("result=NO" + this.ls);
        }
    }

    public void checkDiffDiffLine(StatusHelper statusHelper, boolean bl) {
        try {
            this.m_aOut.write("oldgfx=" + statusHelper.m_sOldGfx + this.ls);
            this.m_aOut.write("newgfx=" + statusHelper.m_sNewGfx + this.ls);
            this.m_aOut.write("diffgfx=" + statusHelper.m_sDiffGfx + this.ls);
            String string = String.valueOf(statusHelper.nPercent) + "%";
            this.m_aOut.write("percent=" + string + this.ls);
            this.writeResult(bl);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

