/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.Boundary;
import com.sun.star.i18n.LineBreakHyphenationOptions;
import com.sun.star.i18n.LineBreakResults;
import com.sun.star.i18n.LineBreakUserOptions;
import com.sun.star.i18n.XBreakIterator;
import com.sun.star.lang.Locale;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XBreakIterator
extends MultiMethodTest {
    public XBreakIterator oObj = null;
    Locale locale = null;
    String UnicodeString = null;
    short wordType = 1;
    Vector vBounds = new Vector();
    Vector vSentenceStart = new Vector();
    private static String katakana = new String(new char[]{'\u30a1', '\u30a2'});
    private static String arrows = new String(new char[]{'\u2190', '\u2191'});
    private static String arabic = new String(new char[]{'\u0641', '\u0642'});
    boolean bCharBlockRes = true;
    Vector vCharBlockBounds = new Vector();
    Vector vCharBlockTypes = new Vector();

    protected void before() {
        this.locale = (Locale)this.tEnv.getObjRelation("Locale");
        if (this.locale == null) {
            throw new StatusException(Status.failed("Relation 'Locale' not found"));
        }
        this.UnicodeString = (String)this.tEnv.getObjRelation("UnicodeString");
        if (this.UnicodeString == null) {
            throw new StatusException(Status.failed("Relation 'UnicodeString' not found"));
        }
    }

    public void _nextCharacters() {
        short s = 0;
        int n = this.UnicodeString.length();
        int[][] nArrayArray = new int[][]{{1, 5000, n, n - 1}, {10, 6, 16, 6}};
        boolean bl = true;
        for (int i = 0; i < nArrayArray.length; ++i) {
            int[] nArray = new int[1];
            long l = this.oObj.nextCharacters(this.UnicodeString, nArrayArray[i][0], this.locale, s, nArrayArray[i][1], nArray);
            this.log.println("Expected result is: lRes = " + nArrayArray[i][2] + "; lDone = " + nArrayArray[i][3]);
            this.log.println("Actual result is: lRes = " + l + "; lDone = " + nArray[0]);
            bl = bl && l == (long)nArrayArray[i][2];
            bl = bl && nArray[0] == nArrayArray[i][3];
        }
        this.tRes.tested("nextCharacters()", bl);
    }

    public void _previousCharacters() {
        short s = 0;
        int[][] nArrayArray = new int[][]{{5, 5000, 0, 5}, {10, 6, 4, 6}};
        boolean bl = true;
        for (int i = 0; i < nArrayArray.length; ++i) {
            int[] nArray = new int[1];
            int n = this.oObj.previousCharacters(this.UnicodeString, nArrayArray[i][0], this.locale, s, nArrayArray[i][1], nArray);
            this.log.println("Expected result is: lRes = " + nArrayArray[i][2] + "; lDone = " + nArrayArray[i][3]);
            this.log.println("Actual result is: lRes = " + n + "; lDone = " + nArray[0]);
            bl = bl && n == nArrayArray[i][2];
            bl = bl && nArray[0] == nArrayArray[i][3];
        }
        this.tRes.tested("previousCharacters()", bl);
    }

    public void _nextWord() {
        int n = 0;
        while (n < this.UnicodeString.length() - 1) {
            Boundary boundary = this.oObj.nextWord(this.UnicodeString, n, this.locale, this.wordType);
            if (boundary.endPos - boundary.startPos > 3) {
                this.vBounds.add(boundary);
                this.log.println("Word " + this.vBounds.size() + "(" + boundary.startPos + "," + boundary.endPos + "): '" + this.UnicodeString.substring(boundary.startPos, boundary.endPos) + "'");
            }
            n = boundary.endPos - 1;
        }
        this.log.println("In text there are " + this.vBounds.size() + " words, if count from left to right");
        this.tRes.tested("nextWord()", true);
    }

    public void _previousWord() {
        this.requiredMethod("nextWord()");
        int n = this.UnicodeString.length() - 1;
        Vector<Boundary> vector = new Vector<Boundary>();
        while (n > 0) {
            Boundary boundary = this.oObj.previousWord(this.UnicodeString, n, this.locale, this.wordType);
            if (boundary.endPos - boundary.startPos > 3) {
                vector.add(boundary);
                this.log.println("Word " + vector.size() + "(" + boundary.startPos + "," + boundary.endPos + "): '" + this.UnicodeString.substring(boundary.startPos, boundary.endPos) + "'");
            }
            n = boundary.startPos;
        }
        this.log.println("In text there are " + vector.size() + " words, if count from right to left");
        this.tRes.tested("previousWord()", vector.size() == this.vBounds.size());
    }

    public void _getWordBoundary() {
        this.requiredMethod("nextWord()");
        boolean bl = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary boundary = (Boundary)this.vBounds.get(i);
            int n = (boundary.endPos - boundary.startPos) / 2 + boundary.startPos;
            Boundary boundary2 = this.oObj.getWordBoundary(this.UnicodeString, n, this.locale, this.wordType, true);
            this.log.println("Expected result is: startPos = " + boundary.startPos + "; endPos = " + boundary.endPos);
            this.log.println("Actual result is: startPos = " + boundary2.startPos + "; endPos = " + boundary2.endPos + " Word is: '" + this.UnicodeString.substring(boundary2.startPos, boundary2.endPos) + "'");
            bl = bl && boundary.startPos == boundary2.startPos;
            bl = bl && boundary.endPos == boundary2.endPos;
        }
        this.tRes.tested("getWordBoundary()", bl);
    }

    public void _getWordType() {
        this.requiredMethod("nextWord()");
        boolean bl = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary boundary = (Boundary)this.vBounds.get(i);
            int n = (boundary.endPos - boundary.startPos) / 2 + boundary.startPos;
            short s = this.oObj.getWordType(this.UnicodeString, n, this.locale);
            bl = bl && s == 0;
        }
        this.tRes.tested("getWordType()", bl);
    }

    public void _isBeginWord() {
        this.requiredMethod("nextWord()");
        boolean bl = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary boundary = (Boundary)this.vBounds.get(i);
            boolean bl2 = this.oObj.isBeginWord(this.UnicodeString, boundary.startPos, this.locale, (short)0);
            bl = bl && bl2;
            boolean bl3 = !this.oObj.isBeginWord(this.UnicodeString, boundary.startPos + 1, this.locale, (short)0);
            bl = bl && bl3;
            this.log.println("At position + " + boundary.startPos + " isBeginWord? " + bl2);
            this.log.println("At position + " + (boundary.startPos + 1) + " isBeginWord? " + !bl3);
        }
        this.tRes.tested("isBeginWord()", bl);
    }

    public void _isEndWord() {
        this.requiredMethod("nextWord()");
        boolean bl = true;
        for (int i = 0; i < this.vBounds.size(); ++i) {
            Boundary boundary = (Boundary)this.vBounds.get(i);
            boolean bl2 = this.oObj.isEndWord(this.UnicodeString, boundary.endPos, this.locale, (short)0);
            bl = bl && bl2;
            boolean bl3 = !this.oObj.isEndWord(this.UnicodeString, boundary.endPos - 1, this.locale, (short)0);
            bl = bl && bl3;
            this.log.println("At position + " + boundary.endPos + " isEndWord? " + bl2);
            this.log.println("At position + " + (boundary.endPos - 1) + " isEndWord? " + !bl3);
        }
        this.tRes.tested("isEndWord()", bl);
    }

    public void _beginOfSentence() {
        for (int i = 0; i < this.UnicodeString.length(); ++i) {
            Integer n = new Integer(this.oObj.beginOfSentence(this.UnicodeString, i, this.locale));
            if (n < 0 || this.vSentenceStart.contains(n)) continue;
            this.vSentenceStart.add(n);
            this.log.println("Sentence " + this.vSentenceStart.size() + " : start from position " + n);
        }
        boolean bl = this.oObj.beginOfSentence(this.UnicodeString, -10, this.locale) == -1;
        if (!(bl &= this.oObj.beginOfSentence(this.UnicodeString, this.UnicodeString.length() + 1, this.locale) == -1)) {
            this.log.println("When invalid position, returned value isn't equal to -1");
        }
        this.tRes.tested("beginOfSentence()", bl);
    }

    public void _endOfSentence() {
        int n;
        boolean bl = true;
        for (n = 0; n < this.vSentenceStart.size(); ++n) {
            int n2 = (Integer)this.vSentenceStart.get(n);
            int n3 = this.oObj.endOfSentence(this.UnicodeString, n2, this.locale);
            bl &= n3 > n2;
            this.log.println("Sentence " + n + " range is [" + n2 + ", " + n3 + "]");
        }
        n = this.oObj.endOfSentence(this.UnicodeString, -10, this.locale) == -1 ? 1 : 0;
        if ((n &= this.oObj.endOfSentence(this.UnicodeString, this.UnicodeString.length() + 1, this.locale) == -1 ? 1 : 0) == 0) {
            this.log.println("When invalid position, returned value isn't equal to -1");
        }
        this.tRes.tested("endOfSentence()", bl && n != 0);
    }

    public void _getLineBreak() {
        int n;
        boolean bl = true;
        LineBreakHyphenationOptions lineBreakHyphenationOptions = new LineBreakHyphenationOptions();
        LineBreakUserOptions lineBreakUserOptions = new LineBreakUserOptions();
        lineBreakUserOptions.applyForbiddenRules = false;
        lineBreakUserOptions.allowHyphenateEnglish = false;
        int n2 = 0;
        for (n = 0; n2 == 0 && n < this.UnicodeString.length(); ++n) {
            LineBreakResults lineBreakResults = this.oObj.getLineBreak(this.UnicodeString, n, this.locale, 0, lineBreakHyphenationOptions, lineBreakUserOptions);
            n2 = lineBreakResults.breakIndex;
        }
        boolean bl2 = bl = n2 <= n && n2 > 0;
        if (!bl) {
            this.log.println("The last position was: " + n + ", and the break position was: " + n2);
        }
        this.tRes.tested("getLineBreak()", bl);
    }

    public void _beginOfScript() {
        String string = "ab" + katakana;
        int n = this.oObj.beginOfScript(string, 3, (short)2);
        this.log.println("Position = " + n);
        this.tRes.tested("beginOfScript()", n == 2);
    }

    public void _endOfScript() {
        String string = "ab" + katakana + "cd";
        int n = this.oObj.endOfScript(string, 2, (short)2);
        this.log.println("Position = " + n);
        this.tRes.tested("endOfScript()", n == 4);
    }

    public void _nextScript() {
        String string = "ab" + katakana + "cd";
        int n = this.oObj.nextScript(string, 0, (short)1);
        this.log.println("Position = " + n);
        this.tRes.tested("nextScript()", n == 4);
    }

    public void _previousScript() {
        String string = "ab" + katakana + "cd";
        int n = this.oObj.previousScript(string, 5, (short)2);
        this.log.println("Position = " + n);
        this.tRes.tested("previousScript()", n == 2);
    }

    public void _getScriptType() {
        boolean bl = true;
        bl &= this.oObj.getScriptType("abcd", 0) == 1;
        bl &= this.oObj.getScriptType(katakana, 0) == 2;
        bl &= this.oObj.getScriptType(arabic, 0) == 3;
        this.tRes.tested("getScriptType()", bl &= this.oObj.getScriptType(arrows, 0) == 4);
    }

    protected short getCharBlockType(int n) {
        int n2 = 0;
        for (int n3 = 1; n3 < 31; n3 = (int)((short)(n3 + 1))) {
            if (this.oObj.beginOfCharBlock(this.UnicodeString, n, this.locale, (short)n3) == -1) continue;
            n2 = n3;
            n3 = 100;
        }
        return (short)n2;
    }

    /*
     * WARNING - void declaration
     */
    public void _beginOfCharBlock() {
        void var2_4;
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.UnicodeString.length() && n3 > -1) {
            short s = this.getCharBlockType(n3);
            n2 = this.oObj.beginOfCharBlock(this.UnicodeString, n3, this.locale, s);
            n3 = n = this.oObj.endOfCharBlock(this.UnicodeString, n3, this.locale, s);
            this.vCharBlockBounds.add(new Boundary(n2, n));
            this.log.println("" + this.vCharBlockBounds.size() + "). Bounds: [" + n2 + "," + n + "]; Type = " + s);
            this.vCharBlockTypes.add(new Short(s));
        }
        boolean bl = false;
        while (var2_4 < this.vCharBlockBounds.size() - 1) {
            n2 = ((Boundary)this.vCharBlockBounds.get((int)var2_4)).endPos;
            n = ((Boundary)this.vCharBlockBounds.get((int)(var2_4 + true))).startPos;
            this.bCharBlockRes &= n2 == n;
            ++var2_4;
        }
        this.log.println("Testing for no intersections : " + this.bCharBlockRes);
        int n4 = ((Boundary)this.vCharBlockBounds.get((int)0)).startPos;
        this.bCharBlockRes &= n4 == 0;
        n2 = ((Boundary)this.vCharBlockBounds.get((int)(this.vCharBlockBounds.size() - 1))).endPos;
        this.bCharBlockRes &= n2 == this.UnicodeString.length();
        this.log.println("Regions should starts with 0 and ends with " + this.UnicodeString.length());
        this.tRes.tested("beginOfCharBlock()", this.bCharBlockRes);
    }

    public void _endOfCharBlock() {
        this.requiredMethod("beginOfCharBlock()");
        this.tRes.tested("endOfCharBlock()", this.bCharBlockRes);
    }

    public void _nextCharBlock() {
        this.requiredMethod("beginOfCharBlock()");
        boolean bl = true;
        for (int i = 0; i < this.vCharBlockBounds.size(); ++i) {
            int n;
            Boundary boundary = (Boundary)this.vCharBlockBounds.get(i);
            Short s = (Short)this.vCharBlockTypes.get(i);
            if (boundary.startPos - 1 < 0 || (n = this.oObj.nextCharBlock(this.UnicodeString, boundary.startPos - 1, this.locale, s)) == boundary.startPos) continue;
            bl = false;
            this.log.println("nextCharBlock(UnicodeString, " + (boundary.startPos - 1) + ", locale, " + s + ") should return " + boundary.startPos);
            this.log.println("... and actual value is " + n);
        }
        this.tRes.tested("nextCharBlock()", bl);
    }

    public void _previousCharBlock() {
        this.requiredMethod("beginOfCharBlock()");
        boolean bl = true;
        for (int i = 0; i < this.vCharBlockBounds.size(); ++i) {
            Boundary boundary = (Boundary)this.vCharBlockBounds.get(i);
            Short s = (Short)this.vCharBlockTypes.get(i);
            int n = this.oObj.previousCharBlock(this.UnicodeString, boundary.endPos + 1, this.locale, s);
            if (n == boundary.startPos) continue;
            bl = false;
            this.log.println("previousCharBlock(UnicodeString, " + (boundary.endPos + 1) + ", locale, " + s + ") should return " + boundary.startPos);
            this.log.println("... and actual value is " + n);
        }
        this.tRes.tested("previousCharBlock()", bl);
    }
}

