/*
 * Decompiled with CFR 0.152.
 */
package ifc.i18n;

import com.sun.star.i18n.XExtendedIndexEntrySupplier;
import com.sun.star.lang.Locale;
import java.util.HashMap;
import lib.MultiMethodTest;

public class _XExtendedIndexEntrySupplier
extends MultiMethodTest {
    public XExtendedIndexEntrySupplier oObj;
    protected Locale[] locales = null;
    protected HashMap algorithms = new HashMap();

    public void _compareIndexEntry() {
        this.requiredMethod("getIndexKey()");
        Locale locale = new Locale("zh", "CN", "");
        String string = new String(new char[]{UnicodeStringPair.getUnicodeValue(0), UnicodeStringPair.getUnicodeValue(1)});
        String string2 = new String(new char[]{UnicodeStringPair.getUnicodeValue(1), UnicodeStringPair.getUnicodeValue(0)});
        short s = this.oObj.compareIndexEntry(string, "", locale, string, "", locale);
        short s2 = this.oObj.compareIndexEntry(string, "", locale, string2, "", locale);
        short s3 = this.oObj.compareIndexEntry(string2, "", locale, string, "", locale);
        this.tRes.tested("compareIndexEntry()", s == 0 && s2 + s3 == 0);
    }

    public void _getAlgorithmList() {
        this.requiredMethod("getLocaleList()");
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < this.locales.length; ++i) {
            String[] stringArray = this.oObj.getAlgorithmList(this.locales[i]);
            this.algorithms.put(new Integer(i), stringArray);
            bl2 = stringArray != null && stringArray.length > 0;
            System.out.println("Locale " + i + ": " + this.locales[i].Country + "," + this.locales[i].Language);
            for (int j = 0; j < stringArray.length; ++j) {
                System.out.println("\tAlgorithm " + j + ": " + stringArray[j]);
            }
            if (!bl2) {
                this.log.println("No Algorithm found for " + this.locales[i].Country + "," + this.locales[i].Language);
            }
            bl &= bl2;
        }
        this.tRes.tested("getAlgorithmList()", bl);
    }

    public void _getIndexKey() {
        this.requiredMethod("loadAlgorithm()");
        char[] cArray = new char[]{'\u4e00'};
        String string = new String(cArray);
        for (int i = 0; i < this.locales.length; ++i) {
            this.log.println("Language: " + this.locales[i].Language);
            for (int j = 0; j < this.algorithms.size(); ++j) {
                String[] stringArray = (String[])this.algorithms.get(new Integer(j));
                for (int k = 0; k < stringArray.length; ++k) {
                    this.log.println("\t Algorythm :" + stringArray[k]);
                    this.oObj.loadAlgorithm(this.locales[i], stringArray[k], 1);
                    this.log.println("\t\t Get: " + this.oObj.getIndexKey(string, "", this.locales[i]));
                }
            }
        }
        this.tRes.tested("getIndexKey()", true);
    }

    public void _getLocaleList() {
        this.locales = this.oObj.getLocaleList();
        this.tRes.tested("getLocaleList()", this.locales.length > 0);
    }

    public void _getPhoneticCandidate() {
        this.requiredMethod("getLocaleList()");
        boolean bl = true;
        Locale locale = new Locale("zh", "CN", "");
        for (int i = 0; i < UnicodeStringPair.getValCount(); ++i) {
            char[] cArray = new char[]{UnicodeStringPair.getUnicodeValue(i)};
            String string = this.oObj.getPhoneticCandidate(new String(cArray), locale);
            boolean bl2 = string.equals(UnicodeStringPair.getExpectedPhoneticString(i));
            if (!bl2) {
                this.log.println("Char: " + cArray[0] + " (" + cArray[0] + ")");
                this.log.println("Expected " + UnicodeStringPair.getExpectedPhoneticString(i));
                this.log.println("Getting " + string);
            }
            bl &= bl2;
        }
        this.tRes.tested("getPhoneticCandidate()", bl);
    }

    public void _loadAlgorithm() {
        this.requiredMethod("getAlgorithmList()");
        boolean bl = true;
        for (int i = 0; i < this.algorithms.size(); ++i) {
            String[] stringArray = (String[])this.algorithms.get(new Integer(i));
            this.log.println("loading algorithms for " + this.locales[i].Country + "," + this.locales[i].Language);
            for (int j = 0; j < stringArray.length; ++j) {
                this.log.println("\t Loading " + stringArray[j]);
                boolean bl2 = this.oObj.loadAlgorithm(this.locales[i], stringArray[j], 1);
                if (!bl2) {
                    this.log.println("\t ... didn't work - FAILED");
                } else {
                    this.log.println("\t ... worked - OK");
                }
                bl &= bl2;
            }
        }
        this.tRes.tested("loadAlgorithm()", bl);
    }

    public void _usePhoneticEntry() {
        this.requiredMethod("getLocaleList()");
        boolean bl = true;
        for (int i = 0; i < this.locales.length; ++i) {
            boolean bl2;
            boolean bl3 = false;
            if (this.locales[i].Language.equals("ja") || this.locales[i].Language.equals("ko") || this.locales[i].Language.equals("zh")) {
                bl3 = true;
            }
            boolean bl4 = bl2 = this.oObj.usePhoneticEntry(this.locales[i]) == bl3;
            if (!bl2) {
                this.log.println("Failure for language " + this.locales[i].Language);
                this.log.println("Expected " + bl3);
                this.log.println("Getting " + this.oObj.usePhoneticEntry(this.locales[i]));
            }
            bl &= bl2;
        }
        this.tRes.tested("usePhoneticEntry()", bl);
    }

    public static class UnicodeStringPair {
        static final int valCount = 78;
        static String[] sStringEquivalence = null;
        static char[] iUnicodeEquivalence = null;

        public static int getValCount() {
            return 78;
        }

        public static String getExpectedPhoneticString(int n) {
            if (n >= 78) {
                return null;
            }
            return sStringEquivalence[n];
        }

        public static char getUnicodeValue(int n) {
            if (n > 78) {
                return '\u0000';
            }
            return iUnicodeEquivalence[n];
        }

        private static void fillValues() {
            UnicodeStringPair.iUnicodeEquivalence[0] = 20049;
            UnicodeStringPair.sStringEquivalence[0] = "zhong";
            UnicodeStringPair.iUnicodeEquivalence[1] = 19968;
            UnicodeStringPair.sStringEquivalence[1] = "yi";
            UnicodeStringPair.iUnicodeEquivalence[2] = 19969;
            UnicodeStringPair.sStringEquivalence[2] = "ding";
            UnicodeStringPair.iUnicodeEquivalence[3] = 19970;
            UnicodeStringPair.sStringEquivalence[3] = "kao";
            UnicodeStringPair.iUnicodeEquivalence[4] = 19971;
            UnicodeStringPair.sStringEquivalence[4] = "qi";
            UnicodeStringPair.iUnicodeEquivalence[5] = 19972;
            UnicodeStringPair.sStringEquivalence[5] = "shang";
            UnicodeStringPair.iUnicodeEquivalence[6] = 19973;
            UnicodeStringPair.sStringEquivalence[6] = "xia";
            UnicodeStringPair.iUnicodeEquivalence[7] = 19975;
            UnicodeStringPair.sStringEquivalence[7] = "wan";
            UnicodeStringPair.iUnicodeEquivalence[8] = 19976;
            UnicodeStringPair.sStringEquivalence[8] = "zhang";
            UnicodeStringPair.iUnicodeEquivalence[9] = 19977;
            UnicodeStringPair.sStringEquivalence[9] = "san";
            UnicodeStringPair.iUnicodeEquivalence[10] = 19978;
            UnicodeStringPair.sStringEquivalence[10] = "shang";
            UnicodeStringPair.iUnicodeEquivalence[11] = 19979;
            UnicodeStringPair.sStringEquivalence[11] = "xia";
            UnicodeStringPair.iUnicodeEquivalence[12] = 19980;
            UnicodeStringPair.sStringEquivalence[12] = "ji";
            UnicodeStringPair.iUnicodeEquivalence[13] = 19981;
            UnicodeStringPair.sStringEquivalence[13] = "bu";
            UnicodeStringPair.iUnicodeEquivalence[14] = 19982;
            UnicodeStringPair.sStringEquivalence[14] = "yu";
            UnicodeStringPair.iUnicodeEquivalence[15] = 19983;
            UnicodeStringPair.sStringEquivalence[15] = "mian";
            UnicodeStringPair.iUnicodeEquivalence[16] = 19984;
            UnicodeStringPair.sStringEquivalence[16] = "gai";
            UnicodeStringPair.iUnicodeEquivalence[17] = 19985;
            UnicodeStringPair.sStringEquivalence[17] = "chou";
            UnicodeStringPair.iUnicodeEquivalence[18] = 19986;
            UnicodeStringPair.sStringEquivalence[18] = "chou";
            UnicodeStringPair.iUnicodeEquivalence[19] = 19987;
            UnicodeStringPair.sStringEquivalence[19] = "zhuan";
            UnicodeStringPair.iUnicodeEquivalence[20] = 19988;
            UnicodeStringPair.sStringEquivalence[20] = "qie";
            UnicodeStringPair.iUnicodeEquivalence[21] = 19989;
            UnicodeStringPair.sStringEquivalence[21] = "pi";
            UnicodeStringPair.iUnicodeEquivalence[22] = 19990;
            UnicodeStringPair.sStringEquivalence[22] = "shi";
            UnicodeStringPair.iUnicodeEquivalence[23] = 19991;
            UnicodeStringPair.sStringEquivalence[23] = "shi";
            UnicodeStringPair.iUnicodeEquivalence[24] = 19992;
            UnicodeStringPair.sStringEquivalence[24] = "qiu";
            UnicodeStringPair.iUnicodeEquivalence[25] = 19993;
            UnicodeStringPair.sStringEquivalence[25] = "bing";
            UnicodeStringPair.iUnicodeEquivalence[26] = 19994;
            UnicodeStringPair.sStringEquivalence[26] = "ye";
            UnicodeStringPair.iUnicodeEquivalence[27] = 19995;
            UnicodeStringPair.sStringEquivalence[27] = "cong";
            UnicodeStringPair.iUnicodeEquivalence[28] = 19996;
            UnicodeStringPair.sStringEquivalence[28] = "dong";
            UnicodeStringPair.iUnicodeEquivalence[29] = 19997;
            UnicodeStringPair.sStringEquivalence[29] = "si";
            UnicodeStringPair.iUnicodeEquivalence[30] = 19998;
            UnicodeStringPair.sStringEquivalence[30] = "cheng";
            UnicodeStringPair.iUnicodeEquivalence[31] = 19999;
            UnicodeStringPair.sStringEquivalence[31] = "diu";
            UnicodeStringPair.iUnicodeEquivalence[32] = 20000;
            UnicodeStringPair.sStringEquivalence[32] = "qiu";
            UnicodeStringPair.iUnicodeEquivalence[33] = 20001;
            UnicodeStringPair.sStringEquivalence[33] = "liang";
            UnicodeStringPair.iUnicodeEquivalence[34] = 20002;
            UnicodeStringPair.sStringEquivalence[34] = "diu";
            UnicodeStringPair.iUnicodeEquivalence[35] = 20003;
            UnicodeStringPair.sStringEquivalence[35] = "you";
            UnicodeStringPair.iUnicodeEquivalence[36] = 20004;
            UnicodeStringPair.sStringEquivalence[36] = "liang";
            UnicodeStringPair.iUnicodeEquivalence[37] = 20005;
            UnicodeStringPair.sStringEquivalence[37] = "yan";
            UnicodeStringPair.iUnicodeEquivalence[38] = 20006;
            UnicodeStringPair.sStringEquivalence[38] = "bing";
            UnicodeStringPair.iUnicodeEquivalence[39] = 20007;
            UnicodeStringPair.sStringEquivalence[39] = "sang";
            UnicodeStringPair.iUnicodeEquivalence[40] = 20008;
            UnicodeStringPair.sStringEquivalence[40] = "shu";
            UnicodeStringPair.iUnicodeEquivalence[41] = 20009;
            UnicodeStringPair.sStringEquivalence[41] = "jiu";
            UnicodeStringPair.iUnicodeEquivalence[42] = 20010;
            UnicodeStringPair.sStringEquivalence[42] = "ge";
            UnicodeStringPair.iUnicodeEquivalence[43] = 20011;
            UnicodeStringPair.sStringEquivalence[43] = "ya";
            UnicodeStringPair.iUnicodeEquivalence[44] = 20012;
            UnicodeStringPair.sStringEquivalence[44] = "qiang";
            UnicodeStringPair.iUnicodeEquivalence[45] = 20013;
            UnicodeStringPair.sStringEquivalence[45] = "zhong";
            UnicodeStringPair.iUnicodeEquivalence[46] = 20014;
            UnicodeStringPair.sStringEquivalence[46] = "ji";
            UnicodeStringPair.iUnicodeEquivalence[47] = 20015;
            UnicodeStringPair.sStringEquivalence[47] = "jie";
            UnicodeStringPair.iUnicodeEquivalence[48] = 20016;
            UnicodeStringPair.sStringEquivalence[48] = "feng";
            UnicodeStringPair.iUnicodeEquivalence[49] = 20017;
            UnicodeStringPair.sStringEquivalence[49] = "guan";
            UnicodeStringPair.iUnicodeEquivalence[50] = 20018;
            UnicodeStringPair.sStringEquivalence[50] = "chuan";
            UnicodeStringPair.iUnicodeEquivalence[51] = 20019;
            UnicodeStringPair.sStringEquivalence[51] = "chan";
            UnicodeStringPair.iUnicodeEquivalence[52] = 20020;
            UnicodeStringPair.sStringEquivalence[52] = "lin";
            UnicodeStringPair.iUnicodeEquivalence[53] = 20021;
            UnicodeStringPair.sStringEquivalence[53] = "zhuo";
            UnicodeStringPair.iUnicodeEquivalence[54] = 20022;
            UnicodeStringPair.sStringEquivalence[54] = "zhu";
            UnicodeStringPair.iUnicodeEquivalence[55] = 20024;
            UnicodeStringPair.sStringEquivalence[55] = "wan";
            UnicodeStringPair.iUnicodeEquivalence[56] = 20025;
            UnicodeStringPair.sStringEquivalence[56] = "dan";
            UnicodeStringPair.iUnicodeEquivalence[57] = 20026;
            UnicodeStringPair.sStringEquivalence[57] = "wei";
            UnicodeStringPair.iUnicodeEquivalence[58] = 20027;
            UnicodeStringPair.sStringEquivalence[58] = "zhu";
            UnicodeStringPair.iUnicodeEquivalence[59] = 20028;
            UnicodeStringPair.sStringEquivalence[59] = "jing";
            UnicodeStringPair.iUnicodeEquivalence[60] = 20029;
            UnicodeStringPair.sStringEquivalence[60] = "li";
            UnicodeStringPair.iUnicodeEquivalence[61] = 20030;
            UnicodeStringPair.sStringEquivalence[61] = "ju";
            UnicodeStringPair.iUnicodeEquivalence[62] = 20031;
            UnicodeStringPair.sStringEquivalence[62] = "pie";
            UnicodeStringPair.iUnicodeEquivalence[63] = 20032;
            UnicodeStringPair.sStringEquivalence[63] = "fu";
            UnicodeStringPair.iUnicodeEquivalence[64] = 20033;
            UnicodeStringPair.sStringEquivalence[64] = "yi";
            UnicodeStringPair.iUnicodeEquivalence[65] = 20034;
            UnicodeStringPair.sStringEquivalence[65] = "yi";
            UnicodeStringPair.iUnicodeEquivalence[66] = 20035;
            UnicodeStringPair.sStringEquivalence[66] = "nai";
            UnicodeStringPair.iUnicodeEquivalence[67] = 20037;
            UnicodeStringPair.sStringEquivalence[67] = "jiu";
            UnicodeStringPair.iUnicodeEquivalence[68] = 20038;
            UnicodeStringPair.sStringEquivalence[68] = "jiu";
            UnicodeStringPair.iUnicodeEquivalence[69] = 20039;
            UnicodeStringPair.sStringEquivalence[69] = "tuo";
            UnicodeStringPair.iUnicodeEquivalence[70] = 20040;
            UnicodeStringPair.sStringEquivalence[70] = "me";
            UnicodeStringPair.iUnicodeEquivalence[71] = 20041;
            UnicodeStringPair.sStringEquivalence[71] = "yi";
            UnicodeStringPair.iUnicodeEquivalence[72] = 20043;
            UnicodeStringPair.sStringEquivalence[72] = "zhi";
            UnicodeStringPair.iUnicodeEquivalence[73] = 20044;
            UnicodeStringPair.sStringEquivalence[73] = "wu";
            UnicodeStringPair.iUnicodeEquivalence[74] = 20045;
            UnicodeStringPair.sStringEquivalence[74] = "zha";
            UnicodeStringPair.iUnicodeEquivalence[75] = 20046;
            UnicodeStringPair.sStringEquivalence[75] = "hu";
            UnicodeStringPair.iUnicodeEquivalence[76] = 20047;
            UnicodeStringPair.sStringEquivalence[76] = "fa";
            UnicodeStringPair.iUnicodeEquivalence[77] = 20048;
            UnicodeStringPair.sStringEquivalence[77] = "le";
        }

        static {
            sStringEquivalence = new String[78];
            iUnicodeEquivalence = new char[78];
            UnicodeStringPair.fillValues();
        }
    }
}

