/*
 * Decompiled with CFR 0.152.
 */
package ifc.sdbc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.sdbc.DriverPropertyInfo;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XDriver;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XDriver
extends MultiMethodTest {
    public XDriver oObj = null;
    String url = null;
    String wrongUrl = null;
    String nbu = null;
    PropertyValue[] info = null;

    protected void before() {
        this.nbu = (String)this.tEnv.getObjRelation("NoBadURL");
        this.url = (String)this.tEnv.getObjRelation("XDriver.URL");
        if (this.url == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.URL'"));
        }
        this.wrongUrl = (String)this.tEnv.getObjRelation("XDriver.UNSUITABLE_URL");
        if (this.wrongUrl == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.WRONG_URL'"));
        }
        this.info = (PropertyValue[])this.tEnv.getObjRelation("XDriver.INFO");
        if (this.info == null) {
            throw new StatusException(Status.failed("Couldn't get relation 'XDriver.INFO'"));
        }
    }

    public void _connect() {
        Object object;
        boolean bl = true;
        try {
            this.log.println("Trying to connect to " + this.url);
            object = this.oObj.connect(this.url, this.info);
            bl = object != null;
            this.log.println("Connected? " + bl);
            this.log.println("Trying to connect to " + this.wrongUrl);
            object = this.oObj.connect(this.wrongUrl, this.info);
            this.log.println("Connected? " + !(bl &= object == null));
        }
        catch (SQLException sQLException) {
            this.log.println("Unexpected exception");
            bl &= false;
        }
        if (this.nbu == null) {
            try {
                object = this.url + "bla";
                this.log.println("Trying to connect to " + (String)object);
                this.oObj.connect((String)object, this.info);
                bl &= false;
                this.log.println("Expected exception isn't thrown");
            }
            catch (SQLException sQLException) {
                this.log.println("Expected exception");
                bl &= true;
            }
        }
        this.tRes.tested("connect()", bl);
    }

    public void _acceptsURL() {
        boolean bl = false;
        try {
            bl = this.oObj.acceptsURL(this.url);
            this.log.println("Accepts " + this.url + "? " + bl);
            this.log.println("Accepts " + this.wrongUrl + "? " + !(bl &= !this.oObj.acceptsURL(this.wrongUrl)));
        }
        catch (SQLException sQLException) {
            this.log.println("Unexpected exception");
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("acceptsURL()", bl);
    }

    public void _getPropertyInfo() {
        this.requiredMethod("acceptsURL()");
        boolean bl = false;
        DriverPropertyInfo[] driverPropertyInfoArray = null;
        try {
            driverPropertyInfoArray = this.oObj.getPropertyInfo(this.url, this.info);
        }
        catch (SQLException sQLException) {
            this.log.println("Unexpected exception");
            sQLException.printStackTrace(this.log);
            bl = false;
        }
        if (driverPropertyInfoArray != null) {
            bl = true;
            this.log.println("Driver properties info:");
            for (int i = 0; i < driverPropertyInfoArray.length; ++i) {
                this.log.println("Property: " + driverPropertyInfoArray[i].Name);
                this.log.println("Description: " + driverPropertyInfoArray[i].Description);
                this.log.println("IsRequired? " + driverPropertyInfoArray[i].IsRequired);
                this.log.println("Value: " + driverPropertyInfoArray[i].Value);
                this.log.println("Choices: ");
                for (int j = 0; j < driverPropertyInfoArray[i].Choices.length; ++j) {
                    this.log.println("\t" + driverPropertyInfoArray[i].Choices[j]);
                }
            }
        }
        this.tRes.tested("getPropertyInfo()", bl);
    }

    public void _getMajorVersion() {
        int n = this.oObj.getMajorVersion();
        boolean bl = n >= 1;
        this.log.println("Major version " + n);
        this.tRes.tested("getMajorVersion()", bl);
    }

    public void _getMinorVersion() {
        int n = this.oObj.getMinorVersion();
        boolean bl = n >= 0;
        this.log.println("Minor version " + n);
        this.tRes.tested("getMinorVersion()", bl);
    }
}

