/*
 * Decompiled with CFR 0.152.
 */
package ifc.ucb;

import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.ContentProviderInfo;
import com.sun.star.ucb.DuplicateProviderException;
import com.sun.star.ucb.XContentProvider;
import com.sun.star.ucb.XContentProviderManager;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import lib.MultiMethodTest;
import lib.Status;
import lib.StatusException;

public class _XContentProviderManager
extends MultiMethodTest {
    public XContentProviderManager oObj;
    static final String myScheme = "test-scheme";
    XContentProvider firstContentProvider;
    XContentProvider contentProvider;
    ContentProviderInfo[] initialProvidersInfo;
    static /* synthetic */ Class class$com$sun$star$ucb$XContentProvider;

    public void before() {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)this.tParam.getMSF();
        this.log.println("creating testing content providers");
        try {
            this.firstContentProvider = (XContentProvider)UnoRuntime.queryInterface(class$com$sun$star$ucb$XContentProvider == null ? (class$com$sun$star$ucb$XContentProvider = _XContentProviderManager.class$("com.sun.star.ucb.XContentProvider")) : class$com$sun$star$ucb$XContentProvider, xMultiServiceFactory.createInstance("com.sun.star.ucb.FileContentProvider"));
            this.contentProvider = (XContentProvider)UnoRuntime.queryInterface(class$com$sun$star$ucb$XContentProvider == null ? (class$com$sun$star$ucb$XContentProvider = _XContentProviderManager.class$("com.sun.star.ucb.XContentProvider")) : class$com$sun$star$ucb$XContentProvider, xMultiServiceFactory.createInstance("com.sun.star.ucb.FileContentProvider"));
        }
        catch (Exception exception) {
            this.log.println("Can't create content providers " + exception.getMessage());
            exception.printStackTrace(this.log);
            throw new StatusException("Unexpected exception", exception);
        }
    }

    public void _registerContentProvider() {
        XContentProvider xContentProvider;
        this.initialProvidersInfo = this.oObj.queryContentProviders();
        this.log.println("registering the first provider");
        try {
            this.oObj.registerContentProvider(this.firstContentProvider, myScheme, false);
        }
        catch (DuplicateProviderException duplicateProviderException) {
            this.log.println("Unexpected exception thrown " + duplicateProviderException.getMessage());
            duplicateProviderException.printStackTrace(this.log);
            throw new StatusException("Unexpected exception ", duplicateProviderException);
        }
        this.log.println("registering the second provider in non-replacing mode");
        try {
            this.oObj.registerContentProvider(this.contentProvider, myScheme, false);
            Status.failed("registerContentProvider(.., .., false)");
        }
        catch (DuplicateProviderException duplicateProviderException) {
            this.log.println("DuplicateProviderException thrown - OK");
        }
        this.log.println("registering the second provider in the replace mode");
        try {
            xContentProvider = this.oObj.registerContentProvider(this.contentProvider, myScheme, true);
        }
        catch (DuplicateProviderException duplicateProviderException) {
            this.log.println("Unexpected exception thrown " + duplicateProviderException.getMessage());
            duplicateProviderException.printStackTrace(this.log);
            throw new StatusException("Unexpected exception ", duplicateProviderException);
        }
        this.tRes.tested("registerContentProvider()", xContentProvider.equals(this.firstContentProvider));
    }

    public void _queryContentProviders() {
        this.executeMethod("registerContentProvider()");
        ContentProviderInfo[] contentProviderInfoArray = this.oObj.queryContentProviders();
        this.tRes.tested("queryContentProviders()", contentProviderInfoArray.length == this.initialProvidersInfo.length + 1);
    }

    public void _queryContentProvider() {
        this.executeMethod("registerContentProvider()");
        XContentProvider xContentProvider = this.oObj.queryContentProvider("http://www.sun.com");
        this.log.println("finding queryContentProvider() result");
        boolean bl = false;
        ContentProviderInfo[] contentProviderInfoArray = this.oObj.queryContentProviders();
        for (int i = 0; i < contentProviderInfoArray.length; ++i) {
            if (!xContentProvider.equals(contentProviderInfoArray[i].ContentProvider)) continue;
            bl = true;
            break;
        }
        this.tRes.tested("queryContentProvider()", bl);
    }

    public void _deregisterContentProvider() {
        this.executeMethod("queryContentProvider()");
        this.executeMethod("queryContentProviders()");
        this.requiredMethod("registerContentProvider()");
        this.log.println("deregistering the second provider");
        this.oObj.deregisterContentProvider(this.contentProvider, myScheme);
        XContentProvider xContentProvider = this.oObj.queryContentProvider(myScheme);
        this.log.println("deregistering the first provider");
        this.oObj.deregisterContentProvider(this.firstContentProvider, myScheme);
        xContentProvider = this.oObj.queryContentProvider(myScheme);
        this.tRes.tested("deregisterContentProvider()", xContentProvider == null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

