/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XChild;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XHierarchicalNameContainer;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XFormDocumentsSupplier;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdb.XQueriesSupplier;
import com.sun.star.sdb.XQueryDefinitionsSupplier;
import com.sun.star.sdb.XReportDocumentsSupplier;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XDataSource;
import com.sun.star.sdbc.XDatabaseMetaData;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.common.SystemDialog;
import com.sun.star.wizards.db.SQLQueryComposer;
import com.sun.star.wizards.db.TypeInspector;
import java.util.Vector;

public class DBMetaData {
    public XNameAccess xTableNames;
    public XNameAccess xQueryNames;
    private XInteractionHandler oInteractionHandler;
    private XNameAccess xNameAccess;
    private XInterface xDatabaseContext;
    public XDatabaseMetaData xDBMetaData;
    public XDataSource xDataSource;
    public XOfficeDatabaseDocument xModel;
    private XCompletedConnection xCompleted;
    public XPropertySet xDataSourcePropertySet;
    private int[] nDataTypes = null;
    private XWindowPeer xWindowPeer;
    public String[] DataSourceNames;
    public String[] CommandNames;
    public String[] TableNames = new String[0];
    public String[] QueryNames = new String[0];
    public Vector CommandObjects = new Vector(1);
    public int[][] WidthList;
    public int[] NumericTypes;
    public int[] BinaryTypes;
    public Locale aLocale;
    public int[] CommandTypes;
    public String DataSourceName;
    public XConnection DBConnection;
    public XMultiServiceFactory xMSF;
    public XComponent xConnectionComponent;
    public SQLQueryComposer oSQLQueryComposer;
    int iMaxColumnsInSelect;
    int iMaxColumnsInGroupBy;
    int iMaxColumnsInTable;
    int iMaxColumnNameLength = -1;
    int iMaxTableNameLength = -1;
    private boolean bPasswordIsRequired;
    private boolean bFormatKeysareset = false;
    final int NOLIMIT = 9999999;
    final int RID_DB_COMMON = 1000;
    final int INVALID = 9999999;
    public TypeInspector oTypeInspector;
    private PropertyValue[] aInfoPropertyValues = null;
    private boolean bisSQL92CheckEnabled = false;
    private NumberFormatter oNumberFormatter = null;
    private long lDateCorrection = 9999999L;
    private boolean bdisposeConnection = false;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatsSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$task$XInteractionHandler;
    static /* synthetic */ Class class$com$sun$star$sdbcx$XColumnsSupplier;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$sdb$XQueriesSupplier;
    static /* synthetic */ Class class$com$sun$star$sdbcx$XTablesSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XChild;
    static /* synthetic */ Class class$com$sun$star$sdbc$XDataSource;
    static /* synthetic */ Class class$com$sun$star$sdb$XDocumentDataSource;
    static /* synthetic */ Class class$com$sun$star$sdb$XCompletedConnection;
    static /* synthetic */ Class class$com$sun$star$sdbc$XConnection;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$sdb$XQueryDefinitionsSupplier;
    static /* synthetic */ Class class$com$sun$star$lang$XSingleServiceFactory;
    static /* synthetic */ Class class$com$sun$star$container$XNameContainer;
    static /* synthetic */ Class class$com$sun$star$sdb$XReportDocumentsSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XHierarchicalNameAccess;
    static /* synthetic */ Class class$com$sun$star$sdb$XFormDocumentsSupplier;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$util$XCloseable;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$container$XHierarchicalNameContainer;
    static /* synthetic */ Class class$com$sun$star$ucb$XSimpleFileAccess;
    static /* synthetic */ Class class$com$sun$star$frame$XComponentLoader;
    static /* synthetic */ Class class$com$sun$star$sdbc$XRow;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$lang$XInitialization;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XExecutableDialog;

    public DBMetaData(XMultiServiceFactory xMultiServiceFactory) {
        this.getInterfaces(xMultiServiceFactory);
        this.InitializeWidthList();
    }

    public DBMetaData(XMultiServiceFactory xMultiServiceFactory, Locale locale, NumberFormatter numberFormatter) {
        this.oNumberFormatter = numberFormatter;
        this.aLocale = locale;
        this.getInterfaces(xMultiServiceFactory);
        this.InitializeWidthList();
    }

    public NumberFormatter getNumberFormatter() {
        if (this.oNumberFormatter == null) {
            try {
                XNumberFormatsSupplier xNumberFormatsSupplier = (XNumberFormatsSupplier)AnyConverter.toObject((Class)(class$com$sun$star$util$XNumberFormatsSupplier == null ? (class$com$sun$star$util$XNumberFormatsSupplier = DBMetaData.class$("com.sun.star.util.XNumberFormatsSupplier")) : class$com$sun$star$util$XNumberFormatsSupplier), (Object)this.xDataSourcePropertySet.getPropertyValue("NumberFormatsSupplier"));
                this.aLocale = Configuration.getOfficeLocale(this.xMSF);
                this.oNumberFormatter = new NumberFormatter(this.xMSF, xNumberFormatsSupplier, this.aLocale);
                this.lDateCorrection = this.oNumberFormatter.getNullDateCorrection();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
        return this.oNumberFormatter;
    }

    public long getNullDateCorrection() {
        if (this.lDateCorrection == 9999999L) {
            if (this.oNumberFormatter == null) {
                this.oNumberFormatter = this.getNumberFormatter();
            }
            this.lDateCorrection = this.oNumberFormatter.getNullDateCorrection();
        }
        return this.lDateCorrection;
    }

    void getInterfaces(XMultiServiceFactory xMultiServiceFactory) {
        try {
            this.xMSF = xMultiServiceFactory;
            this.xDatabaseContext = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.sdb.DatabaseContext");
            this.xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = DBMetaData.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)this.xDatabaseContext);
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.sdb.InteractionHandler");
            this.oInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface((Class)(class$com$sun$star$task$XInteractionHandler == null ? (class$com$sun$star$task$XInteractionHandler = DBMetaData.class$("com.sun.star.task.XInteractionHandler")) : class$com$sun$star$task$XInteractionHandler), (Object)xInterface);
            this.DataSourceNames = this.xNameAccess.getElementNames();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void setCommandTypes() {
        int n = JavaTools.getArraylength(this.TableNames);
        int n2 = JavaTools.getArraylength(this.QueryNames);
        int n3 = n + n2;
        this.CommandTypes = new int[n3];
        if (n > 0) {
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                this.CommandTypes[n4] = 0;
            }
            int n5 = n4;
            for (n4 = 0; n4 < n2; ++n4) {
                this.CommandTypes[n5] = 1;
                ++n5;
            }
        }
    }

    public boolean hasTableByName(String string) {
        this.getTableNames();
        return this.xTableNames.hasByName(string);
    }

    public void setTableByName(String string) {
        CommandObject commandObject = new CommandObject(string, 0);
        this.CommandObjects.addElement(commandObject);
    }

    public CommandObject getTableByName(String string) {
        return this.getCommandByName(string, 0);
    }

    public CommandObject getQueryByName(String string) {
        return this.getCommandByName(string, 1);
    }

    public CommandObject getCommandByName(String string, int n) {
        CommandObject commandObject = null;
        for (int i = 0; i < this.CommandObjects.size(); ++i) {
            commandObject = (CommandObject)this.CommandObjects.elementAt(i);
            if (!commandObject.Name.equals(string) || commandObject.CommandType != n) continue;
            return commandObject;
        }
        if (commandObject == null) {
            commandObject = new CommandObject(string, n);
            this.CommandObjects.addElement(commandObject);
        }
        return commandObject;
    }

    public void setQueryByName(String string) {
        CommandObject commandObject = new CommandObject(string, 1);
        this.CommandObjects.addElement(commandObject);
    }

    public void setCommandNames() {
        this.getTableNames();
        XQueriesSupplier xQueriesSupplier = (XQueriesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XQueriesSupplier == null ? (class$com$sun$star$sdb$XQueriesSupplier = DBMetaData.class$("com.sun.star.sdb.XQueriesSupplier")) : class$com$sun$star$sdb$XQueriesSupplier), (Object)this.DBConnection);
        this.xQueryNames = xQueriesSupplier.getQueries();
        this.QueryNames = this.xQueryNames.getElementNames();
    }

    public String[] getTableNames() {
        if (this.TableNames != null && this.TableNames.length > 0) {
            return this.TableNames;
        }
        XTablesSupplier xTablesSupplier = (XTablesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbcx$XTablesSupplier == null ? (class$com$sun$star$sdbcx$XTablesSupplier = DBMetaData.class$("com.sun.star.sdbcx.XTablesSupplier")) : class$com$sun$star$sdbcx$XTablesSupplier), (Object)this.DBConnection);
        this.xTableNames = xTablesSupplier.getTables();
        this.TableNames = this.xTableNames.getElementNames();
        return this.TableNames;
    }

    void InitializeWidthList() {
        this.WidthList = new int[17][2];
        this.WidthList[0][0] = -7;
        this.WidthList[1][0] = 16;
        this.WidthList[2][0] = -6;
        this.WidthList[3][0] = -5;
        this.WidthList[4][0] = -1;
        this.WidthList[5][0] = 1;
        this.WidthList[6][0] = 2;
        this.WidthList[7][0] = 3;
        this.WidthList[8][0] = 4;
        this.WidthList[9][0] = 5;
        this.WidthList[10][0] = 6;
        this.WidthList[11][0] = 7;
        this.WidthList[12][0] = 8;
        this.WidthList[13][0] = 12;
        this.WidthList[14][0] = 91;
        this.WidthList[15][0] = 92;
        this.WidthList[16][0] = 93;
        this.NumericTypes = new int[9];
        this.NumericTypes[0] = -6;
        this.NumericTypes[1] = -5;
        this.NumericTypes[2] = 2;
        this.NumericTypes[3] = 3;
        this.NumericTypes[4] = 4;
        this.NumericTypes[5] = 5;
        this.NumericTypes[6] = 6;
        this.NumericTypes[7] = 7;
        this.NumericTypes[8] = 8;
        this.BinaryTypes = new int[12];
        this.BinaryTypes[0] = -2;
        this.BinaryTypes[1] = -3;
        this.BinaryTypes[2] = -4;
        this.BinaryTypes[3] = 2004;
        this.BinaryTypes[4] = 0;
        this.BinaryTypes[5] = 2000;
        this.BinaryTypes[6] = 2001;
        this.BinaryTypes[7] = 2002;
        this.BinaryTypes[8] = 2003;
        this.BinaryTypes[9] = 2005;
        this.BinaryTypes[10] = 2006;
        this.BinaryTypes[11] = 1111;
    }

    public boolean isBinaryDataType(int n) {
        if (this.NumericTypes == null) {
            this.InitializeWidthList();
        }
        return JavaTools.FieldInIntTable(this.BinaryTypes, n) > -1;
    }

    public int getMaxTablesInSelect() {
        try {
            int n = this.xDBMetaData.getMaxTablesInSelect();
            if (n == 0) {
                this.getClass();
                return 9999999;
            }
            return n;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            return -1;
        }
    }

    public int getMaxColumnsInSelect() {
        return this.iMaxColumnsInSelect;
    }

    public int getMaxColumnsInGroupBy() {
        return this.iMaxColumnsInGroupBy;
    }

    private void setMaxColumnsInSelect() throws SQLException {
        this.iMaxColumnsInSelect = this.xDBMetaData.getMaxColumnsInSelect();
        if (this.iMaxColumnsInSelect == 0) {
            this.getClass();
            this.iMaxColumnsInSelect = 9999999;
        }
    }

    private void setMaxColumnsInGroupBy() throws SQLException {
        this.iMaxColumnsInGroupBy = this.xDBMetaData.getMaxColumnsInGroupBy();
        if (this.iMaxColumnsInGroupBy == 0) {
            this.getClass();
            this.iMaxColumnsInGroupBy = 9999999;
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        this.iMaxColumnsInTable = this.xDBMetaData.getMaxColumnsInTable();
        if (this.iMaxColumnsInTable == 0) {
            this.getClass();
            this.iMaxColumnsInTable = 9999999;
        }
        return this.iMaxColumnsInTable;
    }

    private void getDataSourceObjects() throws Exception {
        try {
            this.xDBMetaData = this.DBConnection.getMetaData();
            XChild xChild = (XChild)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XChild == null ? (class$com$sun$star$container$XChild = DBMetaData.class$("com.sun.star.container.XChild")) : class$com$sun$star$container$XChild), (Object)this.DBConnection);
            Object object = xChild.getParent();
            this.getDataSourceInterfaces();
            this.setMaxColumnsInGroupBy();
            this.setMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
        }
    }

    public boolean isSQL92CheckEnabled() {
        try {
            if (this.aInfoPropertyValues == null) {
                this.aInfoPropertyValues = (PropertyValue[])AnyConverter.toArray((Object)this.xDataSourcePropertySet.getPropertyValue("Info"));
                if (Properties.hasPropertyValue(this.aInfoPropertyValues, "EnableSQL92Check")) {
                    this.bisSQL92CheckEnabled = AnyConverter.toBoolean((Object)Properties.getPropertyValue(this.aInfoPropertyValues, "EnableSQL92Check"));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.bisSQL92CheckEnabled;
    }

    public String verifyName(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        if (this.isSQL92CheckEnabled()) {
            return Desktop.removeSpecialCharacters(this.xMSF, Configuration.getOfficeLocale(this.xMSF), string);
        }
        return string;
    }

    private void setDataSourceByName(String string, boolean bl) {
        try {
            this.DataSourceName = string;
            Object object = this.xNameAccess.getByName(this.DataSourceName);
            this.xDataSource = (XDataSource)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbc$XDataSource == null ? (class$com$sun$star$sdbc$XDataSource = DBMetaData.class$("com.sun.star.sdbc.XDataSource")) : class$com$sun$star$sdbc$XDataSource), (Object)object);
            this.getDataSourceInterfaces();
            XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XDocumentDataSource == null ? (class$com$sun$star$sdb$XDocumentDataSource = DBMetaData.class$("com.sun.star.sdb.XDocumentDataSource")) : class$com$sun$star$sdb$XDocumentDataSource), (Object)this.xDataSource);
            if (xDocumentDataSource != null) {
                this.xModel = xDocumentDataSource.getDatabaseDocument();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void getDataSourceInterfaces() throws Exception {
        this.xCompleted = (XCompletedConnection)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XCompletedConnection == null ? (class$com$sun$star$sdb$XCompletedConnection = DBMetaData.class$("com.sun.star.sdb.XCompletedConnection")) : class$com$sun$star$sdb$XCompletedConnection), (Object)this.xDataSource);
        this.xDataSourcePropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBMetaData.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xDataSource);
        this.bPasswordIsRequired = (Boolean)this.xDataSourcePropertySet.getPropertyValue("IsPasswordRequired");
    }

    public boolean getConnection(PropertyValue[] propertyValueArray) {
        try {
            XConnection xConnection = null;
            if (Properties.hasPropertyValue(propertyValueArray, "ActiveConnection")) {
                xConnection = (XConnection)AnyConverter.toObject((Class)(class$com$sun$star$sdbc$XConnection == null ? (class$com$sun$star$sdbc$XConnection = DBMetaData.class$("com.sun.star.sdbc.XConnection")) : class$com$sun$star$sdbc$XConnection), (Object)Properties.getPropertyValue(propertyValueArray, "ActiveConnection"));
                if (xConnection != null) {
                    XPropertySet xPropertySet;
                    XChild xChild = (XChild)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XChild == null ? (class$com$sun$star$container$XChild = DBMetaData.class$("com.sun.star.container.XChild")) : class$com$sun$star$container$XChild), (Object)xConnection);
                    this.xDataSource = (XDataSource)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbc$XDataSource == null ? (class$com$sun$star$sdbc$XDataSource = DBMetaData.class$("com.sun.star.sdbc.XDataSource")) : class$com$sun$star$sdbc$XDataSource), (Object)xChild.getParent());
                    XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XDocumentDataSource == null ? (class$com$sun$star$sdb$XDocumentDataSource = DBMetaData.class$("com.sun.star.sdb.XDocumentDataSource")) : class$com$sun$star$sdb$XDocumentDataSource), (Object)this.xDataSource);
                    if (xDocumentDataSource != null) {
                        this.xModel = xDocumentDataSource.getDatabaseDocument();
                    }
                    if ((xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBMetaData.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xDataSource)) != null) {
                        this.DataSourceName = AnyConverter.toString((Object)xPropertySet.getPropertyValue("Name"));
                    }
                    return this.getConnection(xConnection);
                }
                this.bdisposeConnection = true;
            } else {
                this.bdisposeConnection = true;
            }
            if (Properties.hasPropertyValue(propertyValueArray, "DataSourceName")) {
                String string = AnyConverter.toString((Object)Properties.getPropertyValue(propertyValueArray, "DataSourceName"));
                return this.getConnection(string);
            }
            if (Properties.hasPropertyValue(propertyValueArray, "DataSource")) {
                this.xDataSource = (XDataSource)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbc$XDataSource == null ? (class$com$sun$star$sdbc$XDataSource = DBMetaData.class$("com.sun.star.sdbc.XDataSource")) : class$com$sun$star$sdbc$XDataSource), (Object)Properties.getPropertyValue(propertyValueArray, "DataSource"));
                XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XDocumentDataSource == null ? (class$com$sun$star$sdb$XDocumentDataSource = DBMetaData.class$("com.sun.star.sdb.XDocumentDataSource")) : class$com$sun$star$sdb$XDocumentDataSource), (Object)this.xDataSource);
                if (xDocumentDataSource != null) {
                    this.xModel = xDocumentDataSource.getDatabaseDocument();
                }
                return this.getConnection(this.xDataSource);
            }
            if (Properties.hasPropertyValue(propertyValueArray, "DatabaseLocation")) {
                String string = AnyConverter.toString((Object)Properties.getPropertyValue(propertyValueArray, "DatabaseLocation"));
                return this.getConnection(string);
            }
            if (xConnection != null) {
                this.bdisposeConnection = false;
                return this.getConnection(xConnection);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.out);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace(System.out);
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace(System.out);
        }
        return false;
    }

    private boolean getConnection(String string) {
        this.setDataSourceByName(string, true);
        return this.getConnection(this.xDataSource);
    }

    private boolean getConnection(XConnection xConnection) {
        try {
            this.DBConnection = xConnection;
            this.getDataSourceObjects();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    private boolean getConnection(XDataSource xDataSource) {
        Resource resource = new Resource(this.xMSF, "Database", "dbw");
        try {
            Object object;
            int n = 0;
            boolean bl = false;
            if (this.DBConnection != null) {
                this.xConnectionComponent.dispose();
            }
            this.getDataSourceInterfaces();
            if (!this.bPasswordIsRequired) {
                this.DBConnection = xDataSource.getConnection("", "");
                bl = true;
            } else {
                object = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.InteractionHandler");
                XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface((Class)(class$com$sun$star$task$XInteractionHandler == null ? (class$com$sun$star$task$XInteractionHandler = DBMetaData.class$("com.sun.star.task.XInteractionHandler")) : class$com$sun$star$task$XInteractionHandler), (Object)object);
                boolean bl2 = true;
                do {
                    XCompletedConnection xCompletedConnection = (XCompletedConnection)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XCompletedConnection == null ? DBMetaData.class$("com.sun.star.sdb.XCompletedConnection") : class$com$sun$star$sdb$XCompletedConnection), (Object)xDataSource);
                    try {
                        this.DBConnection = xCompletedConnection.connectWithCompletion(xInteractionHandler);
                        boolean bl3 = bl = this.DBConnection != null;
                        if (bl) continue;
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        String string = resource.getResText(1014);
                        n = this.showMessageBox("QueryBox", 0x4000000, string);
                        bl2 = n == 0;
                        bl = false;
                    }
                } while (!bl2);
            }
            if (!bl) {
                object = resource.getResText(1035);
                this.showMessageBox("ErrorBox", 0x400000, (String)object);
            } else {
                this.xConnectionComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = DBMetaData.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)this.DBConnection);
                this.getDataSourceObjects();
            }
            return bl;
        }
        catch (Exception exception) {
            String string = resource.getResText(1035);
            this.showMessageBox("ErrorBox", 0x400000, string);
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public int getMaxColumnNameLength() {
        try {
            if (this.iMaxColumnNameLength <= 0) {
                this.iMaxColumnNameLength = this.xDBMetaData.getMaxColumnNameLength();
            }
            return this.iMaxColumnNameLength;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            return 0;
        }
    }

    public int getMaxTableNameLength() {
        try {
            if (this.iMaxTableNameLength <= 0) {
                this.iMaxTableNameLength = this.xDBMetaData.getMaxTableNameLength();
            }
            return this.iMaxTableNameLength;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            return 0;
        }
    }

    public boolean supportsCoreSQLGrammar() {
        try {
            return this.xDBMetaData.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            return false;
        }
    }

    public boolean supportsAutoIncrementation() {
        return false;
    }

    public String createQuery(SQLQueryComposer sQLQueryComposer, String string) {
        try {
            XQueryDefinitionsSupplier xQueryDefinitionsSupplier = (XQueryDefinitionsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XQueryDefinitionsSupplier == null ? (class$com$sun$star$sdb$XQueryDefinitionsSupplier = DBMetaData.class$("com.sun.star.sdb.XQueryDefinitionsSupplier")) : class$com$sun$star$sdb$XQueryDefinitionsSupplier), (Object)this.xDataSource);
            XNameAccess xNameAccess = xQueryDefinitionsSupplier.getQueryDefinitions();
            XSingleServiceFactory xSingleServiceFactory = (XSingleServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XSingleServiceFactory == null ? (class$com$sun$star$lang$XSingleServiceFactory = DBMetaData.class$("com.sun.star.lang.XSingleServiceFactory")) : class$com$sun$star$lang$XSingleServiceFactory), (Object)xNameAccess);
            Object object = xSingleServiceFactory.createInstance();
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBMetaData.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
            String string2 = sQLQueryComposer.xQueryAnalyzer.getQuery();
            xPropertySet.setPropertyValue("Command", (Object)sQLQueryComposer.xQueryAnalyzer.getQuery());
            XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = DBMetaData.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer), (Object)xNameAccess);
            XNameAccess xNameAccess2 = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = DBMetaData.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)xNameAccess);
            String string3 = Desktop.getUniqueName(xNameAccess2, string);
            xNameContainer.insertByName(string3, object);
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void dispose() {
        if (this.DBConnection != null && this.bdisposeConnection) {
            this.xConnectionComponent.dispose();
        }
    }

    public XHierarchicalNameAccess getReportDocuments() {
        XReportDocumentsSupplier xReportDocumentsSupplier = (XReportDocumentsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XReportDocumentsSupplier == null ? (class$com$sun$star$sdb$XReportDocumentsSupplier = DBMetaData.class$("com.sun.star.sdb.XReportDocumentsSupplier")) : class$com$sun$star$sdb$XReportDocumentsSupplier), (Object)this.xModel);
        xReportDocumentsSupplier.getReportDocuments();
        XHierarchicalNameAccess xHierarchicalNameAccess = (XHierarchicalNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XHierarchicalNameAccess == null ? (class$com$sun$star$container$XHierarchicalNameAccess = DBMetaData.class$("com.sun.star.container.XHierarchicalNameAccess")) : class$com$sun$star$container$XHierarchicalNameAccess), (Object)xReportDocumentsSupplier.getReportDocuments());
        return xHierarchicalNameAccess;
    }

    public XHierarchicalNameAccess getFormDocuments() {
        XFormDocumentsSupplier xFormDocumentsSupplier = (XFormDocumentsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XFormDocumentsSupplier == null ? (class$com$sun$star$sdb$XFormDocumentsSupplier = DBMetaData.class$("com.sun.star.sdb.XFormDocumentsSupplier")) : class$com$sun$star$sdb$XFormDocumentsSupplier), (Object)this.xModel);
        XHierarchicalNameAccess xHierarchicalNameAccess = (XHierarchicalNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XHierarchicalNameAccess == null ? (class$com$sun$star$container$XHierarchicalNameAccess = DBMetaData.class$("com.sun.star.container.XHierarchicalNameAccess")) : class$com$sun$star$container$XHierarchicalNameAccess), (Object)xFormDocumentsSupplier.getFormDocuments());
        return xHierarchicalNameAccess;
    }

    public boolean hasFormDocumentByName(String string) {
        XFormDocumentsSupplier xFormDocumentsSupplier = (XFormDocumentsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdb$XFormDocumentsSupplier == null ? (class$com$sun$star$sdb$XFormDocumentsSupplier = DBMetaData.class$("com.sun.star.sdb.XFormDocumentsSupplier")) : class$com$sun$star$sdb$XFormDocumentsSupplier), (Object)this.xModel);
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = DBMetaData.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)xFormDocumentsSupplier.getFormDocuments());
        return xNameAccess.hasByName(string);
    }

    public void addFormDocument(XComponent xComponent) {
        XHierarchicalNameAccess xHierarchicalNameAccess = this.getFormDocuments();
        this.addDatabaseDocument(xComponent, xHierarchicalNameAccess, false);
    }

    public void addReportDocument(XComponent xComponent, boolean bl) {
        XHierarchicalNameAccess xHierarchicalNameAccess = this.getReportDocuments();
        this.addDatabaseDocument(xComponent, xHierarchicalNameAccess, bl);
    }

    public void addDatabaseDocument(XComponent xComponent, XHierarchicalNameAccess xHierarchicalNameAccess, boolean bl) {
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = DBMetaData.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), (Object)xComponent);
            String string = xModel.getURL();
            String string2 = FileAccess.getBasename(string, "/");
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XCloseable == null ? (class$com$sun$star$util$XCloseable = DBMetaData.class$("com.sun.star.util.XCloseable")) : class$com$sun$star$util$XCloseable), (Object)xComponent);
            xComponent.dispose();
            xCloseable.close(false);
            Object[] objectArray = bl ? new PropertyValue[5] : new PropertyValue[]{Properties.createProperty("Name", string2), Properties.createProperty("Parent", xHierarchicalNameAccess), Properties.createProperty("URL", string), Properties.createProperty("DocumentTitle", string2)};
            if (bl) {
                objectArray[4] = Properties.createProperty("AsTemplate", new Boolean(bl));
            }
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = DBMetaData.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)xHierarchicalNameAccess);
            Object object = xMultiServiceFactory.createInstanceWithArguments("com.sun.star.sdb.DocumentDefinition", objectArray);
            XHierarchicalNameContainer xHierarchicalNameContainer = (XHierarchicalNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XHierarchicalNameContainer == null ? (class$com$sun$star$container$XHierarchicalNameContainer = DBMetaData.class$("com.sun.star.container.XHierarchicalNameContainer")) : class$com$sun$star$container$XHierarchicalNameContainer), (Object)xHierarchicalNameAccess);
            String string3 = Desktop.getUniqueName(xHierarchicalNameAccess, string2);
            xHierarchicalNameContainer.insertByHierarchicalName(string3, object);
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$ucb$XSimpleFileAccess == null ? (class$com$sun$star$ucb$XSimpleFileAccess = DBMetaData.class$("com.sun.star.ucb.XSimpleFileAccess")) : class$com$sun$star$ucb$XSimpleFileAccess), (Object)xInterface);
            xSimpleFileAccess.kill(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public XComponent[] openDatabaseDocument(String string, boolean bl, boolean bl2, XHierarchicalNameAccess xHierarchicalNameAccess) {
        XComponent[] xComponentArray = new XComponent[2];
        try {
            XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XComponentLoader == null ? (class$com$sun$star$frame$XComponentLoader = DBMetaData.class$("com.sun.star.frame.XComponentLoader")) : class$com$sun$star$frame$XComponentLoader), (Object)xHierarchicalNameAccess);
            PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("OpenMode", bl2 ? "openDesign" : "open"), Properties.createProperty("ActiveConnection", this.DBConnection), Properties.createProperty("DocumentTitle", string), Properties.createProperty("AsTemplate", new Boolean(bl))};
            XHierarchicalNameContainer xHierarchicalNameContainer = (XHierarchicalNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XHierarchicalNameContainer == null ? (class$com$sun$star$container$XHierarchicalNameContainer = DBMetaData.class$("com.sun.star.container.XHierarchicalNameContainer")) : class$com$sun$star$container$XHierarchicalNameContainer), (Object)xHierarchicalNameAccess);
            if (xHierarchicalNameContainer.hasByHierarchicalName(string)) {
                xComponentArray[0] = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = DBMetaData.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)xHierarchicalNameContainer.getByHierarchicalName(string));
                xComponentArray[1] = xComponentLoader.loadComponentFromURL(string, "", 0, propertyValueArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return xComponentArray;
    }

    public XComponent[] openFormDocument(String string, boolean bl) {
        XHierarchicalNameAccess xHierarchicalNameAccess = this.getFormDocuments();
        return this.openDatabaseDocument(string, false, bl, xHierarchicalNameAccess);
    }

    public XComponent[] openReportDocument(String string, boolean bl, boolean bl2) {
        XHierarchicalNameAccess xHierarchicalNameAccess = this.getReportDocuments();
        return this.openDatabaseDocument(string, bl, bl2, xHierarchicalNameAccess);
    }

    public void createTypeInspector() throws SQLException {
        this.oTypeInspector = new TypeInspector(this.xDBMetaData.getTypeInfo());
    }

    public TypeInspector getDBDataTypeInspector() {
        return this.oTypeInspector;
    }

    private String[] StringsFromResultSet(XResultSet xResultSet, int n) {
        String[] stringArray = null;
        try {
            XRow xRow = (XRow)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbc$XRow == null ? (class$com$sun$star$sdbc$XRow = DBMetaData.class$("com.sun.star.sdbc.XRow")) : class$com$sun$star$sdbc$XRow), (Object)xResultSet);
            Vector<String> vector = new Vector<String>();
            while (xResultSet.next()) {
                vector.addElement(xRow.getString(n));
            }
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return stringArray;
    }

    public String[] getCatalogNames() {
        try {
            XResultSet xResultSet = this.xDBMetaData.getCatalogs();
            return this.StringsFromResultSet(xResultSet, 1);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            return null;
        }
    }

    public String[] getSchemaNames() {
        try {
            XResultSet xResultSet = this.xDBMetaData.getSchemas();
            return this.StringsFromResultSet(xResultSet, 1);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.out);
            return null;
        }
    }

    public boolean storeDatabaseDocumentToTempPath(XComponent xComponent, String string) {
        try {
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$ucb$XSimpleFileAccess == null ? (class$com$sun$star$ucb$XSimpleFileAccess = DBMetaData.class$("com.sun.star.ucb.XSimpleFileAccess")) : class$com$sun$star$ucb$XSimpleFileAccess), (Object)xInterface);
            String string2 = FileAccess.getOfficePath(this.xMSF, "Temp", xSimpleFileAccess) + "/" + string;
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DBMetaData.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)xComponent);
            PropertyValue[] propertyValueArray = new PropertyValue[]{Properties.createProperty("FilterName", "writer8")};
            string2 = string2 + ".odt";
            xStorable.storeAsURL(string2, propertyValueArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public int showMessageBox(String string, int n, String string2) {
        if (this.getWindowPeer() != null) {
            return SystemDialog.showMessageBox(this.xMSF, this.xWindowPeer, string, n, string2);
        }
        return SystemDialog.showMessageBox(this.xMSF, string, n, string2);
    }

    public XWindowPeer getWindowPeer() {
        return this.xWindowPeer;
    }

    public void setWindowPeer(XWindowPeer xWindowPeer) {
        this.xWindowPeer = xWindowPeer;
    }

    public void callSQLErrorMessageDialog(SQLException sQLException, XWindow xWindow) {
        try {
            Object object = this.xMSF.createInstance("com.sun.star.sdb.ErrorMessageDialog");
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XInitialization == null ? (class$com$sun$star$lang$XInitialization = DBMetaData.class$("com.sun.star.lang.XInitialization")) : class$com$sun$star$lang$XInitialization), (Object)object);
            Object[] objectArray = new PropertyValue[]{Properties.createProperty("SQLException", (Object)sQLException), Properties.createProperty("ParentWindow", xWindow)};
            xInitialization.initialize(objectArray);
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XExecutableDialog == null ? (class$com$sun$star$ui$dialogs$XExecutableDialog = DBMetaData.class$("com.sun.star.ui.dialogs.XExecutableDialog")) : class$com$sun$star$ui$dialogs$XExecutableDialog), (Object)object);
            xExecutableDialog.execute();
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class CommandObject {
        public XNameAccess xColumns;
        public XPropertySet xPropertySet;
        public String Name;
        public int CommandType;

        public CommandObject(String string, int n) {
            try {
                this.Name = string;
                this.CommandType = n;
                if (DBMetaData.this.xTableNames == null) {
                    DBMetaData.this.setCommandNames();
                }
                Object object = this.CommandType == 0 ? DBMetaData.this.xTableNames.getByName(this.Name) : DBMetaData.this.xQueryNames.getByName(this.Name);
                XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$sdbcx$XColumnsSupplier == null ? (class$com$sun$star$sdbcx$XColumnsSupplier = DBMetaData.class$("com.sun.star.sdbcx.XColumnsSupplier")) : class$com$sun$star$sdbcx$XColumnsSupplier), (Object)object);
                this.xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBMetaData.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
                this.xColumns = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = DBMetaData.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)xColumnsSupplier.getColumns());
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }
}

