/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.MethodParameterPanel;
import org.openide.explorer.propertysheet.editors.ObjectArrayPanel;
import org.openide.src.MethodParameter;
import org.openide.src.Type;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MethodParameterArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    MethodParameterArrayPanel panel;
    boolean ignoreEditor = false;
    boolean ignorePanel = false;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor;

    public String getAsText() {
        MethodParameter[] methodParameterArray = (MethodParameter[])this.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        if (methodParameterArray != null) {
            int n = 0;
            while (n < methodParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(methodParameterArray[n].getSourceString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        MethodParameter[] methodParameterArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        ArrayList<MethodParameter> arrayList = new ArrayList<MethodParameter>();
        while (stringTokenizer.hasMoreTokens()) {
            MethodParameter methodParameter;
            methodParameterArray = stringTokenizer.nextToken();
            try {
                methodParameter = MethodParameter.parse((String)methodParameterArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = MessageFormat.format(MethodParameterArrayEditor.getString("MSG_IllegalMethodParameter"), new Object[]{methodParameterArray});
                ErrorManager.getDefault().annotate(illegalArgumentException, 256, null, string2, null, null);
                throw illegalArgumentException;
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (!methodParameter.getName().equals(((MethodParameter)iterator.next()).getName())) continue;
                String string3 = MessageFormat.format(MethodParameterArrayEditor.getString("MSG_DuplicateName2"), methodParameter.getName());
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Ambiguous name");
                ErrorManager.getDefault().annotate(illegalArgumentException, 256, null, string3, null, null);
                throw illegalArgumentException;
            }
            arrayList.add(methodParameter);
        }
        methodParameterArray = new MethodParameter[arrayList.size()];
        arrayList.toArray(methodParameterArray);
        this.setValue(methodParameterArray);
    }

    public void setValue(Object object) {
        this.ignoreEditor = true;
        boolean bl = this.ignorePanel;
        this.ignorePanel = false;
        super.setValue(object);
        if (this.panel != null & !bl) {
            this.panel.setMethodParameters((MethodParameter[])object);
        }
        this.ignoreEditor = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.panel == null) {
            this.panel = new MethodParameterArrayPanel();
            this.panel.setMethodParameters((MethodParameter[])this.getValue());
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!MethodParameterArrayEditor.this.ignoreEditor && "methodParameters".equals(propertyChangeEvent.getPropertyName())) {
                        MethodParameterArrayEditor.this.ignorePanel = true;
                        MethodParameterArrayEditor.this.setValue(propertyChangeEvent.getNewValue());
                        MethodParameterArrayEditor.this.ignorePanel = false;
                    }
                }
            });
        }
        return this.panel;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
    }

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor == null ? (class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor = MethodParameterArrayEditor.class$("org.openide.explorer.propertysheet.editors.MethodParameterArrayEditor")) : class$org$openide$explorer$propertysheet$editors$MethodParameterArrayEditor).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class MethodParameterArrayPanel
    extends ObjectArrayPanel
    implements EnhancedCustomPropertyEditor {
        public static final String PROP_METHOD_PARAMETERS = "methodParameters";
        MethodParameter[] prevValue = new MethodParameter[0];

        public MethodParameterArrayPanel() {
            this.getListComponent().setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ MethodParameterArrayPanel this$0;
                {
                    this.this$0 = methodParameterArrayPanel;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (component == this) {
                        this.setText(((MethodParameter)object).toString());
                    }
                    return component;
                }
            });
        }

        public MethodParameter[] getMethodParameters() {
            Object[] objectArray = new MethodParameter[this.model.size()];
            this.model.copyInto(objectArray);
            return objectArray;
        }

        public void setMethodParameters(MethodParameter[] methodParameterArray) {
            this.model = new DefaultListModel();
            if (methodParameterArray != null) {
                int n = 0;
                while (n < methodParameterArray.length) {
                    this.model.addElement(methodParameterArray[n]);
                    ++n;
                }
            }
            this.getListComponent().setModel(this.model);
            this.modelChanged();
        }

        protected void modelChanged() {
            super.modelChanged();
            MethodParameter[] methodParameterArray = this.getMethodParameters();
            this.firePropertyChange(PROP_METHOD_PARAMETERS, this.prevValue, methodParameterArray);
            this.prevValue = methodParameterArray;
        }

        protected Object insertNewValue() {
            return this.openInputDialog(null);
        }

        protected Object editValue(Object object) {
            return this.openInputDialog((MethodParameter)object);
        }

        protected MethodParameter openInputDialog(MethodParameter methodParameter) {
            Object object;
            MethodParameterPanel methodParameterPanel = new MethodParameterPanel();
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor(methodParameterPanel, MethodParameterArrayEditor.getString("LAB_EnterParameter"), 2, -1, null, null);
            if (methodParameter != null) {
                methodParameterPanel.nameTextField.setText(methodParameter.getName().toString());
                methodParameterPanel.typeCombo.setSelectedItem(methodParameter.getType().toString());
                methodParameterPanel.finalCheckBox.setSelected(methodParameter.isFinal());
            }
            while ((object = TopManager.getDefault().notify(notifyDescriptor)) == NotifyDescriptor.OK_OPTION) {
                String string = null;
                String string2 = methodParameterPanel.nameTextField.getText();
                if (!Utilities.isJavaIdentifier(string2)) {
                    string = "MSG_NotValidID";
                } else {
                    try {
                        Type type = Type.parse(methodParameterPanel.typeCombo.getSelectedItem().toString());
                        boolean bl = methodParameterPanel.finalCheckBox.isSelected();
                        Enumeration enumeration = this.model.elements();
                        while (enumeration.hasMoreElements()) {
                            MethodParameter methodParameter2 = (MethodParameter)enumeration.nextElement();
                            if (methodParameter != null && methodParameter2.equals(methodParameter) || !string2.equals(methodParameter2.getName())) continue;
                            string = "MSG_DuplicateName";
                            break;
                        }
                        if (string == null) {
                            return new MethodParameter(string2, type, bl);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        string = "MSG_NotValidType";
                    }
                }
                TopManager.getDefault().notify(new NotifyDescriptor.Message(MethodParameterArrayEditor.getString(string)));
            }
            return null;
        }

        public Object getPropertyValue() throws IllegalStateException {
            return this.getMethodParameters();
        }
    }
}

