/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.FolderList;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ProxyLookup;

public class FolderLookup
extends FolderInstance {
    private static final Object LOCK = new Object();
    private ProxyLkp lookup;
    private String rootName;
    private final boolean isRoot;
    static /* synthetic */ Class class$org$openide$loaders$FolderLookup$ProxyLkp;
    static /* synthetic */ Class class$org$openide$util$Lookup;
    static /* synthetic */ Class class$java$lang$Object;

    public FolderLookup(DataObject.Container container) {
        this(container, "FL[");
    }

    public FolderLookup(DataObject.Container container, String string) {
        this(container, string, true);
    }

    private FolderLookup(DataObject.Container container, String string, boolean bl) {
        super(container);
        this.rootName = string;
        this.isRoot = bl;
    }

    public final Class instanceClass() {
        return class$org$openide$loaders$FolderLookup$ProxyLkp == null ? (class$org$openide$loaders$FolderLookup$ProxyLkp = FolderLookup.class$("org.openide.loaders.FolderLookup$ProxyLkp")) : class$org$openide$loaders$FolderLookup$ProxyLkp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lookup getLookup() {
        boolean bl = false;
        Object object = LOCK;
        synchronized (object) {
            if (this.lookup == null) {
                this.lookup = new ProxyLkp(this);
                bl = true;
            }
        }
        if (bl) {
            this.checkRecreate();
        }
        return this.lookup;
    }

    protected final Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        FolderLookupData folderLookupData = new FolderLookupData();
        if (this.isRoot) {
            folderLookupData.lookups.add(null);
        }
        int n = 0;
        while (n < instanceCookieArray.length) {
            try {
                Object object = instanceCookieArray[n].instanceCreate();
                if (object instanceof FolderLookupData) {
                    folderLookupData.items.addAll(((FolderLookupData)object).items);
                    folderLookupData.lookups.addAll(((FolderLookupData)object).lookups);
                } else if (object instanceof Lookup) {
                    folderLookupData.lookups.add(object);
                } else {
                    folderLookupData.items.add(object);
                }
            }
            catch (IOException iOException) {
                FolderLookup.exception(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FolderLookup.exception(classNotFoundException);
            }
            ++n;
        }
        if (!this.isRoot) {
            return folderLookupData;
        }
        this.getLookup();
        this.lookup.update(folderLookupData.items, folderLookupData.lookups);
        return this.lookup;
    }

    protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        boolean bl = instanceCookie instanceof InstanceCookie.Of ? ((InstanceCookie.Of)instanceCookie).instanceOf(class$org$openide$util$Lookup == null ? (class$org$openide$util$Lookup = FolderLookup.class$("org.openide.util.Lookup")) : class$org$openide$util$Lookup) : (class$org$openide$util$Lookup == null ? (class$org$openide$util$Lookup = FolderLookup.class$("org.openide.util.Lookup")) : class$org$openide$util$Lookup).isAssignableFrom(instanceCookie.instanceClass());
        if (bl) {
            return instanceCookie.instanceCreate();
        }
        return new ICItem(dataObject, this.rootName, instanceCookie);
    }

    protected InstanceCookie acceptFolder(DataFolder dataFolder) {
        return new FolderLookup(dataFolder, FolderLookup.objectName(this.rootName, dataFolder), false);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return new FolderLookup(container, this.rootName == null ? "<container>" : this.rootName + "<container>", false);
    }

    protected final Task postCreationTask(Runnable runnable) {
        runnable.run();
        return null;
    }

    private static String objectName(String string, DataObject dataObject) {
        if (string == null) {
            return dataObject.getName();
        }
        return string + '/' + dataObject.getName();
    }

    private static void exception(Exception exception) {
        ErrorManager.getDefault().notify(1, exception);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FolderLookupData {
        private Collection items = new ArrayList(30);
        private List lookups = new ArrayList(5);
    }

    private static final class ICItem
    extends AbstractLookup.Pair {
        private InstanceCookie ic;
        private DataObject obj;
        private WeakReference ref;
        private String rootName;

        public ICItem(DataObject dataObject, String string, InstanceCookie instanceCookie) {
            this.ic = instanceCookie;
            this.obj = dataObject;
            this.rootName = string;
        }

        protected boolean instanceOf(Class clazz) {
            if (this.ic instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.ic;
                return of.instanceOf(clazz);
            }
            try {
                return clazz.isAssignableFrom(this.ic.instanceClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                FolderLookup.exception(classNotFoundException);
            }
            catch (IOException iOException) {
                FolderLookup.exception(iOException);
            }
            return false;
        }

        public Object getInstance() {
            try {
                Object object = this.ic.instanceCreate();
                this.ref = new WeakReference<Object>(object);
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                FolderLookup.exception(classNotFoundException);
            }
            catch (IOException iOException) {
                FolderLookup.exception(iOException);
            }
            return null;
        }

        public int hashCode() {
            return System.identityHashCode(this.ic);
        }

        public boolean equals(Object object) {
            if (object instanceof ICItem) {
                ICItem iCItem = (ICItem)object;
                return this.ic == iCItem.ic;
            }
            return false;
        }

        public String getId() {
            return FolderLookup.objectName(this.rootName, this.obj);
        }

        public String getDisplayName() {
            return this.obj.getNodeDelegate().getDisplayName();
        }

        protected boolean creatorOf(Object object) {
            WeakReference weakReference = this.ref;
            return weakReference != null && weakReference.get() == object;
        }

        public Class getType() {
            try {
                return this.ic.instanceClass();
            }
            catch (IOException iOException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = FolderLookup.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }

    private static final class ProxyLkp
    extends ProxyLookup {
        private FolderLookup fl;
        private AbstractLookup.Content content;

        public ProxyLkp(FolderLookup folderLookup) {
            this(folderLookup, new AbstractLookup.Content());
        }

        private ProxyLkp(FolderLookup folderLookup, AbstractLookup.Content content) {
            super(new Lookup[]{new AbstractLookup(content)});
            this.fl = folderLookup;
            this.content = content;
        }

        public void update(Collection collection, List list) {
            Lookup lookup = this.getLookups()[0];
            this.content.setPairs(collection);
            if (this.fl.err().isLoggable(1)) {
                this.fl.err().log("Changed pairs: " + collection);
            }
            list.set(0, lookup);
            Lookup[] lookupArray = list.toArray(new Lookup[list.size()]);
            this.setLookups(lookupArray);
            if (this.fl.err().isLoggable(1)) {
                this.fl.err().log("Changed lookups: " + list);
            }
        }

        protected void beforeLookup(Lookup.Template template) {
            if (!FolderList.isFolderRecognizerThread()) {
                this.fl.instanceFinished();
            }
        }
    }
}

