/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.print.Pageable;
import java.text.AttributedCharacterIterator;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.openide.options.SystemOption;
import org.openide.text.Annotation;
import org.openide.text.BackwardPosition;
import org.openide.text.DefaultPrintable;

public final class NbDocument {
    public static final Object GUARDED = new AttributeSet.CharacterAttribute(){};
    private static final SimpleAttributeSet ATTR_ADD = new SimpleAttributeSet();
    private static final SimpleAttributeSet ATTR_REMOVE = new SimpleAttributeSet();
    public static final String BREAKPOINT_STYLE_NAME = "NbBreakpointStyle";
    public static final String ERROR_STYLE_NAME = "NbErrorStyle";
    public static final String CURRENT_STYLE_NAME = "NbCurrentStyle";
    public static final String NORMAL_STYLE_NAME = "NbNormalStyle";
    public static final Colors COLORS;

    private NbDocument() {
    }

    public static Element findLineRootElement(StyledDocument styledDocument) {
        NbDocument.checkDocParameter(styledDocument);
        Element element = styledDocument.getParagraphElement(0).getParentElement();
        if (element == null) {
            element = styledDocument.getDefaultRootElement();
        }
        return element;
    }

    public static int findLineNumber(StyledDocument styledDocument, int n) {
        Element element = NbDocument.findLineRootElement(styledDocument);
        return element.getElementIndex(n);
    }

    public static int findLineColumn(StyledDocument styledDocument, int n) {
        Element element = NbDocument.findLineRootElement(styledDocument);
        int n2 = element.getElementIndex(n);
        return n - element.getElement(n2).getStartOffset();
    }

    public static int findLineOffset(StyledDocument styledDocument, int n) {
        Element element = NbDocument.findLineRootElement(styledDocument);
        Element element2 = element.getElement(n);
        if (element2 == null) {
            throw new IndexOutOfBoundsException("Index=" + n + " is out of bounds.");
        }
        return element2.getStartOffset();
    }

    public static Position createPosition(Document document, int n, Position.Bias bias) throws BadLocationException {
        NbDocument.checkDocParameter(document);
        if (document instanceof PositionBiasable) {
            return ((PositionBiasable)document).createPosition(n, bias);
        }
        if (bias == Position.Bias.Forward) {
            return document.createPosition(n);
        }
        return BackwardPosition.create(document, n);
    }

    public static void markGuarded(StyledDocument styledDocument, int n, int n2) {
        NbDocument.checkDocParameter(styledDocument);
        styledDocument.setCharacterAttributes(n, n2, ATTR_ADD, false);
    }

    public static void unmarkGuarded(StyledDocument styledDocument, int n, int n2) {
        NbDocument.checkDocParameter(styledDocument);
        styledDocument.setCharacterAttributes(n, n2, ATTR_REMOVE, false);
    }

    public static void insertGuarded(StyledDocument styledDocument, int n, String string) throws BadLocationException {
        NbDocument.checkDocParameter(styledDocument);
        styledDocument.insertString(n, string, ATTR_ADD);
    }

    public static void markBreakpoint(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(BREAKPOINT_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(BREAKPOINT_STYLE_NAME, null);
            if (style == null) {
                return;
            }
            style.addAttribute(StyleConstants.ColorConstants.Background, Color.red);
            style.addAttribute(StyleConstants.ColorConstants.Foreground, Color.white);
        }
        styledDocument.setLogicalStyle(n, style);
    }

    public static void markError(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(ERROR_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(ERROR_STYLE_NAME, null);
            if (style == null) {
                return;
            }
            style.addAttribute(StyleConstants.ColorConstants.Background, Color.green);
            style.addAttribute(StyleConstants.ColorConstants.Foreground, Color.black);
        }
        styledDocument.setLogicalStyle(n, style);
    }

    public static void markCurrent(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(CURRENT_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(CURRENT_STYLE_NAME, null);
            if (style == null) {
                return;
            }
            style.addAttribute(StyleConstants.ColorConstants.Background, Color.blue);
            style.addAttribute(StyleConstants.ColorConstants.Foreground, Color.white);
        }
        styledDocument.setLogicalStyle(n, style);
    }

    public static void markNormal(StyledDocument styledDocument, int n) {
        NbDocument.checkDocParameter(styledDocument);
        Style style = styledDocument.getStyle(NORMAL_STYLE_NAME);
        if (style == null) {
            style = styledDocument.addStyle(NORMAL_STYLE_NAME, null);
        }
        if (style != null) {
            styledDocument.setLogicalStyle(n, style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAtomic(StyledDocument styledDocument, Runnable runnable) {
        NbDocument.checkDocParameter(styledDocument);
        if (styledDocument instanceof WriteLockable) {
            ((WriteLockable)((Object)styledDocument)).runAtomic(runnable);
        } else {
            StyledDocument styledDocument2 = styledDocument;
            synchronized (styledDocument2) {
                runnable.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAtomicAsUser(StyledDocument styledDocument, Runnable runnable) throws BadLocationException {
        NbDocument.checkDocParameter(styledDocument);
        if (styledDocument instanceof WriteLockable) {
            ((WriteLockable)((Object)styledDocument)).runAtomicAsUser(runnable);
        } else {
            StyledDocument styledDocument2 = styledDocument;
            synchronized (styledDocument2) {
                runnable.run();
            }
        }
    }

    private static void checkDocParameter(Document document) {
        if (document == null) {
            throw new NullPointerException("Invalid doc parameter. Document may not be null!");
        }
    }

    public static Object findPageable(StyledDocument styledDocument) {
        if (styledDocument instanceof Pageable) {
            return styledDocument;
        }
        if (styledDocument instanceof java.awt.print.Printable) {
            return styledDocument;
        }
        return new DefaultPrintable(styledDocument);
    }

    public static void addAnnotation(final StyledDocument styledDocument, final Position position, final int n, final Annotation annotation) {
        if (!(styledDocument instanceof Annotatable)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ((Annotatable)((Object)styledDocument)).addAnnotation(position, n, annotation);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((Annotatable)((Object)styledDocument)).addAnnotation(position, n, annotation);
                }
            });
        }
    }

    public static void removeAnnotation(final StyledDocument styledDocument, final Annotation annotation) {
        if (!(styledDocument instanceof Annotatable)) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ((Annotatable)((Object)styledDocument)).removeAnnotation(annotation);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((Annotatable)((Object)styledDocument)).removeAnnotation(annotation);
                }
            });
        }
    }

    static {
        ATTR_ADD.addAttribute(GUARDED, Boolean.TRUE);
        ATTR_REMOVE.addAttribute(GUARDED, Boolean.FALSE);
        COLORS = new Colors();
    }

    public static interface Annotatable
    extends Document {
        public void addAnnotation(Position var1, int var2, Annotation var3);

        public void removeAnnotation(Annotation var1);
    }

    public static interface CustomEditor
    extends Document {
        public Component createEditor(JEditorPane var1);
    }

    public static interface PositionBiasable
    extends Document {
        public Position createPosition(int var1, Position.Bias var2) throws BadLocationException;
    }

    public static interface Printable
    extends Document {
        public AttributedCharacterIterator[] createPrintIterators();
    }

    public static interface WriteLockable
    extends Document {
        public void runAtomic(Runnable var1);

        public void runAtomicAsUser(Runnable var1) throws BadLocationException;
    }

    public static final class Colors
    extends SystemOption {
        public static final String PROP_BREAKPOINT = "NbBreakpointStyle";
        public static final String PROP_ERROR = "NbErrorStyle";
        public static final String PROP_CURRENT = "NbCurrentStyle";
        static final long serialVersionUID = -9152250591365746193L;

        public void setBreakpoint(Color color) {
        }

        public Color getBreakpoint() {
            return new Color(127, 127, 255);
        }

        public void setError(Color color) {
        }

        public Color getError() {
            return Color.red;
        }

        public void setCurrent(Color color) {
        }

        public Color getCurrent() {
            return Color.magenta;
        }

        public String displayName() {
            return "COLORS";
        }
    }
}

