/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.configuration;

public class Decoder {
    static final int[] aEncodingTable = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 46};
    static final int[] aModifiedBase64 = new int[]{65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 62, 63, 65, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 65, 65, 65, 65, 65, 65, 65, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 65, 65, 65, 65, 64, 65, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 65, 65, 65, 65, 65};

    static boolean isUsAsciiAlphaDigit(char c) {
        return Decoder.isUsAsciiAlphaDigit(c, true);
    }

    static boolean isUsAsciiAlphaDigit(char c, boolean bl) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || bl && c >= '0' && c <= '9';
    }

    static boolean write(int n, StringBuffer stringBuffer, boolean bl) {
        if (Decoder.isUsAsciiAlphaDigit((char)n, !bl) || !bl && (n == 45 || n == 46)) {
            return false;
        }
        stringBuffer.append((char)n);
        return true;
    }

    static int decodeModifiedUTF7(String string, int n, boolean bl, StringBuffer stringBuffer) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        block23: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            char c2 = c;
            int n5 = c2 < '\u0080' ? aModifiedBase64[c2] : 65;
            switch (n5) {
                default: {
                    switch (n4) {
                        case 2: {
                            if (Decoder.write(n3 |= n5 >> 2, stringBuffer, bl)) break;
                            return -1;
                        }
                        case 5: {
                            if (Decoder.write(n3 |= n5 >> 4, stringBuffer, bl)) break;
                            return -1;
                        }
                        case 7: {
                            if (Decoder.write(n3 |= n5, stringBuffer, bl)) break;
                            return -1;
                        }
                    }
                    bl = false;
                    switch (n4) {
                        case 0: {
                            n3 = n5 << 10;
                            ++n4;
                            break;
                        }
                        case 1: {
                            n3 |= n5 << 4;
                            ++n4;
                            break;
                        }
                        case 2: {
                            n3 = (n5 & 3) << 14;
                            ++n4;
                            break;
                        }
                        case 3: {
                            n3 |= n5 << 8;
                            ++n4;
                            break;
                        }
                        case 4: {
                            n3 |= n5 << 2;
                            ++n4;
                            break;
                        }
                        case 5: {
                            n3 = (n5 & 0xF) << 12;
                            ++n4;
                            break;
                        }
                        case 6: {
                            n3 |= n5 << 6;
                            ++n4;
                            break;
                        }
                        case 7: {
                            n4 = 0;
                        }
                    }
                    continue block23;
                }
                case 64: {
                    switch (n4) {
                        case 3: 
                        case 6: {
                            if (n3 != 0) break;
                        }
                        case 0: {
                            return ++i;
                        }
                    }
                }
                case 65: {
                    return -1;
                }
            }
        }
        return -1;
    }

    public static String decodeValid(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block4: while (n2 < n) {
            char c = string.charAt(n2);
            if (!Decoder.isUsAsciiAlphaDigit(c, n2 != 0)) {
                switch (c) {
                    case '_': {
                        stringBuffer.append(string.substring(n3, n2));
                        n2 = Decoder.decodeModifiedUTF7(string, n2, ++n2 == 1, stringBuffer);
                        if (n2 < 0) {
                            return null;
                        }
                        n3 = n2;
                        continue block4;
                    }
                    case '-': 
                    case '.': {
                        if (n2 != 0) break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            ++n2;
        }
        if (n3 == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    public static String decode(String string) {
        String string2 = Decoder.decodeValid(string);
        System.out.println("Encoded string:" + string);
        if (string2 == null) {
            System.out.println("Decoded string:null");
        } else {
            System.out.println("Decoded string:" + string2);
        }
        return string2 != null ? string2 : string;
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block3: while (n3 < n) {
            char c = string.charAt(n3);
            if (!Decoder.isUsAsciiAlphaDigit(c, n3 != 0)) {
                switch (c) {
                    case '-': 
                    case '.': {
                        if (n3 != 0) break;
                    }
                    default: {
                        stringBuffer.append(string.substring(n2, n3));
                        stringBuffer.append('_');
                        ModifiedUTF7Buffer modifiedUTF7Buffer = new ModifiedUTF7Buffer(stringBuffer);
                        do {
                            modifiedUTF7Buffer.write(c);
                        } while (++n3 != n && !Decoder.isUsAsciiAlphaDigit(c = string.charAt(n3)) && c != '-' && c != '.');
                        modifiedUTF7Buffer.flush();
                        stringBuffer.append('_');
                        n2 = n3;
                        continue block3;
                    }
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length != 1) {
            System.out.println("Usage : Convert filname");
        }
        if ((string = Decoder.decode(stringArray[0])) == null) {
            System.out.println("Our String is null");
        } else {
            System.out.println("Our String " + string);
        }
    }

    static class ModifiedUTF7Buffer {
        StringBuffer aBuffer;
        int nValue;
        int nFilled = 0;

        public ModifiedUTF7Buffer(StringBuffer stringBuffer) {
            this.aBuffer = stringBuffer;
        }

        public void write(char c) {
            switch (this.nFilled) {
                case 0: {
                    this.nValue = c << 8;
                    this.nFilled = 2;
                    break;
                }
                case 1: {
                    this.nValue |= c;
                    this.nFilled = 3;
                    this.flush();
                    break;
                }
                case 2: {
                    this.nValue |= c >> 8;
                    this.nFilled = 3;
                    this.flush();
                    this.nValue = (c & 0xFF) << 16;
                    this.nFilled = 1;
                }
            }
        }

        void flush() {
            switch (this.nFilled) {
                case 1: {
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 18]);
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 12 & 0x3F]);
                    break;
                }
                case 2: {
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 18]);
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 12 & 0x3F]);
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 6 & 0x3F]);
                    break;
                }
                case 3: {
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 18]);
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 12 & 0x3F]);
                    this.aBuffer.append((char)aEncodingTable[this.nValue >> 6 & 0x3F]);
                    this.aBuffer.append((char)aEncodingTable[this.nValue & 0x3F]);
                }
            }
            this.nFilled = 0;
            this.nValue = 0;
        }
    }
}

